/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst.service;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DSTRequestHandler
implements RequestHandler {
    public Message processRequest(Message message) throws SOAPFaultException, Exception {
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:Request received: " + message.toString());
        }
        List list = message.getBodies();
        if ((list = Utils.convertElementToJAXB(list)) == null || list.size() == 0) {
            DSTUtils.debug.error("DSTRequestHandler:processRequest:SOAPBodies are null");
            throw new Exception(DSTUtils.bundle.getString("nullInputParams"));
        }
        Message message2 = null;
        int n = message.getSecurityProfileType();
        message2 = n == 1 || n == 2 || n == 3 ? new Message(null, this.generateBinarySecurityToken(message)) : new Message();
        message2.setCorrelationHeader(message.getCorrelationHeader());
        List list2 = this.processSOAPBodies(list, message, message2);
        list2 = Utils.convertJAXBToElement(list2);
        message2.setSOAPBodies(list2);
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:returned response: " + message2.toString());
        }
        return message2;
    }

    private List processSOAPBodies(List list, Message message, Message message2) throws SOAPFaultException, DSTException {
        DSTUtils.debug.message("DSTRequestHandler:processSOAPBodies:Init");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            arrayList.add(this.processDSTRequest(e, message, message2));
            ++n2;
        }
        return arrayList;
    }

    private BinarySecurityToken generateBinarySecurityToken(Message message) throws DSTException {
        try {
            SecurityTokenManager securityTokenManager = new SecurityTokenManager(message.getToken());
            return securityTokenManager.getX509CertificateToken();
        }
        catch (Exception exception) {
            DSTUtils.debug.error("DSTRequestHandler:generateBinarySecurityToken: Error in generating binary security token.", (Throwable)exception);
            throw new DSTException(exception);
        }
    }

    public abstract Object processDSTRequest(Object var1, Message var2, Message var3) throws SOAPFaultException, DSTException;

    protected String getResourceID(Object object, String string, String string2) {
        DSTUtils.debug.message("PPRequestHandler:getResourceID:Init");
        if (object == null) {
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("PPRequestHandler:getResourceID:ResourceIDType is null");
            }
            return null;
        }
        if (object instanceof ResourceIDType) {
            ResourceIDType resourceIDType = (ResourceIDType)object;
            return resourceIDType.getValue();
        }
        if (object instanceof EncryptedResourceIDType) {
            EncryptedResourceIDType encryptedResourceIDType = (EncryptedResourceIDType)object;
            try {
                Document document = XMLUtils.newDocument();
                DiscoUtils.getDiscoMarshaller().marshal((Object)encryptedResourceIDType, (Node)document);
                if (DSTUtils.debug.messageEnabled()) {
                    DSTUtils.debug.message("PPRequestHandler.getResourceID:Encrypted ResourceID = " + XMLUtils.print((Node)document));
                }
                EncryptedResourceID encryptedResourceID = new EncryptedResourceID(document.getDocumentElement(), string2);
                String string3 = EncryptedResourceID.getDecryptedResourceID(encryptedResourceID, string).getResourceID();
                if (DSTUtils.debug.messageEnabled()) {
                    DSTUtils.debug.message("PPRequestHandler.getResourceID: ResourceID Value after decryption" + string3);
                }
                return string3;
            }
            catch (Exception exception) {
                DSTUtils.debug.error("PPRequestHandler.getResourceID:error", (Throwable)exception);
                return null;
            }
        }
        DSTUtils.debug.error("PPRequestHandler:getResourceID:invalidresource ID type.");
        return null;
    }
}

