/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTQuery {
    private String resourceID = null;
    private EncryptedResourceID encryptedResourceID = null;
    private String id = null;
    private String itemID = null;
    private List dstQueryItems = new ArrayList();
    private List extensions = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQuery() {
    }

    public DSTQuery(String string, List list, String string2) {
        this.resourceID = string;
        if (list != null && list.size() != 0) {
            this.dstQueryItems.addAll(list);
            DSTQueryItem dSTQueryItem = (DSTQueryItem)list.get(0);
            this.nameSpaceURI = string2 == null ? dSTQueryItem.getNameSpaceURI() : string2;
            this.prefix = dSTQueryItem.getNameSpacePrefix();
        }
    }

    public DSTQuery(EncryptedResourceID encryptedResourceID, List list, String string) {
        this.encryptedResourceID = encryptedResourceID;
        if (list != null && list.size() != 0) {
            this.dstQueryItems.addAll(list);
            DSTQueryItem dSTQueryItem = (DSTQueryItem)list.get(0);
            this.nameSpaceURI = string == null ? dSTQueryItem.getNameSpaceURI() : string;
            this.prefix = dSTQueryItem.getNameSpacePrefix();
        }
    }

    public DSTQuery(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTQuery(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("Query")) {
            DSTUtils.debug.error("DSTQuery(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemID = element.getAttribute("itemID");
        NodeList nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "ResourceID");
        if (nodeList.getLength() == 0 || nodeList.getLength() > 1) {
            DSTUtils.debug.error("DSTQuery(element): ResourceIDNode is null or more than one resource id is found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        this.resourceID = XMLUtils.getElementValue((Element)((Element)nodeList.item(0)));
        if (this.resourceID == null) {
            DSTUtils.debug.error("DSTQuery(element): ResourceID is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        NodeList nodeList2 = element.getElementsByTagNameNS(this.nameSpaceURI, "QueryItem");
        if (nodeList2 == null || nodeList2.getLength() == 0) {
            DSTUtils.debug.error("DSTQuery(element): QueryItems are null");
            throw new DSTException(DSTUtils.bundle.getString("nullQueryItems"));
        }
        int n = nodeList2.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList2.item(0);
            DSTQueryItem dSTQueryItem = new DSTQueryItem((Element)node);
            this.dstQueryItems.add(dSTQueryItem);
            ++n2;
        }
    }

    public List getQueryItems() {
        return this.dstQueryItems;
    }

    public void setQueryItem(List list) {
        if (list != null && list.size() != 0) {
            this.dstQueryItems.addAll(list);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptedResourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptedResourceID = encryptedResourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String string) {
        this.resourceID = string;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String string) {
        this.itemID = string;
    }

    public List getExtension() {
        return this.extensions;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        if (this.encryptedResourceID == null && this.resourceID == null || this.dstQueryItems.isEmpty()) {
            DSTUtils.debug.error("DSTQuery.toString: ResourceID or QueryItems are null.");
            return "";
        }
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQuery.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(3000);
        stringBuffer.append("<").append(string).append("Query");
        if (this.id != null && this.id.length() != 0) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemID != null && this.itemID.length() != 0) {
            stringBuffer.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">");
        if (this.encryptedResourceID == null) {
            stringBuffer.append("<").append(string).append("ResourceID").append(">").append(this.resourceID).append("</").append(string).append("ResourceID").append(">");
        } else {
            stringBuffer.append(this.encryptedResourceID.toString(this.nameSpaceURI));
        }
        Iterator iterator = this.dstQueryItems.iterator();
        while (iterator.hasNext()) {
            DSTQueryItem dSTQueryItem = (DSTQueryItem)iterator.next();
            stringBuffer.append(dSTQueryItem.toString(true, false));
        }
        stringBuffer.append("</").append(string).append("Query").append(">");
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTQuery.toString: Query: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

