/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicDiscoEntryHandler
implements DiscoEntryHandler {
    private static final String DYNAMIC_ATTR_NAME = "sunIdentityServerDynamicDiscoEntries";

    public DynamicDiscoEntryHandler() {
        DiscoUtils.debug.message("in DynamicDiscoEntryHandler.constructor");
    }

    private static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        return (SSOToken)AccessController.doPrivileged(new AdminTokenAction());
    }

    public Map getDiscoEntries(String string, List list) {
        DiscoUtils.debug.message("in DynamicDiscoEntryHandler.getDiscoEntries");
        Map map = new HashMap();
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(DynamicDiscoEntryHandler.getSSOToken(), string);
            if (aMIdentity == null) {
                DiscoUtils.debug.error("Could not find user using " + string);
                return map;
            }
            DiscoUtils.getDynamicDiscoEntries(aMIdentity, DYNAMIC_ATTR_NAME, map, string);
            map = DiscoUtils.getQueryResults(map, list);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DynamicDiscoEntryHandler.getDiscoEntries: Exception:", (Throwable)exception);
        }
        return map;
    }

    public Map modifyDiscoEntries(String string, List list, List list2) {
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DynamicDiscoEntryHandler.modifyDiscoEntries: this operation is not supported.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("STATUS_CODE", "Failed");
        return hashMap;
    }
}

