/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.policy.PolicyEvaluator;
import java.util.Map;

public class DefaultDiscoAuthorizer
implements Authorizer {
    public static final String RESOURCE_SEPERATOR = ";";
    PolicyEvaluator pe = null;

    public DefaultDiscoAuthorizer() {
        DiscoUtils.debug.message("in DefaultDiscoAuthorizer.constructor");
        try {
            this.pe = new PolicyEvaluator("sunIdentityServerDiscoveryService");
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.constructor: Exception obtaining PolicyEvaluator: ", (Throwable)exception);
        }
    }

    public boolean isAuthorized(Object object, String string, Object object2, Map map) {
        DiscoUtils.debug.message("DefaultDiscoAuthorizer.isAuthorized.");
        if (this.pe == null) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: null Policy Evaluator.");
            return false;
        }
        if (!this.checkInput(object, string, object2, map)) {
            return false;
        }
        String string2 = null;
        try {
            ServiceInstanceType serviceInstanceType = ((ResourceOfferingType)object2).getServiceInstance();
            string2 = serviceInstanceType.getServiceType() + RESOURCE_SEPERATOR + serviceInstanceType.getProviderID();
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: Exception occured when constucting policy resource:", (Throwable)exception);
            return false;
        }
        boolean bl = false;
        try {
            bl = this.pe.isAllowed((SSOToken)object, string2, string, map);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.isAuthorized: Exception occured during policy evaluation: ", (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    private boolean checkInput(Object object, String string, Object object2, Map map) {
        if (object == null || !(object instanceof SSOToken)) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong credential.");
            return false;
        }
        if (string == null || !string.equals("LOOKUP") && !string.equals("UPDATE")) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong action.");
            return false;
        }
        if (object2 == null || !(object2 instanceof ResourceOfferingType)) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or wrong data.");
            return false;
        }
        if (!(map != null && map.containsKey("userID") && map.containsKey("authType") && map.containsKey("message"))) {
            DiscoUtils.debug.error("DefaultDiscoAuthorizer.checkInput: null or missing env data.");
            return false;
        }
        return true;
    }

    public Object getAuthorizationDecision(Object object, String string, Object object2, Map map) throws Exception {
        return null;
    }
}

