/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb11.GenerateBearerTokenElement;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoUtils {
    private static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory discoFac = new com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory();
    private static com.sun.identity.liberty.ws.disco.jaxb11.ObjectFactory disco11Fac = new com.sun.identity.liberty.ws.disco.jaxb11.ObjectFactory();
    private static ObjectFactory entryFac = new ObjectFactory();
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static SSOToken adminToken;
    public static ResourceBundle bundle;
    public static Debug debug;
    public static final String OFFERINGS = "offerings";
    public static final String CREDENTIALS = "credentials";
    public static final String CREDENTIALS_OBJ = "credentialsObj";
    public static final String RES_STMT = "ResourceAccess";
    public static final String RES_SESSION_STMT = "ResourceAccess_Session";
    public static final String SESSION_STMT = "SessionContext";
    public static final String AUTHN_STMT = "Authentication";
    private static String ALL;
    private static int AUTHN;
    private static int AUTHO;
    private static int SESSION;
    private static int BEARER;
    private static int LOGOUT;
    private static int SIZE;
    private static BitSet EMPTY_BITSET;

    private DiscoUtils() {
    }

    public static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory getDiscoFactory() {
        return discoFac;
    }

    public static com.sun.identity.liberty.ws.disco.jaxb11.ObjectFactory getDisco11Factory() {
        return disco11Fac;
    }

    public static ObjectFactory getDiscoEntryFactory() {
        return entryFac;
    }

    public static Marshaller getDiscoMarshaller() {
        return marshaller;
    }

    public static Unmarshaller getDiscoUnmarshaller() {
        return unmarshaller;
    }

    public static boolean getUserDiscoEntries(AMIdentity aMIdentity, String string, Map map) throws Exception {
        boolean bl = false;
        Set set = aMIdentity.getAttribute(string);
        Iterator iterator = set.iterator();
        DiscoEntryElement discoEntryElement = null;
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            try {
                discoEntryElement = (DiscoEntryElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string3)));
                string2 = discoEntryElement.getResourceOffering().getEntryID();
                if (string2 == null || string2.equals("")) {
                    string2 = SAMLUtilsCommon.generateID();
                    discoEntryElement.getResourceOffering().setEntryID(string2);
                    bl = true;
                }
                map.put(string2, discoEntryElement);
            }
            catch (Exception exception) {
                debug.error("DiscoUtils.getUserDiscoEntries: wrong format for entry. Removing it from store: " + string3);
                bl = true;
            }
        }
        return bl;
    }

    public static void getDynamicDiscoEntries(AMIdentity aMIdentity, String string, Map map, String string2) throws Exception {
        Map map2 = aMIdentity.getServiceAttributes("sunIdentityServerDiscoveryService");
        if (map2 == null) {
            return;
        }
        Set set = (Set)map2.get(string);
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        String string3 = null;
        String string4 = null;
        DiscoEntryElement discoEntryElement = null;
        ResourceIDType resourceIDType = null;
        ResourceOfferingType resourceOfferingType = null;
        String string5 = null;
        String string6 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            try {
                discoEntryElement = (DiscoEntryElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string3)));
                resourceOfferingType = discoEntryElement.getResourceOffering();
                string6 = resourceOfferingType.getServiceInstance().getProviderID();
                ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string6);
                if (resourceIDMapper == null) {
                    debug.error("DiscoUtils.getDynamicDiscoEntries: ResourceIDMapper is null for entry:" + string3);
                    continue;
                }
                string4 = resourceIDMapper.getResourceID(string6, string2);
                if (string4 == null) {
                    debug.error("DiscoUtils.getDynamicDiscoEntries: ResourceID is null for entry:" + string3);
                    continue;
                }
                resourceIDType = discoFac.createResourceIDType();
                resourceIDType.setValue(string4);
                resourceOfferingType.setResourceID(resourceIDType);
                string5 = SAMLUtilsCommon.generateID();
                resourceOfferingType.setEntryID(string5);
                map.put(string5, discoEntryElement);
            }
            catch (Exception exception) {
                debug.error("DiscoUtils.getDynamicDiscoEntries: Exception for getting entry: " + string3 + ":", (Throwable)exception);
            }
        }
    }

    public static boolean setUserDiscoEntries(AMIdentity aMIdentity, String string, Collection collection) {
        debug.message("in DiscoUtils.setUserDiscoEntries");
        try {
            Iterator iterator = collection.iterator();
            HashSet<String> hashSet = new HashSet<String>();
            Object var5_6 = null;
            StringWriter stringWriter = null;
            while (iterator.hasNext()) {
                stringWriter = new StringWriter(1000);
                marshaller.marshal((Object)((DiscoEntryElement)iterator.next()), (Writer)stringWriter);
                hashSet.add(stringWriter.getBuffer().toString());
            }
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            hashMap.put(string, hashSet);
            aMIdentity.setAttributes(hashMap);
            aMIdentity.store();
            return true;
        }
        catch (Exception exception) {
            debug.error("UserDiscoEntryHandler.setDiscoEntries: Exception", (Throwable)exception);
            return false;
        }
    }

    public static Map getQueryResults(Map hashMap, List list) {
        HashMap<String, DiscoEntryElement> hashMap2 = null;
        if (list == null || list.size() == 0) {
            debug.message("DiscoUtils.getQueryResults: no reqServiceTypes");
            hashMap2 = hashMap;
        } else {
            hashMap2 = new HashMap<String, DiscoEntryElement>();
            Iterator iterator = hashMap.keySet().iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                DiscoEntryElement discoEntryElement = (DiscoEntryElement)hashMap.get(string);
                ResourceOfferingType resourceOfferingType = discoEntryElement.getResourceOffering();
                String string2 = resourceOfferingType.getServiceInstance().getServiceType();
                List list2 = null;
                if (resourceOfferingType.getOptions() != null) {
                    list2 = resourceOfferingType.getOptions().getOption();
                }
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    QueryType.RequestedServiceTypeType requestedServiceTypeType = (QueryType.RequestedServiceTypeType)iterator2.next();
                    String string3 = requestedServiceTypeType.getServiceType();
                    if (!string3.equals(string2)) continue;
                    List list3 = null;
                    if (requestedServiceTypeType.getOptions() != null) {
                        list3 = requestedServiceTypeType.getOptions().getOption();
                    }
                    if (!DiscoUtils.evaluateOptionsRules(list3, list2)) continue;
                    hashMap2.put(string, discoEntryElement);
                    continue block0;
                }
            }
        }
        return hashMap2;
    }

    private static boolean evaluateOptionsRules(List list, List list2) {
        if (list == null || list2 == null || list.size() == 0) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!list2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean handleRemoves(Map map, List list) {
        Iterator iterator = list.iterator();
        RemoveEntryType removeEntryType = null;
        while (iterator.hasNext()) {
            removeEntryType = (RemoveEntryType)iterator.next();
            if (!map.containsKey(removeEntryType.getEntryID())) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.handleRemoves: can not remove entry: " + removeEntryType.getEntryID());
                }
                return false;
            }
            map.remove(removeEntryType.getEntryID());
        }
        return true;
    }

    public static Map handleInserts(Set set, List list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("STATUS_CODE", "Failed");
        Set set2 = DiscoServiceManager.getSupportedDirectives();
        if (debug.messageEnabled()) {
            debug.message("DiscoUtils.handleInserts: size of supportedDirective is " + set2.size());
        }
        Iterator iterator = list.iterator();
        InsertEntryType insertEntryType = null;
        DiscoEntryElement discoEntryElement = null;
        ResourceOfferingType resourceOfferingType = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            insertEntryType = (InsertEntryType)iterator.next();
            try {
                discoEntryElement = entryFac.createDiscoEntryElement();
            }
            catch (JAXBException jAXBException) {
                debug.error("DiscoUtils.handleInserts: couldn't create DiscoEntry: ", (Throwable)jAXBException);
                return hashMap;
            }
            resourceOfferingType = insertEntryType.getResourceOffering();
            String string = SAMLUtilsCommon.generateID();
            debug.message("DiscoUtils: newEntryID=" + string);
            resourceOfferingType.setEntryID(string);
            linkedList.add(string);
            discoEntryElement.setResourceOffering(resourceOfferingType);
            List list2 = insertEntryType.getAny();
            if (list2 != null && list2.size() != 0) {
                Iterator iterator2 = list2.iterator();
                Object var12_13 = null;
                while (iterator2.hasNext()) {
                    var12_13 = iterator2.next();
                    if (var12_13 instanceof AuthenticateRequesterElement) {
                        if (set2.contains("AuthenticateRequester")) continue;
                        debug.error("Directive AuthenticateRequester is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof AuthorizeRequesterElement) {
                        if (set2.contains("AuthorizeRequester")) continue;
                        debug.error("Directive AuthorizeRequester is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof AuthenticateSessionContextElement) {
                        if (set2.contains("AuthenticateSessionContext")) continue;
                        debug.error("Directive AuthenticateSessionContext is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof EncryptResourceIDElement) {
                        if (set2.contains("EncryptResourceID")) continue;
                        debug.error("Directive EncryptResourceID is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof GenerateBearerTokenElement) {
                        if (set2.contains("GenerateBearerToken")) continue;
                        debug.error("Directive GenerateBearerToken is not supported.");
                        return hashMap;
                    }
                    debug.error("Directive " + var12_13 + " is not supported.");
                    return hashMap;
                }
                discoEntryElement.getAny().addAll(list2);
            }
            if (set.add(discoEntryElement)) continue;
            debug.error("DiscoUtils.handleInserts: couldn't add DiscoEntry to Set.");
            return hashMap;
        }
        hashMap.put("STATUS_CODE", "OK");
        hashMap.put("newEntryIDs", linkedList);
        return hashMap;
    }

    public static Status parseStatus(Element element) throws DiscoveryException {
        Object object;
        if (element == null) {
            debug.message("DiscoUtils.parseStatus: nullInput");
            throw new DiscoveryException(bundle.getString("nullInput"));
        }
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        Status status = new Status(string, string2);
        String string3 = element.getAttribute("code");
        if (string3 == null || string3.length() == 0) {
            debug.message("DiscoUtils.parseStatus: missing status code.");
            throw new DiscoveryException(bundle.getString("missingStatusCode"));
        }
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        if (string3.indexOf(":") != -1) {
            object = new StringTokenizer(string3, ":");
            if (((StringTokenizer)object).countTokens() != 2) {
                debug.message("DiscoUtils.parseStatus: wrong status code.");
                throw new DiscoveryException(bundle.getString("wrongInput"));
            }
            string5 = ((StringTokenizer)object).nextToken();
            string6 = ((StringTokenizer)object).nextToken();
        }
        if (string5 != null && string2 != null && !string5.equals(string2)) {
            string4 = element.getAttribute("xmlns:" + string5);
        }
        if (string4 != null && string4.length() != 0) {
            if (string5 != null && string5.length() != 0) {
                status.setCode(new QName(string4, string6, string5));
            } else {
                status.setCode(new QName(string4, string6));
            }
        } else {
            status.setCode(new QName(string6));
        }
        status.setComment(element.getAttribute("comment"));
        status.setRef(element.getAttribute("ref"));
        object = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"urn:liberty:disco:2003-08", (String)"Status");
        int n = object.size();
        if (n != 0) {
            if (n == 1) {
                status.setSubStatus(DiscoUtils.parseStatus((Element)object.get(0)));
            } else {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.parseStatus: included more than one sub status.");
                }
                throw new DiscoveryException(bundle.getString("moreElement"));
            }
        }
        return status;
    }

    public static List parseOptions(Element element) throws DiscoveryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getLocalName();
            if (string != null) {
                String string2 = element.getNamespaceURI();
                if (string2 == null || !string2.equals("urn:liberty:disco:2003-08")) {
                    if (debug.messageEnabled()) {
                        debug.message("DiscoUtils.parseOption(Element): invalid namespace for node " + string);
                    }
                    throw new DiscoveryException(bundle.getString("wrongInput"));
                }
                if (string.equals("Option")) {
                    arrayList.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("DiscoUtils.parseOption(Element): invalid node" + string);
                    }
                    throw new DiscoveryException(bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static Element parseXML(String string) throws DiscoveryException {
        try {
            debug.message("DiscoUtils.parseXML: xmlString=" + string);
            Document document = XMLUtils.toDOMDocument((String)string, (Debug)debug);
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            debug.error("DiscoUtils.parseXML: Parsing error.", (Throwable)exception);
            throw new DiscoveryException(exception);
        }
    }

    public static Map checkPolicyAndHandleDirectives(String string, Message message, Collection collection, Authorizer authorizer, SessionContext sessionContext, String string2, SSOToken sSOToken) {
        Object object;
        debug.message("DiscoService.checkPolicyAndHandleDirectives");
        LinkedList<ResourceOffering> linkedList = new LinkedList<ResourceOffering>();
        LinkedList linkedList2 = new LinkedList();
        HashMap<String, Object> hashMap = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (InsertEntryType)iterator.next();
            if (authorizer != null) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("userID", string);
                    hashMap.put("authType", message.getAuthenticationMechanism());
                    hashMap.put("message", message);
                }
                if (!authorizer.isAuthorized(message.getToken(), "LOOKUP", object.getResourceOffering(), hashMap)) {
                    debug.error("DiscoveryService.checkPolicyAndHandleDirectives: WSC is not authorized to do lookup");
                    continue;
                }
            }
            ResourceOffering resourceOffering = null;
            try {
                resourceOffering = new ResourceOffering(Utils.convertJAXBToElement(object.getResourceOffering(), false));
            }
            catch (Exception exception) {
                debug.error("DiscoveryService.checkPolicyAndHandleDirectives:exception when constructing ResourceOffering:", (Throwable)exception);
                continue;
            }
            List list = object.getAny();
            if (list == null || list.isEmpty()) {
                debug.message("DiscoService: no directives.");
                linkedList.add(resourceOffering);
                continue;
            }
            debug.message("DiscoService: has directives.");
            DiscoUtils.handleDirectives(resourceOffering, list, string, message, sessionContext, string2, sSOToken, linkedList, linkedList2);
        }
        object = new HashMap();
        object.put(OFFERINGS, linkedList);
        object.put(CREDENTIALS, linkedList2);
        return object;
    }

    private static void handleDirectives(ResourceOffering resourceOffering, List list, String string, Message message, SessionContext sessionContext, String string2, SSOToken sSOToken, List list2, List list3) {
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        Object object4;
        HashMap hashMap = new HashMap();
        BitSet bitSet = new BitSet(SIZE);
        if (sessionContext != null && DiscoServiceManager.needSessionContextStatement()) {
            bitSet.set(SESSION);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = ((DirectiveType)object4).getDescriptionIDRefs();
            if (object4 instanceof EncryptResourceIDElement) {
                debug.message("DiscoService: has encrypt D");
                resourceOffering = DiscoUtils.doEncryption(resourceOffering);
                continue;
            }
            if (object4 instanceof AuthenticateRequesterElement) {
                DiscoUtils.setMap((List)object3, AUTHN, hashMap, bitSet);
                continue;
            }
            if (object4 instanceof AuthorizeRequesterElement) {
                DiscoUtils.setMap((List)object3, AUTHO, hashMap, bitSet);
                continue;
            }
            if (object4 instanceof AuthenticateSessionContextElement) {
                DiscoUtils.setMap((List)object3, SESSION, hashMap, bitSet);
                continue;
            }
            if (object4 instanceof GenerateBearerTokenElement) {
                DiscoUtils.setMap((List)object3, BEARER, hashMap, bitSet);
                continue;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("DiscoUtils.handleDirective: directive not supported.");
        }
        object4 = new HashMap();
        object3 = new HashMap();
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            cloneable = (BitSet)hashMap.get(object2);
            ((BitSet)cloneable).or(bitSet);
            if (object4.containsKey(cloneable)) {
                object3.put(object2, (String)object4.get(cloneable));
                continue;
            }
            object = DiscoUtils.generateCredential((BitSet)cloneable, resourceOffering, message, string, list3, sessionContext, string2, sSOToken);
            if (object == null) continue;
            object4.put(cloneable, object);
            object3.put(object2, object);
        }
        object2 = resourceOffering.getServiceInstance().getDescription().iterator();
        cloneable = null;
        while (object2.hasNext()) {
            cloneable = new ArrayList();
            object = (Description)object2.next();
            String string3 = ((Description)object).getId();
            if (string3 != null && string3.length() != 0 && object3.containsKey(string3)) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.handleDirective: containsKey:" + string3);
                }
                cloneable.add((String)object3.get(string3));
            } else {
                debug.message("DiscoUtils.handleDirective:  not containsKey");
                String string4 = (String)object3.get("all");
                if (string4 == null) {
                    if (object4.containsKey(bitSet)) {
                        string4 = (String)object4.get(bitSet);
                        object3.put("all", string4);
                        cloneable.add(string4);
                    } else if (!bitSet.equals(EMPTY_BITSET) && (string4 = DiscoUtils.generateCredential(bitSet, resourceOffering, message, string, list3, sessionContext, string2, sSOToken)) != null) {
                        object3.put("all", string4);
                        cloneable.add(string4);
                    }
                } else {
                    cloneable.add(string4);
                }
            }
            if (cloneable.isEmpty()) continue;
            ((Description)object).setCredentialRef((List)((Object)cloneable));
        }
        list2.add(resourceOffering);
    }

    private static ResourceOffering doEncryption(ResourceOffering resourceOffering) {
        ResourceID resourceID = resourceOffering.getResourceID();
        if (resourceID == null) {
            return resourceOffering;
        }
        try {
            EncryptedResourceID encryptedResourceID = EncryptedResourceID.getEncryptedResourceID(resourceID, resourceOffering.getServiceInstance().getProviderID());
            resourceOffering.setResourceID(null);
            resourceOffering.setEncryptedResourceID(encryptedResourceID);
        }
        catch (Exception exception) {
            debug.error("DiscoUtils.doEncryption: exception:", (Throwable)exception);
        }
        return resourceOffering;
    }

    private static void setMap(List list, int n, Map map, BitSet bitSet) {
        if (list == null || list.size() == 0) {
            bitSet.set(n);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = ((DescriptionType)iterator.next()).getId();
                BitSet bitSet2 = (BitSet)map.get(string);
                if (bitSet2 == null) {
                    bitSet2 = new BitSet(SIZE);
                }
                bitSet2.set(n);
                map.put(string, bitSet2);
            }
        }
    }

    private static SessionContext getSessionContext(SecurityAssertion securityAssertion) {
        if (securityAssertion == null) {
            return null;
        }
        Iterator iterator = securityAssertion.getStatement().iterator();
        SessionContext sessionContext = null;
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            int n = statement.getStatementType();
            if (!(n == 4 ? (sessionContext = ((ResourceAccessStatement)statement).getSessionContext()) != null : n == 5 && (sessionContext = ((SessionContextStatement)statement).getSessionContext()) != null)) continue;
            return sessionContext;
        }
        return null;
    }

    private static String generateCredential(BitSet bitSet, ResourceOffering resourceOffering, Message message, String string, List list, SessionContext sessionContext, String string2, SSOToken sSOToken) {
        AssertionBase assertionBase = null;
        try {
            Object object;
            Object object2;
            Object object3;
            SecurityTokenManager securityTokenManager = new SecurityTokenManager(sSOToken);
            NameIdentifier nameIdentifier = null;
            String string3 = string2;
            if ((string3 == null || string3.length() == 0) && (object3 = message.getProviderHeader()) != null) {
                string3 = ((ProviderHeader)object3).getProviderID();
            }
            if ((object3 = sessionContext) == null) {
                object3 = DiscoUtils.getSessionContext(message.getAssertion());
            }
            if (object3 != null) {
                try {
                    object2 = ((SessionContext)object3).getSessionSubject();
                    object = ((Subject)object2).getNameIdentifier();
                    if (((NameIdentifier)object).getFormat() != null && ((NameIdentifier)object).getFormat().equals("urn:liberty:iff:nameid:encrypted")) {
                        object = EncryptedNameIdentifier.getDecryptedNameIdentifier((NameIdentifier)object, DiscoServiceManager.getDiscoProviderID());
                    }
                    String string4 = resourceOffering.getServiceInstance().getProviderID();
                    FSProviderDescriptor fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string3);
                    if (fSProviderDescriptor.getNameIdentifierEncryption()) {
                        ((Subject)object2).setNameIdentifier(EncryptedNameIdentifier.getEncryptedNameIdentifier((NameIdentifier)object, string4));
                    } else {
                        ((Subject)object2).setNameIdentifier((NameIdentifier)object);
                    }
                    ((SessionContext)object3).setSessionSubject((SessionSubject)object2);
                }
                catch (Exception exception) {
                    debug.error("DiscoUtils.handleDirective: En/Decryption Exception:" + exception);
                }
            }
            if ((object2 = resourceOffering.getEncryptedResourceID()) == null) {
                object2 = resourceOffering.getResourceID();
                object2 = object2 == null ? "urn:liberty:isf:implied-resource" : ((ResourceID)object2).getResourceID();
            }
            if (bitSet.get(BEARER)) {
                if (bitSet.get(AUTHN) || bitSet.get(AUTHO) || bitSet.get(SESSION)) {
                    nameIdentifier = string3 != null && string3.length() != 0 ? new NameIdentifier(string3, null, "urn:liberty:iff:nameid:entityID") : new NameIdentifier(string);
                    assertionBase = object2 instanceof String ? securityTokenManager.getSAMLBearerToken(nameIdentifier, (SessionContext)object3, (String)object2, bitSet.get(AUTHN), bitSet.get(AUTHO)) : securityTokenManager.getSAMLBearerToken(nameIdentifier, (SessionContext)object3, (EncryptedResourceID)object2, bitSet.get(AUTHN), bitSet.get(AUTHO));
                }
            } else {
                nameIdentifier = string3 != null && string3.length() != 0 ? new NameIdentifier(string3, null, "urn:liberty:iff:nameid:entityID") : new NameIdentifier(string);
                if (string3 != null) {
                    securityTokenManager.setCertAlias(DiscoUtils.getProviderCertAlias(string3));
                } else {
                    object = message.getPeerCertificate();
                    if (object == null && (object = message.getMessageCertificate()) == null) {
                        if (debug.messageEnabled()) {
                            debug.message("DiscoUtils.generateCredential:client cert is null. Cannot generate credential.");
                        }
                        return null;
                    }
                    securityTokenManager.setCertificate((X509Certificate)object);
                }
                assertionBase = object2 instanceof String ? securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, (SessionContext)object3, (String)object2, bitSet.get(AUTHN), bitSet.get(AUTHO)) : securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, (SessionContext)object3, (EncryptedResourceID)object2, bitSet.get(AUTHN), bitSet.get(AUTHO));
            }
        }
        catch (Exception exception) {
            debug.error("DiscoUtils.generateCredential:cannot generate credential: ", (Throwable)exception);
        }
        if (assertionBase == null) {
            debug.error("DiscoUtils.generateCredential: cannot generate credential.");
            return null;
        }
        list.add(assertionBase);
        return assertionBase.getAssertionID();
    }

    private static String getProviderCertAlias(String string) throws DiscoveryException {
        try {
            FSProviderDescriptor fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string);
            return fSProviderDescriptor.getSigningKeyAlias();
        }
        catch (Exception exception) {
            debug.error("DiscoUtils.getProviderCertAlias:Exception while trying to get the certificate alias", (Throwable)exception);
            throw new DiscoveryException(exception);
        }
    }

    static {
        adminToken = null;
        bundle = Locale.getInstallResourceBundle((String)"amDisco");
        debug = Debug.getInstance((String)"amDisco");
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)Utils.getJAXBPackages());
            unmarshaller = jAXBContext.createUnmarshaller();
            marshaller = jAXBContext.createMarshaller();
        }
        catch (Exception exception) {
            debug.error("DiscoUtils:static: Initialization failed.", (Throwable)exception);
        }
        ALL = "all";
        AUTHN = 0;
        AUTHO = 1;
        SESSION = 2;
        BEARER = 3;
        LOGOUT = 4;
        SIZE = 5;
        EMPTY_BITSET = new BitSet(SIZE);
    }
}

