/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceOffering {
    private String entryID = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private ServiceInstance serviceInstance = null;
    private List options = null;
    private String abs = null;

    public ResourceOffering(ResourceID resourceID, ServiceInstance serviceInstance) {
        this.resourceID = resourceID;
        this.serviceInstance = serviceInstance;
    }

    public ResourceOffering(EncryptedResourceID encryptedResourceID, ServiceInstance serviceInstance) {
        this.encryptResID = encryptedResourceID;
        this.serviceInstance = serviceInstance;
    }

    public ResourceOffering(Element element) throws DiscoveryException {
        if (element == null) {
            DiscoUtils.debug.message("ResourceOffering(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string = null;
        String string2 = null;
        string = element.getLocalName();
        if (string == null || !string.equals("ResourceOffering") || (string2 = element.getNamespaceURI()) == null || !string2.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("ResourceOffering(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.entryID = element.getAttribute("entryID");
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string = node.getLocalName();
            if (string != null) {
                string2 = ((Element)node).getNamespaceURI();
                if (string2 == null || !string2.equals("urn:liberty:disco:2003-08")) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): invalid namespace for node " + string);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
                if (string.equals("ResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    try {
                        this.resourceID = new ResourceID((Element)node);
                    }
                    catch (DiscoveryException discoveryException) {}
                } else if (string.equals("EncryptedResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    this.encryptResID = new EncryptedResourceID((Element)node);
                } else if (string.equals("ServiceInstance")) {
                    if (this.serviceInstance != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ServiceInstance.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                    }
                    this.serviceInstance = new ServiceInstance((Element)node);
                } else if (string.equals("Options")) {
                    if (this.options != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("ResourceOffering(Element): Included more than one Options.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                    }
                    this.options = DiscoUtils.parseOptions((Element)node);
                } else if (string.equals("Abstract")) {
                    if (this.abs != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("ResourceOffering(Element): Included more than one Abstract.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                    }
                    this.abs = XMLUtils.getElementValue((Element)((Element)node));
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): invalid node" + string);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
    }

    public List getOptions() {
        return this.options;
    }

    public void setOptions(List list) {
        this.options = list;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptResID = encryptedResourceID;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public String getEntryID() {
        return this.entryID;
    }

    public void setEntryID(String string) {
        this.entryID = string;
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    public void setServiceInstance(ServiceInstance serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    public String getAbstract() {
        return this.abs;
    }

    public void setAbstract(String string) {
        this.abs = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<ResourceOffering xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.entryID != null && !this.entryID.equals("")) {
            stringBuffer.append(" entryID=\"").append(this.entryID).append("\"");
        }
        stringBuffer.append(">");
        if (this.resourceID != null) {
            stringBuffer.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            stringBuffer.append(this.encryptResID.toString());
        }
        if (this.serviceInstance != null) {
            stringBuffer.append(this.serviceInstance.toString());
        }
        if (this.options != null) {
            stringBuffer.append("<Options>");
            if (!this.options.isEmpty()) {
                Iterator iterator = this.options.iterator();
                String string = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (string == null || string.equals("")) continue;
                    stringBuffer.append("<Option>").append(string).append("</Option>");
                }
            }
            stringBuffer.append("</Options>");
        }
        if (this.abs != null && !this.abs.equals("")) {
            stringBuffer.append("<Abstract>").append(this.abs).append("</Abstract>");
        }
        stringBuffer.append("</ResourceOffering>");
        return stringBuffer.toString();
    }
}

