/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoConstants;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.StatusType;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DiscoveryService
implements RequestHandler {
    private static SecurityTokenManager stm = null;

    public DiscoveryService() {
        DiscoUtils.debug.message("In DiscoveryService constructor.");
    }

    public Message processRequest(Message message) throws Exception {
        Set set;
        List list = message.getBodies();
        if ((list = Utils.convertElementToJAXB(list)).size() != 1) {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAP message didn't contain one SOAP body.");
            throw new Exception(DiscoUtils.bundle.getString("oneBody"));
        }
        String string = message.getAuthenticationMechanism();
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoService.processRequest: authentication mechanism =" + string);
        }
        if ((set = DiscoServiceManager.getSupportedAuthenticationMechanisms()) == null || !set.contains(string)) {
            DiscoUtils.debug.error("DiscoService.processRequest: AuthenticationMechanism used is not supported by this service:" + string);
            throw new Exception(DiscoUtils.bundle.getString("authnMechNotSupported"));
        }
        Message message2 = null;
        ProviderHeader providerHeader = null;
        try {
            providerHeader = new ProviderHeader(DiscoServiceManager.getDiscoProviderID());
        }
        catch (SOAPBindingException sOAPBindingException) {
            throw new DiscoveryException(sOAPBindingException.getMessage());
        }
        if (DiscoServiceManager.useResponseAuthentication() || string.equals("urn:liberty:security:2003-08:null:X509") || string.equals("urn:liberty:security:2003-08:null:SAML") || string.equals("urn:liberty:security:2004-04:null:Bearer") || string.equals("urn:liberty:security:2003-08:TLS:X509") || string.equals("urn:liberty:security:2003-08:TLS:SAML") || string.equals("urn:liberty:security:2004-04:TLS:Bearer") || string.equals("urn:liberty:security:2003-08:ClientTLS:X509") || string.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || string.equals("urn:liberty:security:2004-04:ClientTLS:Bearer")) {
            try {
                message2 = new Message(providerHeader, stm.getX509CertificateToken());
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message with X509 token: ", (Throwable)exception);
                throw new DiscoveryException(exception.getMessage());
            }
        }
        try {
            message2 = new Message(providerHeader);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message: ", (Throwable)exception);
            throw new DiscoveryException(exception.getMessage());
        }
        Object e = list.iterator().next();
        if (e instanceof QueryType) {
            message2.setSOAPBody(this.lookup((QueryType)e, message));
        } else if (e instanceof ModifyType) {
            message2.setSOAPBody(Utils.convertJAXBToElement(this.update((ModifyType)e, message)));
        } else {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAPBody is not a Disco message.");
            throw new Exception(DiscoUtils.bundle.getString("bodyNotDisco"));
        }
        return message2;
    }

    private Element lookup(QueryType queryType, Message message) throws JAXBException {
        String string;
        DiscoUtils.debug.message("in lookup.");
        Status status = new Status("urn:liberty:disco:2003-08", "disco");
        QueryResponse queryResponse = new QueryResponse(status);
        String string2 = DiscoServiceManager.getDiscoProviderID();
        String string3 = null;
        ResourceIDType resourceIDType = queryType.getResourceID();
        string3 = resourceIDType == null ? this.getResourceID(queryType.getEncryptedResourceID(), string2) : resourceIDType.getValue();
        ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string2);
        if (resourceIDMapper == null) {
            resourceIDMapper = DiscoServiceManager.getDefaultResourceIDMapper();
        }
        if ((string = resourceIDMapper.getUserID(string2, string3, message)) == null) {
            DiscoUtils.debug.error("DiscoService.lookup: couldn't find the user associated with the resourceID:" + string3);
            status.setCode(DiscoConstants.QNAME_FAILED);
            Document document = null;
            try {
                document = XMLUtils.newDocument();
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("DiscoService.lookup:", (Throwable)exception);
            }
            DiscoUtils.getDiscoMarshaller().marshal((Object)queryResponse, (Node)document);
            return document.getDocumentElement();
        }
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoService.lookup: userDN=" + string);
        }
        DiscoEntryHandler discoEntryHandler = DiscoServiceManager.getDiscoEntryHandler();
        Map map = discoEntryHandler.getDiscoEntries(string, queryType.getRequestedServiceType());
        Collection collection = map.values();
        String string4 = DiscoUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + "." + DiscoUtils.bundle.getString("providerID") + "=" + string2 + "." + DiscoUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + "." + DiscoUtils.bundle.getString("resourceOfferingID") + "=" + string3 + "." + DiscoUtils.bundle.getString("operation") + "=" + "Lookup";
        Map map2 = null;
        if (collection.size() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: lookup NoResults for user:" + string);
            }
            status.setCode(DiscoConstants.QNAME_FAILED);
            String[] stringArray = new String[]{string};
            LogUtil.error(Level.INFO, "DS_Lookup_Failure", stringArray);
        } else {
            Object object;
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: find " + collection.size() + "ResourceOfferings for userDN:" + string);
            }
            Authorizer authorizer = null;
            if (DiscoServiceManager.needPolicyEvalLookup()) {
                DiscoUtils.debug.message("DiscoService.lookup:needPolicyEval.");
                authorizer = DiscoServiceManager.getAuthorizer();
            }
            String string5 = string;
            try {
                object = IdUtils.getIdentity((SSOToken)AccessController.doPrivileged(new AdminTokenAction()), string);
                string5 = ((AMIdentity)object).getDN();
            }
            catch (IdRepoException idRepoException) {
                DiscoUtils.debug.error("DiscoService.lookup: couldn't get userDN", (Throwable)idRepoException);
                string5 = string;
            }
            map2 = DiscoUtils.checkPolicyAndHandleDirectives(string5, message, collection, authorizer, null, null, (SSOToken)message.getToken());
            object = (List)map2.get("offerings");
            if (object.isEmpty()) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("DiscoService.lookup: after policy check and directive handling, NoResults for:" + string);
                }
                status.setCode(DiscoConstants.QNAME_FAILED);
                String[] stringArray = new String[]{string};
                LogUtil.error(Level.INFO, "DS_Lookup_Failure", stringArray);
            } else {
                queryResponse.setResourceOffering((List)object);
                DiscoUtils.debug.message("after resp.getresoff.addall");
                List list = (List)map2.get("credentials");
                if (list != null && !list.isEmpty()) {
                    DiscoUtils.debug.message("DiscoService.lookup: has cred.");
                    queryResponse.setCredentials(list);
                }
                status.setCode(DiscoConstants.QNAME_OK);
                String[] stringArray = new String[]{string};
                LogUtil.access(Level.INFO, "DS_Lookup_Success", stringArray);
            }
        }
        return XMLUtils.toDOMDocument((String)queryResponse.toString(), null).getDocumentElement();
    }

    private ModifyResponseElement update(ModifyType modifyType, Message message) throws JAXBException {
        Map map;
        String string;
        DiscoUtils.debug.message("in update.");
        ModifyResponseElement modifyResponseElement = null;
        StatusType statusType = null;
        try {
            modifyResponseElement = DiscoUtils.getDiscoFactory().createModifyResponseElement();
            statusType = DiscoUtils.getDiscoFactory().createStatusType();
            modifyResponseElement.setStatus(statusType);
        }
        catch (JAXBException jAXBException) {
            DiscoUtils.debug.error("DiscoService.update: couldn't form ModifyResponse.");
            throw jAXBException;
        }
        String string2 = DiscoServiceManager.getDiscoProviderID();
        String string3 = null;
        ResourceIDType resourceIDType = modifyType.getResourceID();
        string3 = resourceIDType == null ? this.getResourceID(modifyType.getEncryptedResourceID(), string2) : resourceIDType.getValue();
        ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string2);
        if (resourceIDMapper == null) {
            resourceIDMapper = DiscoServiceManager.getDefaultResourceIDMapper();
        }
        String string4 = resourceIDMapper.getUserID(string2, string3, message);
        String string5 = DiscoUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + "." + DiscoUtils.bundle.getString("providerID") + "=" + string2 + "." + DiscoUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + "." + DiscoUtils.bundle.getString("resourceOfferingID") + "=" + string3 + "." + DiscoUtils.bundle.getString("operation") + "=" + "Update";
        if (string4 == null) {
            DiscoUtils.debug.error("DiscoService.update: couldn't find user from resourceID: " + string3);
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            String[] stringArray = new String[]{string3};
            LogUtil.error(Level.INFO, "DS_Update_Failure", stringArray);
            return modifyResponseElement;
        }
        DiscoEntryHandler discoEntryHandler = DiscoServiceManager.getDiscoEntryHandler();
        if (DiscoServiceManager.needPolicyEvalUpdate()) {
            DiscoUtils.debug.message("DiscoService.lookup: needPolicyEval.");
            if (!this.isUpdateAllowed(string4, message, modifyType.getRemoveEntry(), modifyType.getInsertEntry(), discoEntryHandler, DiscoServiceManager.getAuthorizer())) {
                statusType.setCode(DiscoConstants.QNAME_FAILED);
                String[] stringArray = new String[]{string4};
                LogUtil.error(Level.INFO, "DS_Update_Failure", stringArray);
                return modifyResponseElement;
            }
        }
        if ((string = (String)(map = discoEntryHandler.modifyDiscoEntries(string4, modifyType.getRemoveEntry(), modifyType.getInsertEntry())).get("STATUS_CODE")).equals("OK")) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.update: modified DiscoEntries through DiscoEntryHandler successfully.");
            }
            statusType.setCode(DiscoConstants.QNAME_OK);
            List list = (List)map.get("newEntryIDs");
            if (list != null && list.size() != 0) {
                modifyResponseElement.getNewEntryIDs().addAll(list);
            }
            String[] stringArray = new String[]{string5};
            LogUtil.access(Level.INFO, "DS_Update_Success", stringArray);
        } else {
            DiscoUtils.debug.error("DiscoService.update: couldn't modify DiscoEntries through DiscoEntryHandler.");
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            String[] stringArray = new String[]{string5};
            LogUtil.error(Level.INFO, "DS_Update_Failure", stringArray);
        }
        return modifyResponseElement;
    }

    private boolean isUpdateAllowed(String string, Message message, List list, List list2, DiscoEntryHandler discoEntryHandler, Authorizer authorizer) {
        Object object;
        DiscoUtils.debug.message("DiscoService.isUpdateAllowed.");
        HashMap<String, Object> hashMap = null;
        if (list != null && list.size() != 0) {
            object = discoEntryHandler.getDiscoEntries(string, null);
            Iterator iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = ((RemoveEntryType)iterator.next()).getEntryID();
                if (!object.containsKey(string2)) {
                    DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: remove entry not exits: " + string2);
                    return false;
                }
                if (hashMap == null) {
                    hashMap = new HashMap();
                    hashMap.put("userID", string);
                    hashMap.put("authType", message.getAuthenticationMechanism());
                    hashMap.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)object.get(string2)).getResourceOffering(), hashMap)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to remove entry: " + string2);
                return false;
            }
        }
        if (list2 != null && list2.size() != 0) {
            object = list2.iterator();
            while (object.hasNext()) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("userID", string);
                    hashMap.put("authType", message.getAuthenticationMechanism());
                    hashMap.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)object.next()).getResourceOffering(), hashMap)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to insert entry.");
                return false;
            }
        }
        return true;
    }

    private String getResourceID(EncryptedResourceIDType encryptedResourceIDType, String string) {
        if (encryptedResourceIDType == null || string == null) {
            return null;
        }
        String string2 = null;
        try {
            EncryptedResourceID encryptedResourceID = new EncryptedResourceID(Utils.convertJAXBToElement(encryptedResourceIDType, false));
            ResourceID resourceID = EncryptedResourceID.getDecryptedResourceID(encryptedResourceID, string);
            if (resourceID != null) {
                string2 = resourceID.getResourceID();
            }
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryService.getResourceID: Exception:", (Throwable)exception);
        }
        return string2;
    }

    static {
        try {
            stm = new SecurityTokenManager((SSOToken)AccessController.doPrivileged(new AdminTokenAction()));
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryService.static: unable to get SecurityTokenManager: ", (Throwable)exception);
        }
    }
}

