/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SASLRequest {
    private byte[] data = null;
    private Element requestAuthnContext = null;
    private String mechanism = null;
    private String authzID = null;
    private String advisoryAuthnID = null;
    private String id = null;
    private String messageID = null;
    private String refToMessageID = null;

    public SASLRequest(String string) {
        this.mechanism = string;
    }

    public SASLRequest(Element element) throws AuthnSvcException {
        Object object;
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = nodeList.item(n2);
            if (object.getNodeType() == 1) {
                Element element3 = (Element)object;
                String string = element3.getLocalName();
                String string2 = element3.getNamespaceURI();
                if ("urn:liberty:sa:2004-04".equals(string2) && "Data".equals(string)) {
                    if (element2 != null) {
                        throw new AuthnSvcException("tooManyDataInReq");
                    }
                    if (this.requestAuthnContext != null) {
                        throw new AuthnSvcException("invalidSeqInReq");
                    }
                    element2 = element3;
                } else if ("urn:liberty:iff:2003-08".equals(string2) && "RequestAuthnContext".equals(string)) {
                    if (this.requestAuthnContext != null) {
                        throw new AuthnSvcException("tooManyReqAuthnCon");
                    }
                    this.requestAuthnContext = element3;
                } else {
                    throw new AuthnSvcException("invalidChildReq");
                }
            }
            ++n2;
        }
        this.data = AuthnSvcUtils.decodeDataElement(element2);
        this.mechanism = XMLUtils.getNodeAttributeValue((Node)element, (String)"mechanism");
        if (this.mechanism == null) {
            object = AuthnSvcUtils.getString("missingMechanism");
            AuthnSvcUtils.debug.error("SASLRequest: " + (String)object);
            throw new AuthnSvcException((String)object);
        }
        this.id = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        this.authzID = XMLUtils.getNodeAttributeValue((Node)element, (String)"authzID");
        this.advisoryAuthnID = XMLUtils.getNodeAttributeValue((Node)element, (String)"advisoryAuthnID");
    }

    public byte[] getData() {
        return this.data;
    }

    public Element getRequestAuthnContext() {
        return this.requestAuthnContext;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getAuthzID() {
        return this.authzID;
    }

    public String getAdvisoryAuthnID() {
        return this.advisoryAuthnID;
    }

    public String getId() {
        return this.id;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setRequestAuthnContext(Element element) {
        this.requestAuthnContext = element;
    }

    public void setMechanism(String string) {
        this.mechanism = string;
    }

    public void setAuthzID(String string) {
        this.authzID = string;
    }

    public void setAdvisoryAuthnID(String string) {
        this.advisoryAuthnID = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setMessageID(String string) {
        this.messageID = string;
    }

    public void setRefToMessageID(String string) {
        this.refToMessageID = string;
    }

    public Element toElement() throws AuthnSvcException {
        Document document = null;
        try {
            document = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            AuthnSvcUtils.debug.error("SASLRequest:toElement", (Throwable)exception);
            throw new AuthnSvcException(exception.getMessage());
        }
        Element element = document.createElementNS("urn:liberty:sa:2004-04", "sa:SASLRequest");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sa", "urn:liberty:sa:2004-04");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:lib", "urn:liberty:iff:2003-08");
        element.setAttributeNS(null, "mechanism", this.mechanism);
        if (this.authzID != null) {
            element.setAttributeNS(null, "authzID", this.authzID);
        }
        if (this.advisoryAuthnID != null) {
            element.setAttributeNS(null, "advisoryAuthnID", this.advisoryAuthnID);
        }
        if (this.id != null) {
            element.setAttributeNS(null, "id", this.id);
        }
        if (this.data != null) {
            Element element2 = document.createElementNS("urn:liberty:sa:2004-04", "sa:Data");
            element2.appendChild(document.createTextNode(Base64.encode((byte[])this.data)));
            element.appendChild(element2);
        }
        document.appendChild(element);
        return document.getDocumentElement();
    }
}

