/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.mechanism;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.security.AdminTokenAction;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class CramMD5MechanismHandler
implements MechanismHandler {
    private static String defaultOrg;
    private static final String PROP_SERVER_HOST = "com.iplanet.am.server.host";
    private static final String PROP_DS_HOST = "com.iplanet.am.directory.host";
    private static final String PROP_DS_PORT = "com.iplanet.am.directory.port";
    private static final String serverHost;
    private static final String dsHost;
    private static int dsPort;
    private static final int LDAP_VERSION = 3;
    private static final int MAX_RANDOM_NUM = 9999;
    private static final int NUM_RANDOM_DIGITS;
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static char[] hexChar;
    private static SecureRandom secureRandom;
    private static SSOToken adminToken;
    private static Map challengeMap;
    private static Thread cThread;

    public SASLResponse processSASLRequest(SASLRequest sASLRequest, Message message, String string) {
        String string2;
        boolean bl;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.processSASLRequest: ");
        }
        boolean bl2 = bl = (string2 = sASLRequest.getRefToMessageID()) == null || string2.length() == 0;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.processSASLRequest: refToMessageID = " + string2);
        }
        SASLResponse sASLResponse = null;
        byte[] byArray = sASLRequest.getData();
        if (byArray == null) {
            if (bl) {
                sASLResponse = new SASLResponse("continue");
                sASLResponse.setServerMechanism("CRAM-MD5");
                byte[] byArray2 = CramMD5MechanismHandler.generateChallenge();
                Map map = challengeMap;
                synchronized (map) {
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("CramMD5MechanismHandler.processSASLRequest: add respMessageID: " + string);
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(byArray2);
                    arrayList.add(new Long(System.currentTimeMillis()));
                    challengeMap.put(string, arrayList);
                }
                sASLResponse.setData(byArray2);
            } else {
                sASLResponse = new SASLResponse("abort");
            }
        } else {
            String string3 = null;
            try {
                string3 = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                AuthnSvcUtils.debug.error("CramMD5MechanismHandler.processSASLRequest: ", (Throwable)exception);
            }
            sASLResponse = string3 == null ? new SASLResponse("abort") : this.authenticate(string3, message);
            if (bl) {
                sASLResponse.setServerMechanism("PLAIN");
            }
        }
        return sASLResponse;
    }

    private SASLResponse authenticate(String string, Message message) {
        Callback[] callbackArray;
        Object object;
        int n = string.indexOf(32);
        if (n == -1) {
            return new SASLResponse("abort");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = CramMD5MechanismHandler.getUserPassword(string2);
        if (string4 == null) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: can't get password");
            }
            return new SASLResponse("abort");
        }
        String string5 = message.getCorrelationHeader().getRefToMessageID();
        if (string5 == null || string5.length() == 0) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: no refToMessageID");
            }
            return new SASLResponse("abort");
        }
        byte[] byArray = null;
        Map map = challengeMap;
        synchronized (map) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: remove refToMessageID: " + string5);
            }
            if ((object = (List)challengeMap.remove(string5)) != null) {
                byArray = (byte[])object.get(0);
            }
        }
        if (byArray == null) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: no challenge found");
            }
            return new SASLResponse("abort");
        }
        object = null;
        try {
            object = string4.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            AuthnSvcUtils.debug.error("CramMD5MechanismHandler.authenticate:", (Throwable)unsupportedEncodingException);
            return new SASLResponse("abort");
        }
        String string6 = null;
        try {
            string6 = CramMD5MechanismHandler.generateHMACMD5((byte[])object, byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AuthnSvcUtils.debug.error("CramMD5MechanismHandler.authenticate:", (Throwable)noSuchAlgorithmException);
            return new SASLResponse("abort");
        }
        if (!string3.equals(string6)) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: digests not equal");
            }
            return new SASLResponse("abort");
        }
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: digests equal");
        }
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(defaultOrg);
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
        }
        catch (AuthLoginException authLoginException) {
            AuthnSvcUtils.debug.error("CramMD5MechanismHandler.authenticate: ", (Throwable)authLoginException);
            return new SASLResponse("abort");
        }
        if (authContext.hasMoreRequirements() && (callbackArray = authContext.getRequirements()) != null) {
            CramMD5MechanismHandler.fillInCallbacks(callbackArray, string2, string4);
            authContext.submitRequirements(callbackArray);
        }
        callbackArray = authContext.getStatus();
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.authenticate: login status = " + callbackArray);
        }
        if (callbackArray != AuthContext.Status.SUCCESS) {
            return new SASLResponse("abort");
        }
        try {
            SSOToken sSOToken = authContext.getSSOToken();
            SASLResponse sASLResponse = new SASLResponse("OK");
            if (!AuthnSvcUtils.setResourceOfferingAndCredentials(sASLResponse, message, sSOToken)) {
                return new SASLResponse("abort");
            }
            return sASLResponse;
        }
        catch (Exception exception) {
            AuthnSvcUtils.debug.error("CramMD5MechanismHandler.authenticate: ", (Throwable)exception);
            return new SASLResponse("abort");
        }
    }

    private static void fillInCallbacks(Callback[] callbackArray, String string, String string2) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.fillInCallbacks:");
        }
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback = callbackArray[n];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(string);
            } else if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(string2.toCharArray());
            }
            ++n;
        }
    }

    private static byte[] generateChallenge() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        int n = secureRandom.nextInt(9999);
        String string = Integer.toString(n);
        int n2 = string.length();
        while (n2 < NUM_RANDOM_DIGITS) {
            stringBuffer.append("0");
            ++n2;
        }
        stringBuffer.append(string).append(".");
        stringBuffer.append(System.currentTimeMillis()).append("@");
        stringBuffer.append(serverHost).append(">");
        try {
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return stringBuffer.toString().getBytes();
        }
    }

    private static String getUserPassword(String string) {
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(adminToken, defaultOrg);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(true);
            idSearchControl.setTimeOut(0);
            idSearchControl.setMaxResults(0);
            idSearchControl.setAllReturnAttributes(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(IdType.USER, string, idSearchControl);
            Set set = idSearchResults.getSearchResults();
            if (set == null || set.isEmpty()) {
                if (AuthnSvcUtils.debug.messageEnabled()) {
                    AuthnSvcUtils.debug.message("CramMD5MechanismHandler.getUserPassword: no user found");
                }
                return null;
            }
            if (set.size() > 1) {
                if (AuthnSvcUtils.debug.messageEnabled()) {
                    AuthnSvcUtils.debug.message("CramMD5MechanismHandler.getUserPassword: more than 1 user found");
                }
                return null;
            }
            AMIdentity aMIdentity = (AMIdentity)set.iterator().next();
            Set set2 = aMIdentity.getAttribute("userPassword");
            if (set2 == null || set2.isEmpty()) {
                if (AuthnSvcUtils.debug.messageEnabled()) {
                    AuthnSvcUtils.debug.message("CramMD5MechanismHandler.getUserPassword: user has no password");
                }
                return null;
            }
            if (set2.size() > 1) {
                if (AuthnSvcUtils.debug.messageEnabled()) {
                    AuthnSvcUtils.debug.message("CramMD5MechanismHandler.getUserPassword: user has more than 1 passwords");
                }
                return null;
            }
            String string2 = (String)set2.iterator().next();
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("CramMD5MechanismHandler.getUserPassword: password = " + string2);
            }
            return string2;
        }
        catch (Exception exception) {
            AuthnSvcUtils.debug.error("CramMD5MechanismHandler.getUserPassword: ", (Throwable)exception);
            return null;
        }
    }

    private static String generateHMACMD5(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (byArray.length > 64) {
            byArray = messageDigest.digest(byArray);
        }
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        int n = 0;
        while (n < byArray.length) {
            byArray3[n] = (byte)(byArray[n] ^ 0x36);
            byArray4[n] = (byte)(byArray[n] ^ 0x5C);
            ++n;
        }
        int n2 = byArray.length;
        while (n2 < 64) {
            byArray3[n2] = 54;
            byArray4[n2] = 92;
            ++n2;
        }
        messageDigest.update(byArray3);
        messageDigest.update(byArray2);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        return CramMD5MechanismHandler.toHexString(byArray5);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexChar[(byArray[n] & 0xF0) >>> 4]);
            stringBuffer.append(hexChar[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        block2: {
            defaultOrg = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            serverHost = SystemProperties.get((String)PROP_SERVER_HOST, (String)"localhost");
            dsHost = SystemProperties.get((String)PROP_DS_HOST, (String)"localhost");
            dsPort = 389;
            NUM_RANDOM_DIGITS = Integer.toString(9999).length();
            hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            secureRandom = new SecureRandom();
            adminToken = null;
            challengeMap = new HashMap();
            cThread = null;
            String string = SystemProperties.get((String)PROP_DS_PORT, (String)"389");
            try {
                dsPort = Integer.parseInt(string);
            }
            catch (Exception exception) {
                if (!AuthnSvcUtils.debug.warningEnabled()) break block2;
                AuthnSvcUtils.debug.warning("CramMD5MechanismHandler.static: ", (Throwable)exception);
            }
        }
        adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        cThread = new CleanUpThread();
        cThread.start();
    }

    private static class CleanUpThread
    extends Thread {
        static final String CHALLENGE_CLEANUP_INTERVAL_PROP = "com.sun.identity.liberty.ws.authnsvc.challengeCleanupInterval";
        static int challenge_cleanup_interval;
        static final String STALE_TIME_LIMIT_PROP = "com.sun.identity.liberty.ws.soap.staleTimeLimit";
        static int stale_time_limit;

        private CleanUpThread() {
        }

        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                Iterator<Object> iterator = challengeMap.keySet().iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                Map map = challengeMap;
                synchronized (map) {
                    String string;
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("CramMD5MechanismHandler.CleanUpThread.run: challengeMap size = " + challengeMap.size());
                    }
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        List list = (List)challengeMap.get(string);
                        Long l2 = (Long)list.get(1);
                        if (l - l2 <= (long)stale_time_limit) continue;
                        arrayList.add(string);
                    }
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (AuthnSvcUtils.debug.messageEnabled()) {
                            AuthnSvcUtils.debug.message("CramMD5MechanismHandler.CleanUpThread.run: removing expired refMessageID: " + string);
                        }
                        challengeMap.remove(string);
                    }
                }
                try {
                    Thread.sleep(challenge_cleanup_interval);
                    continue;
                }
                catch (Exception exception) {
                    if (!AuthnSvcUtils.debug.messageEnabled()) continue;
                    AuthnSvcUtils.debug.message("CramMD5MechanismHandler.CleanUpThread.run:", (Throwable)exception);
                    continue;
                }
                break;
            }
        }

        static {
            block7: {
                String string;
                block6: {
                    challenge_cleanup_interval = 60000;
                    stale_time_limit = 300000;
                    string = SystemProperties.get((String)CHALLENGE_CLEANUP_INTERVAL_PROP);
                    if (string != null) {
                        try {
                            challenge_cleanup_interval = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            if (!AuthnSvcUtils.debug.warningEnabled()) break block6;
                            AuthnSvcUtils.debug.warning("CramMD5MechanismHandler.CleanUpThread.static: Unable to get stale time limit. Default value will be used", (Throwable)exception);
                        }
                    }
                }
                if ((string = SystemProperties.get((String)STALE_TIME_LIMIT_PROP)) != null) {
                    try {
                        stale_time_limit = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        if (!AuthnSvcUtils.debug.warningEnabled()) break block7;
                        AuthnSvcUtils.debug.warning("CramMD5MechanismHandler.CleanUpThread.static: Unable to get stale time limit. Default value will be used");
                    }
                }
            }
        }
    }
}

