/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcService;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class AuthnSvcRequestHandlerImpl
implements RequestHandler {
    public AuthnSvcRequestHandlerImpl() {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl constructor.");
        }
    }

    public Message processRequest(Message message) throws AuthnSvcException {
        List list = message.getBodies("urn:liberty:sa:2004-04", "SASLRequest");
        if (list.isEmpty()) {
            throw new AuthnSvcException("missingSASLRequet");
        }
        if (list.size() > 1) {
            throw new AuthnSvcException("tooManySASLRequet");
        }
        SASLRequest sASLRequest = new SASLRequest((Element)list.get(0));
        sASLRequest.setMessageID(message.getCorrelationHeader().getMessageID());
        sASLRequest.setRefToMessageID(message.getCorrelationHeader().getRefToMessageID());
        Message message2 = new Message();
        String string = message2.getCorrelationHeader().getMessageID();
        SASLResponse sASLResponse = AuthnSvcRequestHandlerImpl.processSASLRequest(sASLRequest, message, string);
        message2.setSOAPBody(sASLResponse.toElement());
        return message2;
    }

    private static SASLResponse processSASLRequest(SASLRequest sASLRequest, Message message, String string) throws AuthnSvcException {
        Object object;
        String[] stringArray;
        String string2 = sASLRequest.getMechanism().trim();
        if (AuthnSvcUtils.debug.messageEnabled()) {
            stringArray = AuthnSvcUtils.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + ", " + AuthnSvcUtils.getString("mechanism") + "=" + string2 + ", " + AuthnSvcUtils.getString("authzID") + "=" + sASLRequest.getAuthzID() + ", " + AuthnSvcUtils.getString("advisoryAuthnID") + "=" + sASLRequest.getAdvisoryAuthnID();
            AuthnSvcUtils.debug.message((String)stringArray);
        }
        stringArray = new String[]{message.getCorrelationHeader().getMessageID(), string2, sASLRequest.getAuthzID(), sASLRequest.getAdvisoryAuthnID()};
        if (string2.length() == 0) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: mechanism is empty");
            }
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, "AS_Abort", stringArray);
            }
            return new SASLResponse("abort");
        }
        Element element = sASLRequest.getRequestAuthnContext();
        MechanismHandler mechanismHandler = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            mechanismHandler = AuthnSvcService.getMechanismHandler((String)object);
            if (mechanismHandler != null) break;
        }
        if (mechanismHandler == null) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: Unable to find mechanismHandler");
            }
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, "AS_Abort", stringArray);
            }
            return new SASLResponse("abort");
        }
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: mechanismHandler = " + mechanismHandler.getClass());
        }
        object = mechanismHandler.processSASLRequest(sASLRequest, message, string);
        if (LogUtil.isLogEnabled()) {
            String string3 = ((SASLResponse)object).getStatusCode();
            if (string3.equals("OK")) {
                LogUtil.access(Level.INFO, "AS_OK", stringArray);
            } else if (string3.equals("continue")) {
                LogUtil.access(Level.INFO, "AS_Continue", stringArray);
            } else {
                LogUtil.access(Level.INFO, "AS_Abort", stringArray);
            }
        }
        return object;
    }
}

