/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.jaxrpc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.jaxrpc.SOAPClient;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.rpc.Stub;

public class JAXRPCUtil {
    static final String JAXRPC_URL = "com.sun.identity.jaxrpc.url";
    static final String JAXRPC_SERVICE = "jaxrpc";
    public static final String SMS_SERVICE = "SMSObjectIF";
    private static HashMap remoteStubs = new HashMap();
    private static String validRemoteURL;
    private static boolean serverFailed;
    private static String baseDN;
    private static Debug debug;

    public static String getValidURL(String string) throws RemoteException {
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("JAXRPCUtil: Service name is null");
            }
            throw new RemoteException("invalid-service-name");
        }
        if (serverFailed) {
            validRemoteURL = JAXRPCUtil.getValidServerURL();
        }
        if (validRemoteURL == null) {
            if (debug.warningEnabled()) {
                debug.warning("JAXRPCUtil: No vaild server found");
            }
            throw new RemoteException("no-server-found");
        }
        return validRemoteURL + string;
    }

    public static Object getRemoteStub(String string) throws RemoteException {
        Object object = null;
        if (serverFailed || (object = remoteStubs.get(string)) == null) {
            object = JAXRPCUtil.getValidStub(string);
            serverFailed = false;
        }
        return object;
    }

    public static void serverFailed(String string) {
        if (string.startsWith(validRemoteURL)) {
            serverFailed = true;
        } else {
            remoteStubs.remove(string);
        }
    }

    protected static synchronized Object getValidStub(String string) throws RemoteException {
        Object object = JAXRPCUtil.getServiceEndPoint(JAXRPCUtil.getValidURL(string));
        remoteStubs.put(string, object);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    protected static String getValidServerURL() {
        block11: {
            block10: {
                var0 = null;
                var1_1 = SystemProperties.get((String)"com.sun.identity.jaxrpc.url");
                if (var1_1 == null) break block10;
                var2_2 = new StringTokenizer(var1_1, ",");
                while (var2_2.hasMoreTokens()) {
                    var3_4 = var2_2.nextToken();
                    if (!var3_4.endsWith("/")) {
                        var3_4 = var3_4 + "/";
                    }
                    if (!JAXRPCUtil.isServerValid(var3_4)) continue;
                    return var3_4;
                }
                break block11;
            }
            var2_3 = null;
            try {
                var2_3 = WebtopNaming.getPlatformServerList().elements();
                if (true) ** GOTO lbl37
            }
            catch (Exception var3_5) {
                if (JAXRPCUtil.debug.warningEnabled()) {
                    JAXRPCUtil.debug.warning("JAXRPCUtil:getValidServerURL: Unable to get platform server", (Throwable)var3_5);
                }
                return null;
            }
            do {
                try {
                    var3_6 = new URL((String)var2_3.nextElement());
                    var4_8 = WebtopNaming.getServiceURL((String)"jaxrpc", (String)var3_6.getProtocol(), (String)var3_6.getHost(), (String)Integer.toString(var3_6.getPort()));
                    var5_10 = var4_8.toString();
                    if (!var5_10.endsWith("/")) {
                        var5_10 = var5_10 + "/";
                    }
                    if (!JAXRPCUtil.isServerValid(var5_10)) continue;
                    return var5_10;
                }
                catch (MalformedURLException var3_7) {
                    if (!JAXRPCUtil.debug.warningEnabled()) continue;
                    JAXRPCUtil.debug.warning("JAXRPCUtil:getValidServerURL: ", (Throwable)var3_7);
                }
                catch (URLNotFoundException var4_9) {
                    if (!JAXRPCUtil.debug.warningEnabled()) continue;
                    JAXRPCUtil.debug.warning("JAXRPCUtil:getValidServerURL: ", (Throwable)var4_9);
                }
lbl37:
                // 6 sources

            } while (var2_3 != null && var2_3.hasMoreElements());
        }
        return null;
    }

    protected static Object getServiceEndPoint(String string) {
        Stub stub;
        block11: {
            if (debug.messageEnabled()) {
                debug.message("JAXRPCUtil Endpoint URL: " + string);
            }
            stub = null;
            try {
                Class<?> clazz = Class.forName("com.sun.identity.jaxrpc.IdentityManagementServices_Impl");
                Object obj = clazz.newInstance();
                Method method = null;
                if (string.endsWith(SMS_SERVICE)) {
                    method = clazz.getMethod("getSMSObjectIFPort", null);
                }
                stub = (Stub)method.invoke(obj, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: unable to find class IdentityManagementServices_Impl", (Throwable)classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: unable to instantiate class IdentityManagementServices_Impl", (Throwable)instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: Illegal access to class IdentityManagementServices_Impl", (Throwable)illegalAccessException);
                }
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("JAXRPCUtil:getServiceEndPoint exception", throwable);
            }
        }
        if (stub != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
        }
        return stub;
    }

    protected static boolean isServerValid(String string) {
        try {
            if (!string.endsWith(SMS_SERVICE)) {
                string = string + SMS_SERVICE;
            }
            SOAPClient sOAPClient = new SOAPClient();
            sOAPClient.setURL(string);
            sOAPClient.send(sOAPClient.encodeMessage("checkForLocal", null), null);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("JAXRPCUtil: Connection to URL: " + string + " failed", (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    static {
        serverFailed = true;
        debug = SOAPClient.debug;
    }
}

