/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventServicePolling;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.sm.SchemaType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.ConnectionPool;

public class LDAPv3Repo
extends IdRepo {
    private static IdType[] supportedTypes = new IdType[]{IdType.USER, IdType.AGENT, IdType.GROUP, IdType.GROUP, IdType.ROLE, IdType.FILTEREDROLE, IdType.REALM};
    private Map supportedOps = new HashMap();
    private Map myConfigMap = null;
    private Map myServiceMap = null;
    private IdRepoListener myListener = null;
    private static SOAPClient mySoapClient = new SOAPClient("dummy");
    private String orgDN = "";
    private Debug debug = Debug.getInstance((String)"LDAPv3Repo");
    private ConnectionPool connPool;
    private int connNumRetry = 3;
    private int connRetryInterval = 1000;
    private int timeLimit = 5000;
    private int defaultMaxResults = 100;
    private int roleSearchScope = 2;
    private String userSearchFilter = null;
    private String groupSearchFilter = null;
    private String roleSearchFilter = "(&(objectclass=ldapsubentry)(objectclass=nsmanagedroledefinition))";
    private String filterroleSearchFilter = "(&(objectclass=ldapsubentry)(objectclass=nsfilteredroledefinition))";
    private String agentSearchFilter = null;
    private String userSearchNamingAttr = null;
    private String agentSearchNamingAttr = null;
    private String groupSearchNamingAttr = null;
    private String roleSearchNamingAttr = "cn";
    private String peopleCtnrNamingAttr = null;
    private String agentCtnrNamingAttr = null;
    private String groupCtnrNamingAttr = null;
    private String peopleCtnrValue = null;
    private String agentCtnrValue = null;
    private String groupCtnrValue = null;
    private String nsRoleAttr = "nsRole";
    private String nsRoleDNAttr = "nsRoleDN";
    private String nsRoleFilterAttr = "nsRoleFilter";
    private String memberOfAttr = null;
    private String uniqueMemberAttr = null;
    private String memberURLAttr = null;
    private String isActiveAttrName = null;
    private boolean alwaysActive = false;
    private Set filterroleObjClassSet = null;
    private Set roleObjClassSet = null;
    private Set groupObjClassSet = null;
    private Set userObjClassSet = null;
    private Set agentObjClassSet = null;
    private Map createUserAttrMap = null;
    private Set userAtttributesAllowed = null;
    private Set groupAtttributesAllowed = null;
    private Set agentAtttributesAllowed = null;
    private Set filteredroleAtttributesAllowed = null;
    private Set userSpecifiedOpsSet = null;
    private final int MIN_CONNECTION_POOL_SIZE = 1;
    private final int MAX_CONNECTION_POOL_SIZE = 10;
    private final int DEFAULTPORT = 389;
    protected static Hashtable _eventsMgr = new Hashtable();
    protected static Hashtable _numRequest = new Hashtable();
    private boolean hasListener = false;
    static final String LDAP_OBJECT_CLASS = "objectclass";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private static final String LDAPv3Config_LDAP_SERVER = "sun-idrepo-ldapv3-config-ldap-server";
    private static final String LDAPv3Config_LDAP_PORT = "sun-idrepo-ldapv3-config-ldap-port";
    private static final String LDAPv3Config_AUTHID = "sun-idrepo-ldapv3-config-authid";
    private static final String LDAPv3Config_AUTHPW = "sun-idrepo-ldapv3-config-authpw";
    private static final String LDAPv3Config_LDAP_SSL_ENABLED = "sun-idrepo-ldapv3-config-ssl-enabled";
    private static final String LDAPv3Config_LDAP_CONNECTION_POOL_MIN_SIZE = "sun-idrepo-ldapv3-config-connection_pool_min_size";
    private static final String LDAPv3Config_LDAP_CONNECTION_POOL_MAX_SIZE = "sun-idrepo-ldapv3-config-connection_pool_max_size";
    private static final String LDAPv3Config_ORGANIZATION_NAME = "sun-idrepo-ldapv3-config-organization_name";
    private static final String LDAPv3Config_LDAP_GROUP_SEARCH_FILTER = "sun-idrepo-ldapv3-config-groups-search-filter";
    private static final String LDAPv3Config_LDAP_USERS_SEARCH_FILTER = "sun-idrepo-ldapv3-config-users-search-filter";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_FILTER = "sun-idrepo-ldapv3-config-roles-search-filter";
    private static final String LDAPv3Config_LDAP_AGENT_SEARCH_FILTER = "sun-idrepo-ldapv3-config-agent-search-filter";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-roles-search-attribute";
    private static final String LDAPv3Config_LDAP_GROUPS_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-groups-search-attribute";
    private static final String LDAPv3Config_LDAP_USERS_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-users-search-attribute";
    private static final String LDAPv3Config_LDAP_AGENT_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-agent-search-attribute";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_SCOPE = "sun-idrepo-ldapv3-config-role-search-scope";
    private static final String LDAPv3Config_LDAP_GROUP_CONTAINER_NAME = "sun-idrepo-ldapv3-config-group-container-name";
    private static final String LDAPv3Config_LDAP_AGENT_CONTAINER_NAME = "sun-idrepo-ldapv3-config-agent-container-name";
    private static final String LDAPv3Config_LDAP_PEOPLE_CONTAINER_NAME = "sun-idrepo-ldapv3-config-people-container-name";
    private static final String LDAPv3Config_LDAP_GROUP_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-group-container-value";
    private static final String LDAPv3Config_LDAP_PEOPLE_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-people-container-value";
    private static final String LDAPv3Config_LDAP_AGENT_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-agent-container-value";
    private static final String LDAPv3Config_LDAP_TIME_LIMIT = "sun-idrepo-ldapv3-config-time-limit";
    private static final String LDAPv3Config_LDAP_MAX_RESULT = "sun-idrepo-ldapv3-config-max-result";
    private static final String LDAPv3Config_REFERRALS = "sun-idrepo-ldapv3-config-referrals";
    private static final String LDAPv3Config_ROLE_OBJECT_CLASS = "sun-idrepo-ldapv3-config-role-objectclass";
    private static final String LDAPv3Config_GROUP_OBJECT_CLASS = "sun-idrepo-ldapv3-config-group-objectclass";
    private static final String LDAPv3Config_USER_OBJECT_CLASS = "sun-idrepo-ldapv3-config-user-objectclass";
    private static final String LDAPv3Config_AGENT_OBJECT_CLASS = "sun-idrepo-ldapv3-config-agent-objectclass";
    private static final String LDAPv3Config_GROUP_ATTR = "sun-idrepo-ldapv3-config-group-attributes";
    private static final String LDAPv3Config_USER_ATTR = "sun-idrepo-ldapv3-config-user-attributes";
    private static final String LDAPv3Config_AGENT_ATTR = "sun-idrepo-ldapv3-config-agent-attributes";
    private static final String LDAPv3Config_NSROLE = "sun-idrepo-ldapv3-config-nsrole";
    private static final String LDAPv3Config_NSROLEDN = "sun-idrepo-ldapv3-config-nsroledn";
    private static final String LDAPv3Config_NSROLEFILTER = "sun-idrepo-ldapv3-config-nsrolefilter";
    private static final String LDAPv3Config_MEMBEROF = "sun-idrepo-ldapv3-config-memberof";
    private static final String LDAPv3Config_UNIQUEMEMBER = "sun-idrepo-ldapv3-config-uniquemember";
    private static final String LDAPv3Config_MEMBERURL = "sun-idrepo-ldapv3-config-memberurl";
    private static final String LDAPv3Config_LDAP_IDLETIMEOUT = "sun-idrepo-ldapv3-config-idletimeout";
    private static final String LDAPv3Config_LDAP_PSEARCHBASE = "sun-idrepo-ldapv3-config-psearchbase";
    private static final String LDAPv3Config_LDAP_ISACTIVEATTRNAME = "sun-idrepo-ldapv3-config-isactive";
    private static final String LDAPv3Config_LDAP_CREATEUSERMAPPING = "sun-idrepo-ldapv3-config-createuser-attr-mapping";
    private static SSOToken internalToken = null;
    private static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    private static final String VAL_STANDARD = "standard";
    private static final String CLASS_NAME = "com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo";

    public LDAPv3Repo() {
        this.loadSupportedOps();
    }

    private void initConnectionPool(Map map) {
        int n;
        LDAPConnection lDAPConnection;
        int n2;
        int n3;
        String string;
        String string2;
        int n4;
        String string3;
        block13: {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: initConnectionPool ");
            }
            HashSet hashSet = new HashSet((Set)map.get(LDAPv3Config_LDAP_SERVER));
            string3 = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                string3 = string3 == null || string3.length() == 0 ? string4 : string3 + " " + string4;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("    LDAPv3Config_LDAP_SERVER:" + hashSet + "; ldapServer:" + string3);
            }
            n4 = 389;
            string2 = this.getPropertyStringValue(map, LDAPv3Config_AUTHID);
            string = this.getPropertyStringValue(map, LDAPv3Config_AUTHPW);
            String string5 = this.getPropertyStringValue(map, LDAPv3Config_REFERRALS);
            String string6 = this.getPropertyStringValue(map, LDAPv3Config_LDAP_SSL_ENABLED);
            n3 = this.getPropertyIntValue(map, LDAPv3Config_LDAP_CONNECTION_POOL_MIN_SIZE, 1);
            n2 = this.getPropertyIntValue(map, LDAPv3Config_LDAP_CONNECTION_POOL_MAX_SIZE, 10);
            if (n3 < 1) {
                n3 = 1;
            }
            if (n2 < 1) {
                n2 = 10;
            }
            lDAPConnection = null;
            try {
                lDAPConnection = string6 != null && string6.equalsIgnoreCase("true") ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            }
            catch (Exception exception) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: initConnectionPool LDAPConnection failed", (Throwable)exception);
                }
                this.connPool = null;
            }
            try {
                lDAPConnection.setOption(17, (Object)new Integer(3));
                lDAPConnection.setOption(8, (Object)new Boolean(string5));
                lDAPConnection.setOption(4, (Object)new Integer(this.timeLimit));
                lDAPConnection.setOption(3, (Object)new Integer(this.defaultMaxResults));
                this.setDefaultReferralCredentials(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
                lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
                lDAPConnection.setSearchConstraints(lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                if (!this.debug.messageEnabled()) break block13;
                this.debug.message("LDAPv3Repo: initConnectionPool setOption failed: " + n);
            }
        }
        try {
            lDAPConnection.connect(string3, n4, string2, string);
            this.connPool = new ConnectionPool(n3, n2, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            n = lDAPException.getLDAPResultCode();
            this.debug.error("LDAPv3Repo: initConnectionPool ConnectionPool failed: " + n + "; ldapServer:" + string3);
            this.connPool = null;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: exit initConnectionPool ");
        }
    }

    protected void setDefaultReferralCredentials(LDAPConnection lDAPConnection) {
        final LDAPConnection lDAPConnection2 = lDAPConnection;
        LDAPRebind lDAPRebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String string, int n) {
                return new LDAPRebindAuth(lDAPConnection2.getAuthenticationDN(), lDAPConnection2.getAuthenticationPassword());
            }
        };
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setRebindProc(lDAPRebind);
        lDAPConnection.setSearchConstraints(lDAPSearchConstraints);
    }

    public void initialize(Map map) {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: Initializing configuration()");
        }
        super.initialize(map);
        this.myConfigMap = map;
        String string = this.getPropertyStringValue(map, "sun-idrepo-ldapv3-config-service-attributes");
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: initialize: myServiceStr: " + string);
        }
        this.myServiceMap = string != null && string.length() != 0 ? new HashMap(mySoapClient.decodeMap(string)) : new HashMap();
        if (this.debug.messageEnabled()) {
            if (this.myServiceMap != null) {
                this.debug.message("LDAPv3Repo: initialize: myServiceMap: " + this.myServiceMap);
            } else {
                this.debug.message("LDAPv3Repo: initialize: myServiceMap = null");
            }
        }
        this.timeLimit = this.getPropertyIntValue(map, LDAPv3Config_LDAP_TIME_LIMIT, this.timeLimit) * 1000;
        this.defaultMaxResults = this.getPropertyIntValue(map, LDAPv3Config_LDAP_MAX_RESULT, this.defaultMaxResults);
        this.initConnectionPool(map);
        this.orgDN = this.getPropertyStringValue(map, LDAPv3Config_ORGANIZATION_NAME);
        String string2 = this.getPropertyStringValue(map, LDAPv3Config_LDAP_ROLES_SEARCH_SCOPE);
        this.roleSearchScope = string2 != null && string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2 != null && string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userSearchFilter = this.getPropertyStringValue(map, LDAPv3Config_LDAP_USERS_SEARCH_FILTER);
        this.groupSearchFilter = this.getPropertyStringValue(map, LDAPv3Config_LDAP_GROUP_SEARCH_FILTER);
        this.agentSearchFilter = this.getPropertyStringValue(map, LDAPv3Config_LDAP_AGENT_SEARCH_FILTER);
        this.userSearchNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_USERS_SEARCH_ATTRIBUTE);
        this.agentSearchNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_AGENT_SEARCH_ATTRIBUTE);
        this.groupSearchNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_GROUPS_SEARCH_ATTRIBUTE);
        this.peopleCtnrNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_PEOPLE_CONTAINER_NAME);
        this.agentCtnrNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_AGENT_CONTAINER_NAME);
        this.groupCtnrNamingAttr = this.getPropertyStringValue(map, LDAPv3Config_LDAP_GROUP_CONTAINER_NAME);
        this.peopleCtnrValue = this.getPropertyStringValue(map, LDAPv3Config_LDAP_PEOPLE_CONTAINER_VALUE);
        this.agentCtnrValue = this.getPropertyStringValue(map, LDAPv3Config_LDAP_AGENT_CONTAINER_VALUE);
        this.groupCtnrValue = this.getPropertyStringValue(map, LDAPv3Config_LDAP_GROUP_CONTAINER_VALUE);
        this.groupObjClassSet = new HashSet((Set)map.get(LDAPv3Config_GROUP_OBJECT_CLASS));
        this.userObjClassSet = new HashSet((Set)map.get(LDAPv3Config_USER_OBJECT_CLASS));
        this.agentObjClassSet = new HashSet((Set)map.get(LDAPv3Config_AGENT_OBJECT_CLASS));
        this.memberOfAttr = this.getPropertyStringValue(map, LDAPv3Config_MEMBEROF);
        this.uniqueMemberAttr = this.getPropertyStringValue(map, LDAPv3Config_UNIQUEMEMBER);
        this.memberURLAttr = this.getPropertyStringValue(map, LDAPv3Config_MEMBERURL);
        this.userAtttributesAllowed = new CaseInsensitiveHashSet();
        this.userAtttributesAllowed.addAll((Set)map.get(LDAPv3Config_USER_ATTR));
        this.groupAtttributesAllowed = new CaseInsensitiveHashSet();
        this.groupAtttributesAllowed.addAll((Set)map.get(LDAPv3Config_GROUP_ATTR));
        this.agentAtttributesAllowed = new CaseInsensitiveHashSet();
        this.agentAtttributesAllowed.addAll((Set)map.get(LDAPv3Config_AGENT_ATTR));
        this.userSpecifiedOpsSet = new HashSet((Set)map.get("sunIdRepoSupportedOperations"));
        this.parsedUserSpecifiedOps(this.userSpecifiedOpsSet);
        this.isActiveAttrName = this.getPropertyStringValue(map, LDAPv3Config_LDAP_ISACTIVEATTRNAME);
        if (this.isActiveAttrName == null || this.isActiveAttrName.length() == 0) {
            this.alwaysActive = true;
        }
        this.createUserAttrMap = this.getCreateUserAttrMapping(map);
        this.roleObjClassSet = new HashSet();
        this.roleObjClassSet.add("ldapsubentry");
        this.roleObjClassSet.add("nssimpleroledefinition");
        this.roleObjClassSet.add("nsmanagedroledefinition");
        this.roleObjClassSet.add("nsroledefinition");
        this.filterroleObjClassSet = new HashSet();
        this.filterroleObjClassSet.add("ldapsubentry");
        this.filterroleObjClassSet.add("nscomplexroledefinition");
        this.filterroleObjClassSet.add("nsfilteredroledefinition");
        this.filterroleObjClassSet.add("nsroledefinition");
        this.filteredroleAtttributesAllowed = new CaseInsensitiveHashSet();
        this.filteredroleAtttributesAllowed.add("nsRoleFilter");
        if (this.debug.messageEnabled()) {
            this.debug.message("    userObjClassSet: " + this.userObjClassSet + "; agentObjClassSet: " + this.agentObjClassSet + ";  groupObjClassSet:" + this.groupObjClassSet + ";  roleObjClassSet:" + this.roleObjClassSet + ";  filterroleObjClassSet:" + this.filterroleObjClassSet);
            this.debug.message("    userAtttributesAllowed: " + this.userAtttributesAllowed + ";  groupAtttributesAllowed: " + this.groupAtttributesAllowed + ";  agentAtttributesAllowed: " + this.agentAtttributesAllowed + ";  filteredroleAtttributesAllowed: " + this.filteredroleAtttributesAllowed);
            this.debug.message("LDAPv3Repo: exit Initializing. timeLimit =" + this.timeLimit + "; maxResults =" + this.defaultMaxResults + "; roleSearchScope=" + this.roleSearchScope + "; orgDN=" + this.orgDN + "; createUserAttrMap=" + this.createUserAttrMap);
        }
    }

    public void shutdown() {
        this.debug.message("LDAPv3Repo: shutdown");
        super.shutdown();
        this.connPool.destroy();
    }

    public Set getSupportedOperations(IdType idType) {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getSupportedOps on " + idType + " called" + "\n\tcont LDAPv3Repo: supportedOps Map = " + this.supportedOps.toString());
        }
        return (Set)this.supportedOps.get(idType);
    }

    public Set getSupportedTypes() {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getSupportedTypes: supportedOps.keySet=" + this.supportedOps.keySet());
        }
        return this.supportedOps.keySet();
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string) throws IdRepoUnsupportedOpException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: isActive called: type:" + idType + "; name:" + string);
        }
        if (!idType.equals(IdType.USER)) {
            Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
        }
        if (this.alwaysActive) {
            try {
                boolean bl = this.isExists(sSOToken, idType, string);
                return bl;
            }
            catch (IdRepoException idRepoException) {
                return false;
            }
        }
        Map map = null;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.isActiveAttrName);
        try {
            map = this.getAttributes(sSOToken, idType, string, hashSet);
        }
        catch (IdRepoException idRepoException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("  LDAPv3Repo: isActive idrepoerr=" + idRepoException);
            }
            return false;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("  LDAPv3Repo: isActive attrMap=" + map);
        }
        Set set = (Set)map.get(this.isActiveAttrName);
        String string2 = null;
        if (set != null && set.size() == 1) {
            string2 = (String)set.iterator().next();
            return !string2.equalsIgnoreCase("inactive");
        }
        return true;
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        String string2;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: isExists called " + idType + ": " + string);
        }
        LDAPEntry lDAPEntry = null;
        try {
            string2 = this.getDN(idType, string);
        }
        catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
            return false;
        }
        catch (IdRepoException idRepoException) {
            return false;
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        try {
            lDAPEntry = lDAPConnection.read(string2);
        }
        catch (LDAPException lDAPException) {
            switch (lDAPException.getLDAPResultCode()) {
                case 32: {
                    if (!this.debug.messageEnabled()) break;
                    this.debug.message("LDAPv3Repo: isExists: The specified entry does not exist.");
                    break;
                }
                case 9: {
                    if (!this.debug.messageEnabled()) break;
                    this.debug.message("LDAPv3Repo: isExists: Entry served by a different LDAP server.");
                    break;
                }
                case 50: {
                    if (!this.debug.messageEnabled()) break;
                    this.debug.message("LDAPv3Repo: isExists: You do not have the access rights to perform this operation.");
                    break;
                }
                default: {
                    if (!this.debug.messageEnabled()) break;
                    this.debug.message("LDAPv3Repo: isExists: Error number: " + lDAPException.getLDAPResultCode() + "\n\tLDAPv3Repo: isExists: " + "Could not read the specified entry.", (Throwable)lDAPException);
                }
            }
            this.connPool.close(lDAPConnection);
            int n = lDAPException.getLDAPResultCode();
            if (n == 80 || n == 81 || n == 82) {
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            return false;
        }
        this.connPool.close(lDAPConnection);
        return true;
    }

    public synchronized void removeListener() {
        Object object;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: removeListener called ");
        }
        HashSet hashSet = new HashSet((Set)this.myConfigMap.get(LDAPv3Config_LDAP_SERVER));
        Object object2 = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            object2 = object2 == null || ((String)object2).length() == 0 ? object : (String)object2 + " " + (String)object;
        }
        if (object2 == null) {
            this.debug.error("LDAPv3Repo: removeListener failed. missing ldap server name.");
        }
        if ((object = (LDAPv3EventService)_eventsMgr.get(object2)) != null) {
            if (this.hasListener) {
                ((LDAPv3EventService)object).removeListener(this);
                Integer n = (Integer)_numRequest.get(object2);
                if (n != null) {
                    int n2 = n;
                    if (n2 <= 1) {
                        _eventsMgr.remove(object2);
                        _numRequest.remove(object2);
                    } else {
                        _numRequest.remove(object2);
                        _numRequest.put(object2, new Integer(n2 - 1));
                    }
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3Repo: removeListener.  requestInt=" + n2);
                    }
                }
            } else {
                Integer n = (Integer)_numRequest.get(object2);
                if (n == null) {
                    _eventsMgr.remove(object2);
                }
            }
        }
    }

    public synchronized int addListener(SSOToken sSOToken, IdRepoListener idRepoListener) throws IdRepoException, SSOException {
        String string;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: addListener called  LDAPv3Config_LDAP_SERVER=" + this.configMap.get(LDAPv3Config_LDAP_SERVER) + "; LDAPv3Config_LDAP_PSEARCHBASE=" + this.configMap.get(LDAPv3Config_LDAP_PSEARCHBASE) + "; LDAPv3Config_LDAP_IDLETIMEOUT=" + this.configMap.get(LDAPv3Config_LDAP_IDLETIMEOUT));
        }
        this.myListener = idRepoListener;
        HashSet hashSet = new HashSet((Set)this.myConfigMap.get(LDAPv3Config_LDAP_SERVER));
        String string2 = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = string2 == null || string2.length() == 0 ? string : string2 + " " + string;
        }
        if (string2 == null) {
            this.debug.error("LDAPv3Repo: addListener failed. missing ldap server name.");
            return 0;
        }
        string = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHBASE);
        if (string2 == null) {
            this.debug.error("LDAPv3Repo: addListener failed. missing persistence search base.");
            return 0;
        }
        LDAPv3EventService lDAPv3EventService = (LDAPv3EventService)_eventsMgr.get(string2);
        if (lDAPv3EventService == null) {
            int n = this.getPropertyIntValue(this.myConfigMap, LDAPv3Config_LDAP_IDLETIMEOUT, 0);
            try {
                lDAPv3EventService = n == 0 ? new LDAPv3EventService(this.myConfigMap) : new LDAPv3EventServicePolling(this.myConfigMap);
                _eventsMgr.put(string2, lDAPv3EventService);
            }
            catch (LDAPException lDAPException) {
                this.debug.error("LDAPv3Repo: addListener failed. new eventService failed. LDAPException=", (Throwable)lDAPException);
                Object[] objectArray = new Object[]{CLASS_NAME};
                throw new IdRepoException("amIdRepo", "218", objectArray);
            }
        }
        String string3 = "(objectclass=*)";
        int n = 15;
        try {
            String string4 = lDAPv3EventService.addListener(sSOToken, idRepoListener, string, 2, string3, n, this.myConfigMap, this);
            Integer n2 = (Integer)_numRequest.get(string2);
            int n3 = n2 == null ? 1 : n2 + 1;
            _numRequest.put(string2, new Integer(n3));
        }
        catch (IdRepoException idRepoException) {
            String string5 = idRepoException.getErrorCode();
            this.debug.error("LDAPv3Repo: addListener failed. persistant search not supported");
        }
        catch (LDAPException lDAPException) {
            this.debug.error("LDAPv3Repo: addListener failed. eventService.addListener.LDAPException", (Throwable)lDAPException);
            Object[] objectArray = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "218", objectArray);
        }
        this.hasListener = true;
        return 0;
    }

    private Map getAllowedAttrs(IdType idType, Map map) {
        Set set = Collections.EMPTY_SET;
        if (idType.equals(IdType.USER)) {
            set = this.userAtttributesAllowed;
        } else if (idType.equals(IdType.AGENT)) {
            set = this.agentAtttributesAllowed;
        } else if (idType.equals(IdType.GROUP)) {
            set = this.groupAtttributesAllowed;
        } else {
            if (idType.equals(IdType.ROLE)) {
                return new HashMap(map);
            }
            if (idType.equals(IdType.FILTEREDROLE)) {
                set = this.filteredroleAtttributesAllowed;
            }
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            if (set2 == null) continue;
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    private Map addAttrMapping(IdType idType, String string, Map map) {
        if (this.debug.messageEnabled()) {
            this.debug.message("enter addAttrMapping: createUserAttrMap=" + this.createUserAttrMap);
            this.prtAttrMap(map);
        }
        if (idType.equals(IdType.USER)) {
            Iterator iterator = this.createUserAttrMap.keySet().iterator();
            while (iterator.hasNext()) {
                Set<String> set;
                String string2 = (String)iterator.next();
                if (map.containsKey(string2)) continue;
                String string3 = (String)this.createUserAttrMap.get(string2);
                if (string3.equalsIgnoreCase(string2)) {
                    set = new HashSet<String>();
                    set.add(string);
                    map.put(string2, set);
                    continue;
                }
                set = (Set)map.get(string3);
                if (set == null) continue;
                map.put(string2, set);
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("exit addAttrMapping: ");
            this.prtAttrMap(map);
        }
        return map;
    }

    public String create(SSOToken sSOToken, IdType idType, String string, Map map) throws IdRepoException, SSOException {
        Object[] objectArray;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: Create called on " + idType + ": " + string);
            this.prtAttrMap(map);
        }
        String string2 = this.getDN(idType, string);
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        Set set = null;
        if (idType.equals(IdType.USER)) {
            set = this.userObjClassSet;
        } else if (idType.equals(IdType.AGENT)) {
            set = this.agentObjClassSet;
        } else if (idType.equals(IdType.GROUP)) {
            set = this.groupObjClassSet;
        } else if (idType.equals(IdType.ROLE)) {
            set = this.roleObjClassSet;
        } else if (idType.equals(IdType.FILTEREDROLE)) {
            set = this.filterroleObjClassSet;
        } else {
            Object[] objectArray2 = new Object[]{CLASS_NAME, IdOperation.CREATE.getName(), idType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray2);
        }
        map = this.getAllowedAttrs(idType, map);
        map = this.addAttrMapping(idType, string, map);
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        if (map != null && !map.isEmpty()) {
            HashSet hashSet;
            Set set2;
            String string3;
            boolean bl = false;
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            objectArray = map.keySet().iterator();
            while (objectArray.hasNext()) {
                string3 = (String)objectArray.next();
                if (string3.equalsIgnoreCase(LDAP_OBJECT_CLASS)) {
                    set2 = (Set)map.get(string3);
                    hashSet = new HashSet(set2);
                    hashSet.addAll(set);
                    hashMap.put(string3, hashSet);
                    bl = true;
                    continue;
                }
                set2 = (Set)map.get(string3);
                if (set2.isEmpty()) continue;
                hashMap.put(string3, set2);
            }
            if (!bl) {
                hashMap.put(LDAP_OBJECT_CLASS, set);
            }
            objectArray = hashMap.keySet().iterator();
            while (objectArray.hasNext()) {
                string3 = (String)objectArray.next();
                set2 = (Set)hashMap.get(string3);
                Object object = hashSet = set2 == null ? null : set2.toArray(new String[set2.size()]);
                if (this.debug.messageEnabled()) {
                    if (string3.equalsIgnoreCase("userpassword")) {
                        this.debug.message("    : attrName= " + string3);
                    } else {
                        this.debug.message("    : attrName= " + string3 + " set:" + set2);
                    }
                }
                lDAPAttributeSet.add(new LDAPAttribute(string3, hashSet));
            }
        } else {
            String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
            lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJECT_CLASS, stringArray));
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("    : before ld.add: eDN=" + string2);
        }
        try {
            LDAPEntry lDAPEntry = new LDAPEntry(string2, lDAPAttributeSet);
            lDAPConnection.add(lDAPEntry);
            this.connPool.close(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            this.debug.error("LDAPv3Repo.create failed. errorCode=" + lDAPException.getLDAPResultCode() + "  " + lDAPException.getLDAPErrorMessage());
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo.create failed", (Throwable)lDAPException);
            }
            this.connPool.close(lDAPConnection);
            int n = lDAPException.getLDAPResultCode();
            objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
            if (n == 80 || n == 81 || n == 82) {
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            throw new IdRepoException("amIdRepo", "306", objectArray);
        }
        return string2;
    }

    public void delete(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: delete called on " + idType + ": " + string);
        }
        String string2 = this.getDN(idType, string);
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        try {
            try {
                lDAPConnection.delete(string2);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                String string3 = lDAPException.getLDAPErrorMessage();
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: delete, error: " + n + "errmsg=" + string3, (Throwable)lDAPException);
                }
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                if (n == 80 || n == 81 || n == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                if (n == 32) {
                    objectArray[0] = CLASS_NAME;
                    objectArray[1] = string2;
                    throw new IdRepoException("amIdRepo", "220", objectArray);
                }
                throw new IdRepoException("amIdRepo", "306", objectArray);
            }
            Object var11_6 = null;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getAttributes called: " + idType + ": " + string + " ; attrName=" + set);
        }
        Map map = this.getAttributes(sSOToken, idType, string, set, true);
        return map;
    }

    private Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, boolean bl) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getAttributes called: " + idType + ": " + string + " ; attrName=" + set);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (idType.equals(IdType.REALM) && set != null && set.contains(LDAP_OBJECT_CLASS)) {
            return hashMap;
        }
        String string2 = this.getDN(idType, string);
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        Set set2 = null;
        if (idType.equals(IdType.USER)) {
            set2 = this.userAtttributesAllowed;
        } else if (idType.equals(IdType.AGENT)) {
            set2 = this.agentAtttributesAllowed;
        } else if (idType.equals(IdType.GROUP)) {
            set2 = this.groupAtttributesAllowed;
        } else if (idType.equals(IdType.FILTEREDROLE)) {
            set2 = this.filteredroleAtttributesAllowed;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("  LDAPv3Repo: predefinedAttr=" + set2 + "; attrNames=" + set);
        }
        try {
            Object[] objectArray;
            LDAPEntry lDAPEntry = null;
            if (set == null) {
                lDAPEntry = lDAPConnection.read(string2);
            } else {
                if (set2 != null) {
                    objectArray = new HashSet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        if (!set2.contains(string3)) continue;
                        objectArray.add(string3);
                    }
                    set = objectArray;
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("  LDAPv3Repo: before read: attrNames=" + set);
                }
                lDAPEntry = lDAPConnection.read(string2, set.toArray(new String[set.size()]));
            }
            if (lDAPEntry == null) {
                this.debug.error("getAttributes: unable to find dn:" + string2 + " to retrieve its attributes.");
                this.connPool.close(lDAPConnection);
                objectArray = new Object[]{CLASS_NAME, string2};
                throw new IdRepoException("amIdRepo", "211", objectArray);
            }
            objectArray = lDAPEntry.getAttributeSet();
            int n = objectArray.size();
            int n2 = 0;
            while (n2 < n) {
                LDAPAttribute lDAPAttribute = objectArray.elementAt(n2);
                if (lDAPAttribute != null) {
                    String string4 = lDAPAttribute.getName();
                    if (this.debug.messageEnabled()) {
                        this.debug.message("  LDAPv3Repo: after read: attrName=" + string4);
                    }
                    if (set2 == null || set2.contains(string4.toLowerCase())) {
                        Object object;
                        HashSet<String> hashSet = new HashSet<String>();
                        if (bl) {
                            object = lDAPAttribute.getStringValues();
                            while (object != null && object.hasMoreElements()) {
                                String string5 = (String)object.nextElement();
                                hashSet.add(string5);
                            }
                            hashMap.put(string4.toLowerCase(), hashSet);
                        } else {
                            object = lDAPAttribute.getByteValueArray();
                            hashMap.put(string4, object);
                            if (this.debug.messageEnabled()) {
                                this.debug.message("   getAttribute binary: values=" + object);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (LDAPException lDAPException) {
            String string6 = lDAPException.getLDAPErrorMessage();
            if (this.debug.warningEnabled()) {
                this.debug.warning("LDAPv3Repo.getAttributes failed. errorCode=" + lDAPException.getLDAPResultCode() + "  " + string6);
            }
            this.connPool.close(lDAPConnection);
            int n = lDAPException.getLDAPResultCode();
            Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
            if (n == 80 || n == 81 || n == 82) {
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            if (n == 32) {
                objectArray[0] = CLASS_NAME;
                objectArray[1] = string2;
                throw new IdRepoException("amIdRepo", "220", objectArray);
            }
            throw new IdRepoException("amIdRepo", "306", objectArray);
        }
        this.connPool.close(lDAPConnection);
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getAttributes returns theAttrMap: " + hashMap);
        }
        return hashMap;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getAttributes called: " + idType + ": " + string);
        }
        return this.getAttributes(sSOToken, idType, string, null);
    }

    public Map getBinaryAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("getBinaryAttributes: ...");
        }
        return this.getAttributes(sSOToken, idType, string, set, false);
    }

    public void setBinaryAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("setBinaryAttributes: type:" + idType + "; name=" + string + "; attributes=" + map + "; isAdd:" + bl);
        }
        this.setAttributes(sSOToken, idType, string, map, bl, false);
    }

    private Set findDynamicGroupMembersByUrl(LDAPUrl lDAPUrl) throws IdRepoException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                if (this.debug.messageEnabled()) {
                    this.debug.message("search filter in LDAPGroups : " + lDAPUrl.getFilter());
                }
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), lDAPUrl.getScope(), lDAPUrl.getFilter(), null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        throw new IdRepoException(lDAPException.errorCodeToString());
                    }
                }
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                String string = lDAPException.getLDAPErrorMessage();
                this.debug.error("LDAPv3Repo: findDynamicGroupMembersByUrl. ld.search error: " + n);
                if (this.debug.messageEnabled()) {
                    this.debug.error("LDAPv3Repo: findDynamicGroupMembersByUrl failed", (Throwable)lDAPException);
                }
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                if (n == 80 || n == 81 || n == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                throw new IdRepoException("amIdRepo", "306", objectArray);
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
        return hashSet;
    }

    private Set getGroupMembers(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        HashSet<String> hashSet;
        block15: {
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry;
            block14: {
                hashSet = new HashSet<String>();
                String string2 = null;
                try {
                    string2 = this.getDN(idType, string);
                }
                catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                    return null;
                }
                catch (IdRepoException idRepoException) {
                    return null;
                }
                LDAPConnection lDAPConnection = this.connPool.getConnection();
                lDAPEntry = null;
                try {
                    try {
                        lDAPEntry = lDAPConnection.read(string2);
                    }
                    catch (LDAPException lDAPException) {
                        this.debug.error("LDAPGroups: invalid group name " + string);
                        int n = lDAPException.getLDAPResultCode();
                        if (this.debug.messageEnabled()) {
                            this.debug.message("LDAPGroups: invalid group name " + string, (Throwable)lDAPException);
                        }
                        Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                        if (n == 80 || n == 81 || n == 82) {
                            throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                        }
                        Set set = null;
                        Object var14_12 = null;
                        this.connPool.close(lDAPConnection);
                        return set;
                    }
                    Object var14_11 = null;
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    this.connPool.close(lDAPConnection);
                    throw throwable;
                }
                this.connPool.close(lDAPConnection);
                lDAPAttribute = lDAPEntry.getAttribute(this.uniqueMemberAttr);
                if (lDAPAttribute == null) break block14;
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    hashSet.add(string3);
                }
                break block15;
            }
            lDAPAttribute = lDAPEntry.getAttribute(this.memberURLAttr);
            if (lDAPAttribute == null) break block15;
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                try {
                    LDAPUrl lDAPUrl = new LDAPUrl(string4);
                    Set set = this.findDynamicGroupMembersByUrl(lDAPUrl);
                    hashSet.addAll(set);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IdRepoException("MalformedURLException");
                }
            }
        }
        return hashSet;
    }

    private Set getManagedRoleMembers(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        LDAPSearchResults lDAPSearchResults = null;
        try {
            String string2 = "(" + this.nsRoleDNAttr + "=" + this.getDN(idType, string) + ")";
            if (this.debug.messageEnabled()) {
                this.debug.message("search filter in getManagedRoleMembers: " + string2);
            }
            lDAPSearchResults = lDAPConnection.search(this.orgDN, this.roleSearchScope, string2, null, false, lDAPSearchConstraints);
            while (lDAPSearchResults.hasMoreElements()) {
                try {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (lDAPEntry == null) continue;
                    hashSet.add(lDAPEntry.getDN());
                }
                catch (LDAPReferralException lDAPReferralException) {
                }
                catch (LDAPException lDAPException) {
                    this.connPool.close(lDAPConnection);
                    int n = lDAPException.getLDAPResultCode();
                    if (n == 3 || n == 4) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("LDAPv3Plugin: getManagedRoleMembers search iteration size/time limit reached: " + lDAPException.getMessage());
                        }
                        return hashSet;
                    }
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3Plugin: getManagedRoleMembers search iteration exception", (Throwable)lDAPException);
                    }
                    Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                    if (n == 80 || n == 81 || n == 82) {
                        throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    }
                    throw new IdRepoException("amIdRepo", "306", objectArray);
                }
            }
        }
        catch (LDAPException lDAPException) {
            this.connPool.close(lDAPConnection);
            int n = lDAPException.getLDAPResultCode();
            this.debug.error("LDAPv3Repo: getManagedRoleMembers, ld.search error" + n);
            if (this.debug.messageEnabled()) {
                this.debug.error("LDAPv3Repo: getManagedRoleMembers, ld.search error", (Throwable)lDAPException);
            }
            Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
            if (n == 80 || n == 81 || n == 82) {
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            throw new IdRepoException("amIdRepo", "306", objectArray);
        }
        this.connPool.close(lDAPConnection);
        return hashSet;
    }

    private Set getFilteredRoleMembers(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        String[] stringArray = new String[]{this.nsRoleFilterAttr};
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getDN(idType, string);
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.nsRoleFilterAttr);
            if (lDAPAttribute != null) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.orgDN, this.roleSearchScope, string3, null, false, lDAPSearchConstraints);
                    while (lDAPSearchResults.hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry2 = lDAPSearchResults.next();
                            if (lDAPEntry2 == null) continue;
                            hashSet.add(lDAPEntry2.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            this.connPool.close(lDAPConnection);
                            int n = lDAPException.getLDAPResultCode();
                            if (n == 3 || n == 4) {
                                if (this.debug.messageEnabled()) {
                                    this.debug.message("LDAPv3Plugin: getManagedRoleMembers search iteration size/time limit reached: " + lDAPException.getMessage());
                                }
                                return hashSet;
                            }
                            if (this.debug.messageEnabled()) {
                                this.debug.message("LDAPv3Repo: getFilteredRoleMembers iteration exception", (Throwable)lDAPException);
                            }
                            Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                            if (n == 80 || n == 81 || n == 82) {
                                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                            }
                            throw new IdRepoException("amIdRepo", "306", objectArray);
                        }
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            this.connPool.close(lDAPConnection);
            int n = lDAPException.getLDAPResultCode();
            this.debug.error("LDAPv3Repo: getFilteredRoleMembers, ld.read" + n);
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: getFilteredRoleMembers, ld.read", (Throwable)lDAPException);
            }
            Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
            if (n == 80 || n == 81 || n == 82) {
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            throw new IdRepoException("amIdRepo", "306", objectArray);
        }
        this.connPool.close(lDAPConnection);
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getMembers(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getMembers called" + idType + ": " + string + ": " + idType2);
        }
        Set set = null;
        if (idType.equals(IdType.USER) || idType.equals(IdType.AGENT)) {
            this.debug.error("AMSDKRepo: Membership operation is not supported  for Users or Agents");
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        if (idType.equals(IdType.GROUP)) {
            if (idType2.equals(IdType.USER)) {
                return this.getGroupMembers(sSOToken, idType, string, idType2);
            }
            this.debug.error("AMSDKRepo: Groups do not supported membership for " + idType2.getName());
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        if (idType.equals(IdType.ROLE)) {
            if (idType2.equals(IdType.USER)) {
                return this.getManagedRoleMembers(sSOToken, idType, string, idType2);
            }
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        if (idType.equals(IdType.FILTEREDROLE)) {
            if (idType2.equals(IdType.USER)) {
                return this.getFilteredRoleMembers(sSOToken, idType, string, idType2);
            }
            Object[] objectArray = new Object[]{CLASS_NAME, idType2.getName(), idType.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getGroupMemberShips(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        String[] stringArray = new String[]{this.memberOfAttr};
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getDN(idType, string);
        try {
            block6: {
                try {
                    LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.memberOfAttr);
                    if (lDAPAttribute == null) break block6;
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        hashSet.add(string3);
                    }
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    this.debug.error("LDAPv3Repo: getGroupMemberShips. ld.read error: " + n);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3Repo: getGroupMemberShips. ld.read error", (Throwable)lDAPException);
                    }
                    Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                    if (n == 80) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    if (n == 81) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    if (n != 82) throw new IdRepoException("amIdRepo", "306", objectArray);
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
            }
            Object var15_17 = null;
            this.connPool.close(lDAPConnection);
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getManagedRoleMemberShips(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        String[] stringArray = new String[]{this.nsRoleDNAttr};
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getDN(idType, string);
        try {
            block6: {
                try {
                    LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.nsRoleDNAttr);
                    if (lDAPAttribute == null) break block6;
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        hashSet.add(string3);
                    }
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    this.debug.error("LDAPv3Repo: getManagedRoleMemberShips. ld.read error" + n);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("LDAPv3Repo: getManagedRoleMemberShips. ld.read error", (Throwable)lDAPException);
                    }
                    Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                    if (n == 80) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    if (n == 81) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    if (n != 82) throw new IdRepoException("amIdRepo", "306", objectArray);
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
            }
            Object var15_17 = null;
            this.connPool.close(lDAPConnection);
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
    }

    private Set getFilteredRoleMemberShips(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        String[] stringArray = new String[]{this.nsRoleAttr};
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getDN(idType, string);
        try {
            try {
                Object object;
                LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.nsRoleAttr);
                if (lDAPAttribute != null) {
                    object = lDAPAttribute.getStringValues();
                    while (object != null && object.hasMoreElements()) {
                        String string3 = (String)object.nextElement();
                        hashSet.add(string3);
                    }
                }
                object = this.getManagedRoleMemberShips(sSOToken, idType, string, idType2);
                hashSet.removeAll((Collection<?>)object);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                this.debug.error("LDAPv3Repo: getFilteredRoleMemberShips: ld.read: error" + n);
                if (this.debug.messageEnabled()) {
                    this.debug.error("LDAPv3Repo: getFilteredRoleMemberShips: ld.read: error", (Throwable)lDAPException);
                }
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                if (n == 80 || n == 81 || n == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                throw new IdRepoException("amIdRepo", "306", objectArray);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
        return hashSet;
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getMemberships called" + idType + ": " + string + ": " + idType2);
        }
        Set set = null;
        if (!idType.equals(IdType.USER) && !idType.equals(IdType.AGENT)) {
            this.debug.error("AMSDKRepo: Membership for identities other than  Users is not allowed ");
            Object[] objectArray = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", objectArray);
        }
        if (idType2.equals(IdType.GROUP)) {
            set = this.getGroupMemberShips(sSOToken, idType, string, idType2);
        } else if (idType2.equals(IdType.ROLE)) {
            set = this.getManagedRoleMemberShips(sSOToken, idType, string, idType2);
        } else if (idType2.equals(IdType.FILTEREDROLE)) {
            set = this.getFilteredRoleMemberShips(sSOToken, idType, string, idType2);
        } else {
            this.debug.error("AMSDKRepo: Membership for other types of entities not supported for Users");
            Object[] objectArray = new Object[]{CLASS_NAME, idType.getName(), idType2.getName()};
            throw new IdRepoException("amIdRepo", "204", objectArray);
        }
        return set;
    }

    private void modifyGroupMembership(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n) throws IdRepoException, SSOException {
        String string2 = this.getDN(idType, string);
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(this.uniqueMemberAttr, string3);
            LDAPAttribute lDAPAttribute2 = new LDAPAttribute(this.memberOfAttr, string2);
            LDAPModification lDAPModification = null;
            LDAPModification lDAPModification2 = null;
            switch (n) {
                case 1: {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPModification2 = new LDAPModification(0, lDAPAttribute2);
                    break;
                }
                case 2: {
                    lDAPModification = new LDAPModification(1, lDAPAttribute);
                    lDAPModification2 = new LDAPModification(1, lDAPAttribute2);
                }
            }
            try {
                lDAPConnection.modify(string2, lDAPModification);
                lDAPConnection.modify(string3, lDAPModification2);
            }
            catch (LDAPException lDAPException) {
                int n2 = lDAPException.getLDAPResultCode();
                this.debug.error("LDAPv3Repo: modifyGroupMembership ld.modify: " + n2 + " groupDN = " + string2 + " userDN= " + string3);
                this.connPool.close(lDAPConnection);
                if (this.debug.messageEnabled()) {
                    this.debug.error("LDAPv3Repo: modifyGroupMembership ld.modify", (Throwable)lDAPException);
                }
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n2)};
                if (n2 == 80 || n2 == 81 || n2 == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                throw new IdRepoException("amIdRepo", "306", objectArray);
            }
        }
        this.connPool.close(lDAPConnection);
    }

    private void modifyRoleMembership(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n) throws IdRepoException, SSOException {
        String string2 = this.getDN(idType, string);
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            LDAPModification lDAPModification = null;
            String string3 = (String)iterator.next();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(this.nsRoleDNAttr, string2);
            switch (n) {
                case 1: {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    break;
                }
                case 2: {
                    lDAPModification = new LDAPModification(1, lDAPAttribute);
                }
            }
            try {
                lDAPConnection.modify(string3, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                int n2 = lDAPException.getLDAPResultCode();
                this.debug.error("LDAPv3Repo: modifyRoleMembership ld.modify: " + n2 + " userDN= " + string3 + " roleDN= " + string2);
                if (this.debug.messageEnabled()) {
                    this.debug.error("LDAPv3Repo: modifyRoleMembership ld.modify", (Throwable)lDAPException);
                }
                this.connPool.close(lDAPConnection);
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n2)};
                if (n2 == 80 || n2 == 81 || n2 == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                throw new IdRepoException("amIdRepo", "306", objectArray);
            }
        }
        this.connPool.close(lDAPConnection);
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n) throws IdRepoException, SSOException {
        Object[] objectArray;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: modifyMemberShip called " + idType + "; name= " + string + "; members= " + set + "; membersType= " + idType2 + "; operation= " + n);
        }
        if (set == null || set.isEmpty()) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo.modifyMemberShip: Members set is empty");
            }
            throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        }
        if (idType.equals(IdType.USER) || idType.equals(IdType.AGENT)) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo.modifyMembership: Memberhsip to users and agents is not supported");
            }
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        if (!idType2.equals(IdType.USER)) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo.modifyMembership: A non-user type cannot  be made a member of any identity" + idType2.getName());
            }
            Object[] objectArray2 = new Object[]{CLASS_NAME};
            throw new IdRepoException(IdRepoBundle.getString("206", objectArray2), "206", objectArray2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            String string2 = this.getDN(idType2, (String)objectArray);
            hashSet.add(string2);
        }
        if (idType.equals(IdType.GROUP)) {
            this.modifyGroupMembership(sSOToken, idType, string, hashSet, idType2, n);
        } else if (idType.equals(IdType.ROLE)) {
            this.modifyRoleMembership(sSOToken, idType, string, hashSet, idType2, n);
        } else {
            this.debug.error("AMSDKRepo.modifyMembership: Memberships cannot bemodified for type= " + idType.getName());
            objectArray = new Object[]{CLASS_NAME, idType.getName()};
            throw new IdRepoException("amIdRepo", "209", objectArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set) throws IdRepoException, SSOException {
        Object object;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: removeAttributes called " + idType + ": " + string + set);
        }
        if (set == null) throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        if (set.isEmpty()) {
            throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        }
        Set set2 = null;
        if (idType.equals(IdType.USER)) {
            set2 = this.userAtttributesAllowed;
        } else if (idType.equals(IdType.AGENT)) {
            set2 = this.agentAtttributesAllowed;
        } else if (idType.equals(IdType.GROUP)) {
            set2 = this.groupAtttributesAllowed;
        } else if (idType.equals(IdType.FILTEREDROLE)) {
            set2 = this.filteredroleAtttributesAllowed;
        }
        String string2 = this.getDN(idType, string);
        if (set == null) return;
        if (!set.isEmpty()) return;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (set2 != null && !set2.contains(object)) continue;
            LDAPAttribute lDAPAttribute = new LDAPAttribute((String)object);
            lDAPModificationSet.add(2, lDAPAttribute);
        }
        object = this.connPool.getConnection();
        try {
            try {
                object.modify(string2, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                this.debug.error("LDAPv3Repo: setAttributes, ld.modify error: " + n);
                if (this.debug.messageEnabled()) {
                    this.debug.error("LDAPv3Repo: setAttributes, ld.modify error", (Throwable)lDAPException);
                }
                Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                if (n == 80) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                if (n == 81) throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                if (n == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                }
                if (n != 32) throw new IdRepoException("amIdRepo", "306", objectArray);
                objectArray[0] = CLASS_NAME;
                objectArray[1] = string2;
                throw new IdRepoException("amIdRepo", "220", objectArray);
            }
            Object var14_12 = null;
            this.connPool.close(object);
            return;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this.connPool.close(object);
            throw throwable;
        }
    }

    public RepoSearchResults search(SSOToken sSOToken, IdType idType, String string, int n, int n2, Set set, boolean bl, int n3, Map map, boolean bl2) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: new search called:type:" + idType + " ;pattern:" + string + " ;avPairs: " + map);
            this.debug.message("  cont LDAPv3Repo: search: maxTime:" + n + " ;maxResults:" + n2 + " ;returnAttrs: " + set);
            this.debug.message("  cont LDAPv3Repo: search:returnAllAttrs:" + bl + " ;filterOp:" + n3 + " ;recursive:" + bl2 + " ;returnAttrs: " + set);
        }
        String string2 = this.getBaseDN(idType);
        int n4 = 2;
        if (!bl2) {
            n4 = 1;
        }
        boolean bl3 = false;
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints();
        if (n2 < 1) {
            lDAPSearchConstraints.setMaxResults(this.defaultMaxResults);
        } else {
            lDAPSearchConstraints.setMaxResults(n2);
        }
        if (n < 1) {
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        } else {
            lDAPSearchConstraints.setServerTimeLimit(n * 1000);
        }
        String string3 = this.getNamingAttr(idType);
        String[] stringArray = null;
        if (bl) {
            stringArray = new String[]{"*"};
        } else if (set != null && !set.isEmpty()) {
            set.add(string3);
            stringArray = set.toArray(new String[set.size()]);
        } else {
            stringArray = new String[]{string3};
        }
        LDAPSearchResults lDAPSearchResults = null;
        String string4 = this.getObjClassFilter(idType);
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 == 0) {
            stringBuffer.append("(|");
        } else if (n3 == 1) {
            stringBuffer.append("(&");
        }
        stringBuffer.append("(&").append(this.constructFilter(string3, string4, string));
        if (map != null && map.size() > 0) {
            stringBuffer.append(this.constructFilter(map));
        }
        stringBuffer.append(")");
        if (n3 == 1 || n3 == 0) {
            stringBuffer.append(")");
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: before ld.search call:filterSB:" + stringBuffer + " ; base:" + string2);
            if (stringArray != null) {
                this.debug.message("          theAttr[0]: " + stringArray[0]);
            } else {
                this.debug.message("          theAttr[0]:=null");
            }
        }
        try {
            lDAPSearchResults = lDAPConnection.search(string2, n4, stringBuffer.toString(), stringArray, bl3, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            int n5 = lDAPException.getLDAPResultCode();
            this.connPool.close(lDAPConnection);
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: search, ld.search error: " + n5);
            }
            Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n5)};
            if (n5 == 80 || n5 == 81 || n5 == 82) {
                throw new IdRepoFatalException("amIdRepo", "306", objectArray);
            }
            if (n5 == 32) {
                return new RepoSearchResults(new HashSet(), 0, Collections.EMPTY_MAP, idType);
            }
            throw new IdRepoException("amIdRepo", "306", objectArray);
        }
        int n6 = 0;
        HashMap hashMap = new HashMap();
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                Enumeration enumeration;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string5 = lDAPEntry.getDN();
                HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
                if (bl) {
                    object4 = lDAPEntry.getAttributeSet();
                    int n7 = object4.size();
                    int n8 = 0;
                    while (n8 < n7) {
                        object3 = object4.elementAt(n8);
                        if (object3 != null) {
                            object2 = object3.getName();
                            object = new HashSet<String>();
                            Enumeration enumeration2 = object3.getStringValues();
                            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                                String string6 = (String)enumeration2.nextElement();
                                object.add(string6);
                            }
                            hashMap2.put(object2, object);
                        }
                        ++n8;
                    }
                    object3 = (Set)hashMap2.get(string3);
                    object2 = string5;
                    if (object3 != null && !object3.isEmpty()) {
                        object2 = (String)object3.iterator().next();
                    }
                    hashSet.add(object2);
                    hashMap.put((String)object2, hashMap2);
                    continue;
                }
                if (set != null && !set.isEmpty()) {
                    object4 = set.iterator();
                    while (object4.hasNext()) {
                        String string7 = (String)object4.next();
                        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string7);
                        object3 = new HashSet();
                        if (lDAPAttribute != null) {
                            object2 = lDAPAttribute.getStringValues();
                            while (object2 != null && object2.hasMoreElements()) {
                                object = (String)object2.nextElement();
                                object3.add(object);
                            }
                        }
                        hashMap2.put(string7, object3);
                    }
                    Set set2 = (Set)hashMap2.get(string3);
                    String string8 = string5;
                    if (set2 != null && !set2.isEmpty()) {
                        string8 = (String)set2.iterator().next();
                    }
                    hashSet.add(string8);
                    hashMap.put(string8, hashMap2);
                    continue;
                }
                object4 = string5;
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string3);
                if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                    object4 = (String)enumeration.nextElement();
                }
                hashSet.add(object4);
            }
        }
        catch (LDAPException lDAPException) {
            int n9 = lDAPException.getLDAPResultCode();
            switch (n6) {
                case 3: {
                    n6 = 2;
                    break;
                }
                case 4: {
                    n6 = 1;
                    break;
                }
                default: {
                    n6 = n9;
                }
            }
        }
        this.connPool.close(lDAPConnection);
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: exit search allEntries:" + hashSet + " ;allEntryMap:" + hashMap);
        }
        return new RepoSearchResults(hashSet, n6, hashMap, idType);
    }

    public RepoSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: old search called" + idType + ": " + string + ": " + map);
        }
        return this.search(sSOToken, idType, string, n2, n, set, true, -1, map, bl);
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl) throws IdRepoException, SSOException {
        this.setAttributes(sSOToken, idType, string, map, bl, true);
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, boolean bl2) throws IdRepoException, SSOException {
        Object object;
        Object object2;
        Object object3;
        LDAPConnection lDAPConnection;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: setAttributes called: " + idType + ": " + string);
            this.prtAttrMap(map);
        }
        if (map == null || map.isEmpty()) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: setAttributes. Attributes are empty");
            }
            throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        }
        String string2 = this.getDN(idType, string);
        Set set = null;
        if (idType.equals(IdType.USER)) {
            set = this.userAtttributesAllowed;
        } else if (idType.equals(IdType.AGENT)) {
            set = this.agentAtttributesAllowed;
        } else if (idType.equals(IdType.GROUP)) {
            set = this.groupAtttributesAllowed;
        } else if (idType.equals(IdType.FILTEREDROLE)) {
            set = this.filteredroleAtttributesAllowed;
        }
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            lDAPConnection = null;
            object3 = (String)iterator.next();
            if (set != null && !set.contains(object3)) continue;
            if (bl2) {
                object2 = (Set)map.get(object3);
                Object object4 = object = object2 == null ? null : object2.toArray(new String[object2.size()]);
                if (object2 == null || object2.isEmpty()) {
                    lDAPConnection = new LDAPAttribute((String)object3);
                    lDAPModificationSet.add(2, (LDAPAttribute)lDAPConnection);
                    continue;
                }
                lDAPConnection = new LDAPAttribute((String)object3, (String[])object);
                if (bl) {
                    lDAPModificationSet.add(0, (LDAPAttribute)lDAPConnection);
                    continue;
                }
                lDAPModificationSet.add(2, (LDAPAttribute)lDAPConnection);
                continue;
            }
            object2 = (byte[][])map.get(object3);
            lDAPConnection = new LDAPAttribute((String)object3);
            int n = ((Object)object2).length;
            int n2 = 0;
            while (n2 < n) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("setAttributes binary:" + object2[n2]);
                }
                lDAPConnection.addValue((byte[])object2[n2]);
                ++n2;
            }
            if (bl) {
                lDAPModificationSet.add(0, (LDAPAttribute)lDAPConnection);
            } else {
                lDAPModificationSet.add(2, (LDAPAttribute)lDAPConnection);
            }
            if (!this.debug.messageEnabled()) continue;
            this.debug.message("setAttribute binary attrBytes:" + object2);
        }
        if (lDAPModificationSet.size() == 0) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: setAttributes. LdapModSet is empty");
            }
            throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        }
        if (idType.equals(IdType.USER)) {
            lDAPConnection = new HashSet();
            object3 = new HashSet();
            object3.add(LDAP_OBJECT_CLASS);
            object2 = this.getAttributes(sSOToken, idType, string, (Set)object3);
            if (object2 != null && !object2.isEmpty() && (object = (Set)object2.values().iterator().next()) != null && !object.isEmpty()) {
                Iterator iterator2 = this.userObjClassSet.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    boolean bl3 = false;
                    Iterator iterator3 = object.iterator();
                    while (iterator3.hasNext()) {
                        String string4 = (String)iterator3.next();
                        if (!string3.equalsIgnoreCase(string4)) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    lDAPConnection.add(string3);
                }
            }
            if (!lDAPConnection.isEmpty()) {
                lDAPModificationSet.add(0, new LDAPAttribute(LDAP_OBJECT_CLASS, lDAPConnection.toArray(new String[lDAPConnection.size()])));
            }
        }
        lDAPConnection = this.connPool.getConnection();
        try {
            try {
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: setAttributes. Calling ld.modify");
                }
                lDAPConnection.modify(string2, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (this.debug.warningEnabled()) {
                    this.debug.warning("LDAPv3Repo: setAttributes, ld.modify error: " + n, (Throwable)lDAPException);
                }
                object = new Object[]{CLASS_NAME, Integer.toString(n)};
                if (n == 80 || n == 81 || n == 82) {
                    throw new IdRepoFatalException("amIdRepo", "306", (Object[])object);
                }
                if (n == 32) {
                    object[0] = CLASS_NAME;
                    object[1] = string2;
                    throw new IdRepoException("amIdRepo", "220", (Object[])object);
                }
                throw new IdRepoException("amIdRepo", "306", (Object[])object);
            }
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: assignService called. IdType=" + idType + "; name=" + string + "; serviceName=" + string2 + "; SchemaType=" + schemaType + "; attrMap=" + map);
        }
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.USER)) {
            Set set = (Set)map.get(LDAP_OBJECT_CLASS);
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(LDAP_OBJECT_CLASS);
            Map map2 = this.getAttributes(sSOToken, idType, string, hashSet);
            Set set2 = (Set)map2.get(LDAP_OBJECT_CLASS);
            set = AMCommonUtils.combineOCs(set, set2);
            map.put(LDAP_OBJECT_CLASS, set);
            if (schemaType.equals(SchemaType.USER)) {
                this.setAttributes(sSOToken, idType, string, map, false);
            } else if (schemaType.equals(SchemaType.DYNAMIC)) {
                return;
            }
        } else if (idType.equals(IdType.REALM)) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: assignService: before myServiceMap:" + this.myServiceMap);
            }
            if (string2 != null && string2.length() > 0 && map != null) {
                HashMap hashMap = new HashMap(map);
                this.myServiceMap.put(string2, hashMap);
            } else {
                this.debug.message("LDAPv3Repo: assignService: not stored. null or 0");
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: assignService: after myServiceMap:" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(string2, this.myServiceMap);
            }
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("  exit assignService.  myServiceMap:" + this.myServiceMap);
        }
    }

    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: unassignService called. IdType=" + idType + "; name=" + string + "; serviceName=" + string2 + "; attrMap=" + map);
        }
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.REALM)) {
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: unassignService: before myServiceMap:" + this.myServiceMap);
            }
            if (string2 != null && string2.length() > 0) {
                this.myServiceMap.remove(string2);
            } else {
                this.debug.message("LDAPv3Repo: unassignService: serviceName is null or 0");
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: unassignService: after myServiceMap:" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(string2, this.myServiceMap);
            }
        } else if (idType.equals(IdType.USER)) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Set set = (Set)map.get(LDAP_OBJECT_CLASS);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(LDAP_OBJECT_CLASS);
            Map map2 = this.getAttributes(sSOToken, idType, string, hashSet);
            Set set2 = (Set)map2.get(LDAP_OBJECT_CLASS);
            set = AMCommonUtils.updateAndGetRemovableOCs(set2, set);
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                object3 = null;
                try {
                    object3 = new HashSet(this.getOCAttributes((String)object4));
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    this.debug.error("LDAPv3Repo: unassignService. get Object Attributes failed: " + n);
                    if (this.debug.messageEnabled()) {
                        this.debug.error("LDAPv3Repo: unassignService.", (Throwable)lDAPException);
                    }
                    Object[] objectArray = new Object[]{CLASS_NAME, Integer.toString(n)};
                    if (n == 80 || n == 81 || n == 82) {
                        throw new IdRepoFatalException("amIdRepo", "306", objectArray);
                    }
                    throw new IdRepoException("amIdRepo", "306", objectArray);
                }
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    hashSet2.add(((String)object).toLowerCase());
                }
            }
            object4 = this.getAttributes(sSOToken, idType, string);
            object3 = object4.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!hashSet2.contains(object2)) continue;
                try {
                    object = new AMHashMap();
                    object.put(object2, Collections.EMPTY_SET);
                    this.setAttributes(sSOToken, idType, string, (Map)object, false);
                }
                catch (Exception exception) {
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("unassignService failed. error occurred while removing attribute: " + object2);
                }
            }
            object2 = new AMHashMap();
            object2.put(LDAP_OBJECT_CLASS, set2);
            this.setAttributes(sSOToken, idType, string, (Map)object2, false);
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getAssignedServices. IdType=" + idType + "; Name=" + string + "; mapOfServiceNamesandOCs=" + map);
            this.debug.message("     getAssignedServices. myServiceMap=" + this.myServiceMap);
        }
        Set<Object> set = new HashSet();
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.USER)) {
            Set set2 = this.readObjectClass(sSOToken, idType, string);
            set2 = this.convertToLowerCase(set2);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Set set3 = (Set)map.get(string2);
                set3 = this.convertToLowerCase(set3);
                if (set2 == null || !set2.containsAll(set3)) continue;
                set.add(string2);
            }
            if (this.myServiceMap != null) {
                set.addAll(this.myServiceMap.keySet());
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: getAssignedServices returns resultsSet: " + set);
            }
        } else if (idType.equals(IdType.REALM)) {
            set = this.myServiceMap.keySet();
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: getAssignedServices: resultsSet: " + set + "; myServiceMap:" + this.myServiceMap);
            }
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        return set;
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: getServiceAttributes. IdType=" + idType + "; Name=" + string + "; serviceName=" + string2 + "; attrNames=" + set);
        }
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.USER)) {
            Object object;
            Map map = this.getAttributes(sSOToken, idType, string, set);
            if (string2 == null || string2.length() == 0) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: getServiceAttribute. userAttrs=" + map);
                }
                return map;
            }
            Map map2 = (Map)this.myServiceMap.get(string2);
            HashMap hashMap = new HashMap();
            if (map2 == null || map2.isEmpty()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: getServiceAttribute: return userAttrs:" + map);
                }
                return map;
            }
            Object object2 = map2.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!set.contains(object)) continue;
                hashMap.put((String)object, map2.get(object));
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("    mySrvAttrMap=" + hashMap);
                this.debug.message("    srvCfgAttrMap=" + map2);
                this.debug.message("    userAttrs=" + map);
            }
            object2 = map.keySet();
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                if (object2.contains(string3)) {
                    Set set2 = (Set)map.get(string3);
                    Set set3 = (Set)hashMap.get(string3);
                    set2.addAll(set3);
                    map.put(string3, set2);
                    continue;
                }
                map.put(string3, hashMap.get(string3));
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("    on exit: userAttrs= " + map);
            }
            return map;
        }
        if (idType.equals(IdType.REALM)) {
            Map map = (Map)this.myServiceMap.get(string2);
            if (map == null || map.isEmpty()) {
                this.debug.message("LDAPv3Repo: getServiceAttributes. REALM returns empty");
                return new HashMap();
            }
            if (set == null || set.isEmpty()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("LDAPv3Repo: getServiceAttributes. REALM: attrNames is null or empty. srvCfgAttrMap=" + map);
                }
                return new HashMap(map);
            }
            HashMap hashMap = new HashMap();
            Set set4 = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!set4.contains(string4)) continue;
                hashMap.put(string4, map.get(string4));
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: getServiceAttributes. REALM resultMap=" + hashMap);
            }
            return hashMap;
        }
        Object[] objectArray = new Object[]{this.getClass().getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: modifyService. IdType=" + idType + "; Name=" + string + "; serviceName=" + string2 + "; SchemaType=" + schemaType + "; attrMap=" + map);
        }
        if (idType.equals(IdType.AGENT) || idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
        if (idType.equals(IdType.REALM)) {
            Map map2;
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: modifyService. REALM before. myServiceMap" + this.myServiceMap);
            }
            if ((map2 = (Map)this.myServiceMap.get(string2)) == null || map2.isEmpty()) {
                this.myServiceMap.put(string2, new HashMap(map));
            } else {
                Set set = map2.keySet();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (set.contains(string3)) {
                        Set set2 = (Set)map.get(string3);
                        Set set3 = (Set)map2.get(string3);
                        set3.clear();
                        set3.addAll(set2);
                        map2.put(string3, set3);
                        continue;
                    }
                    map2.put(string3, map.get(string3));
                }
                this.myServiceMap.put(string2, map2);
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: modifyService. REALM after. myServiceMap" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(string2, this.myServiceMap);
                this.debug.message("LDAPv3Repo: modifyService calls setServiceAttributes:" + this.myServiceMap);
            }
        } else if (idType.equals(IdType.USER)) {
            if (schemaType.equals(SchemaType.DYNAMIC)) {
                Object[] objectArray = new Object[]{this.getClass().getName(), schemaType.toString(), idType.getName()};
                throw new IdRepoException("amIdRepo", "214", objectArray);
            }
            this.setAttributes(sSOToken, idType, string, map, false);
        } else {
            Object[] objectArray = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", objectArray);
        }
    }

    private Collection getOCAttributes(String string) throws LDAPException {
        Collection collection = this.getRequiredAttributes(string);
        collection.addAll(this.getOptionalAttributes(string));
        return collection;
    }

    private Collection getRequiredAttributes(String string) throws LDAPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            Enumeration enumeration = lDAPObjectClassSchema.getRequiredAttributes();
            while (enumeration.hasMoreElements()) {
                arrayList.add((String)enumeration.nextElement());
            }
        }
        return arrayList;
    }

    private Collection getOptionalAttributes(String string) throws LDAPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            Enumeration enumeration = lDAPObjectClassSchema.getOptionalAttributes();
            while (enumeration.hasMoreElements()) {
                arrayList.add((String)enumeration.nextElement());
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LDAPSchema getLDAPSchema() throws LDAPException {
        Object object;
        LDAPConnection lDAPConnection;
        LDAPSchema lDAPSchema;
        block18: {
            LDAPSchema lDAPSchema2;
            block16: {
                block17: {
                    lDAPSchema = new LDAPSchema();
                    lDAPConnection = this.connPool.getConnection();
                    object = null;
                    try {
                        try {
                            object = lDAPConnection.getProperty(SCHEMA_BUG_PROPERTY);
                            lDAPConnection.setProperty(SCHEMA_BUG_PROPERTY, (Object)VAL_STANDARD);
                            int n = 0;
                            while (n <= this.connNumRetry) {
                                if (this.debug.messageEnabled()) {
                                    this.debug.message("LDAPv3Repo.getLDAPSchema retry: " + n);
                                }
                                try {
                                    if (n > 0) {
                                        try {
                                            lDAPConnection.read("fake=fake");
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    lDAPSchema.fetchSchema(lDAPConnection, "cn=schema");
                                    lDAPSchema2 = lDAPSchema;
                                    Object var8_10 = null;
                                    if (object == null) break block16;
                                    break block17;
                                }
                                catch (LDAPException lDAPException) {
                                    ++n;
                                    try {
                                        Thread.currentThread();
                                        Thread.sleep(this.connRetryInterval);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                            break block18;
                        }
                        catch (LDAPException lDAPException) {
                            this.debug.error("LDAPv3Repo.getLDAPSchema Exception: ", (Throwable)lDAPException);
                            throw lDAPException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (object != null) {
                            lDAPConnection.setProperty(SCHEMA_BUG_PROPERTY, object);
                        }
                        this.connPool.close(lDAPConnection);
                        throw throwable;
                    }
                }
                lDAPConnection.setProperty(SCHEMA_BUG_PROPERTY, object);
            }
            this.connPool.close(lDAPConnection);
            return lDAPSchema2;
        }
        Object var8_11 = null;
        if (object != null) {
            lDAPConnection.setProperty(SCHEMA_BUG_PROPERTY, object);
        }
        this.connPool.close(lDAPConnection);
        return lDAPSchema;
    }

    private Set readObjectClass(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(LDAP_OBJECT_CLASS);
        Map map = this.getAttributes(sSOToken, idType, string, hashSet);
        Set set = (Set)map.get(LDAP_OBJECT_CLASS);
        return set;
    }

    private Set convertToLowerCase(Set set) {
        if (set == null || set.isEmpty()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((String)iterator.next()).toLowerCase());
        }
        return hashSet;
    }

    private Set parseInputedOps(StringTokenizer stringTokenizer, boolean bl) {
        HashSet<IdOperation> hashSet = new HashSet<IdOperation>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("read")) {
                hashSet.add(IdOperation.READ);
                continue;
            }
            if (string.equalsIgnoreCase("edit")) {
                hashSet.add(IdOperation.EDIT);
                continue;
            }
            if (string.equalsIgnoreCase("create")) {
                hashSet.add(IdOperation.CREATE);
                continue;
            }
            if (string.equalsIgnoreCase("delete")) {
                hashSet.add(IdOperation.DELETE);
                continue;
            }
            if (!string.equalsIgnoreCase("service") || !bl) continue;
            hashSet.add(IdOperation.SERVICE);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("parseInputedOps exit: opsReadSet:" + hashSet);
        }
        return hashSet;
    }

    private void parsedUserSpecifiedOps(Set set) {
        if (this.debug.messageEnabled()) {
            this.debug.message("parsedUserSpecifiedOps entry: userSpecifiedOpsSet:" + set);
        }
        IdType idType = null;
        Object var3_3 = null;
        HashMap hashMap = new HashMap(this.supportedOps);
        this.supportedOps.clear();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            idType = null;
            Set set2 = null;
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "= ,");
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (this.debug.messageEnabled()) {
                    this.debug.message("    idtypeToken:" + string2);
                }
                if (string2.equalsIgnoreCase("user")) {
                    idType = IdType.USER;
                    set2 = this.parseInputedOps(stringTokenizer, true);
                } else if (string2.equalsIgnoreCase("group")) {
                    idType = IdType.GROUP;
                    set2 = this.parseInputedOps(stringTokenizer, false);
                } else if (string2.equalsIgnoreCase("agent")) {
                    idType = IdType.AGENT;
                    set2 = this.parseInputedOps(stringTokenizer, false);
                } else if (string2.equalsIgnoreCase("role")) {
                    idType = IdType.ROLE;
                    set2 = this.parseInputedOps(stringTokenizer, false);
                } else if (string2.equalsIgnoreCase("filteredrole")) {
                    idType = IdType.FILTEREDROLE;
                    set2 = this.parseInputedOps(stringTokenizer, false);
                } else if (string2.equalsIgnoreCase("realm")) {
                    idType = IdType.REALM;
                    set2 = this.parseInputedOps(stringTokenizer, true);
                } else {
                    idType = null;
                }
            }
            if (idType == null || set2 == null || set2.isEmpty()) continue;
            this.supportedOps.put(idType, set2);
            if (!this.debug.messageEnabled()) continue;
            this.debug.message("parsedUserSpecifiedOps called supportedOps:" + this.supportedOps + "; idTypeRead:" + idType + "; opsRead:" + set2);
        }
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> hashSet = new HashSet<IdOperation>();
        hashSet.add(IdOperation.CREATE);
        hashSet.add(IdOperation.DELETE);
        hashSet.add(IdOperation.EDIT);
        hashSet.add(IdOperation.READ);
        hashSet.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(hashSet));
        this.supportedOps.put(IdType.REALM, Collections.unmodifiableSet(hashSet));
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.remove(IdOperation.SERVICE);
        this.supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(hashSet2));
        this.supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(hashSet2));
        this.supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(hashSet2));
        this.supportedOps.put(IdType.FILTEREDROLE, Collections.unmodifiableSet(hashSet2));
        if (this.debug.messageEnabled()) {
            this.debug.message("loadSupportedOps: supportedOps: " + this.supportedOps);
        }
    }

    private String getObjClassFilter(IdType idType) {
        String string = null;
        string = idType.equals(IdType.USER) ? this.userSearchFilter : (idType.equals(IdType.GROUP) ? this.groupSearchFilter : (idType.equals(IdType.ROLE) ? this.roleSearchFilter : (idType.equals(IdType.FILTEREDROLE) ? this.filterroleSearchFilter : (idType.equals(IdType.AGENT) ? this.agentSearchFilter : this.userSearchFilter))));
        if (this.debug.messageEnabled()) {
            this.debug.message("getObjClassFilter returns: objClassFilter=" + string);
        }
        return string;
    }

    private String getNamingAttr(IdType idType) {
        String string = null;
        string = idType.equals(IdType.USER) ? this.userSearchNamingAttr : (idType.equals(IdType.GROUP) ? this.groupSearchNamingAttr : (idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE) ? this.roleSearchNamingAttr : (idType.equals(IdType.AGENT) ? this.agentSearchNamingAttr : this.userSearchNamingAttr)));
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDN(IdType idType, String string) throws IdRepoException {
        String string2 = string;
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            string = string + ",";
        }
        if (idType.equals(IdType.USER)) {
            if (this.peopleCtnrValue != null && this.peopleCtnrValue.length() != 0 && this.peopleCtnrNamingAttr != null && this.peopleCtnrNamingAttr.length() != 0) {
                return this.userSearchNamingAttr + "=" + string + this.peopleCtnrNamingAttr + "=" + this.peopleCtnrValue + "," + this.orgDN;
            }
            String string3 = this.userSearchNamingAttr + "=" + string + this.orgDN;
            String string4 = this.constructFilter(this.userSearchNamingAttr, this.getObjClassFilter(IdType.USER), string2);
            LDAPConnection lDAPConnection = null;
            try {
                block12: {
                    try {
                        lDAPConnection = this.connPool.getConnection();
                        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.orgDN, 2, string4, null, false);
                        if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) break block12;
                        string3 = lDAPSearchResults.next().getDN();
                    }
                    catch (Exception exception) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("LDAPv3Repo: getDN user search", (Throwable)exception);
                        }
                        Object var9_11 = null;
                        if (lDAPConnection == null) return string3;
                        this.connPool.close(lDAPConnection);
                        return string3;
                    }
                }
                Object var9_10 = null;
                if (lDAPConnection == null) return string3;
                this.connPool.close(lDAPConnection);
                return string3;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (lDAPConnection == null) throw throwable;
                this.connPool.close(lDAPConnection);
                throw throwable;
            }
        }
        if (idType.equals(IdType.AGENT)) {
            if (this.agentCtnrValue == null) return this.agentSearchNamingAttr + "=" + string + this.orgDN;
            if (this.agentCtnrValue.length() == 0) return this.agentSearchNamingAttr + "=" + string + this.orgDN;
            if (this.agentCtnrNamingAttr == null) return this.agentSearchNamingAttr + "=" + string + this.orgDN;
            if (this.agentCtnrNamingAttr.length() == 0) return this.agentSearchNamingAttr + "=" + string + this.orgDN;
            return this.agentSearchNamingAttr + "=" + string + this.agentCtnrNamingAttr + "=" + this.agentCtnrValue + "," + this.orgDN;
        }
        if (idType.equals(IdType.GROUP)) {
            if (this.groupCtnrValue == null) return this.groupSearchNamingAttr + "=" + string + this.orgDN;
            if (this.groupCtnrValue.length() == 0) return this.groupSearchNamingAttr + "=" + string + this.orgDN;
            if (this.groupCtnrNamingAttr == null) return this.groupSearchNamingAttr + "=" + string + this.orgDN;
            if (this.groupCtnrNamingAttr.length() == 0) return this.groupSearchNamingAttr + "=" + string + this.orgDN;
            return this.groupSearchNamingAttr + "=" + string + this.groupCtnrNamingAttr + "=" + this.groupCtnrValue + "," + this.orgDN;
        }
        if (idType.equals(IdType.ROLE)) return this.roleSearchNamingAttr + "=" + string + this.orgDN;
        if (idType.equals(IdType.FILTEREDROLE)) return this.roleSearchNamingAttr + "=" + string + this.orgDN;
        Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
    }

    private String getBaseDN(IdType idType) throws IdRepoException {
        String string;
        if (idType.equals(IdType.USER)) {
            string = this.peopleCtnrValue == null || this.peopleCtnrValue.length() == 0 || this.peopleCtnrNamingAttr == null || this.peopleCtnrNamingAttr.length() == 0 ? this.orgDN : this.peopleCtnrNamingAttr + "=" + this.peopleCtnrValue + "," + this.orgDN;
        } else if (idType.equals(IdType.AGENT)) {
            string = this.agentCtnrValue == null || this.agentCtnrValue.length() == 0 || this.agentCtnrNamingAttr == null || this.agentCtnrNamingAttr.length() == 0 ? this.orgDN : this.agentCtnrNamingAttr + "=" + this.agentCtnrValue + "," + this.orgDN;
        } else if (idType.equals(IdType.GROUP)) {
            string = this.groupCtnrValue == null || this.groupCtnrValue.length() == 0 || this.groupCtnrNamingAttr == null || this.groupCtnrNamingAttr.length() == 0 ? this.orgDN : this.groupCtnrNamingAttr + "=" + this.groupCtnrValue + "," + this.orgDN;
        } else if (idType.equals(IdType.ROLE) || idType.equals(IdType.FILTEREDROLE)) {
            string = this.orgDN;
        } else {
            Object[] objectArray = new Object[]{CLASS_NAME, IdOperation.READ.getName(), idType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", objectArray);
        }
        return string;
    }

    private String constructFilter(Map map) {
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: constructFilter: avPairs=" + map);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            stringBuffer.append("(&");
            bl = true;
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = ((Set)map.get(string)).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append("(").append(string).append("=").append(string2).append(")");
            }
        }
        if (bl) {
            stringBuffer.append(")");
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: exit constructFilter: filterSB= " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String constructFilter(String string, String string2, String string3) {
        String string4;
        String string5;
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: constructFilter: objectClassFilter=" + string2 + "; wildcard=" + string3 + "; namingAttr=" + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.indexOf("%U");
        int n2 = string2.indexOf("%V");
        if (n == -1 && n2 == -1) {
            if (string == null || string.length() == 0) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append("(&(").append(string).append("=").append(string3).append(")").append(string2).append(")");
            }
            string2 = stringBuffer.toString();
            if (this.debug.messageEnabled()) {
                this.debug.message("LDAPv3Repo: exit 1 constructFilter . objectClassFilter=" + string2);
            }
            return string2;
        }
        int n3 = string3.indexOf("@");
        if (n3 == -1) {
            string5 = string3;
            string4 = "*";
        } else {
            string5 = string3.substring(0, n3);
            string4 = string3.substring(n3 + 1);
        }
        while (n != -1) {
            stringBuffer.append(string2.substring(0, n)).append(string3).append(string2.substring(n + 2));
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            n = string2.indexOf("%U");
        }
        while (n2 != -1) {
            stringBuffer.append(string2.substring(0, n2)).append(string3).append(string2.substring(n2 + 2));
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            n2 = string2.indexOf("%V");
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo: exit constructFilter. objectClassFilter=" + string2);
        }
        return string2;
    }

    private Map getCreateUserAttrMapping(Map map) {
        Map map2;
        Set set = (Set)map.get(LDAPv3Config_LDAP_CREATEUSERMAPPING);
        if (set == null || set.isEmpty()) {
            map2 = Collections.EMPTY_MAP;
        } else {
            if (this.debug.messageEnabled()) {
                this.debug.message("in getCreateUserAttrMapping: createUserAttrMappingSet=" + set);
            }
            int n = set.size();
            map2 = new CaseInsensitiveHashMap(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n2 = string.indexOf(61);
                if (n2 > -1) {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    map2.put(string2, string3);
                    continue;
                }
                map2.put(string, string);
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("exit getCreateUserAttrMapping: createAttrMap=" + map2);
        }
        return map2;
    }

    private void prtAttrMap(Map map) {
        if (map.containsKey("userpassword")) {
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            aMHashMap.remove("userpassword");
            aMHashMap.put("userpassword", "xxx...");
            this.debug.message("    attrs: " + aMHashMap);
        } else {
            this.debug.message("    attrs: " + map);
        }
    }

    private int getPropertyIntValue(Map map, String string, int n) {
        int n2 = n;
        try {
            Set set = (Set)map.get(string);
            if (set != null && !set.isEmpty()) {
                n2 = Integer.parseInt((String)set.iterator().next());
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("    LDAPv3Repo.getPropertyIntValue(): " + string + " = " + n2);
        }
        return n2;
    }

    private String getPropertyStringValue(Map map, String string) {
        String string2 = null;
        Set set = (Set)map.get(string);
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        } else if (this.debug.messageEnabled()) {
            this.debug.message("LDAPv3Repo.getPropertyStringValue failed:" + string);
        }
        if (this.debug.messageEnabled()) {
            if (!string.equals(LDAPv3Config_AUTHPW)) {
                this.debug.message("    LDAPv3Repo.getPropertyStringValue(): " + string + " = " + string2);
            } else if (string2 == null || string2.length() == 0) {
                this.debug.message("    LDAPv3Repo.getPropertyStringValue(): " + string + " = NULL or ZERO LENGTH");
            } else {
                this.debug.message("    LDAPv3Repo.getPropertyStringValue(): " + string + " = has value XXX");
            }
        }
        return string2;
    }
}

