/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo;
import com.sun.identity.idm.plugins.ldapv3.Request;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPv3EventService
implements Runnable {
    Hashtable _requestList = new Hashtable();
    Thread _monitorThread = null;
    LDAPSearchListener _msgQueue;
    private final int DEFAULTPORT = 389;
    private int connNumRetry = 3;
    private int connRetryInterval = 1000;
    private static final boolean CHANGES_ONLY = true;
    private static final boolean RETURN_CONTROLS = true;
    private static final boolean IS_CRITICAL = true;
    protected static Debug debugger = Debug.getInstance((String)"LDAPv3EventService");
    protected static final String EVENT_CONNECTION_NUM_RETRIES = "com.iplanet.am.event.connection.num.retries";
    protected static final String EVENT_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.event.connection.delay.between.retries";
    protected static final String EVENT_CONNECTION_ERROR_CODES = "com.iplanet.am.event.connection.ldap.error.codes.retries";
    protected static final String EVENT_IDLE_TIMEOUT_INTERVAL = "com.sun.am.event.connection.idle.timeout";
    private static final String LDAPv3Config_LDAP_SERVER = "sun-idrepo-ldapv3-config-ldap-server";
    private static final String LDAPv3Config_LDAP_IDLETIMEOUT = "sun-idrepo-ldapv3-config-idletimeout";
    private static final String LDAPv3Config_LDAP_NUM_RETRIES = "sun-idrepo-ldapv3-config-numretires";
    private static final String LDAPv3Config_LDAP_RETRY_INTERVAL = "sun-idrepo-ldapv3-config-retyrinterval";
    private static final String LDAPv3Config_LDAP_ERROR_CODES = "sun-idrepo-ldapv3-config-errorcodes";
    private static final String LDAPv3Config_LDAP_SSL_ENABLED = "sun-idrepo-ldapv3-config-ssl-enabled";
    private static final String LDAPv3Config_LDAP_PORT = "sun-idrepo-ldapv3-config-ldap-port";
    private static final String LDAPv3Config_AUTHID = "sun-idrepo-ldapv3-config-authid";
    private static final String LDAPv3Config_AUTHPW = "sun-idrepo-ldapv3-config-authpw";
    private static final String CLASS_NAME = "com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService";
    private int _numRetries = 3;
    private int _retryInterval = 3000;
    protected HashSet _retryErrorCodes;
    protected int _idleTimeOut = 0;
    protected long _idleTimeOutMills;
    private boolean pSearchSupported = false;
    int randomID = 0;
    private static final String ATTR_WHEN_CREATED = "whenCreated";
    private static final String ATTR_WHEN_CHANGED = "whenChanged";
    private static final String ATTR_IS_DELETED = "isDeleted";
    private static final String ATTR_OBJECT_GUID = "objectGUID";
    private static final String AD_NOTIFICATION_OID = "1.2.840.113556.1.4.528";
    private boolean adNotificationSupported = false;

    private int getPropertyIntValue(Map map, String string, int n) {
        int n2 = n;
        try {
            Set set = (Set)map.get(string);
            if (set != null && !set.isEmpty()) {
                n2 = Integer.parseInt((String)set.iterator().next());
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.getPropertyIntValue(): " + string + " = " + n2);
        }
        return n2;
    }

    private String getPropertyStringValue(Map map, String string) {
        String string2 = null;
        Set set = (Set)map.get(string);
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
        } else {
            debugger.error("LDAPv3EventService.getPropertyStringValue failed:" + string);
        }
        if (debugger.messageEnabled()) {
            if (!string.equals(LDAPv3Config_AUTHPW)) {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + string + " = " + string2);
            } else if (string2 == null || string2.length() == 0) {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + string + " = NULL or ZERO LENGTH");
            } else {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + string + " = has value XXX");
            }
        }
        return string2;
    }

    private HashSet getPropertyRetryErrorCodes(Map map, String string) {
        HashSet hashSet = new HashSet();
        Object var4_4 = null;
        Set set = (Set)map.get(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.getPropertyRetryErrorCodes: " + string + "retryErrorSet=" + set + " ; codes=" + hashSet);
        }
        return hashSet;
    }

    protected LDAPv3EventService(Map map) throws LDAPException {
        Random random = new Random();
        this.randomID = random.nextInt();
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.constructor. randomID=" + this.randomID);
        }
        this._idleTimeOut = this.getPropertyIntValue(map, LDAPv3Config_LDAP_IDLETIMEOUT, this._idleTimeOut);
        this._idleTimeOutMills = this._idleTimeOut * 60000;
        this._numRetries = this.getPropertyIntValue(map, LDAPv3Config_LDAP_NUM_RETRIES, this._numRetries);
        this._retryInterval = this.getPropertyIntValue(map, LDAPv3Config_LDAP_RETRY_INTERVAL, this._retryInterval);
        this._retryErrorCodes = this.getPropertyRetryErrorCodes(map, LDAPv3Config_LDAP_ERROR_CODES);
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this.getConnection(map);
        }
        catch (LDAPException lDAPException) {
            debugger.error("EventService.constructor - Failed to connect to server. randomID=" + this.randomID, (Throwable)lDAPException);
            throw lDAPException;
        }
        int n = 0;
        while (n <= 3) {
            try {
                this.checkSupportedControls(lDAPConnection);
                break;
            }
            catch (LDAPException lDAPException) {
                debugger.error("EventService.constructor  retry=" + n);
                debugger.error("EventService.constructor - Failed to determine if server supports control. randomID=" + this.randomID, (Throwable)lDAPException);
                if (n == 3) {
                    throw lDAPException;
                }
                this.sleepRetryInterval();
                ++n;
            }
        }
    }

    protected String getName() {
        return "LDAPv3EventService";
    }

    public void finalize() {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            this.removeListener(request);
        }
        this._requestList.clear();
    }

    private Request findRequst(LDAPv3Repo lDAPv3Repo) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.findRequest: requestSize=" + this._requestList.size() + " target=" + lDAPv3Repo);
        }
        Request request = null;
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request2 = (Request)iterator.next();
            LDAPv3Repo lDAPv3Repo2 = request2.getOwner();
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.findRequest: request=" + lDAPv3Repo2);
            }
            if (lDAPv3Repo2 != lDAPv3Repo) continue;
            request = request2;
            debugger.message("LDAPv3EventService.findRequest. found it");
            break;
        }
        return request;
    }

    public synchronized void removeListener(LDAPv3Repo lDAPv3Repo) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.removeListener: target=" + lDAPv3Repo);
        }
        Request request = this.findRequst(lDAPv3Repo);
        request.setStopStatus(true);
        this._requestList.remove(request);
        this.removeListener(request);
        this.dispatchEventAllChanged(request);
        this._monitorThread.interrupt();
    }

    public synchronized String addListener(SSOToken sSOToken, IdRepoListener idRepoListener, String string, int n, String string2, int n2, Map map, LDAPv3Repo lDAPv3Repo) throws LDAPException, IdRepoException {
        LDAPPersistSearchControl lDAPPersistSearchControl;
        if (!this.pSearchSupported && !this.adNotificationSupported) {
            debugger.error("LDAPv3EventService.addListener: unable to determine if psearch or notification is supported. randomID=" + this.randomID);
            Object[] objectArray = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "218", objectArray);
        }
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this.getConnection(map);
        }
        catch (LDAPException lDAPException) {
            debugger.error("LDAPv3EventService.addListener: unable to connect to ldap server. randomID=" + this.randomID);
            throw lDAPException;
        }
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        String[] stringArray = null;
        if (this.pSearchSupported) {
            lDAPPersistSearchControl = new LDAPPersistSearchControl(n2, true, true, true);
            lDAPSearchConstraints.setServerControls((LDAPControl)lDAPPersistSearchControl);
            stringArray = new String[]{"objectclass"};
        } else {
            lDAPPersistSearchControl = new LDAPControl(AD_NOTIFICATION_OID, true, new byte[0]);
            lDAPSearchConstraints.setServerControls((LDAPControl)lDAPPersistSearchControl);
            stringArray = new String[]{"objectclass", ATTR_WHEN_CREATED, ATTR_WHEN_CHANGED, ATTR_IS_DELETED, ATTR_OBJECT_GUID};
            if (string2 == null || !string2.equalsIgnoreCase("(objectclass=*)")) {
                debugger.error("LDAPv3EventService.addListener: Filter has to be (objectclass=*)");
                Object[] objectArray = new Object[]{CLASS_NAME};
                throw new IdRepoException("amIdRepo", "218", objectArray);
            }
        }
        lDAPSearchConstraints.setBatchSize(1);
        lDAPPersistSearchControl = null;
        try {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.addListener() - Submitting Persistent Search on: " + string + " for listener: " + idRepoListener + " scope=" + n + " randomID=" + this.randomID);
            }
            lDAPPersistSearchControl = lDAPConnection.search(string, n, string2, stringArray, false, null, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            debugger.error("LDAPv3EventService.addListener() - Failed to set Persistent Search randomID=" + this.randomID + lDAPException.getMessage());
            throw lDAPException;
        }
        int[] nArray = lDAPPersistSearchControl.getMessageIDs();
        int n3 = nArray[nArray.length - 1];
        String string3 = Integer.toString(n3);
        long l = System.currentTimeMillis();
        Request request = new Request(n3, string3, sSOToken, string, n, string2, stringArray, n2, idRepoListener, lDAPConnection, l, map, lDAPv3Repo);
        this._requestList.put(string3, request);
        if (this._msgQueue == null) {
            this._msgQueue = lDAPPersistSearchControl;
        } else {
            this._msgQueue.merge((LDAPSearchListener)lDAPPersistSearchControl);
            if (debugger.messageEnabled()) {
                nArray = this._msgQueue.getMessageIDs();
                debugger.message("LDAPv3EventService.addListener(): merged Listener:  requestID: " + string3 + " & Request: " + request + " on to message Queue. No. of current outstanding " + "requests = " + nArray.length + " randomID=" + this.randomID);
            }
        }
        this.startMonitorThread();
        return string3;
    }

    public void run() {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.run(): Event Thread is running! No Idle timeout Set: " + this._idleTimeOut + " minutes." + " randomID=" + this.randomID);
        }
        boolean bl = true;
        LDAPMessage lDAPMessage = null;
        while (bl) {
            block12: {
                try {
                    try {
                        if (debugger.messageEnabled()) {
                            debugger.message("LDAPv3EventService.run(): Waiting for response randomID=" + this.randomID);
                        }
                        lDAPMessage = this._msgQueue.getResponse();
                        bl = this.processResponse(lDAPMessage);
                    }
                    catch (LDAPException lDAPException) {
                        int n = lDAPException.getLDAPResultCode();
                        if (debugger.warningEnabled()) {
                            debugger.warning("LDAPv3EventService.run() LDAPException received: randomID=" + this.randomID, (Throwable)lDAPException);
                        }
                        if (this._retryErrorCodes.contains("" + n)) {
                            bl = this.resetAllSearches(true);
                            break block12;
                        }
                        this.processNetworkError((Exception)((Object)lDAPException));
                    }
                }
                catch (Throwable throwable) {
                    if (debugger.warningEnabled()) {
                        debugger.warning("LDAPv3EventService.run(): Unknown exception caught. Sleeping for a while..  randomID=" + this.randomID, throwable);
                    }
                    if (this._requestList.size() <= 0) break block12;
                    this.sleepRetryInterval();
                }
            }
            if (debugger.warningEnabled()) {
                debugger.warning("LDAPv3EventServicePolling.run(). _requestList.size()=" + this._requestList.size());
            }
            if (this._requestList.size() != 0) continue;
            bl = false;
        }
        this.finalize();
        if (debugger.warningEnabled()) {
            debugger.error("LDAPv3EventService.run() - Monitor thread is terminating! Persistent Searches will no longer be operational. randomID=" + this.randomID);
        }
    }

    private void startMonitorThread() {
        if (this._monitorThread == null || !this._monitorThread.isAlive()) {
            this._monitorThread = new Thread((Runnable)this, this.getName());
            this._monitorThread.setDaemon(true);
            this._monitorThread.start();
        }
    }

    protected synchronized boolean processResponse(LDAPMessage lDAPMessage) {
        if (lDAPMessage == null) {
            debugger.warning("LDAPv3EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches randomID=" + this.randomID);
            return this.resetAllSearches(false);
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processResponse() - received DS message  => " + lDAPMessage.toString() + " randomID=" + this.randomID);
        }
        boolean bl = true;
        Request request = this.getRequestEntry(lDAPMessage.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.processResponse() - Received ldap message with unknown id = " + lDAPMessage.getMessageID() + " randomID=" + this.randomID);
            }
        } else if (lDAPMessage instanceof LDAPSearchResult) {
            this.processSearchResultMessage((LDAPSearchResult)lDAPMessage, request);
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (lDAPMessage instanceof LDAPResponse) {
            LDAPResponse lDAPResponse = (LDAPResponse)lDAPMessage;
            bl = this.processResponseMessage(lDAPResponse, request);
        } else if (lDAPMessage instanceof LDAPSearchResultReference) {
            this.processSearchResultRef((LDAPSearchResultReference)lDAPMessage, request);
        }
        return bl;
    }

    protected void removeListener(Request request) {
        block5: {
            LDAPConnection lDAPConnection;
            if (debugger.warningEnabled()) {
                debugger.message("LDAPv3EventService.removeListener: _requestList.size()=" + this._requestList.size());
            }
            if ((lDAPConnection = request.getLDAPConnection()) != null) {
                if (debugger.messageEnabled()) {
                    debugger.message("LDAPv3EventService.removeListener(): Removing listener requestID: " + request.getRequestID() + " Listener: " + request.getListener() + " randomID=" + this.randomID);
                }
                try {
                    lDAPConnection.abandon(request.getId());
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    if (!debugger.warningEnabled()) break block5;
                    debugger.warning("LDAPv3EventService.removeListener(): LDAPException, when trying to remove listener randomID=" + this.randomID, (Throwable)lDAPException);
                }
            }
        }
    }

    protected synchronized boolean resetAllSearches(boolean bl) {
        boolean bl2;
        Hashtable hashtable = (Hashtable)this._requestList.clone();
        this._requestList.clear();
        Collection collection = hashtable.values();
        int n = 1;
        boolean bl3 = bl2 = this._numRetries == -1 || this._numRetries != 0 && n <= this._numRetries;
        if (bl) {
            this.dispatchAllEntriesChangedEvent();
        }
        while (bl2) {
            block9: {
                try {
                    Object object;
                    this.sleepRetryInterval();
                    if (debugger.messageEnabled()) {
                        object = this._numRetries == -1 ? "indefinitely" : Integer.toString(n);
                        debugger.message("LDAPv3EventService.resetAllSearches(): retrying = " + (String)object + " randomID=" + this.randomID);
                    }
                    this._msgQueue = null;
                    object = collection.iterator();
                    while (object.hasNext()) {
                        Request request = (Request)object.next();
                        if (request.getStopStatus()) continue;
                        this.removeListener(request);
                        this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations(), request.getPluginConfig(), request.getOwner());
                    }
                    return true;
                }
                catch (LDAPException lDAPException) {
                    if (n == this._numRetries) {
                        this.processNetworkError((Exception)((Object)lDAPException));
                    }
                }
                catch (IdRepoException idRepoException) {
                    if (n != this._numRetries) break block9;
                    this.processNetworkError(idRepoException);
                }
            }
            if (this._numRetries == -1) continue;
            boolean bl4 = bl2 = ++n <= this._numRetries;
        }
        if (debugger.warningEnabled()) {
            debugger.message("LDAPv3EventService.resetAllSearches exit: _requestList.size()=" + this._requestList.size());
        }
        return false;
    }

    protected void sleepRetryInterval() {
        try {
            Thread.sleep(this._retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void dispatchException(Exception exception, Request request) {
        IdRepoListener idRepoListener = request.getListener();
        debugger.error("LDAPv3EventService.dispatchException() - dispatching exception to the listener: " + request.getRequestID() + " Listener: " + request.getListener() + " randomID=" + this.randomID, (Throwable)exception);
    }

    private void dispatchEventAllChanged(Request request) {
        IdRepoListener idRepoListener = request.getListener();
        Map map = idRepoListener.getConfigMap();
        idRepoListener.allObjectsChanged();
    }

    private void dispatchEvent(String string, int n, Request request) {
        IdRepoListener idRepoListener = request.getListener();
        Map map = idRepoListener.getConfigMap();
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.dispatchEvent() - dn=" + string + " changeType=" + n + " configParams=" + map);
        }
        idRepoListener.objectChanged(string, n, map);
    }

    private synchronized void dispatchAllEntriesChangedEvent() {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            IdRepoListener idRepoListener = request.getListener();
            idRepoListener.allObjectsChanged();
        }
    }

    protected void processNetworkError(Exception exception) {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            this.dispatchException(exception, request);
        }
    }

    private boolean processResponseMessage(LDAPResponse lDAPResponse, Request request) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processResponseMessage().entry - request=" + request + " rsp=" + lDAPResponse);
        }
        boolean bl = true;
        if (this._retryErrorCodes.contains("" + lDAPResponse.getResultCode())) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.processResponseMessage() - received LDAP Response for requestID: " + request.getRequestID() + " Listener: " + request.getListener() + "Need restarting" + " randomID=" + this.randomID);
            }
            bl = this.resetAllSearches(false);
        } else if (lDAPResponse.getResultCode() != 0 || lDAPResponse.getResultCode() != 10) {
            LDAPException lDAPException = new LDAPException("Error result", lDAPResponse.getResultCode(), lDAPResponse.getErrorMessage(), lDAPResponse.getMatchedDN());
            this.dispatchException((Exception)((Object)lDAPException), request);
            if (lDAPResponse.getResultCode() == 50) {
                bl = false;
            }
        } else {
            this.sleepRetryInterval();
        }
        return bl;
    }

    private synchronized void processSearchResultMessage(LDAPSearchResult lDAPSearchResult, Request request) {
        Object object;
        Enumeration enumeration;
        Object object2;
        LDAPControl[] lDAPControlArray;
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultMessage().entry res=" + lDAPSearchResult + " req=" + request);
        }
        LDAPEntry lDAPEntry = lDAPSearchResult.getEntry();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration2 = lDAPAttributeSet.getAttributes();
        while (enumeration2.hasMoreElements()) {
            lDAPControlArray = (LDAPControl[])enumeration2.nextElement();
            object2 = lDAPControlArray.getName();
            enumeration = lDAPControlArray.getStringValues();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultMessage() - Changed " + lDAPEntry.getDN() + " randomID=" + this.randomID);
        }
        if (this.pSearchSupported) {
            lDAPControlArray = lDAPSearchResult.getControls();
            if (lDAPControlArray == null) {
                object2 = new Exception("LDAPv3EventService - Cannot create NamingEvent, no change control info");
                this.dispatchException((Exception)object2, request);
            } else {
                int n = 0;
                while (n < lDAPControlArray.length) {
                    enumeration = null;
                    if (lDAPControlArray[n] instanceof LDAPEntryChangeControl) {
                        enumeration = (LDAPEntryChangeControl)lDAPControlArray[n];
                        if (debugger.messageEnabled()) {
                            debugger.message("LDAPv3EventService.processSearchResultMessage() changeCtrl = " + enumeration.toString() + " randomID=" + this.randomID);
                        }
                        if (enumeration.getChangeType() == -1) {
                            object = new Exception("LDAPv3EventService - Cannot create NamingEvent, no change control info");
                            this.dispatchException((Exception)object, request);
                        }
                        try {
                            this.dispatchEvent(lDAPEntry.getDN(), enumeration.getChangeType(), request);
                        }
                        catch (Exception exception) {
                            this.dispatchException(exception, request);
                        }
                    }
                    ++n;
                }
            }
        } else {
            try {
                this.createDSEventAD(lDAPEntry, request);
            }
            catch (Exception exception) {
                this.dispatchException(exception, request);
            }
        }
    }

    private void processSearchResultRef(LDAPSearchResultReference lDAPSearchResultReference, Request request) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultRef() - Ignoring.. randomID=" + this.randomID);
        }
    }

    private Request getRequestEntry(int n) {
        return (Request)this._requestList.get(Integer.toString(n));
    }

    private LDAPConnection getConnection(Map map) throws LDAPException {
        LDAPConnection lDAPConnection = null;
        String string = this.getPropertyStringValue(map, LDAPv3Config_LDAP_SSL_ENABLED);
        HashSet hashSet = new HashSet((Set)map.get(LDAPv3Config_LDAP_SERVER));
        String string2 = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            string2 = string2 == null || string2.length() == 0 ? string3 : string2 + " " + string3;
        }
        if (debugger.messageEnabled()) {
            debugger.message("    LDAPv3Config_LDAP_SERVER:" + hashSet + "; ldapServer:" + string2);
        }
        int n = 389;
        String string4 = this.getPropertyStringValue(map, LDAPv3Config_AUTHID);
        String string5 = this.getPropertyStringValue(map, LDAPv3Config_AUTHPW);
        if (string != null && string.equalsIgnoreCase("true")) {
            try {
                lDAPConnection = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
            }
            catch (LDAPException lDAPException) {
                debugger.error("LDAPv3EventService.getConnection.JSSSocketFactory randomID=" + this.randomID, (Throwable)lDAPException);
                throw lDAPException;
            }
            catch (Exception exception) {
                debugger.error("LDAPv3EventService.getConnection.JSSSocketFactory randomID=" + this.randomID, (Throwable)exception);
                int n2 = 1;
                throw new LDAPException(exception.getMessage(), n2);
            }
        } else {
            lDAPConnection = new LDAPConnection();
        }
        int n3 = 0;
        while (n3 <= this.connNumRetry) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.GetConnection retry: " + n3 + " randomID=" + this.randomID);
            }
            try {
                if (string4 != null && string5 != null) {
                    lDAPConnection.connect(3, string2, n, string4, string5);
                } else {
                    lDAPConnection.setOption(17, (Object)new Integer(3));
                    lDAPConnection.connect(string2, n);
                }
                lDAPConnection.setOption(3, (Object)new Integer(0));
                break;
            }
            catch (LDAPException lDAPException) {
                if (!this._retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n3 == this.connNumRetry) {
                    debugger.error("LDAPv3EventService.Connection to LDAP server threw exception:  randomID=" + this.randomID, (Throwable)lDAPException);
                    throw lDAPException;
                }
                ++n3;
                try {
                    Thread.currentThread();
                    Thread.sleep(this.connRetryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return lDAPConnection;
    }

    /*
     * Unable to fully structure code
     */
    private void checkSupportedControls(LDAPConnection var1_1) throws LDAPException {
        var2_2 = "(objectclass=*)";
        var3_3 = "";
        var4_4 = new String[]{"supportedControl"};
        var5_5 = false;
        var6_6 = null;
        var7_7 = "2.16.840.1.113730.3.4.3";
        var8_8 = "2.16.840.1.113730.3.4.12";
        try {
            var6_6 = var1_1.search(var3_3, 0, var2_2, var4_4, false);
            if (true) ** GOTO lbl40
        }
        catch (LDAPException var9_9) {
            LDAPv3EventService.debugger.error("LDAPv3EventService().CheckSupportedControls() - Error encountered while checking for supported controls randomID=" + this.randomID);
            throw var9_9;
        }
        do {
            var9_10 = (LDAPEntry)var6_6.nextElement();
            var10_11 = var9_10.getAttributeSet();
            var11_12 = var10_11.getAttributes();
            if (LDAPv3EventService.debugger.messageEnabled()) {
                LDAPv3EventService.debugger.message("LDAPv3EventService.checkSupportedControls: findAttrs:" + var10_11 + "; enumAttrs:" + var11_12);
            }
            while (var11_12.hasMoreElements()) {
                var12_13 = (LDAPAttribute)var11_12.nextElement();
                var13_14 = var12_13.getName();
                var14_15 = var12_13.getStringValues();
                if (LDAPv3EventService.debugger.messageEnabled()) {
                    LDAPv3EventService.debugger.message("   inside while: attrName:" + var13_14 + "; enumVals: " + var14_15);
                }
                while (var14_15.hasMoreElements()) {
                    var15_16 = (String)var14_15.nextElement();
                    if (LDAPv3EventService.debugger.messageEnabled()) {
                        LDAPv3EventService.debugger.message("   inside inside:  aVal:" + var15_16);
                    }
                    if (var15_16.equals("2.16.840.1.113730.3.4.3")) {
                        this.pSearchSupported = true;
                        continue;
                    }
                    if (var15_16.equals("1.2.840.113556.1.4.528")) {
                        this.adNotificationSupported = true;
                        continue;
                    }
                    if (!var15_16.equals("2.16.840.1.113730.3.4.12")) continue;
                    var5_5 = true;
                }
            }
lbl40:
            // 2 sources

        } while (var6_6.hasMoreElements());
        if (LDAPv3EventService.debugger.messageEnabled()) {
            LDAPv3EventService.debugger.message("EventService.checkSupportedControls: pSearchSupported = " + this.pSearchSupported + ", adNotificationSupported = " + this.adNotificationSupported + " randomID=" + this.randomID);
        }
    }

    public boolean persistentSearchSupported() {
        return this.pSearchSupported;
    }

    public boolean ADNotificationSupported() {
        return this.adNotificationSupported;
    }

    private void createDSEventAD(LDAPEntry lDAPEntry, Request request) throws LDAPException {
        int n;
        if (debugger.messageEnabled()) {
            debugger.message("EventService.createDSEventAD - entry = " + lDAPEntry);
            debugger.message("EventService.createDSEventAD - Event Requestor = " + request.getRequester() + " randomID=" + this.randomID);
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(ATTR_IS_DELETED);
        boolean bl = false;
        if (lDAPAttribute != null && lDAPAttribute.size() == 1) {
            bl = lDAPAttribute.getStringValueArray()[0].equalsIgnoreCase("true");
        }
        if (bl) {
            n = 2;
        } else {
            lDAPAttribute = lDAPEntry.getAttribute(ATTR_WHEN_CREATED);
            if (lDAPAttribute == null || lDAPAttribute.size() == 0) {
                if (debugger.warningEnabled()) {
                    debugger.warning("EventService.createDSEventAD: missing attribute 'whenCreated' randomID=" + this.randomID);
                }
                return;
            }
            String string = lDAPAttribute.getStringValueArray()[0];
            lDAPAttribute = lDAPEntry.getAttribute(ATTR_WHEN_CHANGED);
            if (lDAPAttribute == null || lDAPAttribute.size() == 0) {
                if (debugger.warningEnabled()) {
                    debugger.warning("EventService.createDSEventAD: missing attribute 'whenChanged' randomID=" + this.randomID);
                }
                return;
            }
            String string2 = lDAPAttribute.getStringValueArray()[0];
            n = string.equals(string2) ? 1 : 4;
        }
        if ((n & request.getOperations()) == 0) {
            return;
        }
        if (n != 2) {
            this.dispatchEvent(lDAPEntry.getDN(), n, request);
        } else {
            this.dispatchEventAllChanged(request);
        }
    }
}

