/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.sun.identity.common.L10NMessage;
import com.sun.identity.idm.AMIdentityRepository;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class IdRepoException
extends Exception
implements L10NMessage {
    private transient AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private transient Debug debug = AMIdentityRepository.debug;
    private String message;
    private String bundleName;
    private String errorCode;
    private Object[] args;

    public IdRepoException(String string) {
        this.message = string;
    }

    public IdRepoException(String string, String string2) {
        this.message = string;
        this.errorCode = string2;
    }

    public IdRepoException(String string, String string2, Object[] objectArray) {
        this.bundleName = string;
        this.errorCode = string2;
        this.args = objectArray;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public String getL10NMessage(java.util.Locale locale) {
        String string = this.errorCode;
        if (this.bundleName != null && locale != null) {
            ResourceBundle resourceBundle = this.amCache.getResBundle(this.bundleName, locale);
            String string2 = Locale.getString((ResourceBundle)resourceBundle, (String)this.errorCode, (Debug)this.debug);
            string = this.args == null || this.args.length == 0 ? string2 : MessageFormat.format(string2, this.args);
        }
        return string;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.message;
        if (string != null && string.length() > 0) {
            stringBuffer.append("Message:");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.message;
    }

    private String getString(String string) {
        this.errorCode = string;
        ResourceBundle resourceBundle = null;
        if (this.bundleName != null) {
            resourceBundle = this.amCache.getResBundle(this.bundleName, java.util.Locale.ENGLISH);
        }
        return Locale.getString(resourceBundle, (String)string, (Debug)this.debug);
    }
}

