/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.SignatureProviderSPI;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;
import sun.security.provider.Sun;

public class FSSignatureProvider
implements SignatureProviderSPI {
    private KeyProvider keystore = new JKSKeyProvider();

    public void initialize(KeyProvider keyProvider) {
        if (keyProvider == null) {
            FSUtils.debug.error("FSSignatureProvider.initialize: Key Provider is null");
        } else {
            this.keystore = keyProvider;
        }
    }

    public byte[] signBuffer(String string, String string2) throws FSSignatureException {
        return this.signBuffer(string, string2, "SHA1withRSA");
    }

    public byte[] signBuffer(String string, String string2, String string3) throws FSSignatureException {
        if (string == null) {
            FSUtils.debug.error("FSSignatureProvider.signBuffer: data to be signed is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.error("FSSignatureProvider.signBuffer: certAlias is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        try {
            int n;
            PrivateKey privateKey = this.keystore.getPrivateKey(string2);
            if (string3 == null || string3.equals("")) {
                string3 = "SHA1withRSA";
                FSUtils.debug.message("FSSignatureProvider.signBuffer: algorithm is null assigning  algorithm= " + string3);
            }
            if (!this.isValidAlgorithm(string3)) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: algorithm is invalid ");
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            Provider[] providerArray = Security.getProviders();
            boolean bl = false;
            int n2 = 0;
            while (n2 < providerArray.length) {
                if (providerArray[n2].getName().equals("SUN")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl && (n = Security.insertProviderAt(new Sun(), 2)) == -1) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: could not add default provider");
            }
            Signature signature = Signature.getInstance(string3);
            if (string3.equals("SHA1withRSA")) {
                signature = Signature.getInstance(string3, "SunRsaSign");
                FSUtils.debug.message("FSSignatureProvider.signBuffer: " + signature.getProvider().getName());
            } else if (string3.equals("SHA1withDSA")) {
                signature = Signature.getInstance(string3, "SUN");
                FSUtils.debug.message("FSSignatureProvider.signBuffer: " + signature.getProvider().getName());
            }
            signature.initSign(privateKey);
            signature.update(string.getBytes());
            return signature.sign();
        }
        catch (Exception exception) {
            String string4 = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            string4 = byteArrayOutputStream.toString();
            FSUtils.debug.message("FSSignatureProvider.signBuffer: " + string4);
            throw new FSSignatureException(exception.getMessage());
        }
    }

    public boolean verifySignature(String string, byte[] byArray, String string2, String string3) throws FSSignatureException {
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSSignatureProvider.verifySignature: data to be signed is null.");
            throw new FSSignatureException(FSUtils.bundle.getString("nullInput"));
        }
        try {
            int n;
            if (string2 == null || string2.equals("")) {
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new FSSignatureException(FSUtils.bundle.getString("invalidAlgorithm"));
            }
            Provider[] providerArray = Security.getProviders();
            boolean bl = false;
            int n2 = 0;
            while (n2 < providerArray.length) {
                if (providerArray[n2].getName().equals("SUN")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl && (n = Security.insertProviderAt(new Sun(), 2)) == -1) {
                FSUtils.debug.error("FSSignatureProvider.signBuffer: could not add default provider");
            }
            Signature signature = Signature.getInstance(string2);
            if (string2.equals("SHA1withRSA")) {
                signature = Signature.getInstance(string2, "SunRsaSign");
                FSUtils.debug.message("FSSignatureProvider.verifySignature: " + signature.getProvider().getName());
            } else if (string2.equals("SHA1withDSA")) {
                signature = Signature.getInstance(string2, "SUN");
                FSUtils.debug.message("FSSignatureProvider.verifySignature: " + signature.getProvider().getName());
            }
            X509Certificate x509Certificate = this.keystore.getX509Certificate(string3);
            if (x509Certificate != null) {
                FSUtils.debug.message("FSSignatureProvider.verifySignature: Certificate: " + x509Certificate.toString());
                signature.initVerify(x509Certificate);
            } else {
                PublicKey publicKey = this.keystore.getPublicKey(string3);
                if (publicKey != null) {
                    signature.initVerify(publicKey);
                } else {
                    FSUtils.debug.error("FSSignatureProvider.verifySignature: Could not find public key based on certAlias to verify signature");
                    return false;
                }
            }
            signature.update(string.getBytes());
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            String string4 = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            string4 = byteArrayOutputStream.toString();
            FSUtils.debug.message("FSSignatureProvider.verifySignature: " + string4);
            throw new FSSignatureException(exception.getMessage());
        }
    }

    public KeyProvider getKeyProvider() {
        return this.keystore;
    }

    private boolean isValidAlgorithm(String string) {
        return string.equals("SHA1withDSA") || string.equals("SHA1withRSA");
    }
}

