/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationInitiationServlet
extends HttpServlet {
    private static String REGISTRATION_DONE_URL = "";
    private static String COMMON_ERROR_PAGE = "";
    private FSAllianceManager instAlliance = null;
    protected String locale = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationInitiationServlet Init");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
    }

    protected void setRegistrationURL(String string) {
        try {
            if (this.instAlliance != null) {
                REGISTRATION_DONE_URL = this.instAlliance.getHostedProvider(string).getLocalConfiguration().getNameRegistrationDonePageURL(this.request);
                COMMON_ERROR_PAGE = this.instAlliance.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(this.request);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("REGISTRATION_DONE_URL : " + REGISTRATION_DONE_URL);
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor;
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSRegistrationInitiationServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = httpServletRequest.getParameter("metaAlias");
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.instAlliance == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        try {
            fSHostedProviderDescriptor = this.instAlliance.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = httpServletRequest;
        this.setRegistrationURL(fSHostedProviderDescriptor.getProviderID());
        this.doRegistrationInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor);
    }

    private SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationInitiationServlet::getValidToken");
        }
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                FSUtils.debug.error("SSOToken is not valid, redirecting for authentication");
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException caught: " + sSOException.getMessage());
            return null;
        }
    }

    private void doRegistrationInitiation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationInitiationServlet::doRegistrationInitiation");
        }
        try {
            SSOToken sSOToken = this.getValidToken(httpServletRequest);
            if (sSOToken != null) {
                String string = httpServletRequest.getParameter("_liberty_id");
                if (string == null || string.length() < 1) {
                    FSUtils.debug.error("Provider Id not found, display error page");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(COMMON_ERROR_PAGE);
                    char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(FSUtils.bundle.getString("registration-no-provider"));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(FSUtils.bundle.getString("contact-admin"));
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    }
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                if (fSServiceManager != null) {
                    FSNameRegistrationHandler fSNameRegistrationHandler;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager Instance not null");
                    }
                    if ((fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler(string, sSOToken.getProperty("sun.am.UniversalIdentifier"))) != null) {
                        fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        boolean bl = fSNameRegistrationHandler.handleNameRegistration(httpServletRequest, httpServletResponse, sSOToken);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("handleNameRegistration status is : " + bl);
                        }
                        return;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to get registration handler. User account Not valid");
                    }
                } else if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSServiceManager Instance null");
                }
                this.returnLocallyAfterRegistration(httpServletResponse, false);
                return;
            }
            this.redirectForAuthentication(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor);
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.message("IOException in doRegistrationInitiation" + iOException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("IOException in doRegistrationInitiation" + sSOException.getMessage());
        }
        this.returnLocallyAfterRegistration(httpServletResponse, false);
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationInitiationServlet::redirectForAuthentication");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest));
            stringBuffer.append("/preLogin");
            char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("metaAlias");
            stringBuffer.append('=');
            stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getProviderAlias());
            String string = this.getParameterString(httpServletRequest);
            if (string != null && string.length() > 0) {
                stringBuffer.append('&').append(string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting for authentication to: " + stringBuffer.toString());
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error when redirecting : " + iOException.getMessage());
            return;
        }
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]).append('&');
                ++n;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Parameter String: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void returnLocallyAfterRegistration(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(REGISTRATION_DONE_URL);
            char c = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("regisStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("regisSuccess");
            } else {
                stringBuffer.append("regisFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect failed. Control halted" + iOException.getMessage());
            return;
        }
    }
}

