/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.message.common.OldProvidedNameIdentifier;
import com.sun.identity.federation.message.common.SPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.registration.FSRegistrationIdGenerator;
import com.sun.identity.federation.services.registration.FSRegistrationManager;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSNameRegistrationHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected HashMap regisMap = new HashMap();
    protected FSNameRegistrationResponse regisResponse = null;
    protected FSNameRegistrationRequest regisRequest = null;
    protected SSOToken ssoToken = null;
    protected AMIdentity amId = null;
    protected FSAccountFedInfo acctInfo = null;
    protected FSAccountFedInfo newAcctInfo = null;
    protected FSAccountFedInfoKey newAcctKey = null;
    protected FSAccountFedInfoKey oldAcctKey = null;
    protected FSProviderDescriptor remoteDescriptor = null;
    protected FSHostedProviderDescriptor hostedDescriptor = null;
    protected String remoteProviderId = "";
    protected String hostedProviderId = "";
    protected String relayState = "";
    private IDPProvidedNameIdentifier idpNameIdentifier = null;
    private SPProvidedNameIdentifier spNameIdentifier = null;
    private OldProvidedNameIdentifier oldNameIdentifier = null;
    protected FSAllianceManager instAlliance = null;
    protected FSAccountManager managerInst = null;
    protected static String REGISTRATION_DONE_URL = null;
    protected static final String RELAY_STATE = "RELAYSTATE";
    protected HashMap returnMap = new HashMap();
    protected static String returnURL = "";
    protected static String regisSource = "";
    protected String remoteEntityId = "";
    protected String hostedEntityId = "";

    public FSNameRegistrationHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameRegistrationHandler Constructor...");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
        try {
            this.managerInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.managerInst = null;
        }
    }

    protected void setRegistrationURL() {
        REGISTRATION_DONE_URL = this.hostedDescriptor.getLocalConfiguration().getNameRegistrationDonePageURL(this.request);
    }

    public void setHostedDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::setHostedDescriptor");
        }
        this.hostedDescriptor = fSHostedProviderDescriptor;
        this.hostedProviderId = fSHostedProviderDescriptor.getProviderID();
        this.hostedEntityId = fSHostedProviderDescriptor.getEntityID();
    }

    public void setRemoteDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::setRemoteDescriptor");
        }
        this.remoteDescriptor = fSProviderDescriptor;
        this.remoteProviderId = fSProviderDescriptor.getProviderID();
        this.remoteEntityId = fSProviderDescriptor.getEntityID();
    }

    public void setUserDN(AMIdentity aMIdentity) {
        this.amId = aMIdentity;
    }

    public void setAccountInfo(FSAccountFedInfo fSAccountFedInfo) {
        this.acctInfo = fSAccountFedInfo;
    }

    public boolean setUserDN(FSNameRegistrationRequest fSNameRegistrationRequest) {
        try {
            OldProvidedNameIdentifier oldProvidedNameIdentifier;
            SPProvidedNameIdentifier sPProvidedNameIdentifier;
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier;
            OldProvidedNameIdentifier oldProvidedNameIdentifier2 = fSNameRegistrationRequest.getOldProvidedNameIdentifier();
            if (oldProvidedNameIdentifier2 != null) {
                FSUtils.debug.message("OldProvidedIdentifier NAme : " + oldProvidedNameIdentifier2.getName());
                FSUtils.debug.message("OldProvidedIdentifier Name format : " + oldProvidedNameIdentifier2.getFormat());
                FSUtils.debug.message("OldProvidedIdentifier Qualifier : " + oldProvidedNameIdentifier2.getNameQualifier());
            }
            if ((iDPProvidedNameIdentifier = fSNameRegistrationRequest.getIDPProvidedNameIdentifier()) != null) {
                FSUtils.debug.message("IDPProvidedIdentifier NAme : " + iDPProvidedNameIdentifier.getName());
                FSUtils.debug.message("IDPProvidedIdentifier Name format : " + iDPProvidedNameIdentifier.getFormat());
                FSUtils.debug.message("IDPProvidedIdentifier Qualifier : " + iDPProvidedNameIdentifier.getNameQualifier());
            }
            if ((sPProvidedNameIdentifier = fSNameRegistrationRequest.getSPProvidedNameIdentifier()) != null) {
                FSUtils.debug.message("SPProvidedIdentifier NAme : " + sPProvidedNameIdentifier.getName());
                FSUtils.debug.message("SPProvidedIdentifier Name format : " + sPProvidedNameIdentifier.getFormat());
                FSUtils.debug.message("SPProvidedIdentifier Qualifier : " + sPProvidedNameIdentifier.getNameQualifier());
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("remoteProviderId : " + this.remoteProviderId);
            }
            if ((oldProvidedNameIdentifier = fSNameRegistrationRequest.getOldProvidedNameIdentifier()) == null) {
                FSUtils.debug.message("oldProvidedNameIdentifier is null :");
                IDPProvidedNameIdentifier iDPProvidedNameIdentifier2 = fSNameRegistrationRequest.getIDPProvidedNameIdentifier();
                SPProvidedNameIdentifier sPProvidedNameIdentifier2 = fSNameRegistrationRequest.getSPProvidedNameIdentifier();
                String string = iDPProvidedNameIdentifier2.getName();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processRegistrationRequest IdPName : " + string);
                }
                String string2 = this.hostedDescriptor.getLocalConfiguration().getAssociatedOrgDN();
                FSUtils.debug.message("OrgDN : " + string2);
                String string3 = this.hostedEntityId;
                String string4 = iDPProvidedNameIdentifier2.getNameQualifier();
                if (string4 != null && string4.length() != 0 && !string4.equals(this.remoteEntityId)) {
                    string3 = string4;
                }
                FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(string3, string);
                FSUtils.debug.message("Search based on:" + this.hostedEntityId + string);
                this.amId = this.managerInst.getAMIdentity(fSAccountFedInfoKey, string2);
                if (this.amId == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("UserDn is null");
                    }
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("user dn is " + this.amId);
                }
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    FSUtils.debug.message("Failed to read account information");
                    return false;
                }
                this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)iDPProvidedNameIdentifier2, sPProvidedNameIdentifier2, false);
                this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                this.newAcctKey = new FSAccountFedInfoKey(string3, iDPProvidedNameIdentifier2.getName());
                return true;
            }
            FSUtils.debug.message("oldProvidedNameIdentifier not null");
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier3 = fSNameRegistrationRequest.getIDPProvidedNameIdentifier();
            SPProvidedNameIdentifier sPProvidedNameIdentifier3 = fSNameRegistrationRequest.getSPProvidedNameIdentifier();
            OldProvidedNameIdentifier oldProvidedNameIdentifier3 = fSNameRegistrationRequest.getOldProvidedNameIdentifier();
            String string = this.hostedDescriptor.getLocalConfiguration().getAssociatedOrgDN();
            FSUtils.debug.message("OrgDN : " + string);
            String string5 = "";
            String string6 = null;
            boolean bl = false;
            String string7 = this.hostedEntityId;
            if (sPProvidedNameIdentifier3 != null && !sPProvidedNameIdentifier3.equals(oldProvidedNameIdentifier3)) {
                string5 = sPProvidedNameIdentifier3.getName();
                string6 = sPProvidedNameIdentifier3.getNameQualifier();
            } else {
                bl = true;
                string5 = iDPProvidedNameIdentifier3.getName();
                string6 = iDPProvidedNameIdentifier3.getNameQualifier();
            }
            if (string6 != null && string6.length() != 0 && !string6.equals(this.hostedEntityId)) {
                string7 = string6;
            }
            FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(string7, string5);
            FSUtils.debug.message("Search based on :" + string7 + string5);
            this.amId = this.managerInst.getAMIdentity(fSAccountFedInfoKey, string);
            if (this.amId == null) {
                FSUtils.debug.message("UserDn is null in step 3");
                string5 = iDPProvidedNameIdentifier3.getName();
                string6 = iDPProvidedNameIdentifier3.getNameQualifier();
                if (string6 != null && string6.length() != 0 && !string6.equals(this.hostedEntityId)) {
                    string7 = string6;
                }
                fSAccountFedInfoKey = new FSAccountFedInfoKey(string7, string5);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Search based on :" + string7 + " " + string5);
                }
                this.amId = this.managerInst.getAMIdentity(fSAccountFedInfoKey, string);
                if (this.amId == null) {
                    string5 = iDPProvidedNameIdentifier3.getName();
                    string7 = this.hostedEntityId;
                    fSAccountFedInfoKey = new FSAccountFedInfoKey(string7, string5);
                    this.amId = this.managerInst.getAMIdentity(fSAccountFedInfoKey, string);
                    if (this.amId == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("UserDn is null in step 4");
                        }
                        string5 = oldProvidedNameIdentifier3.getName();
                        string7 = oldProvidedNameIdentifier3.getNameQualifier();
                        if (string7 != null && string7.length() != 0) {
                            fSAccountFedInfoKey = new FSAccountFedInfoKey(string7, string5);
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Search based on :" + string7 + " " + string5);
                            }
                            this.amId = this.managerInst.getAMIdentity(fSAccountFedInfoKey, string);
                        }
                    }
                    if (this.amId == null) {
                        return false;
                    }
                    FSUtils.debug.message("Found user : " + this.amId);
                    try {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, string7);
                        if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                            this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                        }
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        // empty catch block
                    }
                    if (this.acctInfo.isRoleIDP()) {
                        if (bl) {
                            this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, null, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                            this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                            this.newAcctKey = new FSAccountFedInfoKey(string7, iDPProvidedNameIdentifier3.getName());
                        } else {
                            this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)sPProvidedNameIdentifier3, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                            this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                            this.newAcctKey = new FSAccountFedInfoKey(string7, sPProvidedNameIdentifier3.getName());
                        }
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, iDPProvidedNameIdentifier3.getName());
                    }
                } else {
                    try {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, string7);
                        if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                            this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                        }
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        // empty catch block
                    }
                    this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, false);
                    this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                    this.newAcctKey = new FSAccountFedInfoKey(string7, iDPProvidedNameIdentifier3.getName());
                }
            } else {
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, string7);
                    if (this.acctInfo == null || !this.acctInfo.isFedStatusActive()) {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                    }
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    // empty catch block
                }
                if (this.acctInfo.isRoleIDP()) {
                    if (bl) {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, null, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.remoteEntityId, iDPProvidedNameIdentifier3.getName());
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)sPProvidedNameIdentifier3, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, sPProvidedNameIdentifier3.getName());
                    }
                } else {
                    this.newAcctInfo = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                    this.newAcctInfo.setAffiliation(this.acctInfo.getAffiliation());
                    this.newAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, iDPProvidedNameIdentifier3.getName());
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user dn is " + this.amId);
            }
            return true;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("In FSAccountMgmtException :: " + fSAccountMgmtException.getMessage());
            this.amId = null;
            return false;
        }
    }

    public boolean handleNameRegistration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) {
        regisSource = "STAND_ALONE";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        try {
            this.amId = FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier"));
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::IdRepoException" + idRepoException.getMessage());
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, sSOToken);
            return false;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SSOException" + sSOException.getMessage());
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, sSOToken);
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        return bl;
    }

    public boolean handleNameRegistration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken, HashMap hashMap) {
        regisSource = "DuringSSO";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        this.regisMap = hashMap;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        try {
            this.amId = FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier"));
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::IdRepoException" + idRepoException.getMessage());
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, sSOToken);
            return false;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SSOException" + sSOException.getMessage());
            LogUtil.error(Level.INFO, "USER_NOT_FOUND", null, sSOToken);
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        FSUtils.debug.message("Returning cntrol to SIngle Sign On with status " + bl);
        return bl;
    }

    public boolean handleRegistrationAfterFederation(String string, HttpServletResponse httpServletResponse) {
        regisSource = "AfterFederation";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler:: handleNameRegistration");
        }
        returnURL = string;
        this.response = httpServletResponse;
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-alliance-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        FSUtils.debug.message("Completed registration after federation with status " + bl);
        return bl;
    }

    public boolean processRegistrationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSNameRegistrationResponse fSNameRegistrationResponse) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleRegistrationResponse");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.regisResponse = fSNameRegistrationResponse;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        String string = fSNameRegistrationResponse.getStatus().getStatusCode().getValue();
        if (string.equals("samlp:Success")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Successful");
            }
            this.relayState = fSNameRegistrationResponse.getRelayState();
            FSUtils.debug.message("Relay State : " + this.relayState);
            if (this.relayState == null) {
                this.returnLocallyAfterRegistration(httpServletResponse, false);
                return true;
            }
            FSRegistrationManager fSRegistrationManager = FSRegistrationManager.getInstance(this.hostedDescriptor.getProviderID());
            HashMap hashMap = new HashMap();
            hashMap = fSRegistrationManager.getRegistrationMap(this.relayState);
            if (hashMap == null) {
                FSUtils.debug.message("Map does not contain request for state = " + this.relayState);
                this.returnLocallyAfterRegistration(httpServletResponse, false);
                return false;
            }
            this.regisMap = (HashMap)hashMap.get("SSODetails");
            HashMap hashMap2 = (HashMap)hashMap.get("ReturnEntry");
            this.oldAcctKey = (FSAccountFedInfoKey)hashMap2.get("OldAccountKey");
            if (this.oldAcctKey != null) {
                FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
            } else {
                FSUtils.debug.message("OldAccount Key is null");
            }
            this.newAcctKey = (FSAccountFedInfoKey)hashMap2.get("AccountKey");
            if (this.newAcctKey != null) {
                FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName());
                FSUtils.debug.message("Get newAcctKey Qualifier : " + this.newAcctKey.getNameSpace());
            } else {
                FSUtils.debug.message("newAcctKey Key is null");
            }
            this.newAcctInfo = (FSAccountFedInfo)hashMap2.get("AccountInfo");
            this.amId = (AMIdentity)hashMap2.get("amId");
            regisSource = (String)hashMap2.get("RegisSource");
            returnURL = (String)hashMap2.get("RelayState");
            boolean bl = this.doCommonRegistration(false);
            this.returnLocallyAfterRegistration(httpServletResponse, bl);
            return bl;
        }
        if (string.equals("lib:FederationDoesNotExist")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Failed. Federation does not exist");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        if (string.equals("lib:Failure")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Failed.");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doRemoteRegistration() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::doRemoteRegistration");
        }
        try {
            CharSequence charSequence;
            String string;
            block63: {
                FSNameRegistrationRequest fSNameRegistrationRequest;
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration create request start");
                }
                if ((fSNameRegistrationRequest = this.createNameRegistrationRequest(this.acctInfo)) == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::Registration request could not be formed");
                    }
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::Registration request formedsuccessfully");
                }
                boolean bl = true;
                if (this.acctInfo.isRoleIDP()) {
                    if (this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                        bl = true;
                    } else {
                        if (!this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        bl = false;
                    }
                } else if (this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                    bl = true;
                } else {
                    if (!this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                        this.returnLocallyAtSource(this.response, false);
                        return false;
                    }
                    bl = false;
                }
                if (bl) {
                    FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                    if (fSSOAPService != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Signing suceeded. To call bindRegistrationRequest");
                        }
                        fSNameRegistrationRequest.setID("reg-Sig-ID");
                        SOAPMessage sOAPMessage = fSSOAPService.bindRegistrationRequest(fSNameRegistrationRequest);
                        if (sOAPMessage != null) {
                            SOAPMessage sOAPMessage2 = null;
                            try {
                                if (FSServiceUtils.isSigningOn()) {
                                    int n = fSNameRegistrationRequest.getMinorVersion();
                                    if (n == 0) {
                                        sOAPMessage = this.signRegistrationRequest(sOAPMessage, "id", fSNameRegistrationRequest.getID());
                                    } else if (n == 2) {
                                        sOAPMessage = this.signRegistrationRequest(sOAPMessage, "RequestID", fSNameRegistrationRequest.getRequestID());
                                    } else if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("invalid minor version.");
                                    }
                                }
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("calling sendRegistrationMessage");
                                }
                                sOAPMessage2 = fSSOAPService.sendRegistrationMessage(sOAPMessage, this.remoteDescriptor.getSOAPEndPoint());
                            }
                            catch (SOAPException sOAPException) {
                                FSUtils.debug.error("Error in sending request " + sOAPException.getMessage());
                                this.returnLocallyAtSource(this.response, false);
                                return false;
                            }
                            catch (Exception exception) {
                                FSUtils.debug.error("Error in sending request " + exception.getMessage());
                                this.returnLocallyAtSource(this.response, false);
                                return false;
                            }
                            if (sOAPMessage2 == null) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("sendRegistrationMessagereturn response is null");
                                }
                                this.returnLocallyAfterRegistration(this.response, false);
                                return false;
                            }
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("callingparseSOAPMessage after return from IDP");
                            }
                            Element element = fSSOAPService.parseSOAPMessage(sOAPMessage2);
                            if (FSServiceUtils.isSigningOn() && this.regisResponse != null && !this.verifyResponseSignature(sOAPMessage2)) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("Response signature verification failed");
                                    FSUtils.debug.message("Name registration failed in doRemoteRegistration");
                                }
                                this.returnLocallyAfterRegistration(this.response, false);
                                return false;
                            }
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Response signature verification succeeded");
                            }
                            if (element.getLocalName().equalsIgnoreCase("RegisterNameIdentifierResponse")) {
                                FSNameRegistrationResponse fSNameRegistrationResponse = null;
                                try {
                                    fSNameRegistrationResponse = new FSNameRegistrationResponse(element);
                                }
                                catch (SAMLException sAMLException) {
                                    fSNameRegistrationResponse = null;
                                }
                                if (fSNameRegistrationResponse != null) {
                                    String string2 = fSNameRegistrationResponse.getStatus().getStatusCode().getValue();
                                    if (string2.equals("samlp:Success")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Successful");
                                        }
                                        this.oldAcctKey = (FSAccountFedInfoKey)this.returnMap.get("OldAccountKey");
                                        if (this.oldAcctKey != null) {
                                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                                            FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                                        } else {
                                            FSUtils.debug.message("OldAccount Key is null");
                                        }
                                        this.newAcctKey = (FSAccountFedInfoKey)this.returnMap.get("AccountKey");
                                        if (this.newAcctKey != null) {
                                            FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName());
                                            FSUtils.debug.message("Get newAcctKey Qualifier : " + this.newAcctKey.getNameSpace());
                                        } else {
                                            FSUtils.debug.message("newAcctKey Key is null");
                                        }
                                        this.newAcctInfo = (FSAccountFedInfo)this.returnMap.get("AccountInfo");
                                        this.amId = (AMIdentity)this.returnMap.get("amId");
                                        regisSource = (String)this.returnMap.get("RegisSource");
                                        returnURL = (String)this.returnMap.get("RelayState");
                                        boolean bl2 = this.doCommonRegistration(false);
                                        FSUtils.debug.message("doCommonRegistration returns " + bl2);
                                        this.returnLocallyAfterRegistration(this.response, bl2);
                                        return bl2;
                                    }
                                    if (string2.equals("lib:FederationDoesNotExist")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Failed. Federation does not exist");
                                        }
                                        this.returnLocallyAfterRegistration(this.response, false);
                                        return false;
                                    }
                                    if (string2.equals("lib:Failure")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Failed.");
                                        }
                                        this.returnLocallyAfterRegistration(this.response, false);
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration In Redirect profile");
                }
                String string3 = FSRegistrationIdGenerator.generateId();
                FSUtils.debug.message("Registration Id : " + string3);
                fSNameRegistrationRequest.setRelayState(string3);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("SSODetails", this.regisMap);
                hashMap.put("ReturnEntry", this.returnMap);
                if (returnURL != null) {
                    hashMap.put("RelayState", returnURL);
                }
                FSRegistrationManager fSRegistrationManager = FSRegistrationManager.getInstance(this.hostedProviderId);
                fSRegistrationManager.setRegistrationMapInfo(string3, hashMap);
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                String string4 = null;
                String string5 = null;
                while (true) {
                    if (!iterator.hasNext()) {
                        string = fSNameRegistrationRequest.toURLEncodedQueryString();
                        if (FSServiceUtils.isSigningOn()) {
                            charSequence = this.hostedDescriptor.getSigningKeyAlias();
                            if (charSequence != null && !((String)charSequence).equals("")) break;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                            }
                            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                        }
                        break block63;
                    }
                    string4 = (String)iterator.next();
                    string5 = (String)this.regisMap.get(string4);
                    FSUtils.debug.message("Putting in Map Key : " + string4);
                    FSUtils.debug.message("Putting in Map Value : " + string5);
                }
                string = FSSignatureUtil.signAndReturnQueryString(string, (String)charSequence);
            }
            charSequence = new StringBuffer();
            String string6 = this.remoteDescriptor.getNameRegistrationURL();
            ((StringBuffer)charSequence).append(string6);
            if (string6.indexOf(63) == -1) {
                ((StringBuffer)charSequence).append('?');
            } else {
                ((StringBuffer)charSequence).append('&');
            }
            ((StringBuffer)charSequence).append(string);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request to be sent : " + ((StringBuffer)charSequence).toString());
            }
            this.response.sendRedirect(((StringBuffer)charSequence).toString());
            return true;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSNameRegistrationHandler" + FSUtils.bundle.getString("federation-redirection-failed"));
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        catch (SAMLResponderException sAMLResponderException) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        this.returnLocallyAtSource(this.response, false);
        return false;
    }

    public void processRegistrationRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSNameRegistrationRequest fSNameRegistrationRequest) {
        block19: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest...");
            }
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.regisRequest = fSNameRegistrationRequest;
            this.relayState = fSNameRegistrationRequest.getRelayState();
            this.setRegistrationURL();
            if (this.instAlliance == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Alliance manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
                }
                this.sendRegistrationResponse();
                return;
            }
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean bl = this.setUserDN(fSNameRegistrationRequest);
            if (!bl) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Failed to get UserDN. Invalid Name registration request");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean bl2 = this.doCommonRegistration(true);
            FSUtils.debug.message("doCommonRegistration returns " + bl2);
            if (bl2) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS completed successfully");
                }
                try {
                    StatusCode statusCode = new StatusCode("samlp:Success");
                    this.regisResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                    this.regisResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    break block19;
                }
                catch (SAMLException sAMLException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    break block19;
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS failed");
            }
            try {
                StatusCode statusCode = new StatusCode("lib:Failure");
                this.regisResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                this.regisResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
            }
            catch (FSMsgException fSMsgException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                }
            }
            catch (SAMLException sAMLException) {
                if (!FSUtils.debug.messageEnabled()) break block19;
                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
            }
        }
        this.sendRegistrationResponse();
    }

    public FSNameRegistrationResponse processRegistrationRequest(FSNameRegistrationRequest fSNameRegistrationRequest) {
        this.relayState = fSNameRegistrationRequest.getRelayState();
        try {
            FSNameRegistrationResponse fSNameRegistrationResponse = null;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest");
            }
            if (this.instAlliance == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
                }
                StatusCode statusCode = new StatusCode("lib:Failure");
                try {
                    fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    return null;
                }
                fSNameRegistrationResponse.setID("reg-Sig-ID");
                fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                return fSNameRegistrationResponse;
            }
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                StatusCode statusCode = new StatusCode("lib:Failure");
                try {
                    fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    return null;
                }
                fSNameRegistrationResponse.setID("reg-Sig-ID");
                fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                return fSNameRegistrationResponse;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Begin processRegistrationRequest SOAP profile...");
            }
            if (fSNameRegistrationRequest != null) {
                boolean bl = this.setUserDN(fSNameRegistrationRequest);
                if (bl) {
                    boolean bl2 = this.doCommonRegistration(true);
                    FSUtils.debug.message("doCommonRegistration returns " + bl2);
                    if (bl2) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS completed successfully");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("samlp:Success");
                            fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS failed");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("lib:Failure");
                            fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Failed to get UserDN. Invalid termination request");
                    }
                    try {
                        StatusCode statusCode = new StatusCode("lib:FederationDoesNotExist");
                        fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedEntityId, this.relayState);
                    }
                    catch (FSMsgException fSMsgException) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                    catch (SAMLException sAMLException) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                }
            } else {
                FSUtils.debug.error("FSNameRegistrationHandler::processRegistrationRequest Federation termination request is improper");
                return null;
            }
            fSNameRegistrationResponse.setID("reg-Sig-ID");
            fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
            return fSNameRegistrationResponse;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.message("FSNameRegistrationHandler::SAMLException" + sAMLException.getMessage());
            return null;
        }
    }

    public void returnLocallyAtSource(HttpServletResponse httpServletResponse, boolean bl) {
        if (regisSource.equals("AfterFederation")) {
            try {
                FSUtils.debug.message("redirecting to Resource : " + returnURL);
                httpServletResponse.sendRedirect(returnURL);
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Error when redirecting back to resource");
                return;
            }
        }
        if (regisSource.equals("DuringSSO")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(this.request));
            stringBuffer.append("/SingleSignOnService");
            stringBuffer.append("/");
            stringBuffer.append("metaAlias");
            stringBuffer.append("/");
            stringBuffer.append(FSServiceUtils.getMetaAlias(this.request));
            stringBuffer.append('?');
            Set set = this.regisMap.keySet();
            Iterator iterator = set.iterator();
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)this.regisMap.get(string);
                stringBuffer.append(string).append('=').append(AMURLEncDec.encode((String)string2));
                stringBuffer.append('&');
            }
            stringBuffer.append("Authn");
            stringBuffer.append('=').append("true");
            stringBuffer.append('&');
            stringBuffer.append("nameregis");
            stringBuffer.append('=').append("true");
            try {
                FSUtils.debug.message("redirecting to SSO : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Error when redirecting back to SSO service");
                return;
            }
        }
        if (regisSource.equals("STAND_ALONE")) {
            try {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Entered  returnLocallyAfterRegistration with isSuccess set to " + bl);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(REGISTRATION_DONE_URL);
                char c = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("regisStatus");
                stringBuffer.append('=');
                if (bl) {
                    stringBuffer.append("regisSuccess");
                } else {
                    stringBuffer.append("regisFailure");
                }
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.message("Exception in  returnLocallyAfterRegistration " + iOException.getMessage());
            }
        }
    }

    public void returnLocallyAfterRegistration(HttpServletResponse httpServletResponse, boolean bl) {
        if (regisSource.equals("AfterFederation")) {
            try {
                FSUtils.debug.message("redirecting to Resource : " + returnURL);
                httpServletResponse.sendRedirect(returnURL);
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Error when redirecting back to resource");
                return;
            }
        }
        if (regisSource.equals("DuringSSO")) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(this.request));
            stringBuffer.append("/SingleSignOnService");
            stringBuffer.append("/");
            stringBuffer.append("metaAlias");
            stringBuffer.append("/");
            stringBuffer.append(FSServiceUtils.getMetaAlias(this.request));
            stringBuffer.append('?');
            Set set = this.regisMap.keySet();
            Iterator iterator = set.iterator();
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)this.regisMap.get(string);
                stringBuffer.append(string).append('=').append(AMURLEncDec.encode((String)string2));
                stringBuffer.append('&');
            }
            stringBuffer.append("Authn");
            stringBuffer.append('=').append("true");
            stringBuffer.append('&');
            stringBuffer.append("nameregis");
            stringBuffer.append('=').append("true");
            try {
                FSUtils.debug.message("redirecting to SSO : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Error when redirecting back to SSO service");
                return;
            }
        }
        if (regisSource.equals("STAND_ALONE")) {
            try {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Entered  returnLocallyAfterRegistration with isSuccess set to " + bl);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(REGISTRATION_DONE_URL);
                char c = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("regisStatus");
                stringBuffer.append('=');
                if (bl) {
                    stringBuffer.append("regisSuccess");
                } else {
                    stringBuffer.append("regisFailure");
                }
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.message("Exception in  returnLocallyAfterRegistration " + iOException.getMessage());
            }
        }
    }

    protected SOAPMessage signRegistrationRequest(SOAPMessage sOAPMessage, String string, String string2) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationRequest");
        String string3 = this.hostedDescriptor.getSigningKeyAlias();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSNameRegistrationHandler.signRegistrationRequestProvider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    protected boolean verifyResponseSignature(SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::verifyResponseSignature");
        try {
            String string = this.remoteDescriptor.getSigningKeyAlias();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyResponseSignaturecouldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
            }
            FSUtils.debug.message("NameRegistration.verifyResponseSignature: Provider's certAlias is found: " + string);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("Error in verifying response " + sAMLException.getMessage());
            return false;
        }
    }

    private FSNameRegistrationRequest createNameRegistrationRequest(FSAccountFedInfo fSAccountFedInfo) {
        block23: {
            try {
                Object object;
                Object object2;
                FSNameRegistrationRequest fSNameRegistrationRequest;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("EnteredFSNameRegistrationHandler:: createNameRegistrationRequest");
                }
                if ((fSNameRegistrationRequest = new FSNameRegistrationRequest()) == null) break block23;
                fSNameRegistrationRequest.setProviderId(this.hostedEntityId);
                if (fSAccountFedInfo.isRoleIDP()) {
                    Object object3;
                    FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + fSAccountFedInfo.isRoleIDP());
                    NameIdentifier nameIdentifier = this.generateNameIdentifier();
                    if (fSAccountFedInfo.getAffiliation()) {
                        object3 = FSServiceUtils.getAffiliationID(this.remoteEntityId);
                        if (object3 != null) {
                            nameIdentifier.setNameQualifier((String)object3);
                        }
                    } else {
                        nameIdentifier.setNameQualifier(this.hostedEntityId);
                    }
                    FSUtils.debug.message("out of generateNameIdentifier ****");
                    FSUtils.debug.message("New SP nameIdentifier Qualifier: ");
                    FSUtils.debug.message(nameIdentifier.getNameQualifier());
                    FSUtils.debug.message("New SP nameIdentifier Name :" + nameIdentifier.getName());
                    object3 = new SPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                    NameIdentifier nameIdentifier2 = fSAccountFedInfo.getRemoteNameIdentifier();
                    NameIdentifier nameIdentifier3 = fSAccountFedInfo.getLocalNameIdentifier();
                    fSNameRegistrationRequest.setIDPProvidedNameIdentifier(new IDPProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), nameIdentifier2.getFormat()));
                    fSNameRegistrationRequest.setSPProvidedNameIdentifier((SPProvidedNameIdentifier)object3);
                    if (nameIdentifier3 != null) {
                        fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier3.getName(), nameIdentifier3.getNameQualifier(), nameIdentifier3.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(nameIdentifier3.getNameQualifier(), nameIdentifier3.getName());
                        }
                        catch (FSAccountMgmtException fSAccountMgmtException) {
                            this.oldAcctKey = null;
                        }
                    } else {
                        fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), nameIdentifier2.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(nameIdentifier2.getNameQualifier(), nameIdentifier2.getName());
                        }
                        catch (FSAccountMgmtException fSAccountMgmtException) {
                            this.oldAcctKey = null;
                        }
                    }
                    try {
                        FSAccountFedInfoKey fSAccountFedInfoKey = null;
                        fSAccountFedInfoKey = new FSAccountFedInfoKey(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
                        FSAccountFedInfo fSAccountFedInfo2 = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)object3, nameIdentifier2, fSAccountFedInfo.isRoleIDP());
                        fSAccountFedInfo2.setAffiliation(fSAccountFedInfo.getAffiliation());
                        this.returnMap.put("amId", this.amId);
                        this.returnMap.put("OldAccountKey", this.oldAcctKey);
                        if (this.oldAcctKey != null) {
                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                            FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                        } else {
                            FSUtils.debug.message("OldAccount Key is null");
                        }
                        this.returnMap.put("AccountKey", fSAccountFedInfoKey);
                        this.returnMap.put("AccountInfo", fSAccountFedInfo2);
                        this.returnMap.put("RegisSource", regisSource);
                        this.returnMap.put("RelayState", returnURL);
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        return null;
                    }
                }
                FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + fSAccountFedInfo.isRoleIDP());
                NameIdentifier nameIdentifier = this.generateNameIdentifier();
                if (fSAccountFedInfo.getAffiliation() && (object2 = FSServiceUtils.getAffiliationID(this.remoteEntityId)) != null) {
                    nameIdentifier.setNameQualifier((String)object2);
                }
                FSUtils.debug.message("New IDP nameIdentifier Name : ");
                FSUtils.debug.message(nameIdentifier.getName());
                FSUtils.debug.message("New IDP nameIdentifier Qualifier :" + nameIdentifier.getNameQualifier());
                FSUtils.debug.message("out of generateNameIdentifier*****");
                object2 = new IDPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                NameIdentifier nameIdentifier4 = fSAccountFedInfo.getRemoteNameIdentifier();
                NameIdentifier nameIdentifier5 = fSAccountFedInfo.getLocalNameIdentifier();
                FSUtils.debug.message("Old IDP nameIdentifier Name : " + nameIdentifier5.getName());
                FSUtils.debug.message("Old IDP nameIdentifier Qualifier :" + nameIdentifier5.getNameQualifier());
                FSUtils.debug.message("To set OldProvidedNameIdentifier");
                fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier5.getName(), nameIdentifier5.getNameQualifier(), nameIdentifier5.getFormat()));
                FSUtils.debug.message("To set IdpProvidedNameIdentifier");
                fSNameRegistrationRequest.setIDPProvidedNameIdentifier((IDPProvidedNameIdentifier)object2);
                if (nameIdentifier4 != null) {
                    FSUtils.debug.message("SP nameIdentifier Name : " + nameIdentifier4.getName());
                    FSUtils.debug.message("SP nameIdentifier Qualifier :" + nameIdentifier4.getNameQualifier());
                    object = new SPProvidedNameIdentifier(nameIdentifier4.getName(), nameIdentifier4.getNameQualifier(), nameIdentifier4.getFormat());
                    fSNameRegistrationRequest.setSPProvidedNameIdentifier((SPProvidedNameIdentifier)object);
                }
                try {
                    this.oldAcctKey = new FSAccountFedInfoKey(this.hostedEntityId, nameIdentifier5.getName());
                    object = new FSAccountFedInfoKey(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
                    FSAccountFedInfo fSAccountFedInfo3 = new FSAccountFedInfo(this.remoteEntityId, (NameIdentifier)object2, nameIdentifier4, fSAccountFedInfo.isRoleIDP());
                    this.returnMap.put("amId", this.amId);
                    this.returnMap.put("OldAccountKey", this.oldAcctKey);
                    this.returnMap.put("AccountKey", object);
                    this.returnMap.put("AccountInfo", fSAccountFedInfo3);
                    this.returnMap.put("RegisSource", regisSource);
                    this.returnMap.put("RelayState", returnURL);
                    if (this.oldAcctKey != null) {
                        FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                        FSUtils.debug.message("Get OldAcctKet Qualifier: " + this.oldAcctKey.getNameSpace());
                    } else {
                        FSUtils.debug.message("OldAccount Key is null");
                    }
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    return null;
                }
                fSNameRegistrationRequest.setMinorVersion(this.remoteDescriptor.getMinorVersion());
                return fSNameRegistrationRequest;
            }
            catch (SAMLException sAMLException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean doCommonRegistration(boolean bl) {
        try {
            FSUtils.debug.message("user dn is " + this.amId);
            FSUtils.debug.message("To write account fed info to DS");
            if (this.oldAcctKey != null) {
                FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                FSAccountFedInfo fSAccountFedInfo = this.managerInst.readAccountFedInfo(this.amId, this.remoteEntityId);
                if (fSAccountFedInfo != null) {
                    this.managerInst.removeAccountFedInfo(this.amId, fSAccountFedInfo);
                }
                this.managerInst.writeAccountFedInfo(this.amId, this.newAcctKey, this.newAcctInfo, this.oldAcctKey);
            } else {
                FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                if (this.acctInfo != null) {
                    this.managerInst.removeAccountFedInfo(this.amId, this.acctInfo);
                }
                this.managerInst.writeAccountFedInfo(this.amId, this.newAcctKey, this.newAcctInfo);
            }
            return true;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Error when writing user information " + fSAccountMgmtException.getMessage());
            }
            return false;
        }
    }

    private NameIdentifier generateNameIdentifier() {
        try {
            FSNameIdentifierHelper fSNameIdentifierHelper;
            String string;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::generateNameIdentifier");
            }
            if ((string = (fSNameIdentifierHelper = new FSNameIdentifierHelper(this.hostedProviderId)).createNameIdentifier()) == null || string.trim().length() < 1) {
                FSUtils.debug.error("FSHandleGenerator::generateHandle returned null");
                return null;
            }
            FSUtils.debug.message("To set nameIdentifier");
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = this.hostedDescriptor.getLocalConfiguration();
            NameIdentifier nameIdentifier = new NameIdentifier(string, this.remoteEntityId);
            nameIdentifier.setFormat("urn:liberty:iff:nameid:federated");
            FSUtils.debug.message("completed set nameIdentifier");
            return nameIdentifier;
        }
        catch (SAMLException sAMLException) {
            String[] stringArray = new String[]{FSUtils.bundle.getString("registration-failed-sp-name-identifier")};
            LogUtil.error(Level.INFO, "REGISTRATION_FAILED_SP_NAME_IDENTIFIER", stringArray);
            return null;
        }
    }

    private void sendRegistrationResponse() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.remoteDescriptor.getNameRegistrationReturnURL();
        stringBuffer.append(string);
        if (this.regisResponse != null) {
            String string2 = null;
            try {
                string2 = this.regisResponse.toURLEncodedQueryString();
            }
            catch (FSMsgException fSMsgException) {
                string2 = null;
            }
            if (string2 != null) {
                if (FSServiceUtils.isSigningOn()) {
                    String string3 = this.hostedDescriptor.getSigningKeyAlias();
                    if (string3 == null || string3.equals("")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                        }
                        string2 = null;
                    }
                    if (string2 != null) {
                        string2 = FSSignatureUtil.signAndReturnQueryString(string2, string3);
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("URLEncodedRequest to be sent : " + string2);
                }
                if (string2 != null) {
                    if (stringBuffer.toString().indexOf(63) == -1) {
                        stringBuffer.append('?');
                    } else {
                        stringBuffer.append('&');
                    }
                    stringBuffer.append(string2);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::Redirect URL is " + stringBuffer.toString());
                    }
                }
            }
        }
        try {
            this.response.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error in sending registration response");
            return;
        }
    }
}

