/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSProcessLogoutServlet
extends HttpServlet {
    private static FSAllianceManager allianceInst = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSProcessLogoutServlet Initializing...");
        }
        allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSProcessLogoutServlet doGetPost...");
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSProcessLogoutServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            String[] stringArray = new String[]{FSUtils.bundle.getString("notLibertyEnabled")};
            LogUtil.error(Level.INFO, "LIBERTY_NOT_ENABLED", stringArray);
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string2 = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string2 == null || string2.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (allianceInst == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceInst.getHostedProviderByMetaAlias(string2);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String string3 = "";
        String string4 = "";
        try {
            if (allianceInst != null) {
                string = fSHostedProviderDescriptor.getProviderID();
                string3 = allianceInst.getHostedProvider(string).getLocalConfiguration().getLogoutDonePageURL(httpServletRequest);
                string4 = allianceInst.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(httpServletRequest);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException ", (Throwable)((Object)fSAllianceManagementException));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("logoutDoneURL : " + string3);
            FSUtils.debug.message("commonErrorPage : " + string4);
        }
        if ((string = (String)httpServletRequest.getAttribute("logoutSource")) == null) {
            string = httpServletRequest.getParameter("logoutSource");
        }
        SSOToken sSOToken = this.getValidToken(httpServletRequest);
        AMIdentity aMIdentity = null;
        if (sSOToken == null) {
            if (string != null) {
                if (string.equalsIgnoreCase("local")) {
                    this.redirectForAuthentication(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor);
                    return;
                }
                if (string.equalsIgnoreCase("remote")) {
                    FSUtils.debug.message("Control where Source is remote - not from applink but from other provider");
                    this.returnLocallyAfterLogout(httpServletResponse, string3, true);
                    return;
                }
                if (string.equalsIgnoreCase("logoutGet")) {
                    FSUtils.debug.message("Control where Source is Http Get action - not from applink ");
                    this.returnLocallyAfterLogout(httpServletResponse, string3, true);
                    return;
                }
            }
        } else {
            try {
                aMIdentity = IdUtils.getIdentity(sSOToken);
            }
            catch (IdRepoException idRepoException) {
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
            if (string != null) {
                if (string.equalsIgnoreCase("local")) {
                    FSUtils.debug.message("Control where Source is local -  from applink");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
                if (string.equalsIgnoreCase("remote")) {
                    FSUtils.debug.message("Control where Source is remote - not from applink but from other provider. Token valid");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
                if (string.equalsIgnoreCase("logoutGet")) {
                    FSUtils.debug.message("Control where Source is Http Get action - not from applink. Initiation will take care in preLogouthandler ");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
            }
        }
        FSLogoutNotification fSLogoutNotification = new FSLogoutNotification();
        try {
            fSLogoutNotification = FSLogoutNotification.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.message("Bad Logout request. calling showBadRequestErrorPage");
            this.showBadRequestErrorPage(httpServletResponse, string4);
            return;
        }
        if (fSLogoutNotification == null) {
            FSUtils.debug.message("Bad Logout request. calling showBadRequestErrorPage");
            this.showBadRequestErrorPage(httpServletResponse, string4);
        } else {
            this.doRequestProcessing(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, fSLogoutNotification, string4, aMIdentity);
        }
    }

    private SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::getValidToken");
        }
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("SSOToken is not valid, redirecting for authentication");
                }
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRequestProcessing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSLogoutNotification fSLogoutNotification, String string, AMIdentity aMIdentity) {
        String string2;
        int n;
        block18: {
            block19: {
                block20: {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Entered FSProcessLogoutServlet::doRequestProcessing");
                    }
                    n = fSLogoutNotification.getMinorVersion();
                    String string3 = fSLogoutNotification.getProviderId();
                    string2 = null;
                    String string4 = "SP";
                    if (fSHostedProviderDescriptor.getProviderRole().equals("SP")) {
                        string2 = string3 + "|IDP";
                        string4 = "IDP";
                    } else {
                        string2 = string3 + "|SP";
                    }
                    FSProviderDescriptor fSProviderDescriptor = null;
                    try {
                        fSProviderDescriptor = allianceInst.getProvider(string3, string4);
                        if (fSProviderDescriptor == null) {
                            fSProviderDescriptor = allianceInst.getProvider(string3);
                            string2 = string3;
                        }
                    }
                    catch (FSAllianceManagementException fSAllianceManagementException) {
                        FSUtils.debug.error("Remote provider metadata not found.");
                        String[] stringArray = new String[]{string2};
                        LogUtil.error(Level.INFO, "INVALID_PROVIDER", stringArray);
                        this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
                        return;
                    }
                    boolean bl = true;
                    if (FSServiceUtils.isSigningOn()) {
                        try {
                            if (fSProviderDescriptor == null) {
                                FSUtils.debug.error("Remote provider metadata not found.");
                                FSUtils.debug.error("Cannot retrieve provider descriptor.");
                                String[] stringArray = new String[]{string2};
                                LogUtil.error(Level.INFO, "INVALID_PROVIDER", stringArray);
                                this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
                                return;
                            }
                            FSUtils.debug.message("Calling verifyLogoutSignature");
                            bl = this.verifyLogoutSignature(httpServletRequest, fSProviderDescriptor);
                        }
                        catch (FSException fSException) {
                            FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on Logout request is invalidCannot proceed federation Logout");
                            String[] stringArray = new String[]{IdUtils.getUniversalId(aMIdentity)};
                            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
                            this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
                            return;
                        }
                        catch (SAMLException sAMLException) {
                            FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on Logout request is invalidCannot proceed federation Logout");
                            String[] stringArray = new String[]{IdUtils.getUniversalId(aMIdentity)};
                            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
                            this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
                            return;
                        }
                    }
                    if (!bl) break block19;
                    Set set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
                    if (set == null) break block20;
                    if (set.contains(string3)) {
                        SSOToken sSOToken = this.getValidToken(httpServletRequest);
                        if (sSOToken != null) {
                            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                            if (fSServiceManager == null) {
                                FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
                                String[] stringArray = new String[]{IdUtils.getUniversalId(aMIdentity)};
                                LogUtil.error(Level.INFO, "LOGOUT_FAILED", stringArray);
                                this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
                                return;
                            }
                            FSUtils.debug.message("FSServiceManager Instance not null");
                            FSPreLogoutHandler fSPreLogoutHandler = fSServiceManager.getPreLogoutHandler();
                            if (fSPreLogoutHandler != null) {
                                fSPreLogoutHandler.setLogoutRequest(fSLogoutNotification);
                                fSPreLogoutHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                                fSPreLogoutHandler.setRemoteDescriptor(fSProviderDescriptor);
                                fSPreLogoutHandler.processSingleLogoutRequest(httpServletRequest, httpServletResponse, sSOToken);
                                return;
                            }
                            break block18;
                        } else {
                            FSUtils.debug.message("Invalid SSOToken in request processing. Nothing to logout");
                            AMIdentity aMIdentity2 = FSLogoutUtil.getAMIdentity(fSLogoutNotification, fSHostedProviderDescriptor.getProviderID());
                            if (aMIdentity2 != null) {
                                FSLogoutUtil.destroyPrincipalSession(IdUtils.getUniversalId(aMIdentity), fSHostedProviderDescriptor.getProviderID(), fSLogoutNotification.getSessionIndex());
                                this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity2);
                                return;
                            }
                        }
                        break block18;
                    } else {
                        FSUtils.debug.error("Remote provider not in trusted list");
                    }
                    break block18;
                }
                FSUtils.debug.error("Remote provider not in trusted list");
                FSUtils.debug.error("Trusted provider list is empty.");
                break block18;
            }
            FSUtils.debug.error("FSFedTerminationServlet::doRequestProcesing Signature on Logout request is invalidCannot proceed federation Logout");
            String[] stringArray = new String[]{IdUtils.getUniversalId(aMIdentity)};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", stringArray);
        }
        this.returnToSource(httpServletResponse, string2, "samlp:Failure", string, n, fSHostedProviderDescriptor, aMIdentity);
    }

    private void doLogoutInitiation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, SSOToken sSOToken, String string) {
        FSUtils.debug.message("FSProcessLogoutServlet::doLogoutInitiation");
        try {
            FSUtils.debug.message("In FSProcessLogoutServlet:doLogoutInitiation for: " + sSOToken.getPrincipal().toString());
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            if (fSServiceManager != null) {
                FSUtils.debug.message("FSServiceManager Instance not null");
                FSPreLogoutHandler fSPreLogoutHandler = fSServiceManager.getPreLogoutHandler();
                if (fSPreLogoutHandler != null) {
                    fSPreLogoutHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                    fSPreLogoutHandler.handleSingleLogout(httpServletRequest, httpServletResponse, sSOToken);
                    return;
                }
                FSUtils.debug.error("FSPreLogoutHandler Object null.Cannot continue logout");
                String[] stringArray = new String[]{string};
                LogUtil.error(Level.INFO, "LOGOUT_FAILED_INVALID_HANDLER", stringArray);
            } else {
                FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
            }
            this.returnLocallyAfterLogout(httpServletResponse, string, false);
            return;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet::doLogoutInitiation::SSOExceptionError in Token. Process halted.");
            }
            FSUtils.debug.error("FSProcessLogoutServlet::doLogoutInitiation " + FSUtils.bundle.getString("logout-token-invalid"));
            this.returnLocallyAfterLogout(httpServletResponse, string, false);
            return;
        }
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::redirectForAuthentication");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest));
            stringBuffer.append("/preLogin");
            char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("metaAlias");
            stringBuffer.append('=');
            stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getProviderAlias());
            String string = this.getParameterString(httpServletRequest);
            if (string != null && string.length() > 0) {
                stringBuffer.append('&').append(string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting for authentication to: " + stringBuffer.toString());
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error when redirecting : " + iOException.getMessage());
            return;
        }
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]).append('&');
                ++n;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Parameter String: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string, String string2, String string3, int n, FSHostedProviderDescriptor fSHostedProviderDescriptor, AMIdentity aMIdentity) {
        try {
            String string4 = "";
            if (allianceInst != null) {
                string4 = allianceInst.getProvider(string).getSLOServiceReturnURL();
                if (string4 == null || string4.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                    char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("logout-failed")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string4);
                String string5 = this.buildSignedResponse(string4, string2, n, fSHostedProviderDescriptor, aMIdentity);
                httpServletResponse.sendRedirect(string5);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("logout-failed")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    public String buildSignedResponse(String string, String string2, int n, FSHostedProviderDescriptor fSHostedProviderDescriptor, AMIdentity aMIdentity) {
        try {
            Object object;
            Object object2;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            FSLogoutResponse fSLogoutResponse = new FSLogoutResponse();
            fSLogoutResponse.setID("logout-sig-ID");
            if (aMIdentity != null) {
                object2 = FSReturnSessionManager.getInstance(fSHostedProviderDescriptor.getEntityID());
                object = new HashMap();
                if (object2 != null) {
                    object = ((FSReturnSessionManager)object2).getUserProviderInfo(IdUtils.getUniversalId(aMIdentity));
                }
                if (object != null) {
                    string3 = (String)((HashMap)object).get("responseTo");
                    string5 = (String)((HashMap)object).get("RelayState");
                    string4 = (String)((HashMap)object).get("logoutStatus");
                    string3 = (String)((HashMap)object).get("responseTo");
                    ((FSReturnSessionManager)object2).removeUserProviderInfo(IdUtils.getUniversalId(aMIdentity));
                    FSUtils.debug.message("Deleted " + aMIdentity + " from return list");
                    fSLogoutResponse.setResponseTo(string3);
                    fSLogoutResponse.setRelayState(string5);
                    fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getEntityID());
                    fSLogoutResponse.setStatus(string4);
                } else {
                    fSLogoutResponse.setStatus(string2);
                    fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getProviderID());
                }
            } else {
                fSLogoutResponse.setStatus(string2);
                fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getEntityID());
            }
            fSLogoutResponse.setMinorVersion(n);
            object2 = fSLogoutResponse.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                object = fSHostedProviderDescriptor.getSigningKeyAlias();
                if (object == null || ((String)object).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                object2 = FSSignatureUtil.signAndReturnQueryString((String)object2, (String)object);
            }
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            if (string.indexOf(63) == -1) {
                ((StringBuffer)object).append('?');
            } else {
                ((StringBuffer)object).append('&');
            }
            ((StringBuffer)object).append((String)object2);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LogoutServlet : Response to be sent : " + ((StringBuffer)object).toString());
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void returnLocallyAfterLogout(HttpServletResponse httpServletResponse, String string, boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            char c = string.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("logoutStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("logoutSuccess");
            } else {
                stringBuffer.append("logoutFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect failed. Control halted" + iOException.getMessage());
            return;
        }
    }

    private boolean verifyLogoutSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::verifyLogoutSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getSigningKeyAlias();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet.verifyLogoutSignature: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Logout request is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Logout request is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        char c = string.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("logout-request-improper")));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(AMURLEncDec.encode((String)FSUtils.bundle.getString("logout-failed")));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }
}

