/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSAuthnResponseEnvelope;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;

public class FSSSOLECPProfileHandler
extends FSSSOAndFedHandler {
    private FSAuthnResponseEnvelope authnResponseEnvelope = null;

    protected FSSSOLECPProfileHandler() {
    }

    public FSSSOLECPProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        super(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string);
    }

    public void processLECPAuthnRequest(FSAuthnRequest fSAuthnRequest) {
        this.processAuthnRequest(fSAuthnRequest, false);
    }

    public String formatLoginURL(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOLECPProfileHandler.formatLoginURL: Called\nloginUrl=" + string + "\nauthnContext=" + string2);
        }
        try {
            if (string == null) {
                FSUtils.debug.error("FSSSOLECPProfileHandler.formatLoginURL: ");
                return null;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(this.hostProviderId);
            String string3 = fSHostedProviderDescriptor.getSSOServiceURL();
            StringBuffer stringBuffer = new StringBuffer(string3);
            if (string3.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("LECP").append("=").append("TRUE").append("&").append("Authn").append("=").append("true").append("&");
            if (!string2.equals("http://www.projectliberty.org/schemas/authctx/classes/Password")) {
                stringBuffer.append("AuthnContext").append("=").append(AMURLEncDec.encode((String)string2)).append("&");
            }
            stringBuffer.append("_liberty_idp").append("=").append(AMURLEncDec.encode((String)fSHostedProviderDescriptor.getEntityID())).append("&").append("RequestID").append("=").append(AMURLEncDec.encode((String)this.authnRequest.getRequestID()));
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            StringBuffer stringBuffer2 = new StringBuffer("/postLogin");
            stringBuffer2.append("/").append("metaAlias").append("/").append(this.metaAlias).append("/");
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
            String string4 = this.authnRequest.getRequestID();
            fSSessionManager.setRelayState(string4, stringBuffer.toString());
            stringBuffer2.append("RelayState").append("/").append(AMURLEncDec.encode((String)string4)).append("/").append("sso").append("/").append("true");
            StringBuffer stringBuffer3 = new StringBuffer(100);
            stringBuffer3.append(string);
            if (string.indexOf(63) == -1) {
                stringBuffer3.append("?");
            } else {
                stringBuffer3.append("&");
            }
            stringBuffer3.append("goto").append("=");
            stringBuffer3.append(AMURLEncDec.encode((String)stringBuffer2.toString())).append("&");
            Set set = this.localConfig.getAuthDomainURLList();
            if (set != null && !set.isEmpty()) {
                String string5 = (String)set.iterator().next();
                stringBuffer3.append("org").append("=").append(AMURLEncDec.encode((String)string5)).append("&");
            }
            this.request.getSession(true).setAttribute("AuthnContext", (Object)string2);
            int n = stringBuffer3.length() - 1;
            if (stringBuffer3.charAt(n) == '&') {
                stringBuffer3 = stringBuffer3.deleteCharAt(n);
            }
            return stringBuffer3.toString();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOLECPProfileHandler.formatLoginURL: Exception: " + exception.getMessage());
            return null;
        }
    }

    private boolean isWMLContent(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Accept");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLECPHandler.isWMLContent:acceptStr=" + string);
        }
        if (string != null && string.toLowerCase().indexOf("text/vnd.wap.wml") != -1) {
            FSUtils.debug.message("FSLECPHandler.isWMLContent() :: true");
            return true;
        }
        return false;
    }

    protected void sendAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        fSAuthnResponse.setProviderId(this.hostProviderId);
        FSAuthnResponseEnvelope fSAuthnResponseEnvelope = new FSAuthnResponseEnvelope(fSAuthnResponse);
        fSAuthnResponseEnvelope.setMinorVersion(fSAuthnResponse.getMinorVersion());
        fSAuthnResponseEnvelope.setAssertionConsumerServiceURL(this.spDescriptor.getAssertionConsumerServiceURL());
        FSSOAPService fSSOAPService = FSSOAPService.getInstance();
        SOAPMessage sOAPMessage = fSSOAPService.bindAuthnResponseEnvelope(fSAuthnResponseEnvelope);
        this.response.setHeader("Liberty-Enabled", this.request.getHeader("Liberty-Enabled"));
        this.response.setContentType("application/vnd.liberty-response+xml");
        if (FSServiceUtils.isSigningOn()) {
            try {
                List list = fSAuthnResponse.getAssertion();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSAssertion fSAssertion = (FSAssertion)iterator.next();
                    String string = fSAssertion.getID();
                    Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
                    FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                    if (fSAllianceManager == null) {
                        FSUtils.debug.error("FSSSOLECPProfileHandler.sendAuthnResponse: could not create alliance instance");
                        this.response.setStatus(500);
                        this.returnSOAPMessage(fSSOAPService.FormSOAPError("Server", "cannotProcessRequest", null), this.response);
                        return;
                    }
                    String string2 = fSAllianceManager.getProvider(FSServiceUtils.getHostedProviderID(this.request)).getSigningKeyAlias();
                    if (string2 == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOLECPProfileHandler.sendAuthnResponse: couldn't obtain this site's cert alias.");
                        }
                        this.response.setStatus(500);
                        this.returnSOAPMessage(fSSOAPService.FormSOAPError("Server", "cannotProcessRequest", null), this.response);
                    }
                    XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                    int n = fSAssertion.getMinorVersion();
                    if (n == 0) {
                        xMLSignatureManager.signXML(document, string2, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "id", string, false);
                    } else if (n == 2 || n == 2) {
                        xMLSignatureManager.signXML(document, string2, SAMLUtilsCommon.bundle.getString("xmlsigalgorithm"), "AssertionID", fSAssertion.getAssertionID(), false);
                    } else if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("invalid minor version.");
                    }
                    sOAPMessage = FSServiceUtils.convertDOMToSOAP(document);
                }
            }
            catch (Exception exception) {
                this.response.setStatus(500);
                this.returnSOAPMessage(fSSOAPService.FormSOAPError("Server", "cannotProcessRequest", null), this.response);
            }
        }
        this.returnSOAPMessage(sOAPMessage, this.response);
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSAuthnResponse fSAuthnResponse = this.createAuthnResponse(sSOToken, string, nameIdentifier, nameIdentifier2);
        this.sendAuthnResponse(fSAuthnResponse);
        return true;
    }

    private void returnSOAPMessage(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) {
        try {
            if (sOAPMessage != null) {
                httpServletResponse.setHeader("Liberty-Enabled", this.request.getHeader("Liberty-Enabled"));
                httpServletResponse.setContentType("application/vnd.liberty-response+xml");
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::" + exception.getMessage());
            return;
        }
    }

    private static void putHeaders(MimeHeaders mimeHeaders, HttpServletResponse httpServletResponse) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = mimeHeaders.getHeader(mimeHeader.getName());
            if (stringArray.length == 1) {
                httpServletResponse.setHeader(mimeHeader.getName(), mimeHeader.getValue());
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n++]);
            }
            httpServletResponse.setHeader(mimeHeader.getName(), stringBuffer.toString());
        }
    }
}

