/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSSSOBrowserArtifactProfileHandler
extends FSSSOAndFedHandler {
    private Request samlRequest;
    private Element samlRequestElement = null;
    private SOAPMessage soapMsg = null;

    public void setSOAPMessage(SOAPMessage sOAPMessage) {
        this.soapMsg = sOAPMessage;
    }

    public void setSAMLRequestElement(Element element) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.setSAMLRequestElement: Called");
        }
        this.samlRequestElement = element;
    }

    protected FSSSOBrowserArtifactProfileHandler() {
    }

    public FSSSOBrowserArtifactProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        super(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string);
    }

    public FSSSOBrowserArtifactProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Request request) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.samlRequest = request;
    }

    public void processAuthnRequest(FSAuthnRequest fSAuthnRequest, boolean bl) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: Called");
        }
        try {
            if (bl) {
                if (this.processPostAuthnSSO(fSAuthnRequest)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processingsuccessful");
                    }
                    return;
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing failed");
                }
                String[] stringArray = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
                LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", stringArray);
                this.sendSAMLArtifacts(null);
                return;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string = this.spDescriptor.getSigningKeyAlias();
            boolean bl2 = this.spDescriptor.getAuthnRequestSigned();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: ProviderID : " + this.spDescriptor.getProviderID() + " AuthnRequestSigned : " + bl2);
            }
            if (FSServiceUtils.isSigningOn() && bl2) {
                if (!this.verifyRequestSignature(fSAuthnRequest)) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Signature Verification Failed");
                    String[] stringArray = new String[]{FSUtils.bundle.getString("signatureVerificationFailed")};
                    LogUtil.error(Level.INFO, "SIGNATURE VERIFICATION FAILED", stringArray);
                    this.sendSAMLArtifacts(null);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Signature Verified");
                }
            }
            if (this.processPreAuthnSSO(fSAuthnRequest)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing  successful");
                }
                return;
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: AuthnRequest Processing failed");
            }
            String[] stringArray = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
            LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", stringArray);
            this.sendSAMLArtifacts(null);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processAuthnRequest: Exception Occured: " + exception.getMessage());
            this.sendSAMLArtifacts(null);
            return;
        }
    }

    public FSResponse processSAMLRequest(FSSAMLRequest fSSAMLRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.processSAMLRequest: Called");
        }
        try {
            return this.createSAMLResponse(fSSAMLRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.processSAMLRequest: Fatal error, cannot create status or response: " + exception.getMessage());
            return null;
        }
    }

    private Response validateStatements(Assertion assertion, List list, List list2, int n, String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.validateStatements: Called");
        }
        Object var7_7 = null;
        String string3 = null;
        Set set = assertion.getStatement();
        int n2 = set.size();
        FSResponse fSResponse = null;
        Status status = null;
        if (set.isEmpty() || n2 == 0) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Assertion found does not have any statements in it");
            string3 = FSUtils.bundle.getString("missingStatement");
            try {
                status = new Status(new StatusCode("samlp:Responder"), string3, null);
                fSResponse = new FSResponse(string, string2, status, list2);
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Fatal error, cannot create status or response:" + fSException.getMessage());
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            return fSResponse;
        }
        boolean bl = false;
        list2.add(n, assertion);
        if (bl) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Assertion does not  meet respondWith criteria in the received Request");
            string3 = FSUtils.bundle.getString("mismatchRespondWith");
            try {
                status = new Status(new StatusCode("samlp:Success"), string3, null);
                return new FSResponse(string, string2, status, list2);
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Fatal error,  cannot create status or response:" + sAMLException.getMessage());
            }
            catch (FSException fSException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.validateStatements: Fatal error,  cannot create status or response:" + fSException.getMessage());
            }
        }
        return null;
    }

    private FSResponse createSAMLResponse(FSSAMLRequest fSSAMLRequest) throws FSException {
        Object object;
        String[] stringArray;
        Object object2;
        String string;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Called");
        }
        FSResponse fSResponse = null;
        String string2 = FSUtils.generateID();
        String string3 = fSSAMLRequest.getRequestID();
        ArrayList arrayList = new ArrayList();
        String string4 = null;
        String string5 = string = this.request.getRemoteAddr();
        String string6 = FSUtils.bundle.getString("responseLogMessage") + " " + string;
        int n = fSSAMLRequest.getContentType();
        if (n == -1) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Found element in the request which are not supported");
            }
            string4 = FSUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                fSResponse = new FSResponse(string2, string3, status, arrayList);
                fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: " + sAMLException.getMessage());
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] stringArray2 = new String[]{string6, fSResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray2);
            } else {
                String[] stringArray3 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray3);
            }
            return fSResponse;
        }
        Object object3 = fSSAMLRequest.getRespondWith();
        if (object3.size() == 0) {
            object2 = new ArrayList<String>();
            object2.add(0, "SingleStatement");
            object3 = object2;
        }
        object2 = null;
        try {
            object2 = FSAssertionManager.getInstance(this.hostEntityId);
            ((FSAssertionManager)object2).setProviderId(this.hostProviderId);
        }
        catch (FSException fSException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Cannot instantiate FSAssertionManager");
            }
            string4 = fSException.getMessage();
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                fSResponse = new FSResponse(string2, string3, status, arrayList);
                fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: " + sAMLException.getMessage());
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] stringArray4 = new String[]{string6, fSResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray4);
            } else {
                String[] stringArray5 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray5);
            }
            return fSResponse;
        }
        List list = null;
        ArrayList<Assertion> arrayList2 = new ArrayList<Assertion>();
        if (n == 3) {
            list = fSSAMLRequest.getAssertionArtifact();
            int n2 = list.size();
            String string7 = null;
            String string8 = null;
            stringArray = null;
            int n3 = 0;
            while (n3 < n2) {
                stringArray = (AssertionArtifact)list.get(n3);
                if (string7 != null) {
                    if (!string7.equals(stringArray.getSourceID())) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Artifacts not from the same source");
                        }
                        string4 = FSUtils.bundle.getString("mismatchSourceID");
                        try {
                            Status status = new Status(new StatusCode("samlp:Requester", new StatusCode("lib:FederationDoesNotExist", null)), string4, null);
                            fSResponse = new FSResponse(string2, string3, status, arrayList);
                            fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                        }
                        catch (SAMLException sAMLException) {
                            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response: " + sAMLException.getMessage());
                        }
                        if (LogUtil.isAccessLoggable(Level.FINER)) {
                            String[] stringArray6 = new String[]{string6, fSResponse.toString()};
                            LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray6);
                        } else {
                            String[] stringArray7 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                            LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray7);
                        }
                        return fSResponse;
                    }
                } else {
                    string7 = stringArray.getSourceID();
                }
                ++n3;
            }
            if (stringArray != null) {
                try {
                    string8 = ((FSAssertionManager)object2).getDestIdForArtifact((AssertionArtifact)stringArray);
                }
                catch (FSException fSException) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: FSException Occured while retrieving sp's providerID for the artifact: " + fSException.getMessage());
                    string8 = null;
                }
                if (string8 == null) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: artifact received does not correspond to any SP");
                    string4 = FSUtils.bundle.getString("invalidSource");
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester", new StatusCode("lib:FederationDoesNotExist", null)), string4, null);
                        fSResponse = new FSResponse(string2, string3, status, arrayList);
                        fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                        return fSResponse;
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                        return null;
                    }
                }
                try {
                    Set set = this.localConfig.getTrustedProviders();
                    if (set != null) {
                        if (!set.contains(string8)) {
                            FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                            string4 = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                            Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                            fSResponse = new FSResponse(string2, string3, status, arrayList);
                            fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                            return fSResponse;
                        }
                    } else {
                        FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                        string4 = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                        Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                        fSResponse = new FSResponse(string2, string3, status, arrayList);
                        fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                        return fSResponse;
                    }
                    object = FSServiceUtils.getAllianceInstance();
                    this.spDescriptor = ((FSAllianceManager)object).getProvider(string8);
                    string = string8;
                }
                catch (Exception exception) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: FSAllianceManagementException Occured while getting" + exception.getMessage());
                    string4 = exception.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                        fSResponse = new FSResponse(string2, string3, status, arrayList);
                        fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                        return fSResponse;
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                        return null;
                    }
                }
                if (FSServiceUtils.isSigningOn()) {
                    if (!this.verifySAMLRequestSignature(this.samlRequestElement, this.soapMsg)) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: SAMLRequest signature verification failed");
                        string4 = FSUtils.bundle.getString("signatureVerificationFailed");
                        try {
                            Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                            fSResponse = new FSResponse(string2, string3, status, arrayList);
                            fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                            return fSResponse;
                        }
                        catch (SAMLException sAMLException) {
                            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                        }
                    } else if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtProfileHandler.createSAMLResp: SAMLRequest signature verified");
                    }
                }
            } else {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: No artifact found in samlRequest");
                string4 = FSUtils.bundle.getString("missingArtifact");
                try {
                    Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                    fSResponse = new FSResponse(string2, string3, status, arrayList);
                    fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                    return fSResponse;
                }
                catch (SAMLException sAMLException) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                    return null;
                }
            }
            int n4 = 0;
            while (n4 < n2) {
                object = (AssertionArtifact)list.get(n4);
                Assertion assertion = null;
                try {
                    assertion = ((FSAssertionManager)object2).getAssertion((AssertionArtifact)object, this.spDescriptor.getEntityID());
                }
                catch (FSException fSException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: could not find matching assertion");
                    }
                    string4 = fSException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                        fSResponse = new FSResponse(string2, string3, status, arrayList);
                        fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                    }
                    if (LogUtil.isAccessLoggable(Level.FINER)) {
                        String[] stringArray8 = new String[]{string6, fSResponse.toString()};
                        LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray8);
                    } else {
                        String[] stringArray9 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                        LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray9);
                    }
                    return fSResponse;
                }
                if (assertion != null) {
                    arrayList2.add(n4, assertion);
                }
                ++n4;
            }
        }
        int n5 = arrayList2.size();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: found " + n5 + "assertions.");
        }
        int n6 = 0;
        while (n6 < n5) {
            stringArray = (Assertion)arrayList2.get(n6);
            Conditions conditions = stringArray.getConditions();
            Set set = conditions.getAudienceRestrictionCondition();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: checking to see if assertions are for host:" + string);
            }
            if (!set.isEmpty()) {
                object = set.iterator();
                while (object.hasNext()) {
                    if (((AudienceRestrictionCondition)object.next()).containsAudience(string)) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: removing TRC notmeant for this host");
                    }
                    arrayList2.remove(stringArray);
                }
            }
            ++n6;
        }
        n5 = arrayList2.size();
        if (n5 == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Matching Assertions(s) not created for this host");
            }
            string4 = FSUtils.bundle.getString("mismatchDest");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                fSResponse = new FSResponse(string2, string3, status, arrayList);
                fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                stringArray = new String[]{string6, fSResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray);
            } else {
                stringArray = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray);
            }
            return fSResponse;
        }
        int n7 = 0;
        while (n7 < n5) {
            Response response = this.validateStatements((Assertion)arrayList2.get(n7), (List)object3, arrayList, n7, string2, string3);
            if (response != null) {
                Object object4;
                if (LogUtil.isAccessLoggable(Level.FINER)) {
                    object4 = new String[]{string6, response.toString()};
                    LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", (String[])object4);
                } else {
                    object4 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                    LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", (String[])object4);
                }
                object4 = (FSResponse)response;
                ((FSResponse)object4).setMinorVersion(fSSAMLRequest.getMinorVersion());
                return object4;
            }
            ++n7;
        }
        if (n == 3) {
            if (arrayList.size() == list.size()) {
                string4 = null;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Matching Assertion found");
                }
                try {
                    Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                    fSResponse = new FSResponse(string2, string3, status, arrayList);
                    fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
                }
                catch (SAMLException sAMLException) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    return null;
                }
                catch (Exception exception) {
                    FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:" + exception.getMessage());
                    return null;
                }
                if (LogUtil.isAccessLoggable(Level.FINER)) {
                    String[] stringArray10 = new String[]{string6, fSResponse.toString()};
                    LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray10);
                } else {
                    String[] stringArray11 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                    LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray11);
                }
                return fSResponse;
            }
            string4 = FSUtils.bundle.getString("unequalMatch");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                fSResponse = new FSResponse(string2, string3, status, arrayList);
                fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            if (LogUtil.isAccessLoggable(Level.FINER)) {
                String[] stringArray12 = new String[]{string6, fSResponse.toString()};
                LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray12);
            } else {
                String[] stringArray13 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
                LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray13);
            }
            return fSResponse;
        }
        try {
            string4 = null;
            Status status = new Status(new StatusCode("samlp:Success"), string4, null);
            fSResponse = new FSResponse(string2, string3, status, arrayList);
            fSResponse.setMinorVersion(fSSAMLRequest.getMinorVersion());
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLResponse: Fatal error, cannot create status or response:" + sAMLException.getMessage());
        }
        if (LogUtil.isAccessLoggable(Level.FINER)) {
            String[] stringArray14 = new String[]{string6, fSResponse.toString()};
            LogUtil.access(Level.FINER, "CREATE_SAML_RESPONSE", stringArray14);
        } else {
            String[] stringArray15 = new String[]{string6, FSUtils.bundle.getString("responseID"), fSResponse.getResponseID(), FSUtils.bundle.getString("inResponseTo"), fSResponse.getInResponseTo()};
            LogUtil.access(Level.INFO, "CREATE_SAML_RESPONSE", stringArray15);
        }
        return fSResponse;
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.doSingleSignOn: Called");
        List list = this.createSAMLAssertionArtifact(sSOToken, string, nameIdentifier, nameIdentifier2);
        this.sendSAMLArtifacts(list);
        return true;
    }

    protected List createSAMLAssertionArtifact(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact: Called");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            FSAssertionManager fSAssertionManager = FSAssertionManager.getInstance(this.hostEntityId);
            fSAssertionManager.setProviderId(this.hostProviderId);
            AssertionArtifact assertionArtifact = fSAssertionManager.createFSAssertionArtifact(sSOToken.getTokenID().toString(), this.spDescriptor, this.hostProviderId, nameIdentifier, nameIdentifier2, string, this.authnRequest.getMinorVersion());
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionArtifact id = " + assertionArtifact.toString());
            }
            String string2 = assertionArtifact.getAssertionArtifact();
            arrayList.add(string2);
            return arrayList;
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact(0): ", (Throwable)((Object)fSException));
            return null;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.createSAMLAssertionArtifact(1): ", (Throwable)sAMLException);
            return null;
        }
    }

    private void sendSAMLArtifacts(List list) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Called");
        }
        if (list == null) {
            list = this.createFaultSAMLArtifact();
        }
        try {
            String string;
            Object object;
            String string2 = this.authnRequest.getAssertionConsumerServiceID();
            if (string2 == null || string2.equals("")) {
                string2 = this.spDescriptor.getAssertionConsumerServiceURL();
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            if (list == null || list.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Sending null artifact");
                }
                stringBuffer.append("SAMLart").append("=").append("&");
            } else {
                object = list.iterator();
                while (object.hasNext()) {
                    string = AMURLEncDec.encode((String)((String)object.next()));
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: " + string);
                    }
                    stringBuffer.append("SAMLart").append("=").append(string).append("&");
                }
            }
            object = new StringBuffer(1000);
            if (string2.indexOf(63) == -1) {
                ((StringBuffer)object).append(string2).append("?");
            } else {
                ((StringBuffer)object).append(string2).append("&");
            }
            ((StringBuffer)object).append(stringBuffer.toString());
            string = this.authnRequest.getRelayState();
            if (string != null) {
                ((StringBuffer)object).append("RelayState").append("=").append(AMURLEncDec.encode((String)string));
            }
            this.response.setStatus(302);
            String string3 = ((StringBuffer)object).toString();
            this.response.setContentType("text/html");
            this.response.setHeader("Location", string3);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: Sending artifacts to: " + string3);
            }
            String[] stringArray = new String[]{string3};
            LogUtil.access(Level.FINER, "REDIRECT_TO", stringArray);
            this.response.sendRedirect(string3);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.sendSAMLArtifacts: " + exception.getMessage());
            return;
        }
    }

    private List createFaultSAMLArtifact() {
        String string;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler. In createFaultSAMLArtifacts");
        }
        if ((string = SAMLUtils.generateAssertionHandle()) == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.create FaultSAMLArtifacts: couldn't generate assertion handle.");
            }
            return null;
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(this.hostProviderId);
            String string2 = fSHostedProviderDescriptor.getProviderSuccinctID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.createFaultSAMLArtifacts: SourceID for the Artifact: " + string2);
            }
            byte[] byArray = FSUtils.hexStringToByteArray(string2);
            byte[] byArray2 = null;
            byArray2 = string.getBytes("ISO-8859-1");
            FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(byArray, byArray2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(fSAssertionArtifact.getAssertionArtifact());
            return arrayList;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSBrowserArtifactProfileHandler.createFaultSAMLArtifacts: ", (Throwable)exception);
            return null;
        }
    }

    protected boolean verifySAMLRequestSignature(Element element, SOAPMessage sOAPMessage) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: Called");
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string = this.spDescriptor.getSigningKeyAlias();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: Provider's certAlias is found: " + string);
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOBrowserArtifactProfileHandler.verifySAMLRequestSignature: Exception occured while verifying IDP's signature:" + exception.getMessage());
            return false;
        }
    }
}

