/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.message.FSScoping;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSAuthnDecisionImpl;
import com.sun.identity.federation.services.FSIDPProxy;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public abstract class FSSSOAndFedHandler {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected FSProviderDescriptor spDescriptor;
    protected String relayState = null;
    protected FSAuthnRequest authnRequest = null;
    protected SSOToken ssoToken = null;
    protected String hostProviderId = null;
    protected String metaAlias = null;
    protected FSLocalConfigurationDescriptor localConfig = null;
    private static FSIDPProxy proxyFinder = null;
    protected Status noFedStatus = null;
    protected String hostEntityId = null;

    public void setHostProviderId(String string) {
        this.hostProviderId = string;
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            this.localConfig = fSHostedProviderDescriptor.getLocalConfiguration();
            this.hostEntityId = fSHostedProviderDescriptor.getEntityID();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSSSOAndFedHandler.setHostProviderId: Could not obtain local config");
        }
    }

    public void setMetaAlias(String string) {
        this.metaAlias = string;
    }

    public String getHostProviderId() {
        return this.hostProviderId;
    }

    protected FSSSOAndFedHandler() {
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string, SSOToken sSOToken) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
        }
        if (fSProviderDescriptor != null) {
            this.spDescriptor = fSProviderDescriptor;
        }
        if (sSOToken != null) {
            this.ssoToken = sSOToken;
        }
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
        }
        if (fSProviderDescriptor != null) {
            this.spDescriptor = fSProviderDescriptor;
        }
        if (string != null) {
            this.relayState = string;
        }
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
    }

    public boolean processPreAuthnSSO(FSAuthnRequest fSAuthnRequest) {
        Object object;
        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: Called");
        boolean bl = false;
        String string = null;
        ArrayList<String> arrayList = null;
        String string2 = null;
        List list = null;
        String string3 = null;
        String string4 = null;
        FSAuthContextResult fSAuthContextResult = null;
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        if (fSAuthnRequest.getAuthnContext() != null) {
            arrayList = fSAuthnRequest.getAuthnContext().getAuthnContextClassRefList();
            if (arrayList == null) {
                String string5 = "http://www.projectliberty.org/schemas/authctx/classes/Password";
                arrayList = new ArrayList<String>();
                arrayList.add(string5);
            }
            string4 = fSAuthnRequest.getAuthContextCompType();
            list = fSAuthnRequest.getAuthnContext().getAuthnContextStatementRefList();
            string3 = null;
            bl = true;
        }
        boolean bl2 = true;
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(this.request);
            if (sSOToken == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOToken is null. User is not authenticated.");
                }
                bl2 = false;
            } else if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOToken is not valid. User is not authenticated.");
                }
                bl2 = false;
            } else {
                object = fSSessionManager.getSession(sSOToken);
                if (object != null) {
                    string3 = ((FSSession)object).getAuthnContext();
                    if (string3 != null) {
                        bl2 = true;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User has an existing valid session with authnContext: " + string3);
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context information not found using default authentication context");
                        }
                        string3 = this.localConfig.getDefaultAuthenticationContext();
                        bl2 = true;
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authenticated session information is not present in FSSessionManager. using default authentication context");
                    }
                    string3 = this.localConfig.getDefaultAuthenticationContext();
                    bl2 = true;
                }
            }
            if (bl2) {
                sSOToken.addSSOTokenListener((SSOTokenListener)new FSTokenListener(this.hostProviderId));
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOException Occured: User does not have SSOToken " + sSOException.getMessage());
            bl2 = false;
        }
        if (!bl2) {
            try {
                boolean bl3 = this.isIDPProxyEnabled(fSAuthnRequest);
                if (bl3 && !fSAuthnRequest.getFederate() && (object = this.getPreferredIDP(fSAuthnRequest)) != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO:IDP to be proxied" + (String)object);
                    }
                    this.sendProxyAuthnRequest(fSAuthnRequest, (String)object);
                    return true;
                }
            }
            catch (FSRedirectException fSRedirectException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandle.processPreAuthnSSO:Redirecting for the proxy handling.");
                }
                return true;
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO:Exception occured while processing for the proxy.", (Throwable)exception);
                return false;
            }
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication status: " + bl2);
            }
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            object = new FSAuthnDecisionImpl(this.hostProviderId, this.request);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(this.localConfig.getDefaultAuthenticationContext());
            if (fSAuthnRequest.getIsPassive()) {
                if (fSAuthnRequest.getForceAuthn()) {
                    if (FSUtils.debug.warningEnabled()) {
                        FSUtils.debug.warning("FSSSOAndFedHandler.PreAuthnSSO: IDP is passive can't force authentication.");
                    }
                    return false;
                }
                if (bl2) {
                    if (arrayList != null) {
                        fSAuthContextResult = object.decideAuthnContext(arrayList, string3, string4);
                    } else if (string2 != null) {
                        fSAuthContextResult = object.decideAuthnContext(string2, string3);
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                        }
                        fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
                    }
                    if (fSAuthContextResult == null) {
                        return false;
                    }
                    if (fSAuthContextResult.getLoginURL() != null) {
                        string = fSAuthContextResult.getLoginURL();
                        string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                        FSUtils.forwardRequest(this.request, this.response, string);
                        return true;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(fSAuthnRequest);
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOAndFedHandler.processPreAuthnSSO: IDP is passive and user is not authenticated");
                }
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (fSAuthnRequest.getForceAuthn()) {
                fSAuthContextResult = arrayList != null ? object.getURLForAuthnContext(arrayList, string4) : (string2 != null ? object.getURLForAuthnContext(string2) : object.getURLForAuthnContext(arrayList2));
                if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null || fSAuthContextResult.getLoginURL().equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO:AuthnDecision engine failed to take a authn decision");
                    }
                    return false;
                }
                string = fSAuthContextResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
                }
                string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, string);
                this.response.flushBuffer();
                return true;
            }
            if (bl2) {
                if (arrayList != null) {
                    fSAuthContextResult = object.decideAuthnContext(arrayList, string3, string4);
                } else if (string2 != null) {
                    fSAuthContextResult = object.decideAuthnContext(string2, string3);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                    }
                    fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
                }
                if (fSAuthContextResult == null) {
                    return false;
                }
                if (fSAuthContextResult.getLoginURL() == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(fSAuthnRequest);
                }
                if (fSAuthContextResult.getLoginURL().equals("")) {
                    return false;
                }
                string = fSAuthContextResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
                }
                string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, string);
                return true;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (arrayList != null) {
                fSAuthContextResult = object.getURLForAuthnContext(arrayList, string4);
            } else if (string2 != null) {
                fSAuthContextResult = object.getURLForAuthnContext(string2);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                }
                fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
            }
            if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null || fSAuthContextResult.getLoginURL().equals("")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processPreAuthnSSO:  AuthnDecision engine failed to take a decision");
                }
                return false;
            }
            string = fSAuthContextResult.getLoginURL();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
            }
            string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
            FSUtils.forwardRequest(this.request, this.response, string);
            return true;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO: Exception occured");
            return this.processPostAuthnSSO(fSAuthnRequest);
        }
    }

    public String formatLoginURL(String string, String string2) {
        FSUtils.debug.message("FSSSOAndFedHandler.formatLoginURL: Called");
        try {
            if (string == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: ");
                return null;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(this.hostProviderId);
            String string3 = fSHostedProviderDescriptor.getSSOServiceURL();
            StringBuffer stringBuffer = new StringBuffer(string3);
            if (string3.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("Authn").append("=").append("true").append("&").append("AuthnContext").append("=").append(AMURLEncDec.encode((String)string2)).append("&").append("_liberty_idp").append("=").append(AMURLEncDec.encode((String)this.hostProviderId)).append("&").append("RequestID").append("=").append(AMURLEncDec.encode((String)this.authnRequest.getRequestID()));
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            String string4 = FSServiceUtils.getBaseURL(this.request) + "/postLogin";
            StringBuffer stringBuffer2 = new StringBuffer(string4);
            if (string4.indexOf(63) == -1) {
                stringBuffer2.append("?");
            } else {
                stringBuffer2.append("&");
            }
            stringBuffer2.append("RelayState").append("=").append(AMURLEncDec.encode((String)stringBuffer.toString())).append("&").append("sso").append("=").append("true").append("&").append("metaAlias").append("=").append(this.metaAlias);
            StringBuffer stringBuffer3 = new StringBuffer(100);
            stringBuffer3.append(string);
            if (string.indexOf(63) == -1) {
                stringBuffer3.append("?");
            } else {
                stringBuffer3.append("&");
            }
            stringBuffer3.append("goto").append("=").append(AMURLEncDec.encode((String)stringBuffer2.toString()));
            Set set = this.localConfig.getAuthDomainURLList();
            if (set != null && !set.isEmpty()) {
                String string5 = (String)set.iterator().next();
                stringBuffer3.append("&").append("org").append("=").append(AMURLEncDec.encode((String)string5));
            }
            this.request.getSession(true).setAttribute("AuthnContext", (Object)string2);
            int n = stringBuffer3.length() - 1;
            if (stringBuffer3.charAt(n) == '&') {
                stringBuffer3 = stringBuffer3.deleteCharAt(n);
            }
            return stringBuffer3.toString();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: Exception: " + exception.getMessage());
            return null;
        }
    }

    public boolean processPostAuthnSSO(FSAuthnRequest fSAuthnRequest) {
        Object object;
        Object object2;
        Object object3;
        FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: Called");
        try {
            object3 = SSOTokenManager.getInstance();
            if (this.ssoToken == null) {
                this.ssoToken = object3.createSSOToken(this.request);
            } else {
                if (!object3.isValidToken(this.ssoToken)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SSOToken is not valid.");
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: SSOToken is valid.");
                }
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: " + sSOException.getMessage());
            return false;
        }
        object3 = null;
        try {
            object3 = FSServiceUtils.getAMIdentity(this.ssoToken.getProperty("sun.am.UniversalIdentifier"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: UserDN of the principal in the session: " + object3);
            }
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: IdRepoException occured. " + idRepoException.getMessage());
            return false;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SSOException occured. Principal information not found in the SSOToken: " + sSOException.getMessage());
            return false;
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        FSSession fSSession = fSSessionManager.getSession(IdUtils.getUniversalId((AMIdentity)object3), this.ssoToken.getTokenID().toString());
        if (fSSession != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: An existing SSO session found with ID:" + fSSession.getSessionID());
            }
            fSSession.addSessionPartner(new FSSessionPartner(this.spDescriptor.getProviderID(), false));
            fSSessionManager.addSession(IdUtils.getUniversalId((AMIdentity)object3), fSSession);
        } else {
            object2 = this.ssoToken.getTokenID().toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: No existing SSO session found. Entering a new session to the session manager with ID: " + (String)object2);
            }
            fSSession = new FSSession((String)object2);
            object = SAMLUtilsCommon.generateID();
            fSSession.setSessionIndex((String)object);
            fSSession.addSessionPartner(new FSSessionPartner(this.spDescriptor.getProviderID(), false));
            fSSessionManager.addSession(IdUtils.getUniversalId((AMIdentity)object3), fSSession);
        }
        if (fSAuthnRequest.getFederate() || this.localConfig.isAutoFedEnabled()) {
            object2 = this.doAccountFederation(this.ssoToken, fSAuthnRequest, fSSession);
            object = null;
            NameIdentifier nameIdentifier = null;
            if (object2 == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Accountfederation failed");
                return false;
            }
            object = ((FSAccountFedInfo)object2).getRemoteNameIdentifier();
            nameIdentifier = ((FSAccountFedInfo)object2).getLocalNameIdentifier();
            if (nameIdentifier == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Opaque handle not found");
                return false;
            }
            if (object == null) {
                object = nameIdentifier;
            }
            return this.doSingleSignOn(this.ssoToken, fSAuthnRequest.getRequestID(), (NameIdentifier)object, nameIdentifier);
        }
        return this.doSingleSignOn(this.ssoToken, fSAuthnRequest.getRequestID());
    }

    protected FSAuthnResponse createAuthnResponse(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse:  Called");
        FSAuthnResponse fSAuthnResponse = null;
        try {
            String string2 = this.authnRequest.getRequestID();
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string3 = this.hostProviderId;
            FSAssertionManager fSAssertionManager = FSAssertionManager.getInstance(this.hostEntityId);
            fSAssertionManager.setProviderId(this.hostProviderId);
            FSAssertion fSAssertion = null;
            fSAssertion = fSAssertionManager.createFSAssertion(sSOToken.getTokenID().toString(), null, this.spDescriptor, string3, nameIdentifier, nameIdentifier2, string, this.authnRequest.getMinorVersion());
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<FSAssertion> arrayList = new ArrayList<FSAssertion>();
            arrayList.add(fSAssertion);
            fSAuthnResponse = new FSAuthnResponse(null, string2, status, arrayList, this.relayState);
            fSAuthnResponse.setMinorVersion(this.authnRequest.getMinorVersion());
            FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse: CHECK1: " + this.hostProviderId);
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(this.hostProviderId);
            fSAuthnResponse.setProviderId(fSProviderDescriptor.getEntityID());
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: FSException: ", (Throwable)((Object)fSException));
            return null;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: SAMLException: ", (Throwable)sAMLException);
            return null;
        }
        return fSAuthnResponse;
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        return false;
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string) {
        FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn(2):  Called");
        try {
            NameIdentifier nameIdentifier;
            Object object;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: Initiating SSO for user with DN: " + sSOToken.getPrincipal().getName());
            }
            String string2 = this.authnRequest.getProviderId();
            String string3 = this.authnRequest.getAffiliationID();
            if (string3 != null) {
                string2 = string3;
            }
            AMIdentity aMIdentity = FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier"));
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            FSAccountFedInfo fSAccountFedInfo = fSAccountManager.readAccountFedInfo(aMIdentity, string2);
            if (fSAccountFedInfo == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Account Federation Information not found for user with DN: " + sSOToken.getPrincipal().getName());
                this.noFedStatus = new Status(new StatusCode("samlp:Responder", new StatusCode("lib:FederationDoesNotExist", null)), FSUtils.bundle.getString("AuthnRequestProcessingFailed"), null);
                String[] stringArray = new String[]{sSOToken.getPrincipal().getName()};
                LogUtil.error(Level.INFO, "USER_ACCOUNT_FEDERATION_INFO_NOT_FOUND", stringArray);
                return false;
            }
            if (fSAccountFedInfo != null && fSAccountFedInfo.isFedStatusActive() && (object = (nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier()).getNameQualifier()) != null && ((String)object).equals(this.hostEntityId)) {
                nameIdentifier = new NameIdentifier(nameIdentifier.getName(), string2);
                NameIdentifier nameIdentifier2 = fSAccountFedInfo.getRemoteNameIdentifier();
                if (nameIdentifier2 != null) {
                    nameIdentifier2 = new NameIdentifier(nameIdentifier2.getName(), string2);
                }
                FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(string2, nameIdentifier.getName());
                fSAccountFedInfo = new FSAccountFedInfo(string2, nameIdentifier, nameIdentifier2, false);
                fSAccountManager.writeAccountFedInfo(aMIdentity, fSAccountFedInfoKey, fSAccountFedInfo);
                FSAccountFedInfoKey fSAccountFedInfoKey2 = new FSAccountFedInfoKey(this.hostEntityId, nameIdentifier.getName());
                fSAccountManager.removeAccountFedInfoKey(aMIdentity, fSAccountFedInfoKey2);
            }
            if ((nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier()) == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: NameIdentifier not found");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: IDP generated opaque handle: " + nameIdentifier.getName());
            }
            if ((object = fSAccountFedInfo.getRemoteNameIdentifier()) == null) {
                object = nameIdentifier;
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: SP generated opaque handle: " + ((NameIdentifier)object).getName());
            }
            return this.doSingleSignOn(sSOToken, string, (NameIdentifier)object, nameIdentifier);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Exception during Single Sign-On:", (Throwable)exception);
            return false;
        }
    }

    protected FSAccountFedInfo doAccountFederation(SSOToken sSOToken, FSAuthnRequest fSAuthnRequest, FSSession fSSession) {
        Object object;
        boolean bl;
        String string;
        String string2;
        block17: {
            FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Called");
            string2 = fSAuthnRequest.getNameIDPolicy();
            string = fSAuthnRequest.getAffiliationID();
            bl = false;
            if (string != null) {
                object = FSServiceUtils.getAllianceInstance();
                try {
                    bl = ((FSAllianceManager)object).isAffiliateMember(this.hostEntityId, string);
                }
                catch (Exception exception) {
                    if (!FSUtils.debug.messageEnabled()) break block17;
                    FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Error in checking for the affiliation", (Throwable)exception);
                }
            }
        }
        try {
            object = FSAccountManager.getInstance();
            AMIdentity aMIdentity = FSServiceUtils.getAMIdentity(sSOToken.getProperty("sun.am.UniversalIdentifier"));
            FSAccountFedInfo fSAccountFedInfo = null;
            if (bl && (fSAccountFedInfo = ((FSAccountManager)object).readAccountFedInfo(aMIdentity, string)) != null && fSAccountFedInfo.isFedStatusActive()) {
                return fSAccountFedInfo;
            }
            String string3 = fSAuthnRequest.getProviderId();
            fSAccountFedInfo = ((FSAccountManager)object).readAccountFedInfo(aMIdentity, string3);
            if (fSAccountFedInfo != null && fSAccountFedInfo.isFedStatusActive()) {
                return fSAccountFedInfo;
            }
            FSNameIdentifierHelper fSNameIdentifierHelper = new FSNameIdentifierHelper(this.hostProviderId);
            String string4 = fSNameIdentifierHelper.createNameIdentifier();
            if (string4 == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Could not generate handle");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Generated handle: " + string4);
            }
            if (bl) {
                string3 = string;
            }
            NameIdentifier nameIdentifier = new NameIdentifier(string4, string3);
            if (fSAuthnRequest.getMinorVersion() == 2) {
                if (string2 == null || !string2.equals("onetime")) {
                    nameIdentifier.setFormat("urn:liberty:iff:nameid:federated");
                } else {
                    nameIdentifier.setFormat("urn:liberty:iff:nameid:one-time");
                }
            }
            FSAccountFedInfo fSAccountFedInfo2 = new FSAccountFedInfo(fSAuthnRequest.getProviderId(), nameIdentifier, null, false);
            FSAccountFedInfoKey fSAccountFedInfoKey = null;
            if (bl) {
                fSAccountFedInfoKey = new FSAccountFedInfoKey(string, string4);
                fSAccountFedInfo2.setAffiliation(true);
            } else {
                fSAccountFedInfoKey = new FSAccountFedInfoKey(fSAuthnRequest.getProviderId(), string4);
            }
            if (string2 == null || !string2.equals("onetime")) {
                ((FSAccountManager)object).writeAccountFedInfo(aMIdentity, fSAccountFedInfoKey, fSAccountFedInfo2);
            } else {
                fSSession.setOneTime(true);
                fSSession.setAccountFedInfo(fSAccountFedInfo2);
                fSSession.setUserDN(IdUtils.getUniversalId(aMIdentity));
            }
            return fSAccountFedInfo2;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Exception when doing account federation");
            return null;
        }
    }

    protected void returnErrorResponse() {
    }

    public FSResponse processSAMLRequest(FSSAMLRequest fSSAMLRequest) {
        FSUtils.debug.error("FSSSOAndFedHandler.processSAMLRequest: Call should not resolve here, abstract class.");
        return null;
    }

    public void processAuthnRequest(FSAuthnRequest fSAuthnRequest, boolean bl) {
        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: Called");
        this.authnRequest = fSAuthnRequest;
        String string = null;
        String string2 = fSAuthnRequest.getRequestID();
        Status status = null;
        FSAuthnResponse fSAuthnResponse = null;
        String string3 = fSAuthnRequest.getProviderId();
        try {
            Set set = this.localConfig.getTrustedProviders();
            if (set != null) {
                if (!set.contains(string3)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                    string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                    status = new Status(new StatusCode("samlp:Responder"), string, null);
                    fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                    fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                    this.sendAuthnResponse(fSAuthnResponse);
                    return;
                }
            } else {
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = new Status(new StatusCode("samlp:Responder"), string, null);
                fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                this.sendAuthnResponse(fSAuthnResponse);
                return;
            }
            if (bl) {
                if (this.processPostAuthnSSO(fSAuthnRequest)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                    }
                    return;
                }
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
                }
                string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = this.noFedStatus != null ? this.noFedStatus : new Status(new StatusCode("samlp:Responder"), string, null);
                fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                this.sendAuthnResponse(fSAuthnResponse);
                return;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string4 = this.spDescriptor.getSigningKeyAlias();
            boolean bl2 = this.spDescriptor.getAuthnRequestSigned();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: ProviderID : " + this.spDescriptor.getProviderID() + " AuthnRequestSigned :this is for testing " + bl2);
            }
            if (FSServiceUtils.isSigningOn() && bl2) {
                if (!this.verifyRequestSignature(fSAuthnRequest)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Signature Verification Failed");
                    string = FSUtils.bundle.getString("signatureVerificationFailed");
                    String[] stringArray = new String[]{string};
                    LogUtil.error(Level.INFO, "SIGNATURE VERIFICATION FAILED", stringArray);
                    status = new Status(new StatusCode("samlp:Responder"), string, null);
                    fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                    fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                    this.sendAuthnResponse(fSAuthnResponse);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processAuthnRequest: AuthnRequest Signature Verified");
                }
            }
            if (this.processPreAuthnSSO(fSAuthnRequest)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                }
                return;
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
            }
            String[] stringArray = new String[]{FSUtils.bundle.getString("AuthnRequestProcessingFailed")};
            LogUtil.error(Level.INFO, "AUTHN_REQUEST_PROCESSING_FAILED", stringArray);
            string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
            status = new Status(new StatusCode("samlp:Responder"), string, null);
            fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
            fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
            this.sendAuthnResponse(fSAuthnResponse);
            return;
        }
        catch (Exception exception) {
            block18: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: Exception Occured: " + exception.getMessage() + "Stack trace is " + byteArrayOutputStream.toString());
                string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                try {
                    status = new Status(new StatusCode("samlp:Responder"), string, null);
                    fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                    fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                    this.sendAuthnResponse(fSAuthnResponse);
                }
                catch (Exception exception2) {
                    if (!FSUtils.debug.messageEnabled()) break block18;
                    FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: Exception Occured: " + exception.getMessage() + "Stack trace is " + byteArrayOutputStream.toString());
                }
            }
            return;
        }
    }

    protected void sendAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        FSUtils.debug.error("FSSSOAndFedHandler.sendAuthnResponse: Call should not resolve here. error");
    }

    public void setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.spDescriptor = fSProviderDescriptor;
    }

    public FSProviderDescriptor getProvider() {
        return this.spDescriptor;
    }

    protected boolean verifyRequestSignature(FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Called");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string = this.spDescriptor.getSigningKeyAlias();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: couldn't obtain this site's cert alias.");
                }
                throw new FSException("cannotFindCertAlias", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Provider's certAlias is found: " + string);
            }
            if (this.request.getMethod().equals("GET")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by GET");
                }
                String string2 = this.request.getParameter("SigAlg");
                String string3 = this.request.getParameter("Signature");
                if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                    return false;
                }
                String string4 = null;
                if (string2.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    string4 = "SHA1withDSA";
                } else if (string2.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    string4 = "SHA1withRSA";
                } else {
                    FSUtils.debug.error("FSSSOAndFedHandler.signAndReturnQueryString: Invalid signature algorithim");
                    return false;
                }
                String string5 = this.request.getQueryString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: queryString:" + string5);
                }
                int n = string5.indexOf("&Signature");
                String string6 = string5.substring(0, n);
                byte[] byArray = null;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Signature: " + string3 + "Algorithm: " + string4);
                }
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byArray = bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string3.getBytes()));
                FSSignatureManager fSSignatureManager = FSSignatureManager.getInstance();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: String to be verified: " + string6);
                }
                return fSSignatureManager.verifySignature(string6, byArray, string4, string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by POST ");
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            int n = fSAuthnRequest.getMinorVersion();
            if (n == 0) {
                return xMLSignatureManager.verifyXMLSignature(fSAuthnRequest.getSignedXMLString(), "id", string);
            }
            if (n == 2) {
                return xMLSignatureManager.verifyXMLSignature(fSAuthnRequest.getSignedXMLString(), "RequestID", string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.verifyRequestSignature: Exception occured while verifying SP's signature:" + exception.getMessage());
            return false;
        }
    }

    public static String cleanMetaAlias(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: Called");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("metaAlias")) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: found metaAlias");
                continue;
            }
            String string3 = httpServletRequest.getParameter(string2);
            string = string == null || string.length() < 1 ? string2 + "=" + AMURLEncDec.encode((String)string3) : string + "&" + string2 + "=" + AMURLEncDec.encode((String)string3);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias:  returning with " + string);
        }
        return string;
    }

    protected void sendProxyAuthnRequest(FSAuthnRequest fSAuthnRequest, String string) throws FSException, IOException {
        CharSequence charSequence;
        FSAuthnRequest fSAuthnRequest2 = this.getNewAuthnRequest(fSAuthnRequest);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.sendProxyAuthnRequest:New Authentication request:" + fSAuthnRequest2.toXMLString());
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostEntityId);
        String string2 = fSAuthnRequest2.getRequestID();
        fSSessionManager.setAuthnRequest(string2, fSAuthnRequest2);
        fSSessionManager.setProxySPDescriptor(string2, this.spDescriptor);
        fSSessionManager.setProxySPAuthnRequest(string2, fSAuthnRequest);
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string);
        fSSessionManager.setProviderDescriptor(string2, fSProviderDescriptor);
        String string3 = fSProviderDescriptor.getSSOServiceURL();
        if (string3 == null) {
            FSUtils.debug.error("FSSSOAndFedHandler.sendProxyAuthnRequest: Single Sign-on service is not found for the proxying IDP");
            return;
        }
        String string4 = fSAuthnRequest2.toURLEncodedQueryString();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(this.hostProviderId);
        if (FSServiceUtils.isSigningOn()) {
            charSequence = fSHostedProviderDescriptor.getSigningKeyAlias();
            boolean bl = fSHostedProviderDescriptor.getAuthnRequestSigned();
            if (bl) {
                string4 = FSSignatureUtil.signAndReturnQueryString(string4, (String)charSequence);
            }
        }
        charSequence = new StringBuffer(1000);
        if (string3.indexOf("?") != -1) {
            ((StringBuffer)charSequence).append(string3).append("&").append(string4);
        } else {
            ((StringBuffer)charSequence).append(string3).append("?").append(string4);
        }
        String string5 = ((StringBuffer)charSequence).toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.sendProxyAuthnRequest:SSO URL to be redirected" + string5);
        }
        this.response.setStatus(302);
        this.response.setHeader("Location", string5);
        this.response.sendRedirect(string5);
    }

    protected boolean isIDPProxyEnabled(FSAuthnRequest fSAuthnRequest) throws FSException {
        if (fSAuthnRequest.getMinorVersion() != 2) {
            return false;
        }
        FSScoping fSScoping = fSAuthnRequest.getScoping();
        if (fSScoping != null && fSScoping.getProxyCount() == 0) {
            return false;
        }
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId());
        return fSProviderDescriptor.getProxyEnabled();
    }

    private String getPreferredIDP(FSAuthnRequest fSAuthnRequest) throws FSRedirectException {
        return proxyFinder.getPreferredIDP(fSAuthnRequest, this.hostProviderId, this.request, this.response);
    }

    private FSAuthnRequest getNewAuthnRequest(FSAuthnRequest fSAuthnRequest) throws FSException {
        try {
            int n;
            FSAuthnRequest fSAuthnRequest2 = new FSAuthnRequest(null, fSAuthnRequest.getRespondWith(), null, this.hostEntityId, fSAuthnRequest.getForceAuthn(), fSAuthnRequest.getIsPassive(), false, fSAuthnRequest.getNameIDPolicy(), fSAuthnRequest.getProtocolProfile(), fSAuthnRequest.getAuthnContext(), fSAuthnRequest.getRelayState(), fSAuthnRequest.getAuthContextCompType());
            fSAuthnRequest2.setMinorVersion(2);
            FSScoping fSScoping = fSAuthnRequest.getScoping();
            if (fSScoping != null && (n = fSScoping.getProxyCount()) > 0) {
                FSScoping fSScoping2 = new FSScoping();
                fSScoping2.setProxyCount(n - 1);
                fSScoping2.setIDPList(fSScoping.getIDPList());
                fSAuthnRequest2.setScoping(fSScoping2);
            }
            return fSAuthnRequest2;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.getNewAuthnRequest:Error in creating new authn request.", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    static {
        try {
            String string = SystemProperties.get((String)"com.sun.identity.federation.proxyfinder");
            Class<?> clazz = Class.forName(string);
            proxyFinder = (FSIDPProxy)clazz.newInstance();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler:Static Init Failed", (Throwable)exception);
        }
    }
}

