/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSRequestCleanUpThread;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionMapStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FSSessionManager {
    private static final String REQUEST_CLEANUP_INTERVAL = "com.sun.identity.federation.request.cleanup_interval";
    private static final long DEFAULT_REQUEST_CLEANUP_INTERVAL = 300000L;
    private static final String REQUEST_TIMEOUT = "com.sun.identity.federation.request.timeout";
    private static final long DEFAULT_REQUEST_TIMEOUT = 300000L;
    private static Map instanceMap;
    private Map userDNSessionListMap = Collections.synchronizedMap(new HashMap());
    private Map idAuthnRequestMap = Collections.synchronizedMap(new HashMap());
    private Map idAuthnRequestTimeoutMap = Collections.synchronizedMap(new HashMap());
    private Map idLocalSSOTokenMap = Collections.synchronizedMap(new HashMap());
    private Map idDestnMap = Collections.synchronizedMap(new HashMap());
    private String hostProviderId = null;
    private Map relayStateMap = Collections.synchronizedMap(new HashMap());
    private Map proxySPDescMap = Collections.synchronizedMap(new HashMap());
    private Map proxySPAuthnReqMap = Collections.synchronizedMap(new HashMap());
    private static long cleanupInterval;
    private static long requestTimeout;
    private Thread cThread = null;
    public static Stats sessStats;
    private FSSessionMapStats dnStats;
    private FSSessionMapStats reqStats;
    private FSSessionMapStats reqTimeoutStats;
    private FSSessionMapStats tokenStats;
    private FSSessionMapStats idStats;
    private FSSessionMapStats relayStats;

    public String getRelayState(String string) {
        return (String)this.relayStateMap.get(string);
    }

    public void setRelayState(String string, String string2) {
        this.relayStateMap.put(string, string2);
    }

    public void removeRelayState(String string) {
        this.relayStateMap.remove(string);
    }

    public FSAuthnRequest getAuthnRequest(String string) {
        FSUtils.debug.message("FSSessionManager.getAuthnRequest: Called");
        return (FSAuthnRequest)this.idAuthnRequestMap.get(string);
    }

    public void setAuthnRequest(String string, FSAuthnRequest fSAuthnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.setAuthnRequest: Called, ID=" + string);
        }
        this.removeAuthnRequest(string);
        this.idAuthnRequestMap.put(string, fSAuthnRequest);
        if (this.cThread != null) {
            this.idAuthnRequestTimeoutMap.put(string, new Long(System.currentTimeMillis() + requestTimeout));
        }
    }

    public void removeAuthnRequest(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.removeAuthnRequest: Called, ID=" + string);
        }
        this.idAuthnRequestMap.remove(string);
        this.idDestnMap.remove(string);
        if (this.cThread != null) {
            this.idAuthnRequestTimeoutMap.remove(string);
        }
    }

    public SSOToken getLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.getLocalSSOToken: Called");
        return (SSOToken)this.idLocalSSOTokenMap.get(string);
    }

    public void setLocalSSOToken(String string, SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.setLocalSSOToken: Called");
        this.idLocalSSOTokenMap.put(string, sSOToken);
    }

    public void removeLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.removeLocalSSOToken: Called");
        this.idLocalSSOTokenMap.remove(string);
    }

    public FSProviderDescriptor getProviderDescriptor(String string) {
        FSUtils.debug.message("FSSessionManager.getProviderDescriptor: Called");
        return (FSProviderDescriptor)this.idDestnMap.get(string);
    }

    public void setProviderDescriptor(String string, FSProviderDescriptor fSProviderDescriptor) {
        FSUtils.debug.message("FSSessionManager.setProviderDescriptor:Called");
        this.idDestnMap.put(string, fSProviderDescriptor);
    }

    public void setProxySPDescriptor(String string, FSProviderDescriptor fSProviderDescriptor) {
        this.proxySPDescMap.put(string, fSProviderDescriptor);
    }

    public FSProviderDescriptor getProxySPDescriptor(String string) {
        return (FSProviderDescriptor)this.proxySPDescMap.get(string);
    }

    public FSAuthnRequest getProxySPAuthnRequest(String string) {
        return (FSAuthnRequest)this.proxySPAuthnReqMap.get(string);
    }

    public void setProxySPAuthnRequest(String string, FSAuthnRequest fSAuthnRequest) {
        this.proxySPAuthnReqMap.put(string, fSAuthnRequest);
    }

    public List getSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.getSessionList: Called");
        string = string.toLowerCase();
        return (List)this.userDNSessionListMap.get(string);
    }

    public void setSessionList(String string, List list) {
        FSUtils.debug.message("FSSessionManager.setSessionList: Called");
        string = string.toLowerCase();
        this.userDNSessionListMap.put(string, list);
    }

    public void removeSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.removeSessionList: Called ");
        string = string.toLowerCase();
        this.userDNSessionListMap.remove(string);
    }

    public FSSession getSession(String string, String string2) {
        FSUtils.debug.message("FSSessionManager.getSession: Called ");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (!fSSession.isEquals(string2)) continue;
                    FSSession fSSession2 = fSSession;
                    return fSSession2;
                }
            }
        }
        return null;
    }

    public FSSession getSession(List list, String string) {
        FSUtils.debug.message("FSSessionManager.getSession(sessionIndex):");
        if (list == null || string == null) {
            FSUtils.debug.error("FSSessionManager.getSession(sessionIndex):sessions or sessionIndex is null");
            return null;
        }
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FSSession fSSession = (FSSession)iterator.next();
                String string2 = fSSession.getSessionIndex();
                if (string2 == null || !string2.equals(string)) continue;
                FSSession fSSession2 = fSSession;
                return fSSession2;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.getSession(sessionIndex):No session found for the given session index.");
        }
        return null;
    }

    public FSSession getSession(SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        if (sSOToken == null) {
            return null;
        }
        try {
            String string = sSOToken.getProperty("sun.am.UniversalIdentifier");
            String string2 = sSOToken.getTokenID().toString();
            return this.getSession(string, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSessionManager.getSession(token) : " + sSOToken.getTokenID().toString(), (Throwable)exception);
            return null;
        }
    }

    public void removeProvider(String string, String string2, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.removeProvider: Called ");
        if (fSSession != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.removeProvider: localSession is not null");
            }
            fSSession.removeSessionPartner(string2);
            return;
        }
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession2 = (FSSession)iterator.next();
                    if (fSSession2 == null) continue;
                    FSUtils.debug.message("removeSessionPartner" + string2);
                    fSSession2.removeSessionPartner(string2);
                }
            }
        }
    }

    public void removeSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.removeSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession2 = (FSSession)iterator.next();
                    if (!fSSession2.equals(fSSession)) continue;
                    list.remove(fSSession2);
                    break;
                }
            }
            if (list.isEmpty()) {
                this.removeSessionList(string);
            }
        }
    }

    public void addSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.addSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession2 = (FSSession)iterator.next();
                    if (!fSSession2.equals(fSSession)) continue;
                    return;
                }
                list.add(fSSession);
                return;
            }
        }
        ArrayList<FSSession> arrayList = new ArrayList<FSSession>();
        arrayList.add(fSSession);
        this.setSessionList(string, arrayList);
    }

    private FSSessionManager(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager(): created " + string);
        }
        this.hostProviderId = string;
        if (sessStats.isEnabled()) {
            this.dnStats = new FSSessionMapStats(this.userDNSessionListMap, "userDNSessionListMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.dnStats);
            this.reqStats = new FSSessionMapStats(this.idAuthnRequestMap, "idAuthnRequestMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.reqStats);
            this.reqTimeoutStats = new FSSessionMapStats(this.idAuthnRequestTimeoutMap, "idAuthnRequestTimeoutMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.reqTimeoutStats);
            this.tokenStats = new FSSessionMapStats(this.idLocalSSOTokenMap, "idLocalSSOTokenMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.tokenStats);
            this.idStats = new FSSessionMapStats(this.idDestnMap, "idDestnMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.idStats);
            this.relayStats = new FSSessionMapStats(this.relayStateMap, "relayStateMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.relayStats);
        }
        if (cleanupInterval != 0L && requestTimeout != 0L && WebtopNaming.isServerMode()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.getInstance: start cleanup thread for " + string);
            }
            this.cThread = new FSRequestCleanUpThread(string, this.idAuthnRequestTimeoutMap, this.idAuthnRequestMap, this.idDestnMap, cleanupInterval);
            this.cThread.setDaemon(true);
            this.cThread.start();
        }
    }

    public static synchronized FSSessionManager getInstance(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.getInstance: Called " + string);
        }
        if (string == null) {
            FSUtils.debug.error("FSSessionManager.getInstance: null provider ID");
            return null;
        }
        FSSessionManager fSSessionManager = (FSSessionManager)instanceMap.get(string);
        if (fSSessionManager == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.getInstance: new instance of FSSessionManager: " + string);
            }
            fSSessionManager = new FSSessionManager(string);
            Map map = instanceMap;
            synchronized (map) {
                instanceMap.put(string, fSSessionManager);
            }
        }
        return fSSessionManager;
    }

    static {
        String string;
        instanceMap = new HashMap();
        cleanupInterval = 0L;
        requestTimeout = 0L;
        sessStats = Stats.getInstance((String)"amFedSessionMaps");
        try {
            string = SystemProperties.get((String)REQUEST_CLEANUP_INTERVAL);
            cleanupInterval = string == null || string.trim().equals("") ? 300000L : (long)(Integer.parseInt(string) * 1000);
        }
        catch (Exception exception) {
            FSUtils.debug.message("Unable to get fed request cleanup prop.", (Throwable)exception);
            cleanupInterval = 300000L;
        }
        try {
            string = SystemProperties.get((String)REQUEST_TIMEOUT);
            requestTimeout = string == null || string.trim().equals("") ? 300000L : (long)(Integer.parseInt(string) * 1000);
        }
        catch (Exception exception) {
            FSUtils.debug.message("Unable to get fed request timeout prop.", (Throwable)exception);
            requestTimeout = 300000L;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager, cleanup interval=" + cleanupInterval + " ms, timeout=" + requestTimeout + " ms");
        }
    }
}

