/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.sso.IdentityToken;
import com.sun.identity.saml.assertion.AttributeStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FSSession {
    private List sessionPartners = new ArrayList();
    private String sessionID = null;
    private String sessionIndex = null;
    private Map extraSessionAtributes = null;
    private IdentityToken appToken = null;
    private String authnContext = null;
    private AttributeStatement statement = null;
    private NodeList resourceOfferings = null;
    private List securityAssertions = null;
    private boolean oneTimeFederation = false;
    private FSAccountFedInfo fedInfo = null;
    private String userDN = null;
    private List attrStatements = null;
    private AttributeStatement _autoFedStatement = null;

    public FSSession(String string, List list) {
        this.sessionID = string;
        if (list != null) {
            this.sessionPartners = list;
        }
    }

    public FSSession(String string) {
        this.sessionID = string;
    }

    public String getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(String string) {
        this.authnContext = string;
    }

    public IdentityToken getIdentityToken() {
        return this.appToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.appToken = identityToken;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String string) {
        this.sessionIndex = string;
    }

    public List getSessionPartners() {
        return this.sessionPartners;
    }

    public void addSessionPartner(FSSessionPartner fSSessionPartner) {
        Iterator iterator = this.sessionPartners.iterator();
        while (iterator.hasNext()) {
            if (!((FSSessionPartner)iterator.next()).equals(fSSessionPartner)) continue;
            return;
        }
        this.sessionPartners.add(fSSessionPartner);
    }

    public FSSessionPartner getCurrentSessionPartner() {
        Iterator iterator = this.sessionPartners.iterator();
        if (iterator.hasNext()) {
            return (FSSessionPartner)iterator.next();
        }
        return null;
    }

    public void removeSessionPartner(String string) {
        Iterator iterator = this.sessionPartners.iterator();
        while (iterator.hasNext()) {
            FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator.next();
            if (!fSSessionPartner.isEquals(string)) continue;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSession.removeSessionPartner : Removing " + string);
            }
            iterator.remove();
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void addAttribute(String string, String string2) {
        this.extraSessionAtributes.put(string, string2);
    }

    public String getAttribute(String string) {
        return (String)this.extraSessionAtributes.get(string);
    }

    boolean isEquals(String string) {
        return this.sessionID.equals(string);
    }

    boolean equals(FSSession fSSession) {
        return this.sessionID.equals(fSSession.sessionID);
    }

    public void setBootStrapAttributeStatement(AttributeStatement attributeStatement) {
        this.statement = attributeStatement;
        try {
            Document document = XMLUtils.toDOMDocument((String)attributeStatement.toString(true, true), (Debug)FSUtils.debug);
            Element element = document.getDocumentElement();
            this.resourceOfferings = element.getElementsByTagNameNS("urn:liberty:disco:2003-08", "ResourceOffering");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSession.setBootStrapAttributeStatementCan not parse the attribute statement:", (Throwable)exception);
        }
    }

    public AttributeStatement getBootStrapAttributeStatement() {
        return this.statement;
    }

    public NodeList getBootStrapResourceOfferings() {
        return this.resourceOfferings;
    }

    public void setBootStrapCredential(List list) {
        this.securityAssertions = list;
    }

    public List getBootStrapCredential() {
        return this.securityAssertions;
    }

    public void setAutoFedStatement(AttributeStatement attributeStatement) {
        this._autoFedStatement = attributeStatement;
    }

    public AttributeStatement getAutoFedStatement() {
        return this._autoFedStatement;
    }

    public void setAttributeStatements(List list) {
        this.attrStatements = list;
    }

    public List getAttributeStatements() {
        return this.attrStatements;
    }

    public void setOneTime(boolean bl) {
        this.oneTimeFederation = bl;
    }

    public boolean getOneTime() {
        return this.oneTimeFederation;
    }

    public void setAccountFedInfo(FSAccountFedInfo fSAccountFedInfo) {
        this.fedInfo = fSAccountFedInfo;
    }

    public FSAccountFedInfo getAccountFedInfo() {
        return this.fedInfo;
    }

    public void setUserDN(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSEssion.setUserDN : " + string);
        }
        this.userDN = string;
    }

    public String getUserDN() {
        return this.userDN;
    }
}

