/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSIDPProxy;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSIDPProxyImpl
implements FSIDPProxy {
    public String getPreferredIDP(FSAuthnRequest fSAuthnRequest, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FSRedirectException {
        FSUtils.debug.message("FSIDPProxyImpl.getPreferredIDP:Init");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId(), "SP");
            if (fSProviderDescriptor == null) {
                fSProviderDescriptor = fSAllianceManager.getProvider(fSAuthnRequest.getProviderId());
            }
            if (!fSProviderDescriptor.isIntroductionForProxying()) {
                Set set = fSProviderDescriptor.getProxyIDPs();
                if (set == null || set.isEmpty()) {
                    FSUtils.debug.error("FSIDPProxyImpl.getPrefferedIDP:Preferred IDPs are null.");
                    return null;
                }
                return (String)set.iterator().next();
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            String string2 = FSServiceUtils.getBaseURL(httpServletRequest);
            stringBuffer.append(string2).append("/idpfinder").append("?").append("RequestID=").append(fSAuthnRequest.getRequestID()).append("&").append("ProviderID=").append(string);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, stringBuffer.toString());
            throw new FSRedirectException(FSUtils.bundle.getString("Redirection_Happened"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSIDPProxyImpl.getPreferredIDP: Exception in retrieving the preferred IDP", (Throwable)((Object)fSAllianceManagementException));
            return null;
        }
    }
}

