/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRemoteException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAssertionManagerIF;
import com.sun.identity.federation.services.FSAssertionManagerImpl;
import com.sun.identity.federation.services.FSAssertionManagerService_Impl;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.Stub;

public final class FSAssertionManagerClient {
    private static String SERVICE_NAME = "fsassertionmanager";
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;
    private String hostedProviderId;
    private static FSAssertionManagerIF remoteStub;
    private static FSAssertionManager assertionManager;
    private FSAssertionManagerIF stub;

    public FSAssertionManagerClient(String string) throws FSException {
        if (!checkedForLocal) {
            try {
                this.hostedProviderId = string;
                FSAssertionManagerIF fSAssertionManagerIF = FSAssertionManagerClient.getServiceEndPoint(SystemProperties.get((String)"com.iplanet.am.server.protocol"), InetAddress.getLocalHost().getHostName(), SystemProperties.get((String)"com.iplanet.am.server.port"));
                fSAssertionManagerIF.checkForLocal();
                if (FSAssertionManagerImpl.isLocal) {
                    isLocal = true;
                    assertionManager = FSAssertionManager.getInstance(string);
                }
                checkedForLocal = true;
            }
            catch (URLNotFoundException uRLNotFoundException) {
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("AMC: No SAML service locally.", (Throwable)uRLNotFoundException);
                }
                try {
                    URL uRL = new URL(WebtopNaming.getServerFromID((String)"01"));
                    remoteStub = FSAssertionManagerClient.getServiceEndPoint(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("AMC(): Using the remote URL: " + uRL.toString());
                    }
                }
                catch (Exception exception) {
                    if (FSUtils.debug.warningEnabled()) {
                        FSUtils.debug.warning("AMC(): Unable to find remote server", (Throwable)exception);
                    }
                    throw new FSException(exception.getMessage());
                }
                checkedForLocal = true;
            }
            catch (Exception exception) {
                checkedForLocal = true;
                if (FSUtils.debug.warningEnabled()) {
                    FSUtils.debug.warning("AssertionManagerClient()Exception", (Throwable)exception);
                }
                throw new FSException(exception.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
        }
    }

    public FSAssertionManagerClient(String string, String string2) throws FSException {
        try {
            this.hostedProviderId = string;
            Stub stub = (Stub)new FSAssertionManagerService_Impl().getFSAssertionManagerIFPort();
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string2);
            this.stub = (FSAssertionManagerIF)stub;
        }
        catch (Exception exception) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSAssertionManagerClient() Exception", (Throwable)exception);
            }
            throw new FSException(exception.getMessage());
        }
    }

    private static FSAssertionManagerIF getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL((String)SERVICE_NAME, (String)string, (String)string2, (String)string3);
        String string4 = uRL.toString();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManagerClient with URL: " + string4);
        }
        Stub stub = (Stub)new FSAssertionManagerService_Impl().getFSAssertionManagerIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string4);
        return (FSAssertionManagerIF)stub;
    }

    protected Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws FSException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionArtifact, string);
        }
        String string2 = null;
        try {
            string2 = this.stub.getAssertion(this.hostedProviderId, assertionArtifact.getAssertionArtifact(), Base64.encode((byte[])SAMLUtils.stringToByteArray(string)));
            if (string2 == null && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:getAssertion(" + assertionArtifact + ", " + string + "): Server returned NULL");
            } else if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: asserion:" + string2);
            }
            return string2 == null ? null : new FSAssertion(XMLUtils.toDOMDocument((String)string2, (Debug)FSUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + assertionArtifact, (Throwable)remoteException);
            }
            throw new FSException(remoteException.getMessage());
        }
        catch (FSRemoteException fSRemoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + assertionArtifact, (Throwable)fSRemoteException);
            }
            throw new FSException(fSRemoteException.getMessage());
        }
        catch (SAMLException sAMLException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getAssertion: " + assertionArtifact, (Throwable)sAMLException);
            }
            throw new FSException(sAMLException.getMessage());
        }
    }

    protected String getDestIdForArtifact(AssertionArtifact assertionArtifact) throws FSException {
        if (this.useLocal) {
            return assertionManager.getDestIdForArtifact(assertionArtifact);
        }
        String string = null;
        try {
            string = this.stub.getDestIdForArtifact(this.hostedProviderId, assertionArtifact.getAssertionArtifact());
            if (string == null && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:getDestIdForArtifact(" + assertionArtifact + "): Server returned NULL");
            }
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: returning" + string);
            }
            return string;
        }
        catch (RemoteException remoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: " + assertionArtifact, (Throwable)remoteException);
            }
            throw new FSException(remoteException.getMessage());
        }
        catch (FSRemoteException fSRemoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:getDestIdForArtifact: " + assertionArtifact, (Throwable)fSRemoteException);
            }
            throw new FSException(fSRemoteException.getMessage());
        }
    }

    public boolean isUserExists(String string, String string2) throws FSException {
        try {
            boolean bl = this.stub.isUserExists(string, string2);
            if (!bl && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC:isUserExists(" + string + ")" + " returned false.");
            }
            return this.stub.isUserExists(string, string2);
        }
        catch (RemoteException remoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:isUserExists: " + string);
            }
            throw new FSException(remoteException.getMessage());
        }
        catch (FSRemoteException fSRemoteException) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("AMC:isUserExists: " + string);
            }
            throw new FSException(fSRemoteException.getMessage());
        }
    }
}

