/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSArtifactStats;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSAssertionStats;
import com.sun.identity.federation.services.FSAttributePlugin;
import com.sun.identity.federation.services.FSDiscoveryBootStrap;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSAttributeStatementHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class FSAssertionManager {
    private static final Integer DEFAULT_CLEANUP_INTERVAL = new Integer(180);
    private static final Integer DEFAULT_ASSERTION_TIMEOUT = new Integer(60);
    private static Map instanceMap = new HashMap();
    private Map artIdMap = null;
    private Map idEntryMap = new HashMap();
    private static String SERVICE_NAMING = "fsassertionmanager";
    public static Stats artStats = Stats.getInstance((String)"amFedArtifactMap");
    public static Stats assrtStats = Stats.getInstance((String)"amFedAssertionMap");
    private FSArtifactStats artIdStats;
    private FSAssertionStats assrtIdStats;
    private static Thread cThread = null;
    private String hostProviderId = null;
    private String hostEntityId = null;

    private FSAssertionManager(String string) {
        this.artIdMap = new HashMap();
        this.hostEntityId = string;
        if (assrtStats.isEnabled()) {
            this.assrtIdStats = new FSAssertionStats(this.idEntryMap, string);
            assrtStats.addStatsListener((StatsListener)this.assrtIdStats);
            this.artIdStats = new FSArtifactStats(this.artIdMap, string);
            artStats.addStatsListener((StatsListener)this.artIdStats);
        }
        if (cThread == null) {
            cThread = new CleanUpThread();
            cThread.start();
        }
    }

    public String getProviderId() {
        return this.hostProviderId;
    }

    public void setProviderId(String string) {
        this.hostProviderId = string;
    }

    public String getEntityId() {
        return this.hostEntityId;
    }

    public void setEntityId(String string) {
        this.hostEntityId = string;
    }

    public Map getArtIdMap() {
        return this.artIdMap;
    }

    public Map getIdEntryMap() {
        return this.idEntryMap;
    }

    public static synchronized FSAssertionManager getInstance(String string) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getInstance: Called");
        FSAssertionManager fSAssertionManager = (FSAssertionManager)instanceMap.get(string);
        if (fSAssertionManager == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getInstance: Constructing a new instance of FSAssertionManager");
            }
            fSAssertionManager = new FSAssertionManager(string);
            Map map = instanceMap;
            synchronized (map) {
                instanceMap.put(string, fSAssertionManager);
            }
        }
        return fSAssertionManager;
    }

    public AssertionArtifact createFSAssertionArtifact(String string, FSProviderDescriptor fSProviderDescriptor, String string2, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, String string3, int n) throws FSException, SAMLException {
        if (string == null || fSProviderDescriptor == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
            }
            throw new FSException("nullInput", null);
        }
        String string4 = fSProviderDescriptor.getProviderID();
        String string5 = SAMLUtils.generateAssertionHandle();
        if (string5 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertionArtifact: couldn't generate assertion handle.");
            }
            throw new FSException("errorCreateArtifact", null);
        }
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(string2);
        String string6 = fSHostedProviderDescriptor.getProviderSuccinctID();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createFSAssertionArt: SourceID for the Artifact: " + string6);
        }
        byte[] byArray = FSUtils.hexStringToByteArray(string6);
        byte[] byArray2 = null;
        try {
            byArray2 = string5.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionManager.createFSAssertionArt: " + exception.getMessage());
            return null;
        }
        FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(byArray, byArray2);
        int n2 = 0;
        if (n == 2) {
            n2 = 2;
        }
        FSAssertion fSAssertion = this.createFSAssertion(string, fSAssertionArtifact, fSProviderDescriptor, string2, nameIdentifier, nameIdentifier2, string3, n2);
        return fSAssertionArtifact;
    }

    public FSAssertion createFSAssertion(String string, AssertionArtifact assertionArtifact, FSProviderDescriptor fSProviderDescriptor, String string2, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, String string3, int n) throws FSException, SAMLException {
        Object object;
        int n2;
        Object object2;
        Object object3;
        FSAttributePlugin fSAttributePlugin;
        Object object4;
        Object object5;
        Object object6;
        long l;
        Comparable<Integer> comparable;
        Object object7;
        Object object8;
        Object object9;
        String string4;
        Object object10;
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
        FSAllianceManager fSAllianceManager;
        FSSessionManager fSSessionManager;
        SubjectLocality subjectLocality;
        String string5;
        SSOToken sSOToken;
        String string6;
        Date date;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        block74: {
            FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): Called");
            if (string == null || fSProviderDescriptor == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
                }
                throw new FSException("nullInput", null);
            }
            string11 = fSProviderDescriptor.getEntityID();
            string10 = null;
            string9 = null;
            string8 = null;
            string7 = null;
            date = null;
            string6 = null;
            Object var16_16 = null;
            sSOToken = null;
            string5 = null;
            subjectLocality = null;
            fSSessionManager = FSSessionManager.getInstance(FSUtils.getEntityID(this.hostProviderId));
            fSAllianceManager = FSServiceUtils.getAllianceInstance();
            fSLocalConfigurationDescriptor = null;
            try {
                object10 = SSOTokenManager.getInstance();
                sSOToken = object10.createSSOToken(string);
                string4 = sSOToken.getProperty("authInstant");
                if (string4 != null) {
                    try {
                        date = DateUtils.stringToDate((String)string4);
                    }
                    catch (ParseException parseException) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthInstant not foundin the Token");
                        }
                    }
                } else {
                    date = new Date();
                }
                string9 = sSOToken.getAuthType();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthInstant = " + date);
                }
                object9 = fSAllianceManager.getHostedProvider(string2);
                fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)object9).getLocalConfiguration();
                string10 = ((FSProviderDescriptor)object9).getEntityID();
                object8 = fSLocalConfigurationDescriptor.getAssertionIssuer();
                if (object8 == null) {
                    object8 = SystemProperties.get((String)"com.iplanet.am.server.host");
                }
                try {
                    object7 = InetAddress.getByName((String)object8).getHostAddress();
                    subjectLocality = new SubjectLocality((String)object7, (String)object8);
                }
                catch (UnknownHostException unknownHostException) {
                    FSUtils.debug.error("FSAssertionManager.constructor: couldn't obtain the localhost's ipaddress:", (Throwable)unknownHostException);
                }
                try {
                    object7 = fSSessionManager.getSession(sSOToken);
                    string8 = string7 = ((FSSession)object7).getAuthnContext();
                }
                catch (Exception exception) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
                    }
                    string8 = null;
                }
                if (string8 == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
                    }
                    string9 = SAMLServiceManager.getAuthMethodURI(string9);
                } else {
                    string9 = n == 0 ? "http://projectliberty.org/schemas/authctx/2002/05" : "urn:liberty:ac:2003-08";
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthnContextStatement used for authenticating the user: " + string8);
                }
                string5 = sSOToken.getProperty("sun.am.UniversalIdentifier");
                if (string2 != null) {
                    string6 = string2;
                    break block74;
                }
                FSUtils.debug.error("FSAssertionManager.createAssertion(id): Alliance manager could not find local descriptor");
                throw new FSException("alliance_manager_no_local_descriptor", null);
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionManager.createAssertion(id): exception retrieving info from the SSOToken: ", (Throwable)exception);
                throw new FSException("alliance_manager_no_local_descriptor", null, exception);
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Creating Authentication Assertion for user withopaqueHandle= " + nameIdentifier.getName() + " And SecurityDomain= " + string6);
        }
        object10 = null;
        string4 = null;
        if (assertionArtifact != null) {
            string4 = assertionArtifact.getAssertionArtifact();
            object10 = n == 0 ? new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:artifact-01") : new SubjectConfirmation(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT);
            ((SubjectConfirmation)object10).setSubjectConfirmationData(string4);
        } else {
            object10 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        }
        object9 = null;
        if (n == 2 || n == 2) {
            object9 = new IDPProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), nameIdentifier.getFormat());
            ((IDPProvidedNameIdentifier)object9).setMinorVersion(2);
        } else {
            object9 = new IDPProvidedNameIdentifier(nameIdentifier2.getNameQualifier(), nameIdentifier2.getName());
        }
        object8 = new FSSubject(nameIdentifier, (SubjectConfirmation)object10, (IDPProvidedNameIdentifier)object9);
        object7 = new AuthnContext(string7, string8);
        ((AuthnContext)object7).setMinorVersion(n);
        FSAuthenticationStatement fSAuthenticationStatement = new FSAuthenticationStatement(string9, date, (Subject)object8, subjectLocality, null, (AuthnContext)object7);
        FSSession fSSession = fSSessionManager.getSession(string5, string);
        if (fSSession == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): AssertionManager could not find a valid Session forunivId: " + string5 + " SessionID: " + string);
            }
            return null;
        }
        String string12 = fSSession.getSessionIndex();
        if (string12 == null) {
            string12 = SAMLUtilsCommon.generateID();
            fSSession.setSessionIndex(string12);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): SessionIndex: " + string12);
        }
        fSAuthenticationStatement.setSessionIndex(string12);
        Date date2 = new Date();
        if (assertionArtifact != null) {
            try {
                comparable = new Integer(fSLocalConfigurationDescriptor.getArtifactTimeout());
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createAssertion(id): AtrifactTimeOut configuration not found in FSConfig. Using Default");
                }
                comparable = null;
            }
            if (comparable == null) {
                comparable = new Integer(120);
            }
            l = comparable * 1000;
        } else {
            try {
                comparable = new Integer(fSLocalConfigurationDescriptor.getAssertionInterval());
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createAssertion(id): AtrifactTimeOut configuration not found in FSConfig. Using Default");
                }
                comparable = null;
            }
            if (comparable == null) {
                comparable = new Integer(60);
            }
            FSUtils.debug.message("here before assertion time");
            l = comparable * 1000;
            if (l < 60000L) {
                l = 60000L;
            }
            FSUtils.debug.message("here after assertion time");
        }
        FSUtils.debug.message("here before date");
        comparable = new Date(date2.getTime() + l);
        FSUtils.debug.message("here after date");
        fSAuthenticationStatement.setReauthenticateOnOrAfter((Date)comparable);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + fSAuthenticationStatement.toXMLString());
        }
        Conditions conditions = new Conditions(null, (Date)comparable);
        if (string11 != null && !string11.equals("")) {
            object6 = new ArrayList<String>();
            object6.add(string11);
            conditions.addAudienceRestrictionCondition(new AudienceRestrictionCondition((List)object6));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + fSAuthenticationStatement.toXMLString());
        }
        object6 = null;
        Advice advice = null;
        if (n != 0 && fSAllianceManager.getProvider(string2).getGenerateBootstrappingResourceOffering()) {
            object5 = new AuthnContext(null, string8);
            ((AuthnContext)object5).setMinorVersion(2);
            try {
                object4 = new FSDiscoveryBootStrap(sSOToken, (AuthnContext)object5, (FSSubject)object8, string5, string11);
                object6 = ((FSDiscoveryBootStrap)object4).getBootStrapStatement();
                if (((FSDiscoveryBootStrap)object4).hasCredentials()) {
                    advice = ((FSDiscoveryBootStrap)object4).getCredentials();
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionManager.createAssertion(id):exception when generating bootstrapping resource offering:", (Throwable)exception);
            }
        }
        object5 = new AssertionIDReference();
        object4 = new HashSet<Object>();
        object4.add(fSAuthenticationStatement);
        if (object6 != null) {
            object4.add(object6);
        }
        if ((fSAttributePlugin = fSLocalConfigurationDescriptor.getAttributePlugin()) != null && (object3 = fSAttributePlugin.getAttributeStatements(this.hostProviderId, string11, (FSSubject)object8, sSOToken)) != null && object3.size() != 0) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object4.add((AttributeStatement)object2.next());
            }
        }
        if (fSLocalConfigurationDescriptor.isAutoFedEnabled()) {
            object3 = FSAttributeStatementHelper.getAutoFedAttributeStatement(this.hostProviderId, (FSSubject)object8, sSOToken);
            object4.add(object3);
        }
        object3 = new FSAssertion(((AssertionIDReference)object5).getAssertionIDReference(), string10, date2, conditions, advice, (Set)object4, string3);
        ((FSAssertion)object3).setMinorVersion(n);
        ((FSAssertion)object3).setID(((AssertionIDReference)object5).getAssertionIDReference());
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion created successfully: " + ((FSAssertion)object3).toXMLString());
        }
        object2 = ((AssertionBase)object3).getAssertionID();
        Entry entry = new Entry((Assertion)object3, string11, string4, sSOToken);
        Integer n3 = null;
        try {
            n3 = new Integer(fSLocalConfigurationDescriptor.getAssertionLimit());
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion MAX number configuration not found in FSConfig.Using Default");
            }
            n3 = null;
        }
        if (n3 == null) {
            n3 = new Integer(10);
        }
        if ((n2 = n3.intValue()) != 0 && this.idEntryMap.size() > n2) {
            FSUtils.debug.error("FSAssertionManager.createAssertion: reached maxNumber of assertions.");
            throw new FSException("errorCreateAssertion", null);
        }
        try {
            object = this.idEntryMap;
            synchronized (object) {
                this.idEntryMap.put(object2, entry);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: couldn't add to idEntryMap." + exception.getMessage());
            }
            throw new FSException("errorCreateAssertion", null);
        }
        if (LogUtil.isAccessLoggable(Level.FINER)) {
            object = new String[]{((AssertionBase)object3).toString()};
            LogUtil.access(Level.FINER, "CREATE_ASSERTION", object);
        } else {
            object = new String[]{((AssertionBase)object3).getAssertionID()};
            LogUtil.access(Level.INFO, "CREATE_ASSERTION", object);
        }
        if (string4 != null) {
            try {
                object = this.artIdMap;
                synchronized (object) {
                    this.artIdMap.put(string4, object2);
                }
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager: couldn't add artifact to the artIdMap.", (Throwable)exception);
                }
                throw new FSException("errorCreateArtifact", null);
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Returning Assertion: " + ((FSAssertion)object3).toXMLString());
        }
        return object3;
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws FSException {
        if (assertionArtifact == null || string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: input is null.");
            }
            throw new FSException("nullInput", null);
        }
        String string2 = assertionArtifact.getAssertionArtifact();
        String string3 = SAMLUtils.getServerURL(assertionArtifact.getAssertionHandle());
        if (string3 != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + string3);
            }
            FSAssertionManagerClient fSAssertionManagerClient = new FSAssertionManagerClient(this.hostEntityId, this.getFullServiceURL(string3));
            return fSAssertionManagerClient.getAssertion(assertionArtifact, string);
        }
        String string4 = null;
        try {
            string4 = (String)this.artIdMap.get(string2);
            if (string4 == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)this.idEntryMap.get(string4);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Map map = this.artIdMap;
        synchronized (map) {
            this.artIdMap.remove(string2);
        }
        Map map2 = this.idEntryMap;
        synchronized (map2) {
            this.idEntryMap.remove(string4);
        }
        String string5 = entry.getDestID();
        if (string5 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (!string5.equals(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): destinationID doesn't match.");
            }
            throw new FSException("destIDNotMatch", null);
        }
        Assertion assertion = entry.getAssertion();
        if (assertion == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Assertion found corresponding to aID.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        if (!assertion.isTimeValid()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: assertion " + string4 + " is expired.");
            }
            throw new FSException("assertionTimeNotValid", null);
        }
        return assertion;
    }

    public String getDestIdForArtifact(AssertionArtifact assertionArtifact) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Called");
        String string = assertionArtifact.getAssertionArtifact();
        String string2 = SAMLUtils.getServerURL(assertionArtifact.getAssertionHandle());
        if (string2 != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getDestIdForArtifact(art, destid: calling another server in lb site:" + string2);
            }
            FSAssertionManagerClient fSAssertionManagerClient = new FSAssertionManagerClient(this.hostEntityId, this.getFullServiceURL(string2));
            return fSAssertionManagerClient.getDestIdForArtifact(assertionArtifact);
        }
        String string3 = null;
        try {
            string3 = (String)this.artIdMap.get(string);
            if (string3 == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact :no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)this.idEntryMap.get(string3);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        String string4 = entry.getDestID();
        if (string4 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Destination ProviderID found for Artifact: " + string4);
        }
        return string4;
    }

    private String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)SERVICE_NAMING, (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }

    private class CleanUpThread
    extends Thread {
        public CleanUpThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                Integer n = null;
                if (!instanceMap.isEmpty()) {
                    Map map = instanceMap;
                    synchronized (map) {
                        Iterator iterator = instanceMap.values().iterator();
                        while (iterator.hasNext()) {
                            FSAssertionManager fSAssertionManager = (FSAssertionManager)iterator.next();
                            String string = fSAssertionManager.getProviderId();
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("cleanup instance " + string);
                            }
                            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
                            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                            try {
                                fSLocalConfigurationDescriptor = fSAllianceManager.getHostedProvider(FSAssertionManager.this.hostProviderId).getLocalConfiguration();
                            }
                            catch (FSAllianceManagementException fSAllianceManagementException) {
                                FSUtils.debug.error("CleanUpThread.run(): Exception while cleanup assertion :", (Throwable)((Object)fSAllianceManagementException));
                                continue;
                            }
                            Integer n2 = null;
                            try {
                                n2 = new Integer(fSLocalConfigurationDescriptor.getCleanupInterval());
                            }
                            catch (Exception exception) {
                                FSUtils.debug.error("CleanUpThread.run(): Exception while parsing interval", (Throwable)exception);
                                n2 = DEFAULT_CLEANUP_INTERVAL;
                            }
                            if (n == null || n.compareTo(n2) > 0) {
                                n = n2;
                            }
                            Integer n3 = null;
                            try {
                                n3 = new Integer(fSLocalConfigurationDescriptor.getAssertionInterval());
                            }
                            catch (Exception exception) {
                                FSUtils.debug.error("CleanUpThread.run(): Exception while parsing timeout", (Throwable)exception);
                                n3 = DEFAULT_ASSERTION_TIMEOUT;
                            }
                            this.cleanUpInstance(string, fSAssertionManager, n3);
                        }
                    }
                }
                if (n == null) {
                    n = DEFAULT_CLEANUP_INTERVAL;
                }
                long l = n * 1000;
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        private void cleanUpInstance(String string, FSAssertionManager fSAssertionManager, Integer n) {
            Map map;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("CleanUpInstance: provider=" + string + ", defaultAssertionTimeout=" + n);
            }
            if ((map = fSAssertionManager.getIdEntryMap()).isEmpty()) {
                return;
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            Map map2 = map;
            synchronized (map2) {
                Object object;
                Object object2;
                Object object3;
                Iterator<Object> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (String)iterator.next();
                    object2 = (Entry)map.get(object3);
                    if (object2 == null || (object = ((Entry)object2).getAssertion()) == null || !this.removeAssertion((Assertion)object, n)) continue;
                    hashSet.add(object3);
                }
                iterator = hashSet.iterator();
                object3 = fSAssertionManager.getArtIdMap();
                while (iterator.hasNext()) {
                    String string2;
                    object2 = (String)iterator.next();
                    object = (Entry)map.remove(object2);
                    if (object == null) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("CleanUpThread:deleted " + (String)object2);
                    }
                    if ((string2 = ((Entry)object).getArtifactString()) == null) continue;
                    Object object4 = object3;
                    synchronized (object4) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("CleanUpThread:deleting artifact" + string2);
                        }
                        object3.remove(string2);
                    }
                }
            }
        }

        private boolean removeAssertion(Assertion assertion, Integer n) {
            if (assertion.getConditions() != null) {
                return !assertion.isTimeValid();
            }
            long l = System.currentTimeMillis();
            Date date = assertion.getIssueInstant();
            long l2 = n * 1000;
            Date date2 = new Date(date.getTime() + l2);
            return l >= date2.getTime();
        }
    }

    private class Entry {
        private String destID = null;
        private String artString = null;
        private SSOToken token = null;
        private Assertion assertion = null;

        public Entry(Assertion assertion, String string, String string2, SSOToken sSOToken) {
            this.assertion = assertion;
            this.destID = string;
            this.artString = string2;
            this.token = sSOToken;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public String getDestID() {
            return this.destID;
        }

        public String getArtifactString() {
            return this.artString;
        }

        public SSOToken getSSOToken() {
            return this.token;
        }
    }
}

