/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestAuthnContext {
    private List authnContextClassRefList = null;
    private List authnContextStatementRefList = null;
    private String authnContextComparison = null;
    private int minorVersion = 0;

    public RequestAuthnContext(List list, List list2, String string) {
        this.authnContextStatementRefList = list2;
        this.authnContextClassRefList = list;
        this.authnContextComparison = string;
    }

    public RequestAuthnContext() {
    }

    public RequestAuthnContext(Element element) throws FSMsgException {
        if (element == null) {
            FSUtils.debug.message("AuthnContext.parseXML: null input.");
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string = element.getLocalName();
        if (string == null) {
            FSUtils.debug.error("AuthnContext.parseXML: wrong input.");
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (!string.equals("RequestAuthnContext") && !string.equals("AuthnContext")) {
            FSUtils.debug.error("AuthnContext.parseXML: wrong input.");
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("AuthnContextClassRef")) {
                    if (this.authnContextStatementRefList != null) {
                        FSUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextStatementRef> or <AuthnContextClassRef>");
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    if (this.authnContextClassRefList == null || this.authnContextClassRefList == Collections.EMPTY_LIST) {
                        this.authnContextClassRefList = new ArrayList();
                    }
                    this.authnContextClassRefList.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else if (string2.equals("AuthnContextStatementRef")) {
                    if (this.authnContextClassRefList != null) {
                        FSUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextStatementRef> or <AuthnContextClassRef>");
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    if (this.authnContextStatementRefList == null || this.authnContextStatementRefList == Collections.EMPTY_LIST) {
                        this.authnContextStatementRefList = new ArrayList();
                    }
                    this.authnContextStatementRefList.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else if (string2.equals("AuthnContextComparison")) {
                    this.authnContextComparison = XMLUtils.getElementValue((Element)((Element)node));
                }
            }
            ++n2;
        }
    }

    public List getAuthnContextClassRefList() {
        return this.authnContextClassRefList;
    }

    public void setAuthnContextClassRefList(List list) {
        this.authnContextClassRefList = list;
    }

    public List getAuthnContextStatementRefList() {
        return this.authnContextStatementRefList;
    }

    public void setAuthnContextStatementRefList(List list) {
        this.authnContextStatementRefList = list;
    }

    public String getAuthnContextComparison() {
        return this.authnContextComparison;
    }

    public void setAuthnContextComparison(String string) {
        this.authnContextComparison = string;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string2 = "lib:";
            string = "AC:";
        }
        if (bl2) {
            if (this.minorVersion == 2) {
                string4 = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
                string3 = " xmlns:ac=\"urn:liberty:ac:2003-08\"";
            } else {
                string4 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
                string3 = " xmlns:ac=\"http://projectliberty.org/schemas/authctx/2002/05\"";
            }
        }
        stringBuffer.append("<").append(string2);
        if (this.minorVersion == 2) {
            stringBuffer.append("RequestAuthnContext");
        } else {
            stringBuffer.append("AuthnContext");
        }
        stringBuffer.append(string4).append(">\n");
        if (this.authnContextClassRefList != null && this.authnContextClassRefList != Collections.EMPTY_LIST) {
            if (this.authnContextStatementRefList != null && this.authnContextClassRefList != Collections.EMPTY_LIST) {
                throw new FSMsgException(FSUtils.bundle.getString("ExclusiveEntries"));
            }
            iterator = this.authnContextClassRefList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("<").append(string2).append("AuthnContextClassRef").append(">");
                stringBuffer.append((String)iterator.next());
                stringBuffer.append("</").append(string2).append("AuthnContextClassRef").append(">\n");
            }
        }
        if (this.authnContextStatementRefList != null && this.authnContextStatementRefList != Collections.EMPTY_LIST) {
            iterator = this.authnContextStatementRefList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("<").append(string2).append("AuthnContextStatementRef").append(">");
                stringBuffer.append((String)iterator.next());
                stringBuffer.append("</").append(string2).append("AuthnContextStatementRef").append(">\n");
            }
        }
        if (this.minorVersion == 2) {
            stringBuffer.append("<").append(string2).append("AuthnContextComparison").append(">").append(this.authnContextComparison).append("</").append(string2).append("AuthnContextComparison").append(">\n");
        }
        stringBuffer.append("</").append(string2);
        if (this.minorVersion == 2) {
            stringBuffer.append("RequestAuthnContext").append(">\n");
        } else {
            stringBuffer.append("AuthnContext").append(">\n");
        }
        return stringBuffer.toString();
    }

    public static RequestAuthnContext parseURLEncodedRequest(HttpServletRequest httpServletRequest, int n) throws FSMsgException {
        Object object;
        Object object2;
        RequestAuthnContext requestAuthnContext = new RequestAuthnContext();
        String string = httpServletRequest.getParameter("AuthnContextClassRef");
        if (string != null) {
            object2 = new StringTokenizer(string);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                if (requestAuthnContext.authnContextClassRefList == null) {
                    requestAuthnContext.authnContextClassRefList = new ArrayList();
                }
                requestAuthnContext.authnContextClassRefList.add(((StringTokenizer)object2).nextToken());
            }
        }
        if ((object2 = httpServletRequest.getParameter("AuthnContextStatementRef")) != null) {
            object = new StringTokenizer((String)object2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                if (requestAuthnContext.authnContextStatementRefList == null) {
                    requestAuthnContext.authnContextStatementRefList = new ArrayList();
                }
                requestAuthnContext.authnContextStatementRefList.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = httpServletRequest.getParameter("AuthnContextComparison")) != null) {
            requestAuthnContext.setAuthnContextComparison((String)object);
        }
        requestAuthnContext.setMinorVersion(n);
        return requestAuthnContext;
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        Iterator iterator;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = new StringBuffer(300);
        if (this.authnContextClassRefList != null && !this.authnContextClassRefList.isEmpty()) {
            if (this.authnContextStatementRefList != null && !this.authnContextStatementRefList.isEmpty()) {
                throw new FSMsgException(FSUtils.bundle.getString("ExclusiveEntries"));
            }
            stringBuffer = new StringBuffer(100);
            iterator = this.authnContextClassRefList.iterator();
            stringBuffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(" ").append((String)iterator.next());
            }
            stringBuffer2.append("AuthnContextClassRef=").append(AMURLEncDec.encode((String)stringBuffer.toString())).append("&");
        }
        if (this.authnContextStatementRefList != null && !this.authnContextStatementRefList.isEmpty()) {
            stringBuffer = new StringBuffer(100);
            iterator = this.authnContextStatementRefList.iterator();
            stringBuffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(" ").append((String)iterator.next());
            }
            stringBuffer2.append("AuthnContextClassRef=").append(AMURLEncDec.encode((String)stringBuffer.toString())).append("&");
        }
        if (this.authnContextComparison != null) {
            stringBuffer2.append("AuthnContextComparison=").append(AMURLEncDec.encode((String)this.authnContextComparison)).append("&");
        }
        return stringBuffer2.toString();
    }
}

