/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDPEntries {
    private List idpEntryList = null;
    private List otherElements = null;

    public IDPEntries() {
    }

    public IDPEntries(List list) {
        this.idpEntryList = list;
    }

    public List getIDPEntryList() {
        return this.idpEntryList;
    }

    public void setIDPEntryList(List list) {
        this.idpEntryList = list;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        stringBuffer.append("<").append(string).append("IDPEntries").append(string2).append(">\n");
        if (this.idpEntryList != null && this.idpEntryList != Collections.EMPTY_LIST) {
            Iterator iterator = this.idpEntryList.iterator();
            while (iterator.hasNext()) {
                IDPEntry iDPEntry = (IDPEntry)iterator.next();
                stringBuffer.append(iDPEntry.toXMLString(true, false));
            }
        }
        stringBuffer.append("</").append(string).append("IDPEntries>\n");
        return stringBuffer.toString();
    }

    public IDPEntries(Element element) throws FSMsgException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("IDPEntries.parseXML: null input.");
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("IDPEntries")) {
            FSUtils.debug.message("IDPEntries.parseXML: wrong input.");
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null && string2.equals("IDPEntry")) {
                if (this.idpEntryList == null || this.idpEntryList == Collections.EMPTY_LIST) {
                    this.idpEntryList = new ArrayList();
                }
                this.idpEntryList.add(new IDPEntry((Element)node));
            }
            ++n2;
        }
    }
}

