/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.EncryptableNameIdentifier;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedNameIdentifier {
    private static Document getEncryptableDocument(EncryptableNameIdentifier encryptableNameIdentifier) {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        String string2 = "lib:";
        stringBuffer.append("<").append(string2).append("EncryptedNameIdentifier").append(" ").append(string).append(">").append(encryptableNameIdentifier.toString()).append("</").append(string2).append("EncryptedNameIdentifier").append(">");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("EncryptedNameIdentifier.getEncryptableNameIdentifier: doc =" + stringBuffer.toString());
        }
        return XMLUtils.toDOMDocument((String)stringBuffer.toString(), (Debug)FSUtils.debug);
    }

    public static NameIdentifier getEncryptedNameIdentifier(NameIdentifier nameIdentifier, String string) throws FSException {
        Object object;
        Object object2;
        if (nameIdentifier == null || string == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: nullInputParameter");
            throw new FSException("nullInputParameter", null);
        }
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            object2 = FSServiceUtils.getAllianceInstance();
            fSProviderDescriptor = ((FSAllianceManager)object2).getProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: Couldnot retrieve the provider id for provider" + string);
            throw new FSException((Exception)((Object)fSAllianceManagementException));
        }
        object2 = new EncryptableNameIdentifier(nameIdentifier);
        Document document = EncryptedNameIdentifier.getEncryptableDocument((EncryptableNameIdentifier)object2);
        Document document2 = null;
        try {
            object = (Element)document.getElementsByTagNameNS("urn:liberty:iff:2003-08", "EncryptableNameIdentifier").item(0);
            XMLEncryptionManager xMLEncryptionManager = XMLEncryptionManager.getInstance();
            document2 = xMLEncryptionManager.encryptAndReplace(document, (Element)object, fSProviderDescriptor.getEncryptionKeyMethod(), fSProviderDescriptor.getEncryptionKeySize(), fSProviderDescriptor.getEncryptionKeyAlias(), string);
        }
        catch (EncryptionException encryptionException) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: Unableto encrypt the xml doc", (Throwable)((Object)encryptionException));
            throw new FSException((Exception)((Object)encryptionException));
        }
        if (document2 == null) {
            throw new FSException("EncryptionFailed", null);
        }
        object = Base64.encode((byte[])SAMLUtils.stringToByteArray(XMLUtils.print((Node)document2)));
        try {
            return new NameIdentifier((String)object, nameIdentifier.getNameQualifier(), "urn:liberty:iff:nameid:encrypted");
        }
        catch (SAMLException sAMLException) {
            throw new FSException(sAMLException);
        }
    }

    public static NameIdentifier getDecryptedNameIdentifier(NameIdentifier nameIdentifier, String string) throws FSException {
        Object object;
        if (nameIdentifier == null || string == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: null values");
            throw new FSException("nullInputParameter", null);
        }
        if (nameIdentifier.getFormat() == null || !nameIdentifier.getFormat().equals("urn:liberty:iff:nameid:encrypted")) {
            throw new FSException("notValidFormat", null);
        }
        String string2 = nameIdentifier.getName();
        string2 = FSUtils.removeNewLineChars(string2);
        String string3 = SAMLUtils.byteArrayToString(Base64.decode((String)string2));
        Document document = XMLUtils.toDOMDocument((String)string3, (Debug)FSUtils.debug);
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            object = FSServiceUtils.getAllianceInstance();
            fSProviderDescriptor = ((FSAllianceManager)object).getProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: Unable to find provider", (Throwable)((Object)fSAllianceManagementException));
            throw new FSException((Exception)((Object)fSAllianceManagementException));
        }
        try {
            object = XMLEncryptionManager.getInstance();
            Document document2 = ((XMLEncryptionManager)object).decryptAndReplace(document, fSProviderDescriptor.getEncryptionKeyAlias());
            Element element = (Element)document2.getElementsByTagNameNS("urn:liberty:iff:2003-08", "EncryptableNameIdentifier").item(0);
            EncryptableNameIdentifier encryptableNameIdentifier = new EncryptableNameIdentifier(element);
            return new NameIdentifier(encryptableNameIdentifier.getName(), encryptableNameIdentifier.getNameQualifier(), encryptableNameIdentifier.getFormat());
        }
        catch (EncryptionException encryptionException) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: Decryption exception", (Throwable)((Object)encryptionException));
            throw new FSException((Exception)((Object)encryptionException));
        }
        catch (SAMLException sAMLException) {
            throw new FSException(sAMLException);
        }
    }
}

