/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Element;

public class EncryptableNameIdentifier {
    private String _nameQualifier = "";
    private String _name = "";
    private String _nonce = "";
    private String _format = "";
    private Date _issueInstant = null;

    protected EncryptableNameIdentifier() {
    }

    public EncryptableNameIdentifier(NameIdentifier nameIdentifier) throws FSException {
        if (nameIdentifier == null) {
            throw new FSException("nullInput", null);
        }
        this._nameQualifier = nameIdentifier.getNameQualifier();
        this._name = nameIdentifier.getName();
        if (this._nameQualifier == null || this._name == null) {
            throw new FSException("nullInput", null);
        }
        this._format = nameIdentifier.getFormat();
        if (this._format == null || !this._format.equals("urn:liberty:iff:nameid:federated")) {
            throw new FSException("notValidFormat", null);
        }
        this._nonce = FSUtils.generateID();
        this._issueInstant = new Date();
    }

    public EncryptableNameIdentifier(String string, String string2, String string3, Date date, String string4) throws FSException {
        if (string == null || string2 == null || date == null || string3 == null || string4 == null) {
            throw new FSException("nullInput", null);
        }
        this._name = string;
        this._nameQualifier = string2;
        this._format = string3;
        this._nonce = string4;
        this._issueInstant = date;
    }

    public EncryptableNameIdentifier(Element element) throws FSException {
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: local name missing");
            }
            throw new FSException("nullInput", null);
        }
        if (!string.equals("EncryptableNameIdentifier")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: invalid root element");
            }
            throw new FSException("invalidElement", null);
        }
        String string2 = element2.getAttribute("NameQualifier");
        if (string2 != null) {
            this._nameQualifier = string2;
        }
        if ((string2 = element2.getAttribute("Format")) != null) {
            this._format = string2;
        }
        if ((string2 = element2.getAttribute("Nonce")) != null) {
            this._nonce = string2;
        }
        if ((string2 = element2.getAttribute("IssueInstant")) != null) {
            try {
                this._issueInstant = DateUtils.stringToDate((String)string2);
            }
            catch (ParseException parseException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("EncryptableNameIdentifier: Could not parse issue instant", (Throwable)parseException);
                }
                throw new FSException("wrongInput", null);
            }
        }
        if ((string2 = XMLUtils.getElementValue((Element)element2)) == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("EncryptableNameIdentifier: null input specified");
            }
            throw new FSException("nullInput", null);
        }
        this._name = string2;
    }

    public String getFormat() {
        return this._format;
    }

    public boolean setFormat(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        this._format = string;
        return true;
    }

    public String getNameQualifier() {
        return this._nameQualifier;
    }

    public boolean setNameQualifier(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        this._nameQualifier = string;
        return true;
    }

    protected boolean setName(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        this._name = string;
        return true;
    }

    public String getName() {
        return this._name;
    }

    public String getNonce() {
        return this._nonce;
    }

    public Date getIssueInstant() {
        return this._issueInstant;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        }
        if (bl) {
            string2 = "lib:";
        }
        String string3 = null;
        if (this._issueInstant != null) {
            string3 = DateUtils.toUTCDateFormat((Date)this._issueInstant);
        }
        stringBuffer.append("<").append(string2).append("EncryptableNameIdentifier").append(string);
        if (this._nameQualifier != null && !this._nameQualifier.equals("")) {
            stringBuffer.append(" ").append("NameQualifier").append("=\"").append(this._nameQualifier).append("\"");
        }
        if (this._format != null && !this._format.equals("")) {
            stringBuffer.append(" ").append("Format").append("=\"").append(this._format).append("\"");
        }
        if (this._nonce != null && !this._nonce.equals("")) {
            stringBuffer.append(" ").append("Nonce").append("=\"").append(this._nonce).append("\"");
        }
        if (this._issueInstant != null && !this._issueInstant.equals("")) {
            stringBuffer.append(" ").append("IssueInstant").append("=\"").append(string3).append("\"");
        }
        stringBuffer.append(">").append(this._name);
        stringBuffer.append("</").append(string2).append("EncryptableNameIdentifier").append(">");
        return stringBuffer.toString();
    }
}

