/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnContext {
    protected String authnContextClassRef = null;
    protected String authnContextStatementRef = null;
    protected int minorVersion = 0;

    public AuthnContext(String string, String string2) {
        this.authnContextClassRef = string;
        this.authnContextStatementRef = string2;
    }

    public AuthnContext() {
    }

    public AuthnContext(Element element) throws FSMsgException {
        if (element == null) {
            FSUtils.debug.message("AuthnContext(): null input.");
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("AuthnContext")) {
            FSUtils.debug.message("AuthnContext: wrong input.");
            throw new FSMsgException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        String string2 = element.getNamespaceURI();
        if (string2 != null && string2.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 == null) {
                if (string3.equals("AuthnContextClassRef")) {
                    if (this.authnContextClassRef != null) {
                        FSUtils.debug.error("AuthnContext(Element): Shouldcontain only one AuthnContextClassRef element");
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.authnContextClassRef = XMLUtils.getElementValue((Element)((Element)node));
                } else if (string3.equals("AuthnContextStatementRef")) {
                    if (this.authnContextStatementRef != null) {
                        FSUtils.debug.error("AuthnContext(Element): Should contain  only one AuthnContextStatementRef element");
                        throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
                    }
                    this.authnContextStatementRef = XMLUtils.getElementValue((Element)((Element)node));
                } else if (string3.equals("AuthenticationContextStatement") && FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AuthnContext(Element): Authentication Statement");
                }
            }
            ++n2;
        }
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String string) {
        this.authnContextClassRef = string;
    }

    public String getAuthnContextStatementRef() {
        return this.authnContextStatementRef;
    }

    public void setAuthnContextStatementRef(String string) {
        this.authnContextStatementRef = string;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string2 = "lib:";
            string = "AC:";
        }
        if (bl2) {
            if (this.minorVersion == 2) {
                string4 = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
                string3 = " xmlns:ac=\"urn:liberty:ac:2003-08\"";
            } else {
                string4 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
                string3 = " xmlns:ac=\"http://projectliberty.org/schemas/authctx/2002/05\"";
            }
        }
        stringBuffer.append("<").append(string2).append("AuthnContext").append(string4).append(">");
        if (this.authnContextClassRef != null && !this.authnContextClassRef.equals("")) {
            stringBuffer.append("<").append(string2).append("AuthnContextClassRef").append(">");
            stringBuffer.append(this.authnContextClassRef);
            stringBuffer.append("</").append(string2).append("AuthnContextClassRef").append(">");
        } else {
            stringBuffer.append("<").append(string2).append("AuthnContextClassRef").append(">");
            stringBuffer.append("http://www.projectliberty.org/schemas/authctx/classes/Password");
            stringBuffer.append("</").append(string2).append("AuthnContextClassRef").append(">");
        }
        if (this.authnContextStatementRef != null && !this.authnContextStatementRef.equals("")) {
            stringBuffer.append("<").append(string2).append("AuthnContextStatementRef").append(">");
            stringBuffer.append(this.authnContextStatementRef);
            stringBuffer.append("</").append(string2).append("AuthnContextStatementRef").append(">");
        } else {
            stringBuffer.append("<").append(string2).append("AuthnContextStatementRef").append(">");
            stringBuffer.append("http://www.projectliberty.org/schemas/authctx/classes/Password");
            stringBuffer.append("</").append(string2).append("AuthnContextStatementRef").append(">");
        }
        stringBuffer.append("</").append(string2).append("AuthnContext").append(">");
        return stringBuffer.toString();
    }
}

