/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSScoping {
    private int proxyCount = -1;
    private FSIDPList idpList = null;

    public FSScoping() {
    }

    public FSScoping(FSIDPList fSIDPList, int n) {
        this.idpList = fSIDPList;
        this.proxyCount = n;
    }

    public FSScoping(Element element) throws FSMsgException {
        if (element == null) {
            FSUtils.debug.error("FSScoping(Element): null input");
            throw new FSMsgException("nullInput", null);
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("Scoping")) {
            FSUtils.debug.error("FSScoping(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("ProxyCount")) {
                    String string3 = XMLUtils.getElementValue((Element)((Element)node));
                    try {
                        this.proxyCount = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        FSUtils.debug.error("FSScoping(Element): invalid proxyCount", (Throwable)numberFormatException);
                        throw new FSMsgException("wrongInput", null);
                    }
                } else if (string2.equals("IDPList")) {
                    this.idpList = new FSIDPList((Element)node);
                }
            }
            ++n2;
        }
    }

    public void setProxyCount(int n) {
        this.proxyCount = n;
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    public void setIDPList(FSIDPList fSIDPList) {
        this.idpList = fSIDPList;
    }

    public FSIDPList getIDPList() {
        return this.idpList;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        }
        stringBuffer.append("<").append(string).append("Scoping").append(string2).append(">\n");
        if (this.proxyCount >= 0) {
            stringBuffer.append("<").append(string).append("ProxyCount").append(">").append(this.proxyCount).append("</").append(string).append("ProxyCount").append(">\n");
        }
        if (this.idpList != null) {
            stringBuffer.append(this.idpList.toXMLString(true, false));
        }
        stringBuffer.append("</").append(string).append("Scoping").append(">\n");
        return stringBuffer.toString();
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        List list;
        IDPEntries iDPEntries;
        if (this.proxyCount == -1) {
            FSUtils.debug.error("FSScoping.toURLEncodedQueryString: proxyCount is not defined.");
            throw new FSMsgException("proxyCountNotDefined");
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ProxyCount=").append(this.proxyCount).append("&");
        if (this.idpList != null && (iDPEntries = this.idpList.getIDPEntries()) != null && (list = iDPEntries.getIDPEntryList()) != null && list.size() != 0) {
            Iterator iterator = list.iterator();
            StringBuffer stringBuffer2 = new StringBuffer(100);
            String string = "";
            while (iterator.hasNext()) {
                IDPEntry iDPEntry = (IDPEntry)iterator.next();
                String string2 = iDPEntry.getProviderID();
                stringBuffer2.append(string).append(string2);
                string = " ";
            }
            stringBuffer.append("IDPEntries=").append(AMURLEncDec.encode((String)stringBuffer2.toString()));
        }
        stringBuffer.append("&");
        return stringBuffer.toString();
    }

    public static FSScoping parseURLEncodedRequest(HttpServletRequest httpServletRequest) {
        Object object;
        Object object2;
        if (httpServletRequest == null) {
            return null;
        }
        String string = httpServletRequest.getParameter("ProxyCount");
        if (string == null) {
            return null;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("FSScoping.parseURLEncodedRequest:proxyCount can not be parsed.");
            return null;
        }
        FSScoping fSScoping = new FSScoping();
        fSScoping.setProxyCount(n);
        String[] stringArray = httpServletRequest.getParameterValues("IDPEntries");
        if (stringArray == null || stringArray.length == 0) {
            return fSScoping;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            object = new IDPEntry((String)object2, null, null);
            arrayList.add(object);
            ++n2;
        }
        object2 = new IDPEntries(arrayList);
        object = new FSIDPList((IDPEntries)object2, null);
        fSScoping.setIDPList((FSIDPList)object);
        return fSScoping;
    }
}

