/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSNameIdentifierMappingRequest
extends AbstractRequest {
    private String providerID;
    private NameIdentifier nameIdentifier;
    private String targetNamespace;
    private int minorVersion = 2;
    private String xmlString;
    private String signatureString;

    public FSNameIdentifierMappingRequest(String string, NameIdentifier nameIdentifier, String string2) throws FSMsgException {
        this.providerID = string;
        this.nameIdentifier = nameIdentifier;
        this.targetNamespace = string2;
        this.requestID = SAMLUtilsCommon.generateID();
        this.setIssueInstant(new Date());
    }

    public FSNameIdentifierMappingRequest(Element element) throws FSMsgException {
        if (element == null) {
            FSUtils.debug.message("FSNameIdentifierMappingRequest: null element input.");
            throw new FSMsgException(FSUtils.bundle.getString("nullInputParameter"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("NameIdentifierMappingRequest")) {
            FSUtils.debug.message("FSNameIdentifierMappingRequest: wrong input");
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.length() == 0) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: missing IssueInstant");
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: could not parse IssueInstant.", (Throwable)exception);
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        this.requestID = element.getAttribute("RequestID");
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null) {
                if (string3.equals("ProviderID")) {
                    this.providerID = XMLUtils.getElementValue((Element)((Element)node));
                } else if (string3.equals("NameIdentifier")) {
                    try {
                        this.nameIdentifier = new NameIdentifier((Element)node);
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSNameIdentifierMappingRequest: unable to initialize NameIdentifier", (Throwable)sAMLException);
                        throw new FSMsgException(sAMLException.getMessage());
                    }
                } else if (string3.equals("TargetNamespace")) {
                    this.targetNamespace = XMLUtils.getElementValue((Element)((Element)node));
                }
            }
            ++n2;
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: included more than one Signature element.");
            throw new FSMsgException(FSUtils.bundle.getString("moreElement"));
        }
    }

    public static FSNameIdentifierMappingRequest parseXML(String string) throws FSMsgException {
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
        if (document == null) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.parseXML: error while parsing input xml string");
            throw new FSMsgException(FSUtils.bundle.getString("parseError"));
        }
        Element element = document.getDocumentElement();
        return new FSNameIdentifierMappingRequest(element);
    }

    public String getProviderID() {
        return this.providerID;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    private void parseMajorVersion(String string) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: invalid MajorVersion: " + string, (Throwable)numberFormatException);
            }
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: MajorVersion is too high");
                }
                throw new FSMsgException(FSUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: MajorVersion is too low");
            }
            throw new FSMsgException(FSUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: invalid MinorVersion: " + string, (Throwable)numberFormatException);
            }
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion != 2) {
            if (this.minorVersion > 2) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: MinorVersion is too high");
                }
                throw new FSMsgException(FSUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: MinorVersion is too low");
            }
            throw new FSMsgException(FSUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    public void signXML() throws SAMLException {
        String string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.certalias");
        this.signXML(string);
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML: the request is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML: null certAlias");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "RequestID", this.getRequestID(), false);
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.signXML: unable to sign", (Throwable)exception);
            throw new SAMLResponderException(exception.getMessage());
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String string4 = null;
        try {
            string4 = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.toXMLString: could not convert issueInstant to String.", (Throwable)exception);
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        stringBuffer.append("<").append(string).append("NameIdentifierMappingRequest").append(string2).append(string3).append(" RequestID=\"").append(this.requestID).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string4).append("\"").append(">");
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        stringBuffer.append("<").append(string).append("ProviderID").append(">").append(this.providerID).append("</").append(string).append("ProviderID").append(">");
        if (this.nameIdentifier != null) {
            stringBuffer.append(this.nameIdentifier.toString());
        }
        stringBuffer.append("<").append(string).append("TargetNamespace").append(">").append(this.targetNamespace).append("</").append(string).append("TargetNamespace").append(">").append("</").append(string).append("NameIdentifierMappingRequest>");
        return stringBuffer.toString();
    }
}

