/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.GetComplete;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSIDPList {
    private List getCompleteList = null;
    public IDPEntries idpEntries = null;
    private int minorVersion = 0;

    public FSIDPList() {
    }

    public FSIDPList(Element element) throws FSMsgException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("FSIDPList.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String string = element.getNamespaceURI();
        if (string == null) {
            FSUtils.debug.error("FSIDPList(Element):No namespace");
            throw new FSMsgException("wrongInput", null);
        }
        if (string.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        String string2 = null;
        string2 = element.getLocalName();
        if (string2 == null || !string2.equals("IDPList")) {
            FSUtils.debug.message("FSIDPList.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null) {
                if (string3.equals("GetComplete")) {
                    if (this.getCompleteList == null || this.getCompleteList == Collections.EMPTY_LIST) {
                        this.getCompleteList = new ArrayList();
                    }
                    this.getCompleteList.add(new GetComplete((Element)node));
                } else if (string3.equals("IDPEntries")) {
                    this.idpEntries = new IDPEntries((Element)node);
                }
            }
            ++n2;
        }
    }

    public FSIDPList(IDPEntries iDPEntries, List list) {
        this.idpEntries = iDPEntries;
        this.getCompleteList = list;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public IDPEntries getIDPEntries() {
        return this.idpEntries;
    }

    public List getGetCompleteList() {
        return this.getCompleteList;
    }

    public void setIDPEntries(IDPEntries iDPEntries) {
        this.idpEntries = iDPEntries;
    }

    public void setGetCompleteList(List list) {
        this.getCompleteList = list;
    }

    public static FSIDPList parseXML(String string) {
        return null;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        stringBuffer.append("<").append(string).append("IDPList").append(string2).append(">");
        if (this.idpEntries != null) {
            stringBuffer.append(this.idpEntries.toXMLString(true, false));
        }
        if (this.getCompleteList != null && this.getCompleteList != Collections.EMPTY_LIST) {
            Iterator iterator = this.getCompleteList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
        }
        stringBuffer.append("</").append(string).append("IDPList").append(">");
        return stringBuffer.toString();
    }
}

