/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.protocol.AssertionArtifact;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSAssertionArtifact
extends AssertionArtifact {
    public static final int ARTIFACT_1_LENGTH = 42;
    public static final byte ARTIFACT_1_TYPE_CODE_0 = 0;
    public static final byte ARTIFACT_1_TYPE_CODE_1 = 3;
    public static final byte[] ARTIFACT_1_TYPE_CODE = new byte[]{0, 3};
    private BASE64Decoder decoder = new BASE64Decoder();
    private BASE64Encoder encoder = new BASE64Encoder();

    protected FSAssertionArtifact() {
    }

    public FSAssertionArtifact(String string) throws FSMsgException {
        if (string == null || string.equals("")) {
            FSUtils.debug.message("FSAssertionArtifact: empty input.");
            throw new FSMsgException("nullInput", null);
        }
        byte[] byArray = null;
        try {
            byArray = this.decoder.decodeBuffer(string);
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: exception decode input:", (Throwable)exception);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (byArray.length != 42) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: the length is not 42:" + byArray.length);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (byArray[0] != 0 || byArray[1] != 3) {
            FSUtils.debug.message("FSAssertionArtifact: wrong typecode.");
            throw new FSMsgException("wrongInput", null);
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
        this.artifact = string;
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        System.arraycopy(byArray, 2, byArray2, 0, 20);
        System.arraycopy(byArray, 22, byArray3, 0, 20);
        try {
            this.sourceID = new String(byArray2, "ISO-8859-1");
            this.assertionHandle = new String(byArray3, "ISO-8859-1");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifact: encoding exception: ", (Throwable)exception);
            this.sourceID = new String(byArray2);
            this.assertionHandle = new String(byArray3);
        }
    }

    public FSAssertionArtifact(byte[] byArray, byte[] byArray2) throws FSMsgException {
        if (byArray == null || byArray2 == null) {
            FSUtils.debug.message("FSAssertionArtifact: null input.");
            throw new FSMsgException("nullInput", null);
        }
        if (byArray.length != 20 || byArray2.length != 20) {
            FSUtils.debug.message("FSAssertionArtifact: wrong input length.");
            throw new FSMsgException("wrongInput", null);
        }
        try {
            this.sourceID = new String(byArray, "ISO-8859-1");
            this.assertionHandle = new String(byArray2, "ISO-8859-1");
        }
        catch (Exception exception) {
            FSUtils.debug.error("AsseritonArtifact: encoding exception: ", (Throwable)exception);
            this.sourceID = new String(byArray);
            this.assertionHandle = new String(byArray2);
        }
        byte[] byArray3 = new byte[42];
        byArray3[0] = 0;
        byArray3[1] = 3;
        int n = 0;
        while (n < 20) {
            byArray3[2 + n] = byArray[n];
            byArray3[22 + n] = byArray2[n];
            ++n;
        }
        try {
            this.artifact = this.encoder.encodeBuffer(byArray3).trim();
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifact: exception encode input:", (Throwable)exception);
            }
            throw new FSMsgException("errorCreateArtifact", null);
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
    }
}

