/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.login.FSPreLoginException;
import com.sun.identity.federation.login.IPreLogin;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.liberty.LibertyManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSPreLogin
implements IPreLogin {
    private String orgDN = null;
    private static String postLoginURL = null;
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private boolean isFedCookiePresent = false;
    private static boolean messageEnabled = false;
    private static String metaAliasKey = "metaAlias";
    private static String ISCookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name");
    private static String loginURL = null;
    private static String gotoKey = "goto";
    private static String orgKey = "org";
    private static String amserverURI = null;
    private static String authLevelKey = "authlevel";
    private static String headerKey = "headerKey";
    private static String LRURLKey = "RelayState";
    private static String URLKey = "urlKey";
    private static String fedCookieName = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
    private boolean doLocalAuth = false;
    private boolean isLibertyOn = FSServiceUtils.isLibertyEnabled();
    private String errorPage = null;
    private String homePage = null;
    private String commonLoginPage = null;
    private static FSAllianceManager allianceManager = null;
    private String gotoOnFedCookieNoURL = null;

    public FSPreLogin() {
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::Constructor called");
        }
    }

    private void printAllVarSet() {
        FSUtils.debug.message("FSPreLogin::ISCookieName " + ISCookieName);
        FSUtils.debug.message("FSPreLogin::fedCookieName" + fedCookieName);
        FSUtils.debug.message("FSPreLogin::loginURL " + loginURL);
    }

    private String removeMetaGotoOrg() {
        Enumeration enumeration = this.httpRequest.getParameterNames();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase(metaAliasKey) || string2.equalsIgnoreCase(gotoKey) || string2.equalsIgnoreCase(orgKey)) {
                if (!messageEnabled) continue;
                FSUtils.debug.message("FSPreLogin::removeMetaGotoOrg found metaAlias or gotoKey or org.");
                continue;
            }
            String string3 = this.httpRequest.getParameter(string2);
            string = string == null || string.length() < 1 ? string2 + "=" + string3 : string + "&" + string2 + "=" + string3;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::removeMetaGotoOrg  returning with " + string);
        }
        return string;
    }

    private String getLoginURL(boolean bl, String string) {
        String string2 = loginURL + "?" + "arg" + "=" + "newsession";
        String string3 = string2 + "&" + this.getQueryString(bl, string);
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::getLoginURL returning with URL " + string3);
        }
        return string3;
    }

    private String getQueryString(boolean bl, String string) {
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::getQueryString called");
        }
        String string2 = this.httpRequest.getParameter(gotoKey);
        String string3 = null;
        String string4 = null;
        string4 = this.removeMetaGotoOrg();
        if (string2 == null || string2.length() <= 0) {
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::getQueryString.no goto in queryString.Assinging LRURL = " + this.homePage);
            }
            string2 = this.homePage;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::getQueryString. RelayState =" + string2 + " Required QueryString =" + string4);
        }
        string3 = postLoginURL + "?" + metaAliasKey + "=" + string + "&" + LRURLKey + "=" + string2;
        if (bl) {
            string3 = string3 + "&" + "federate" + "=" + "false";
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::getQueryString.gotoURL =" + string3);
        }
        string3 = AMURLEncDec.encode((String)string3);
        String string5 = new String();
        string5 = string4 != null && string4.length() > 0 ? orgKey + "=" + AMURLEncDec.encode((String)this.orgDN) + "&" + string4 + "&" + gotoKey + "=" + string3 : orgKey + "=" + AMURLEncDec.encode((String)this.orgDN) + "&" + gotoKey + "=" + string3;
        return string5;
    }

    private void setAllianceInfo(String string) throws FSPreLoginException {
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::setAllianceInfo called withmetaAlias =" + string);
        }
        String string2 = null;
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
            if (allianceManager == null) {
                FSUtils.debug.error("FSPreLogin::setAllianceInfo getLocalConfiguration retured null. Cannot proceed so throwing error page");
                throw new FSPreLoginException("FSPreLogin:: could not get alliancemanager handle.");
            }
            fSHostedProviderDescriptor = allianceManager.getHostedProviderByMetaAlias(string);
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            if (fSLocalConfigurationDescriptor != null) {
                Set set = fSLocalConfigurationDescriptor.getAuthDomainURLList();
                if (set != null) {
                    this.orgDN = (String)set.iterator().next();
                }
            } else {
                FSUtils.debug.error("FSPreLogin::setAllianceInfo getLocalConfiguration retured null. Cannot proceed so throwing error page");
                throw new FSPreLoginException("FSPreLogin:: could not get local config.");
            }
            this.homePage = fSLocalConfigurationDescriptor.getProviderHomePageURL();
            string2 = fSLocalConfigurationDescriptor.getProviderAuthType();
            this.commonLoginPage = fSLocalConfigurationDescriptor.getProviderCommonLoginPageURL(this.httpRequest);
            this.errorPage = fSLocalConfigurationDescriptor.getErrorPageURL(this.httpRequest);
            if (string2 != null && string2.equalsIgnoreCase("local")) {
                this.doLocalAuth = true;
            } else {
                FSUtils.debug.message("FSPreLogin::setAllianceInfo getProviderAuthType returned null. Setting authTpye to default false.");
            }
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::setAllianceInfo. orgDN = " + this.orgDN + " libertyOn = " + this.isLibertyOn + " doLocalAuth = " + this.doLocalAuth);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSPreLogin::setAllianceInfo. FSAllianceMangement Exception caught. " + fSAllianceManagementException.getMessage());
            throw new FSPreLoginException("FSPreLogin::FSAllianceManagementException. ");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPreLogin::setAllianceInfo. General Exception caught. ", (Throwable)exception);
            throw new FSPreLoginException("Prelogin exception");
        }
    }

    private Map getCookieMap(Cookie[] cookieArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                hashMap.put(cookieArray[n].getName(), cookieArray[n].getValue());
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::getCookieMap with key " + cookieArray[n].getName() + " and value " + cookieArray[n].getValue());
                }
                ++n;
            }
        }
        return hashMap;
    }

    private void setRespone(HttpServletResponse httpServletResponse, Map map) {
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::setResponse called.");
        }
        Map map2 = (Map)map.get(headerKey);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = (String)map2.get(string);
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::setResponse with header  with name " + string + " with value " + string2);
            }
            httpServletResponse.addHeader(string, string2);
        }
        if (!map2.containsKey("Cache-Control")) {
            httpServletResponse.addHeader("Cache-Control", "no-cache");
        }
        if (!map2.containsKey("Pragma")) {
            httpServletResponse.addHeader("Pragma", "no-cache");
        }
    }

    private void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, this.errorPage);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPreLogin:: sendError Error during sending error page");
        }
    }

    private boolean validateISCookie(String string) {
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        if (messageEnabled) {
            FSUtils.debug.message("FSPreLogin::validateISCookie.Called ");
        }
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            FSUtils.debug.message("FSPreLogin::validateISCookie():UnsupportedOperationException:" + unsupportedOperationException.getMessage());
            return false;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("FSPreLogin::validateISCookie():SSOException:" + sSOException.getMessage());
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.message("FSPreLogin::validateISCookie():Exception:" + exception.getMessage());
            return false;
        }
        return sSOTokenManager.isValidToken(sSOToken);
    }

    private Map setHeaderMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = this.httpRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this.httpRequest.getHeader(string);
            hashMap.put(string, string2);
            if (!messageEnabled) continue;
            FSUtils.debug.message("FSLoginHelper.setHeaderMap() : name :: " + string + " :: value :: " + string2);
        }
        return hashMap;
    }

    private Map createSSOMap(String string, String string2) throws FSPreLoginException {
        try {
            Object object;
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::createSSOMap called with authLevel =" + string + " metaAlias =" + string2);
            }
            if (!this.isFedCookiePresent && (object = this.httpRequest.getParameter("actionOnNoFedCookie")) != null && ((String)object).equals("locallogin")) {
                FSUtils.forwardRequest(this.httpRequest, this.httpResponse, this.getLoginURL(false, string2));
                return null;
            }
            object = this.setHeaderMap();
            FSLoginHelper fSLoginHelper = new FSLoginHelper(this.httpRequest);
            String string3 = this.httpRequest.getParameter(gotoKey);
            if (string3 == null || string3.length() <= 0) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::createSSOMap.no goto in queryString.Assinging targetURL = " + this.homePage);
                }
                string3 = this.homePage;
            }
            Map map = fSLoginHelper.createAuthnRequest((Map)object, string3, string, string2, null, this.isFedCookiePresent);
            String string4 = null;
            String string5 = (String)map.get("responseData");
            if (string5 != null && !string5.equals("")) {
                return map;
            }
            string4 = (String)map.get("RequestID");
            String string6 = (String)map.get("urlKey");
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::createSSOMap requestID" + string4 + " URL " + string6);
            }
            if (string4 != null && string6 == null) {
                String string7 = this.getQueryString(true, string2);
                String string8 = this.commonLoginPage + "?" + string7 + "&" + "RequestID" + "=" + AMURLEncDec.encode((String)string4) + "&" + metaAliasKey + "=" + this.httpRequest.getParameter(metaAliasKey);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::createSSOMap framedlogin url " + string8);
                }
                map.put(URLKey, string8);
            }
            return map;
        }
        catch (FSLoginHelperException fSLoginHelperException) {
            FSUtils.debug.error("FSPreLogin::setAllianceInfo. FSLoginHelperException Exception caught. " + (Object)((Object)fSLoginHelperException));
            throw new FSPreLoginException("FSPreLogin::FSLoginHelperException");
        }
    }

    public Map doPreLogin(Map map) {
        return map;
    }

    public void doPreLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string;
            String string2;
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::Entered doPreLogin");
            }
            this.httpRequest = httpServletRequest;
            this.httpResponse = httpServletResponse;
            Cookie[] cookieArray = CookieUtils.getCookieArrayFromReq((HttpServletRequest)httpServletRequest);
            boolean bl = false;
            boolean bl2 = true;
            amserverURI = FSServiceUtils.getBaseURL(httpServletRequest);
            postLoginURL = amserverURI + "/postLogin";
            loginURL = amserverURI + "/UI/Login";
            this.gotoOnFedCookieNoURL = httpServletRequest.getParameter("gotoOnFedCookieNo");
            if (messageEnabled) {
                FSUtils.debug.message("FSPreLogin::gotoOnFedCookieNoURL=" + this.gotoOnFedCookieNoURL);
            }
            this.printAllVarSet();
            String string3 = new String();
            Map map = new HashMap();
            String string4 = httpServletRequest.getParameter(metaAliasKey);
            Map map2 = this.getCookieMap(cookieArray);
            this.setAllianceInfo(string4);
            if (!this.isLibertyOn) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.Liberty off so returing to Login Page ");
                }
                string3 = loginURL + "?" + httpServletRequest.getQueryString();
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. returning with url " + string3);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                return;
            }
            if (LibertyManager.isLECPProfile(httpServletRequest)) {
                string2 = LibertyManager.getLECPHeaderName();
                string = httpServletRequest.getHeader(string2);
                httpServletResponse.setHeader(string2, string);
            }
            if (map2.containsKey(ISCookieName) && this.validateISCookie((String)map2.get(ISCookieName))) {
                bl = true;
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. Access Manager Token is valid");
                }
            }
            if (map2.containsKey(fedCookieName)) {
                this.isFedCookiePresent = true;
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. fedCookie is present");
                }
            }
            if (map2.containsKey(fedCookieName) && ((String)map2.get(fedCookieName)).equalsIgnoreCase("no")) {
                bl2 = false;
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. fedCookie is no");
                }
            }
            if (this.doLocalAuth) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. do local auth is true ");
                }
                string3 = this.getLoginURL(false, string4);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. returning with url " + string3);
                }
                httpServletResponse.sendRedirect(string3);
                return;
            }
            if (bl && bl2) {
                if (httpServletRequest.getParameter(authLevelKey) != null) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken valid and fedcookie yes and dolocalauth false and authLevel present");
                    }
                    string2 = httpServletRequest.getSession();
                    string2.setAttribute(authLevelKey, (Object)httpServletRequest.getParameter(authLevelKey));
                    map = this.createSSOMap(httpServletRequest.getParameter(authLevelKey), string4);
                    if (map == null) {
                        return;
                    }
                    this.setRespone(httpServletResponse, map);
                    string = (String)map.get("responseData");
                    if (string != null && !string.equals("")) {
                        httpServletResponse.getOutputStream().write(string.getBytes());
                        httpServletResponse.flushBuffer();
                        return;
                    }
                    string3 = (String)map.get(URLKey);
                    if (messageEnabled) {
                        FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + string3);
                    }
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                    return;
                }
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken valid andfedcookie yes and dolocalauth false and authLevel not present");
                }
                string3 = this.getLoginURL(true, string4);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + string3);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                return;
            }
            if (bl && !bl2) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken valid and fedcookie is no");
                }
                if (httpServletRequest.getParameter(authLevelKey) != null) {
                    string2 = httpServletRequest.getSession();
                    string2.setAttribute(authLevelKey, (Object)httpServletRequest.getParameter(authLevelKey));
                }
                if (this.gotoOnFedCookieNoURL != null) {
                    httpServletResponse.sendRedirect(this.gotoOnFedCookieNoURL);
                    return;
                }
                string3 = this.getLoginURL(false, string4);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + string3);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                return;
            }
            if (!bl && bl2) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken invalid andfedcookie yes");
                }
                if (httpServletRequest.getParameter(authLevelKey) != null) {
                    string2 = httpServletRequest.getSession();
                    string2.setAttribute(authLevelKey, (Object)httpServletRequest.getParameter(authLevelKey));
                }
                if ((map = this.createSSOMap(httpServletRequest.getParameter(authLevelKey), string4)) == null) {
                    return;
                }
                this.setRespone(httpServletResponse, map);
                string2 = (String)map.get("responseData");
                if (string2 != null && !string2.equals("")) {
                    httpServletResponse.getOutputStream().write(string2.getBytes());
                    httpServletResponse.flushBuffer();
                    return;
                }
                string3 = (String)map.get(URLKey);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + string3);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                return;
            }
            if (!bl && !bl2) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken invalid andfedcookie no");
                }
                if (httpServletRequest.getParameter(authLevelKey) != null) {
                    string2 = httpServletRequest.getSession();
                    string2.setAttribute(authLevelKey, (Object)httpServletRequest.getParameter(authLevelKey));
                }
                if (this.gotoOnFedCookieNoURL != null) {
                    httpServletResponse.sendRedirect(this.gotoOnFedCookieNoURL);
                    return;
                }
                string3 = this.getLoginURL(false, string4);
                if (messageEnabled) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + string3);
                }
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string3);
                return;
            }
        }
        catch (FSPreLoginException fSPreLoginException) {
            FSUtils.debug.error("FSPreLogin::Exception in doPrelogin. ", (Throwable)((Object)fSPreLoginException));
            this.sendError(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPreLogin::Exception in doPrelogin. ", (Throwable)exception);
            this.sendError(httpServletRequest, httpServletResponse);
        }
    }

    static {
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
        allianceManager = FSServiceUtils.getAllianceInstance();
    }
}

