/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.IntegerValidator;
import com.sun.identity.common.validation.URLValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.common.validation.XSDateTimeValidator;
import com.sun.identity.common.validation.XSDurationValidator;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSProviderDescriptor {
    protected String entityID = null;
    protected String providerID = null;
    protected String providerName = null;
    protected String providerStatus = null;
    protected String providerType = null;
    protected String providerRole = null;
    protected Set listOfCOTs = null;
    protected String providerSuccinctID = null;
    protected String keyInfo = null;
    protected String encryptionKeyAlias = null;
    protected String keyUse = null;
    protected String encryptMethod = null;
    protected String keySize = null;
    protected String SOAPEndPoint = null;
    protected String SLOServiceURL = null;
    protected String SLOServiceReturnURL = null;
    protected String federationTerminationServiceURL = null;
    protected String federationTerminationServiceReturnURL = null;
    protected String assertionConsumerServiceURL = null;
    protected Set federationTerminationProtocolProfile = null;
    protected Set SLOProtocolProfile = null;
    protected Set nameRegistrationProfile = null;
    protected String nameRegistrationURL = null;
    protected String nameRegistrationReturnURL = null;
    protected boolean authnRequestSigned = false;
    protected boolean nameRegistrationAfterSSO = false;
    protected String SSOServiceURL = null;
    protected boolean nameRegistrationIndicator = false;
    protected boolean isProxyEnabled = false;
    protected boolean introductionProxy = false;
    protected boolean affiliationFed = false;
    protected Set nameIdMappingEncryptionProfile = null;
    protected Set listOfNameIdMapBinds = null;
    protected Set addMetaLocn = null;
    protected Map contactPerson = null;
    private int cpMaxNum = 0;
    protected FSOrganization organization = null;
    protected String extension = null;
    protected String signCertAlias = null;
    protected String validUtil = null;
    protected String cacheDuration = null;
    protected String preferProtSuppEnum = null;
    protected String protSuppEnum = null;
    protected Set proxyIDPs = null;
    protected int proxyCount = -1;
    protected String nameIDPolicy = null;
    protected boolean enableEncryption = false;
    protected boolean generateBootstrapping = true;
    protected String assertionConsumerServiceURLId = null;
    protected boolean assertionConsumerServiceURLIsDefault = false;
    protected String AuthnServiceURL = null;
    protected Set singleSignonProtocolProfile = null;
    private int beginIndex = "ContactPerson".length();

    public FSProviderDescriptor(String string, String string2) throws FSAllianceManagementException {
        this.setProviderID(string);
        this.setProviderStatus(string2);
        this.setProviderSuccinctID(this.generateSuccinctID(string));
    }

    public FSProviderDescriptor(String string, String string2, String string3) throws FSAllianceManagementException {
        this(string, string2);
        this.setProviderRole(string3);
    }

    private boolean getBooleanValue(Map map, String string) {
        String string2 = FSAllianceManagementUtils.getFirstEntry(map, string);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    FSProviderDescriptor(String string, Map map) throws FSAllianceManagementException {
        this.setProviderID(string);
        this.setCommonAttributes(map);
        this.setCommunicationURLs(map);
        this.setCommunicationProfiles(map);
        this.setServiceProvider(map);
        this.setAdditionalMetaLocation((Set)map.get("sunIdentityServerAdditionalMetaLocation"));
        this.setNameIdMapBind((Set)map.get("sunIdentityServerNameIdentifierMappingBinding"));
        this.setExtension(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerExtension"));
        this.setSignCertAlias(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerSignatureCertAlias"));
    }

    private void setCommonAttributes(Map map) throws FSAllianceManagementException {
        this.setProviderName(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-name"));
        this.setProviderStatus(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-status"));
        this.setProviderSuccinctID(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-succinctid"));
        this.setProviderType(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-type"));
        this.setProviderRole(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-role"));
        this.setListOfCOTs((Set)map.get("iplanet-am-list-of-authenticationdomains"));
        this.setSigningKeyAlias(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-certificate-alias"));
        this.setEncryptionKeyAlias(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEncryptionKeyalias"));
        this.setKeyUse(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerKeyUse"));
        this.setEncryptionKeySize(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerKeySize"));
        this.setEncryptionKeyMethod(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEncryptionMethod"));
        this.setValidUntil(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerValidUntil"));
        this.setCacheDuration(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerCacheDuration"));
        this.setProtocolSuppEnum(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProtocolSupportEnum"));
    }

    private void setCommunicationURLs(Map map) throws FSAllianceManagementException {
        this.setSOAPEndPoint(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-soap-end-point"));
        this.setSLOServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-url"));
        this.setSLOServiceReturnURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-return-url"));
        this.setFederationTerminationServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-url"));
        this.setFederationTerminationServiceReturnURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-return-url"));
        this.setAssertionConsumerServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-consumer-service-url"));
        this.setAssertionConsumerServiceURLId(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAssertionConsumerServiceUrlId"));
        this.setAssertionConsumerServiceURLIsDefault(this.getBooleanValue(map, "sunIdentityServerAssertionConsumerServiceUrlisDefault"));
        this.setNameRegistrationURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-url"));
        this.setNameRegistrationReturnURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-return-url"));
        this.setSSOServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-sso-service-url"));
        this.setAuthnServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAuthnServiceUrl"));
    }

    private void setCommunicationProfiles(Map map) throws FSAllianceManagementException {
        this.setFederationTerminationProtocolProfile((Set)map.get("iplanet-am-federation-termination-protocol-profile"));
        this.setSLOProtocolProfile((Set)map.get("iplanet-am-slo-protocol-profile"));
        this.setNameRegistrationProfile((Set)map.get("iplanet-am-name-registration-profile"));
        this.setNameIdentifierMappingEncryptionProfile((Set)map.get("sunIdentityServerNameIdMappingEncryptionProfile"));
    }

    private void setServiceProvider(Map map) throws FSAllianceManagementException {
        this.setAuthnRequestSigned(this.getBooleanValue(map, "iplanet-am-authnrequest-signed"));
        this.setNameRegistrationAfterSSO(this.getBooleanValue(map, "iplanet-am-name-registration-after-sso"));
        this.setNameRegistrationIndicator(this.getBooleanValue(map, "iplanet-am-name-registration-indicator"));
        this.setProxyEnabled(this.getBooleanValue(map, "sunIdentityServerProviderEnableProxy"));
        this.setIntroductionForProxy(this.getBooleanValue(map, "sunIdentityServerIntroductionForProxying"));
        this.setAffiliationFederation(this.getBooleanValue(map, "sunIdentityServerAffiliationFederation"));
        this.setNameIdentifierEncryption(this.getBooleanValue(map, "sunIdentityServerNameIdentifierEncryption"));
        this.setGenerateBootstrappingResourceOffering(this.getBooleanValue(map, "sunIdentityServerBootstrapping"));
        this.setProxyIDPs((Set)map.get("sunIdentityServerProviderProxies"));
        this.setProxyCount(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderProxyCount"));
        this.setSingleSignOnProtocolProfile((Set)map.get("sunIdentityServerSingleSignOnProtocolprofile"));
        this.setNameIDPolicy(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerNameIDPolicy"));
    }

    String getProviderType() {
        return this.providerType;
    }

    void setProviderType(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("hosted") && !string.equalsIgnoreCase("remote")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerType = string;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getProviderUniqueID() {
        if (this.providerID.endsWith("|" + this.providerRole)) {
            return this.providerID;
        }
        return this.providerID + "|" + this.providerRole;
    }

    public void setProviderID(String string) throws FSInvalidNameException {
        if (string == null || string.trim().length() == 0) {
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        this.providerID = string;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderStatus() {
        return this.providerStatus;
    }

    public String getProviderRole() {
        return this.providerRole;
    }

    public String getSigningKeyAlias() {
        return this.keyInfo;
    }

    public String getEncryptionKeyAlias() {
        return this.encryptionKeyAlias;
    }

    public String getEncryptionKeyMethod() {
        return this.encryptMethod;
    }

    public String getKeyUse() {
        return this.keyUse;
    }

    public int getEncryptionKeySize() {
        int n = -1;
        if (this.keySize != null) {
            try {
                n = Integer.parseInt(this.keySize);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public String getProviderSuccinctID() {
        return this.providerSuccinctID;
    }

    public Set getListOfCOTs() {
        return this.listOfCOTs;
    }

    public String getSLOServiceURL() {
        return this.SLOServiceURL;
    }

    public Set getNameIdentifierMappingEncryptionProfileSet() {
        return this.nameIdMappingEncryptionProfile;
    }

    public String getNameIdentifierMappingEncryptionProfile() {
        String string = null;
        if (this.nameIdMappingEncryptionProfile != null && !this.nameIdMappingEncryptionProfile.isEmpty()) {
            string = (String)this.nameIdMappingEncryptionProfile.iterator().next();
        }
        return string;
    }

    public Set getNameIdMapBind() {
        return this.listOfNameIdMapBinds;
    }

    public FSOrganization getOrganization() {
        return this.organization;
    }

    public Set getAdditionalMetaLocation() {
        return this.addMetaLocn;
    }

    public Set getContactPerson() {
        if (this.contactPerson != null && !this.contactPerson.isEmpty()) {
            return this.contactPerson.entrySet();
        }
        return null;
    }

    public Set getContactPersonId() {
        if (this.contactPerson != null && !this.contactPerson.isEmpty()) {
            return this.contactPerson.keySet();
        }
        return null;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSignCertAlias() {
        return this.signCertAlias;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public String getProtocolSupportEnum() {
        return this.protSuppEnum;
    }

    public int getMinorVersion() {
        int n = 0;
        String string = this.getProtocolSupportEnum();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("getMinorVersion:null protcolSuppEnum.");
            }
        } else if (string.equalsIgnoreCase("urn:liberty:iff:2002-12")) {
            n = 0;
        } else if (string.equalsIgnoreCase("urn:liberty:iff:2003-08")) {
            n = 2;
        }
        return n;
    }

    public String getSLOServiceReturnURL() {
        return this.SLOServiceReturnURL;
    }

    public Set getNameRegistrationProfileSet() {
        return this.nameRegistrationProfile;
    }

    public String getNameRegistrationProfile() {
        String string = null;
        if (this.nameRegistrationProfile != null && !this.nameRegistrationProfile.isEmpty()) {
            string = (String)this.nameRegistrationProfile.iterator().next();
        }
        return string;
    }

    public String getNameRegistrationURL() {
        return this.nameRegistrationURL;
    }

    public String getNameRegistrationReturnURL() {
        return this.nameRegistrationReturnURL;
    }

    public String getSOAPEndPoint() {
        return this.SOAPEndPoint;
    }

    public String getFederationTerminationServiceURL() {
        return this.federationTerminationServiceURL;
    }

    public String getFederationTerminationServiceReturnURL() {
        return this.federationTerminationServiceReturnURL;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getAssertionConsumerServiceURLId() {
        return this.assertionConsumerServiceURLId;
    }

    public boolean getAssertionConsumerServiceURLIsDefault() {
        return this.assertionConsumerServiceURLIsDefault;
    }

    public Set getFederationTerminationProtocolProfileSet() {
        return this.federationTerminationProtocolProfile;
    }

    public String getFederationTerminationProtocolProfile() {
        String string = null;
        if (this.federationTerminationProtocolProfile != null && !this.federationTerminationProtocolProfile.isEmpty()) {
            string = (String)this.federationTerminationProtocolProfile.iterator().next();
        }
        return string;
    }

    public Set getSLOProtocolProfileSet() {
        return this.SLOProtocolProfile;
    }

    public String getSLOProtocolProfile() {
        String string = null;
        if (this.SLOProtocolProfile != null && !this.SLOProtocolProfile.isEmpty()) {
            string = (String)this.SLOProtocolProfile.iterator().next();
        }
        return string;
    }

    public boolean getAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public boolean getNameRegistrationAfterSSO() {
        return this.nameRegistrationAfterSSO;
    }

    public boolean getNameRegistrationIndicator() {
        return this.nameRegistrationIndicator;
    }

    public Set getSingleSignOnProtocolProfileSet() {
        return this.singleSignonProtocolProfile;
    }

    public String getSingleSignOnProtocolProfile() {
        String string = null;
        if (this.singleSignonProtocolProfile != null && !this.singleSignonProtocolProfile.isEmpty()) {
            string = (String)this.singleSignonProtocolProfile.iterator().next();
        }
        return string;
    }

    public void setSingleSignOnProtocolProfile(Set set) throws FSAllianceManagementException {
        boolean bl;
        String string = this.getProviderRole();
        boolean bl2 = bl = string != null && !string.equalsIgnoreCase("SP");
        if (bl && (set == null || set.isEmpty())) {
            throw new FSAllianceManagementException("alliance_management_invalid_sso_protocol_profile", null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (this.isSingleSignOnProtocolProfileValid((String)iterator.next())) continue;
            throw new FSAllianceManagementException("alliance_management_invalid_sso_protocol_profile", null);
        }
        this.singleSignonProtocolProfile = set;
    }

    private boolean isSingleSignOnProtocolProfileValid(String string) {
        return string.equalsIgnoreCase("http://projectliberty.org/profiles/lecp") || string.equalsIgnoreCase("http://projectliberty.org/profiles/brws-post") || string.equalsIgnoreCase("http://projectliberty.org/profiles/brws-art");
    }

    public void setSingleSignOnProtocolProfile(String string) throws FSAllianceManagementException {
        if (!this.isSingleSignOnProtocolProfileValid(string)) {
            throw new FSAllianceManagementException("alliance_management_invalid_sso_protocol_profile", null);
        }
        if (this.singleSignonProtocolProfile == null) {
            this.singleSignonProtocolProfile = new HashSet();
        }
        if (!this.singleSignonProtocolProfile.isEmpty()) {
            this.singleSignonProtocolProfile.clear();
        }
        this.singleSignonProtocolProfile.add(string);
    }

    public void setNameRegistrationIndicator(boolean bl) {
        this.nameRegistrationIndicator = bl;
    }

    public String getSSOServiceURL() {
        return this.SSOServiceURL;
    }

    public String getAuthnServiceURL() {
        return this.AuthnServiceURL;
    }

    public String getNameIDPolicy() {
        return this.nameIDPolicy;
    }

    public void setNameIDPolicy(String string) throws FSAllianceManagementException {
        if (!(string == null || string.equalsIgnoreCase("none") || string.equalsIgnoreCase("onetime") || string.equalsIgnoreCase("federated"))) {
            throw new FSAllianceManagementException("alliance_management_invalid_name_id_policy", null);
        }
        this.nameIDPolicy = string;
    }

    public void setProviderName(String string) {
        this.providerName = string;
    }

    public void setProviderStatus(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("inactive")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerStatus = string;
    }

    public void setProviderRole(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("SP") && !string.equalsIgnoreCase("IDP") && !string.equalsIgnoreCase("IDP/SP")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerRole = string;
    }

    public void setSigningKeyAlias(String string) {
        this.keyInfo = string;
    }

    public void setEncryptionKeyAlias(String string) {
        this.encryptionKeyAlias = string;
    }

    public void setEncryptionKeyMethod(String string) {
        this.encryptMethod = string;
    }

    public void setKeyUse(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("signing") && !string.equalsIgnoreCase("encryption")) {
            throw new FSAllianceManagementException("alliance_management_invalid_key_usage", null);
        }
        this.keyUse = string;
    }

    public void setEncryptionKeySize(int n) throws FSAllianceManagementException {
        this.keySize = Integer.toString(n);
    }

    public void setEncryptionKeySize(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            IntegerValidator integerValidator = IntegerValidator.getInstance();
            try {
                integerValidator.validate(string);
                this.keySize = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_key_size", null);
            }
        } else {
            this.keySize = null;
        }
    }

    public void setListOfCOTs(Set set) {
        this.listOfCOTs = set;
    }

    public void setSLOServiceURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.SLOServiceURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSInvalidNameException("alliance_management_invalid_single_out_service_url", null);
            }
        } else {
            this.SLOServiceURL = null;
        }
    }

    public void setNameIdentifierMappingEncryptionProfile(Set set) {
        this.nameIdMappingEncryptionProfile = set;
    }

    public void setNameIdentifierMappingEncryptionProfile(String string) {
        if (this.nameIdMappingEncryptionProfile == null) {
            this.nameIdMappingEncryptionProfile = new HashSet();
        }
        if (!this.nameIdMappingEncryptionProfile.isEmpty()) {
            this.nameIdMappingEncryptionProfile.clear();
        }
        this.nameIdMappingEncryptionProfile.add(string);
    }

    public void setNameIdMapBind(Set set) {
        this.listOfNameIdMapBinds = set == null ? new HashSet() : set;
    }

    public void setOrganization(FSOrganization fSOrganization) {
        this.organization = fSOrganization;
    }

    public boolean addContactPerson(FSContactPerson fSContactPerson, boolean bl) {
        if (this.contactPerson == null) {
            this.contactPerson = new HashMap();
        }
        if (!fSContactPerson.getCPID().startsWith("ContactPerson")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("ContactPerson id should startwith ContactPerson.");
            }
            return false;
        }
        Set set = this.contactPerson.keySet();
        String string = null;
        try {
            string = fSContactPerson.getCPID().substring(this.beginIndex);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("addContactPerson: NumberFormatException" + numberFormatException.getMessage());
            }
            return false;
        }
        if (set != null && !set.isEmpty() && set.contains(string)) {
            if (bl) {
                this.contactPerson.remove(string);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("ContactPerson existed. SuggestcpId=ContactPerson" + new Integer(++this.cpMaxNum).toString());
                }
                return false;
            }
        }
        this.contactPerson.put(string, fSContactPerson);
        if (Integer.parseInt(string) > this.cpMaxNum) {
            this.cpMaxNum = Integer.parseInt(string);
        }
        return true;
    }

    public void setAdditionalMetaLocation(Set set) {
        this.addMetaLocn = set == null ? new HashSet() : set;
    }

    public boolean setContactPerson(List list) {
        return this.setContactPerson(list, true);
    }

    public boolean setContactPerson(List list, boolean bl) {
        boolean bl2 = false;
        if (list != null && !list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                if (!this.addContactPerson((FSContactPerson)list.get(n), bl)) {
                    return false;
                }
                ++n;
            }
        } else {
            this.contactPerson = null;
        }
        return true;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setSignCertAlias(String string) {
        this.signCertAlias = string;
    }

    public void setValidUntil(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            XSDateTimeValidator xSDateTimeValidator = XSDateTimeValidator.getInstance();
            try {
                xSDateTimeValidator.validate(string);
                this.validUtil = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_valid_until", null);
            }
        } else {
            this.validUtil = null;
        }
    }

    public void setCacheDuration(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            XSDurationValidator xSDurationValidator = XSDurationValidator.getInstance();
            try {
                xSDurationValidator.validate(string);
                this.cacheDuration = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_cache_duration", null);
            }
        } else {
            this.cacheDuration = null;
        }
    }

    public void setProtocolSuppEnum(String string) throws FSAllianceManagementException {
        if (!this.isValidProtocolSuppEnum(string)) {
            throw new FSAllianceManagementException("alliance_management_invalid_protocol_support_enum", null);
        }
        this.protSuppEnum = string;
    }

    private boolean isValidProtocolSuppEnum(String string) {
        return string != null && string.equalsIgnoreCase("urn:liberty:iff:2002-12") || string.equalsIgnoreCase("urn:liberty:iff:2003-08");
    }

    public void setSLOServiceReturnURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.SLOServiceReturnURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSInvalidNameException("alliance_management_invalid_single_logout_service_return_url", null);
            }
        } else {
            this.SLOServiceReturnURL = null;
        }
    }

    public void setNameRegistrationProfile(Set set) {
        this.nameRegistrationProfile = set;
    }

    public void setNameRegistrationProfile(String string) {
        if (this.nameRegistrationProfile == null) {
            this.nameRegistrationProfile = new HashSet();
        }
        if (!this.nameRegistrationProfile.isEmpty()) {
            this.nameRegistrationProfile.clear();
        }
        this.nameRegistrationProfile.add(string);
    }

    public void setNameRegistrationURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.nameRegistrationURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_name_registration_url", null);
            }
        } else {
            this.nameRegistrationURL = null;
        }
    }

    public void setNameRegistrationReturnURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.nameRegistrationReturnURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_name_registration_return_url", null);
            }
        } else {
            this.nameRegistrationReturnURL = null;
        }
    }

    public void setSOAPEndPoint(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.SOAPEndPoint = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_soap_endpoint", null);
            }
        } else {
            this.SOAPEndPoint = null;
        }
    }

    public void setFederationTerminationServiceURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.federationTerminationServiceURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_fed_termination_service_url", null);
            }
        } else {
            this.federationTerminationServiceURL = null;
        }
    }

    public void setFederationTerminationServiceReturnURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
                this.federationTerminationServiceReturnURL = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_fed_termination_service_return_url", null);
            }
        } else {
            this.federationTerminationServiceReturnURL = null;
        }
    }

    public void setAssertionConsumerServiceURL(String string) throws FSAllianceManagementException {
        boolean bl;
        String string2 = this.getProviderRole();
        boolean bl2 = bl = string2 != null && !string2.equalsIgnoreCase("SP");
        if (!bl) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_assertion_consumer_service_url", null);
            }
        }
        this.assertionConsumerServiceURL = string;
    }

    public void setAssertionConsumerServiceURLId(String string) throws FSAllianceManagementException {
        boolean bl;
        String string2 = this.getProviderRole();
        boolean bl2 = bl = string2 != null && !string2.equalsIgnoreCase("SP");
        if (!bl && this.preferProtSuppEnum != null && this.preferProtSuppEnum.equals("urn:liberty:iff:2003-08") && (string == null || string.trim().length() == 0)) {
            throw new FSAllianceManagementException("alliance_management_missing_assertion_consumer_service_url_id", null);
        }
        this.assertionConsumerServiceURLId = string;
    }

    public void setAssertionConsumerServiceURLIsDefault(boolean bl) {
        this.assertionConsumerServiceURLIsDefault = bl;
    }

    public void setFederationTerminationProtocolProfile(Set set) {
        this.federationTerminationProtocolProfile = set;
    }

    public void setFederationTerminationProtocolProfile(String string) {
        if (this.federationTerminationProtocolProfile == null) {
            this.federationTerminationProtocolProfile = new HashSet();
        }
        if (!this.federationTerminationProtocolProfile.isEmpty()) {
            this.federationTerminationProtocolProfile.clear();
        }
        this.federationTerminationProtocolProfile.add(string);
    }

    public void setSLOProtocolProfile(Set set) {
        this.SLOProtocolProfile = set;
    }

    public void setSLOProtocolProfile(String string) {
        if (this.SLOProtocolProfile == null) {
            this.SLOProtocolProfile = new HashSet();
        }
        if (!this.SLOProtocolProfile.isEmpty()) {
            this.SLOProtocolProfile.clear();
        }
        this.SLOProtocolProfile.add(string);
    }

    public void setAuthnRequestSigned(boolean bl) {
        this.authnRequestSigned = bl;
    }

    public void setNameRegistrationAfterSSO(boolean bl) {
        this.nameRegistrationAfterSSO = bl;
    }

    public void setSSOServiceURL(String string) throws FSAllianceManagementException {
        boolean bl;
        String string2 = this.getProviderRole();
        boolean bl2 = bl = string2 != null && !string2.equalsIgnoreCase("SP");
        if (bl) {
            if (string == null || string.trim().length() == 0) {
                throw new FSAllianceManagementException("alliance_management_missing_sso_service_url", null);
            }
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_sso_service_url", null);
            }
            this.SSOServiceURL = string;
        }
    }

    public void setAuthnServiceURL(String string) throws FSAllianceManagementException {
        boolean bl;
        String string2 = this.getProviderRole();
        boolean bl2 = bl = string2 != null && !string2.equalsIgnoreCase("SP");
        if (bl) {
            if (string == null || string.trim().length() == 0) {
                this.AuthnServiceURL = null;
            } else {
                URLValidator uRLValidator = URLValidator.getInstance();
                try {
                    uRLValidator.validate(string);
                }
                catch (ValidationException validationException) {
                    throw new FSAllianceManagementException("alliance_management_invalid_authn_service_url", null);
                }
                this.AuthnServiceURL = string;
            }
        }
    }

    public void setProviderSuccinctID(String string) {
        this.providerSuccinctID = string;
    }

    Map getAttributes() {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-name", this.providerName);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-status", this.providerStatus);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-type", this.providerType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-role", this.providerRole);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-succinctid", this.providerSuccinctID);
        if (this.listOfCOTs != null) {
            hashMap.put("iplanet-am-list-of-authenticationdomains", this.listOfCOTs);
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-certificate-alias", this.keyInfo);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerKeyUse", this.keyUse);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerKeySize", this.keySize);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEncryptionMethod", this.encryptMethod);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEncryptionKeyalias", this.encryptionKeyAlias);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-soap-end-point", this.SOAPEndPoint);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-url", this.SLOServiceURL);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerAdditionalMetaLocation", this.addMetaLocn);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerNameIdentifierMappingBinding", this.listOfNameIdMapBinds);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerNameIdMappingEncryptionProfile", this.nameIdMappingEncryptionProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerExtension", this.extension);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerSignatureCertAlias", this.signCertAlias);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerCacheDuration", this.cacheDuration);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProtocolSupportEnum", this.protSuppEnum);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-return-url", this.SLOServiceReturnURL);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-name-registration-profile", this.nameRegistrationProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-url", this.nameRegistrationURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-return-url", this.nameRegistrationReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-url", this.federationTerminationServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-return-url", this.federationTerminationServiceReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-consumer-service-url", this.assertionConsumerServiceURL);
        String string = this.assertionConsumerServiceURLIsDefault ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAssertionConsumerServiceUrlisDefault", string);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAssertionConsumerServiceUrlId", this.assertionConsumerServiceURLId);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-federation-termination-protocol-profile", this.federationTerminationProtocolProfile);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-slo-protocol-profile", this.SLOProtocolProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-sso-service-url", this.SSOServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAuthnServiceUrl", this.AuthnServiceURL);
        String string2 = this.authnRequestSigned ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authnrequest-signed", string2);
        String string3 = this.nameRegistrationAfterSSO ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-after-sso", string3);
        String string4 = this.nameRegistrationIndicator ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-indicator", string4);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerSingleSignOnProtocolprofile", this.singleSignonProtocolProfile);
        String string5 = this.isProxyEnabled ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderEnableProxy", string5);
        String string6 = this.introductionProxy ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerIntroductionForProxying", string6);
        String string7 = this.affiliationFed ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationFederation", string7);
        String string8 = this.enableEncryption ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerNameIdentifierEncryption", string8);
        String string9 = this.generateBootstrapping ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerBootstrapping", string9);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderProxies", this.proxyIDPs);
        if (this.proxyCount != -1) {
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderProxyCount", Integer.toString(this.proxyCount));
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerNameIDPolicy", this.nameIDPolicy);
        return hashMap;
    }

    public String generateSuccinctID(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = -1;
        if (string.endsWith("|SP") && (n = string.indexOf("|SP")) != -1) {
            string = string.substring(0, n);
        } else if (string.endsWith("|IDP") && (n = string.indexOf("|IDP")) != -1) {
            string = string.substring(0, n);
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = null;
        string2 = SAMLUtilsCommon.byteArrayToHexString(byArray2);
        return string2;
    }

    public boolean getProxyEnabled() {
        return this.isProxyEnabled;
    }

    public void setProxyEnabled(boolean bl) {
        this.isProxyEnabled = bl;
    }

    public Set getProxyIDPs() {
        return this.proxyIDPs;
    }

    public void setProxyIDPs(Set set) {
        this.proxyIDPs = set;
    }

    public void setProxyCount(int n) {
        this.proxyCount = n;
    }

    public void setProxyCount(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            IntegerValidator integerValidator = IntegerValidator.getInstance();
            try {
                integerValidator.validate(string);
                this.proxyCount = Integer.parseInt(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_proxy_count", null);
            }
        } else {
            this.proxyCount = -1;
        }
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    public boolean isIntroductionForProxying() {
        return this.introductionProxy;
    }

    public void setIntroductionForProxy(boolean bl) {
        this.introductionProxy = bl;
    }

    public boolean isAffiliationFederation() {
        return this.affiliationFed;
    }

    public void setAffiliationFederation(boolean bl) {
        this.affiliationFed = bl;
    }

    public boolean getNameIdentifierEncryption() {
        return this.enableEncryption;
    }

    public void setNameIdentifierEncryption(boolean bl) {
        this.enableEncryption = bl;
    }

    public boolean getGenerateBootstrappingResourceOffering() {
        return this.generateBootstrapping;
    }

    public void setGenerateBootstrappingResourceOffering(boolean bl) {
        this.generateBootstrapping = bl;
    }

    public String getEntityID() {
        if (this.entityID != null) {
            return this.entityID;
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            this.entityID = fSAllianceManager.getParentEntity(this.providerID).getEntityID();
            return this.entityID;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSProviderDescriptor.getEntityID: Exception in getting the parent entityID.", (Throwable)exception);
            return null;
        }
    }
}

