/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSCache;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public final class FSAllianceManager {
    private String orgDN = null;
    private SSOToken token = null;
    private ServiceConfigManager providerManager = null;
    private ServiceConfigManager authDomainManager = null;
    private ServiceConfig authDomainConfig = null;
    private ServiceConfig entityConfig = null;
    private ServiceConfig contactConfig = null;
    private ServiceConfig orgConfig = null;
    private boolean messageEnabled = false;
    private Map idMapEntityID = null;
    private static boolean cacheOn = true;
    private int revisionNumber = 0;

    public FSAllianceManager(SSOToken sSOToken) throws FSAllianceManagementException {
        this(sSOToken, SystemProperties.get((String)"com.iplanet.am.defaultOrg"));
        FSUtils.debug.message("FSAllianceManager::Constructor with ssoToken only");
    }

    public FSAllianceManager(SSOToken sSOToken, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager.<init> orgDN invalid");
            throw new FSAllianceManagementException("alliance_management_org_exception", null);
        }
        if (sSOToken == null) {
            FSUtils.debug.error("FSAllianceManager.<init> ssoToken is null");
            throw new FSAllianceManagementException("alliance_management_sso_exception", null);
        }
        this.token = sSOToken;
        this.messageEnabled = FSUtils.debug.messageEnabled();
        try {
            this.getAuthDomainServiceConfigManager(string);
            this.getProviderServiceConfigManager(string);
            this.getEntityServiceConfigManager(string);
            FSUtils.debug.message("FSAllianceManager.<init> Finished entityConfig");
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager,<init>", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.<init>", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
    }

    private void getAuthDomainServiceConfigManager(String string) throws SMSException, SSOException, FSAllianceManagementException {
        this.authDomainManager = new ServiceConfigManager(this.token, "iPlanetAMAuthenticationDomainConfigService", "1.0");
        if (this.authDomainManager != null) {
            this.authDomainConfig = this.authDomainManager.getOrganizationConfig(string, null);
        }
        if (this.authDomainConfig == null) {
            FSUtils.debug.error("FSAllianceManager.<init> Service Configuration not done properly for iPlanetAMAuthenticationDomainConfigServiceservice");
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
        FSUtils.debug.message("FSAllianceManager.<init> Finished AuthDomainConfig");
    }

    private void getProviderServiceConfigManager(String string) throws SMSException, SSOException, FSAllianceManagementException {
        this.providerManager = new ServiceConfigManager(this.token, "iPlanetAMProviderConfigService", "1.1");
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(this.token, "iPlanetAMProviderConfigService", "1.1");
        this.revisionNumber = serviceSchemaManager.getRevisionNumber();
        if (this.providerManager == null) {
            FSUtils.debug.error("FSAllianceManager.<init> Service Configuration not done correctly for iPlanetAMProviderConfigServiceService");
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
    }

    private void getEntityServiceConfigManager(String string) throws SMSException, SSOException, FSAllianceManagementException {
        this.entityConfig = this.providerManager.getOrganizationConfig(string, null);
        if (this.entityConfig == null) {
            this.providerManager.createOrganizationConfig(string, null);
            this.entityConfig = this.providerManager.getOrganizationConfig(string, null);
        }
        if (this.entityConfig == null) {
            FSUtils.debug.error("FSAllianceManager.<init> Service Configuration not done correctly for iPlanetAMProviderConfigServiceService");
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
    }

    public void createCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSInvalidNameException, FSAllianceManagementException {
        if (fSCircleOfTrustDescriptor == null) {
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        String string = fSCircleOfTrustDescriptor.getCircleOfTrustName();
        if (string == null || string.trim().length() == 0) {
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        if (this.getAllCirclesOfTrust().contains(string)) {
            if (FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSAllianceManager.createCircleOfTrust:   authentication domain already exists.");
            }
            throw new FSAllianceManagementException("alliance_management_authdomain_exists", null);
        }
        Map map = fSCircleOfTrustDescriptor.getAttributes();
        try {
            this.authDomainConfig.addSubConfig(string, "AuthenticationDomain", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager.createCircleOfTrust created " + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "CREATE_AUTH_DOMAIN", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
    }

    public void deleteCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager.deleteCircleOfTrust  Name is null or authentication domain does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            this.authDomainConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager.deleteCircleOfTrust deleted " + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "DELETE_AUTH_DOMAIN", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.deleteCircleOfTrust", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
    }

    public void modifyCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSCircleOfTrustDescriptor == null) {
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        String string = fSCircleOfTrustDescriptor.getCircleOfTrustName();
        if (string == null || string.trim().length() == 0 || !this.getAllCirclesOfTrust().contains(string)) {
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.authDomainConfig.getSubConfig(string);
            serviceConfig.setAttributes(fSCircleOfTrustDescriptor.getAttributes());
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager.modifyCircleOfTrust modified " + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "MODIFY_AUTH_DOMAIN", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.modifyCircleOfTrust", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.modifyCircleOfTrust", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
    }

    public FSCircleOfTrustDescriptor getCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager.getCircleOfTrust Name of authentication domain is null or this does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.authDomainConfig.getSubConfig(string);
            return new FSCircleOfTrustDescriptor(string, serviceConfig.getAttributes());
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.getCircleOfTrust", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.getCircleOfTrust", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllCirclesOfTrust(String string) throws FSAllianceManagementException {
        Set set = null;
        try {
            set = string.equals("*") ? this.authDomainConfig.getSubConfigNames() : this.authDomainConfig.getSubConfigNames(string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.getCirclesOfTrust", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        return set;
    }

    public Set getAllActiveCirclesOfTrust() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.authDomainConfig.getSubConfigNames();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Map map = this.authDomainConfig.getSubConfig(string).getAttributes();
                    if (!FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authenticationdomain-status").equalsIgnoreCase("active")) continue;
                    hashSet.add(string);
                }
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.getCirclesOfTrust", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.getCirclesOfTrust", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        return hashSet;
    }

    public Set getAllCirclesOfTrust() throws FSAllianceManagementException {
        return this.getAllCirclesOfTrust("*");
    }

    public void deleteCirclesOfTrust(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteCircleOfTrust((String)iterator.next());
        }
    }

    public void createProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        ServiceConfig serviceConfig = null;
        if (fSProviderDescriptor == null) {
            throw new FSAllianceManagementException("Null input");
        }
        String string = fSProviderDescriptor.getProviderID();
        if (string == null) {
            throw new FSAllianceManagementException("Provider id is null.");
        }
        try {
            if (this.getAllEntityIds().contains(string)) {
                serviceConfig = this.entityConfig.getSubConfig(string);
            } else {
                this.entityConfig.addSubConfig(string, "EntityDescriptor", 0, null);
                FSUtils.debug.message("FSAllianceManager.createProvider Dummy Entity Node created");
                serviceConfig = this.entityConfig.getSubConfig(string);
            }
            this.createProvider(serviceConfig, fSProviderDescriptor);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createProvider could not create provider", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.createProvider could not create provider", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
    }

    public void createProvider(ServiceConfig serviceConfig, FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string = null;
        if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createProvider  ID in the given ProviderDescriptor is null");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        String string2 = fSProviderDescriptor.getProviderRole();
        if (!string2.equals("SP") && !string2.equals("IDP")) {
            FSUtils.debug.error("FSAllianceManager::createProvider Role in the given ProviderDescriptor is neither SP nor IDP");
            throw new FSInvalidNameException("alliance_management_providerrole_invalid", null);
        }
        String string3 = string + "|" + string2;
        if (this.getAllProviderIds().contains(string3)) {
            FSUtils.debug.error("FSAllianceManager::createProvider Provider already exists");
            throw new FSAllianceManagementException("alliance_management_provider_exists", null);
        }
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::createProvider valid provider ID");
        }
        Map map = fSProviderDescriptor.getAttributes();
        ServiceConfig serviceConfig2 = null;
        try {
            String[] stringArray;
            Object object;
            Object object2;
            Set set = fSProviderDescriptor.getListOfCOTs();
            if (!this.isValidCOTList(set)) {
                FSUtils.debug.error("FSAllianceManager.java:: createProvider ListOfCOTs invalid");
                throw new FSAllianceManagementException("cotlist_invalid", null);
            }
            if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSProviderDescriptor")) {
                map = fSProviderDescriptor.getAttributes();
                serviceConfig.addSubConfig(string3, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Remote Provider Node created");
                }
                object2 = new String[]{string3};
                LogUtil.access(Level.INFO, "CREATE_REMOTE_PROVIDER", (String[])object2, this.token);
            } else if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
                fSProviderDescriptor.setProviderType("hosted");
                map = fSProviderDescriptor.getAttributes();
                serviceConfig.addSubConfig(string3, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Created Hosted Provider General attrs nodeabout to set LocalConfiguration");
                }
                serviceConfig2 = serviceConfig.getSubConfig(string3);
                object2 = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration();
                if (object2 != null) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    if (((FSLocalConfigurationDescriptor)object2).getIsPassive() && ((FSLocalConfigurationDescriptor)object2).getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    object = ((FSLocalConfigurationDescriptor)object2).getTrustedProviders();
                    if (!this.isValidProviderList(set, (Set)object)) {
                        serviceConfig.removeSubConfig(string3);
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    serviceConfig2.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, ((FSLocalConfigurationDescriptor)object2).getAttributes(this.revisionNumber));
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider Finished setting LocalConfig");
                    }
                    stringArray = new String[]{string3};
                    LogUtil.access(Level.INFO, "CREATE_HOSTED_PROVIDER", stringArray, this.token);
                    ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig("LocalConfiguration");
                    Map map2 = ((FSLocalConfigurationDescriptor)object2).getSPAuthContextInfo();
                    if (map2 != null) {
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider SPAuthInfo is not null");
                        }
                        serviceConfig3.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                        object7 = serviceConfig3.getSubConfig("SPAuthenticationContextInfo");
                        object6 = map2.keySet();
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            object4 = (FSSPAuthenticationContextInfo)map2.get((String)object5.next());
                            if (object4 == null || (object3 = ((FSSPAuthenticationContextInfo)object4).getAuthenticationContext()) == null || ((String)object3).length() <= 0) continue;
                            ((ServiceConfig)object7).addSubConfig((String)object3, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object4).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider finished SPAuth information saved in DS");
                        }
                    }
                    if ((object7 = ((FSLocalConfigurationDescriptor)object2).getIDPAuthContextInfo()) != null) {
                        serviceConfig3.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                        object6 = serviceConfig3.getSubConfig("IDPAuthenticationContextInfo");
                        object5 = object7.keySet();
                        object4 = object5.iterator();
                        while (object4.hasNext()) {
                            String string4;
                            object3 = (FSIDPAuthenticationContextInfo)object7.get((String)object4.next());
                            if (object3 == null || (string4 = ((FSIDPAuthenticationContextInfo)object3).getAuthenticationContext()) == null || string4.length() <= 0) continue;
                            ((ServiceConfig)object6).addSubConfig(string4, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object3).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProviderfinished IDPAuth information");
                        }
                    }
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider createdHostedProvider");
                    }
                }
            }
            if (serviceConfig2 == null) {
                serviceConfig2 = serviceConfig.getSubConfig(string3);
            }
            if ((object2 = fSProviderDescriptor.getContactPerson()) == null) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider provide contact person is null");
                }
            } else {
                object = object2.iterator();
                while (object.hasNext()) {
                    stringArray = (String[])((Map.Entry)object.next()).getValue();
                    if (stringArray == null) continue;
                    this.createContactPerson(serviceConfig2, (FSContactPerson)stringArray, true);
                }
            }
            if ((object = fSProviderDescriptor.getOrganization()) != null) {
                this.createOrganization(serviceConfig2, (FSOrganization)object, true);
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
    }

    private ServiceConfig getEntityConfig(String string) {
        try {
            Set set = this.entityConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                return null;
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            while (iterator.hasNext()) {
                Set set2;
                serviceConfig = this.entityConfig.getSubConfig((String)iterator.next());
                if (serviceConfig == null || (set2 = serviceConfig.getSubConfigNames()) == null || set2.isEmpty() || !set2.contains(string) && !set2.contains(string + "|SP") && !set2.contains(string + "|IDP")) continue;
                return serviceConfig;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAllianceManager::getEntityConfig couldn't get EntityConfig", (Throwable)exception);
            return null;
        }
    }

    private String getContainerEntityId(String string) {
        try {
            Set set = this.entityConfig.getSubConfigNames();
            String string2 = null;
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                return null;
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            while (iterator.hasNext()) {
                Set set2;
                string2 = (String)iterator.next();
                serviceConfig = this.entityConfig.getSubConfig(string2);
                if (serviceConfig == null || (set2 = serviceConfig.getSubConfigNames()) == null || set2.isEmpty() || !set2.contains(string) && !set2.contains(string + "|SP") && !set2.contains(string + "|IDP")) continue;
                return string2;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAllianceManager::getContainerEntityId couldn't get EntityId", (Throwable)exception);
            return null;
        }
    }

    public FSEntityDescriptor getParentEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        String string2 = this.getContainerEntityId(string);
        if (string2 != null) {
            return this.getEntity(string2);
        }
        throw new FSAllianceManagementException("getParentEntity: No entity found for " + string);
    }

    public Set getAffiliateEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        HashSet<FSAffiliationDescriptor> hashSet = null;
        try {
            Set set = this.entityConfig.getSubConfigNames();
            String string2 = null;
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                throw new FSAllianceManagementException("getAffiliateEntity: No entity found.");
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            FSEntityDescriptor fSEntityDescriptor = null;
            FSAffiliationDescriptor fSAffiliationDescriptor = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                serviceConfig = this.entityConfig.getSubConfig(string2);
                if (serviceConfig == null) continue;
                fSEntityDescriptor = this.getEntity(string2);
                if (fSEntityDescriptor.getType().equalsIgnoreCase("urn:liberty:iff:affiliate")) {
                    fSAffiliationDescriptor = fSEntityDescriptor.getAffiliationDescriptor();
                }
                if (fSAffiliationDescriptor == null || !fSAffiliationDescriptor.getAffiliationMember().contains(string)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<FSAffiliationDescriptor>();
                }
                hashSet.add(fSAffiliationDescriptor);
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliateEntity ", (Throwable)sSOException);
            throw new FSAllianceManagementException(sSOException.getMessage());
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliateEntity ", (Throwable)sMSException);
            throw new FSAllianceManagementException(sMSException.getMessage());
        }
    }

    public boolean isAffiliateMember(String string, String string2) throws FSAllianceManagementException, FSInvalidNameException {
        FSAffiliationDescriptor fSAffiliationDescriptor = this.getAffiliationDescriptor(string2);
        Set set = fSAffiliationDescriptor.getAffiliationMember();
        return set != null && set.contains(string);
    }

    public void deleteProviderContactPerson(String string, String string2) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = this.getEntityConfig(string);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null && serviceConfig2.getSubConfigNames().contains(string2)) {
                serviceConfig2.removeSubConfig(string2);
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.deleteEntityContactPerson", (Throwable)sMSException);
            throw new FSAllianceManagementException("contactperson-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.deleteEntityContactPerson", (Throwable)sSOException);
            throw new FSAllianceManagementException("contactperson-deletion-exception", null);
        }
    }

    public void deleteProviderOrganization(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = this.getEntityConfig(string);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null && serviceConfig2.getSubConfigNames().contains("Organization")) {
                serviceConfig2.removeSubConfig("Organization");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.deleteProviderOrganization cannot delete organization", (Throwable)sMSException);
            throw new FSAllianceManagementException("org-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.deleteProviderOrganization cannot delete organization", (Throwable)sSOException);
            throw new FSAllianceManagementException("org-deletion-exception", null);
        }
    }

    public void deleteProvider(String string, String string2) throws FSAllianceManagementException {
        ServiceConfig serviceConfig = this.getEntityConfig(string);
        String string3 = string;
        if (string2 != null) {
            string3 = string + "|" + string2;
        }
        if (serviceConfig != null) {
            this.deleteProvider(serviceConfig, string3);
        } else {
            FSUtils.debug.message("FSAllianceManager.deleteProvider: getEntityConfig is null.");
        }
    }

    public void deleteProviderWithUniqueId(String string) throws FSAllianceManagementException {
        int n = -1;
        if (string.endsWith("|SP") && (n = string.indexOf("|SP")) != -1) {
            this.deleteProvider(string.substring(0, n), "SP");
        } else if (string.endsWith("|IDP") && (n = string.indexOf("|IDP")) != -1) {
            this.deleteProvider(string.substring(0, n), "IDP");
        } else {
            this.deleteProvider(string, null);
        }
    }

    public void deleteProvider(String string) throws FSAllianceManagementException {
        block9: {
            try {
                ServiceConfig serviceConfig = this.getEntityConfig(string);
                String string2 = string + "|SP";
                String string3 = string + "|IDP";
                if (serviceConfig != null) {
                    Set set = serviceConfig.getSubConfigNames();
                    if (set.contains(string2) && set.contains(string3)) {
                        throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
                    }
                    if (set.contains(string2)) {
                        this.deleteProvider(serviceConfig, string2);
                    } else if (set.contains(string3)) {
                        this.deleteProvider(serviceConfig, string3);
                    } else if (set.contains(string)) {
                        this.deleteProvider(serviceConfig, string);
                    }
                    break block9;
                }
                throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
            }
            catch (SMSException sMSException) {
                FSUtils.debug.error("FSAllianceManager.deleteProviderOrganization cannot delete organization", (Throwable)sMSException);
                throw new FSAllianceManagementException("org-deletion-exception", null);
            }
        }
    }

    public void deleteAffiliationDescriptor(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager.deleteAffiliationDescriptor affID " + string + "is invalid");
            throw new FSInvalidNameException("affiliation-id-invalid", null);
        }
        try {
            serviceConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteAffiliationDescriptor deleted" + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "DELETE_AFFILIATION", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.deleteAffiliationDescriptor cannot delete affiliation", (Throwable)sMSException);
            throw new FSAllianceManagementException("affiliation-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.deleteAffiliationDescriptor cannot delete affiliation", (Throwable)sSOException);
            throw new FSAllianceManagementException("affiliation-deletion-exception", null);
        }
    }

    public void deleteProvider(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider providerID " + string + "is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            serviceConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteProvider deleted" + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "DELETE_PROVIDER", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.deleteProvider cannot delete provider", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.deleteProvider cannot delete provider", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
    }

    public FSProviderDescriptor getProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        return this.getProvider(string, null);
    }

    public FSProviderDescriptor getProviderWithUniqueID(String string) throws FSAllianceManagementException, FSInvalidNameException {
        int n = -1;
        FSProviderDescriptor fSProviderDescriptor = string.endsWith("|SP") && (n = string.indexOf("|SP")) != -1 ? this.getProvider(string.substring(0, n), "SP") : (string.endsWith("|IDP") && (n = string.indexOf("|IDP")) != -1 ? this.getProvider(string.substring(0, n), "IDP") : this.getProvider(string, null));
        return fSProviderDescriptor;
    }

    public FSProviderDescriptor getProvider(String string, String string2) throws FSAllianceManagementException, FSInvalidNameException {
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            if (cacheOn) {
                fSProviderDescriptor = FSCache.getProviderDescriptor(string, string2);
            }
            if (fSProviderDescriptor == null) {
                Set set = this.entityConfig.getSubConfigNames();
                if (set == null || set.isEmpty()) {
                    FSUtils.debug.error("No entity found!");
                    throw new FSAllianceManagementException("getProvider(providerid): No entity found");
                }
                fSProviderDescriptor = this.getProvider(string, string2, set);
                if (cacheOn) {
                    FSCache.setProviderDescriptor(fSProviderDescriptor, string, string2);
                }
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.getProvider: couldn't get provider", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.getProvider: couldn't get provider", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
        return fSProviderDescriptor;
    }

    private FSProviderDescriptor getProvider(String string, String string2, Set set) throws SSOException, SMSException, FSAllianceManagementException {
        FSProviderDescriptor fSProviderDescriptor = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && fSProviderDescriptor == null) {
            String string3;
            String string4 = (String)iterator.next();
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string4);
            String string5 = this.getProviderType(serviceConfig);
            if (string5 == null || !string5.equalsIgnoreCase("urn:liberty:iff:provider")) continue;
            Set set2 = serviceConfig.getSubConfigNames();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAllianceManager.getProvider(Set): ids: " + set2);
            }
            if (set2 == null || set2.isEmpty()) continue;
            if (string2 != null) {
                string3 = string + "|" + string2;
                if (set2.contains(string3)) {
                    fSProviderDescriptor = this.getProvider(serviceConfig, string, string2);
                }
                if (fSProviderDescriptor != null || !set2.contains(string)) continue;
                fSProviderDescriptor = this.getProvider(serviceConfig, string, null);
                continue;
            }
            if (set2.contains(string)) {
                fSProviderDescriptor = this.getProvider(serviceConfig, string, null);
                continue;
            }
            string3 = string + "|" + "IDP";
            if (set2.contains(string3)) {
                fSProviderDescriptor = this.getProvider(serviceConfig, string, "IDP");
                continue;
            }
            String string6 = string + "|" + "SP";
            if (!set2.contains(string6)) continue;
            fSProviderDescriptor = this.getProvider(serviceConfig, string, "SP");
        }
        return fSProviderDescriptor;
    }

    private String getProviderType(ServiceConfig serviceConfig) {
        Map map;
        String string = "";
        if (serviceConfig != null && (map = serviceConfig.getAttributes()) != null && !map.isEmpty()) {
            string = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType");
        }
        return string;
    }

    private FSProviderDescriptor getProvider(ServiceConfig serviceConfig, String string, String string2) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::getProvider providerID: " + string + " is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            ServiceConfig serviceConfig2 = null;
            if (string2 != null) {
                serviceConfig2 = serviceConfig.getSubConfig(string + "|" + string2);
                string = string + "|" + string2;
            } else {
                serviceConfig2 = serviceConfig.getSubConfig(string);
            }
            if (serviceConfig2 == null) {
                FSUtils.debug.error("FSAllianceManager::getProvider Failed to get provider subconfig with providerid:" + string);
                throw new FSAllianceManagementException("alliance_management_provider_sc_exception", null);
            }
            Map map = serviceConfig2.getAttributes();
            FSProviderDescriptor fSProviderDescriptor = new FSProviderDescriptor(string, map);
            String string3 = fSProviderDescriptor.getProviderType();
            if (string3.equalsIgnoreCase("remote")) {
                Set set = serviceConfig2.getSubConfigNames();
                if (set == null || set.isEmpty()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("provider does not contain sub element");
                    }
                } else {
                    Iterator iterator = set.iterator();
                    String string4 = null;
                    while (iterator.hasNext()) {
                        Object object4;
                        string4 = (String)iterator.next();
                        if (string4.startsWith("ContactPerson")) {
                            object4 = this.getContactPerson(serviceConfig2, string4, true);
                            fSProviderDescriptor.addContactPerson((FSContactPerson)object4, false);
                            continue;
                        }
                        if (string4.startsWith("Organization")) {
                            object4 = this.getOrganization(serviceConfig2, string4, true);
                            fSProviderDescriptor.setOrganization((FSOrganization)object4);
                            continue;
                        }
                        FSUtils.debug.error("do not support");
                    }
                }
                return fSProviderDescriptor;
            }
            FSHostedProviderDescriptor fSHostedProviderDescriptor = new FSHostedProviderDescriptor(string, map);
            Set set = serviceConfig2.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("provider does not contain sub element");
            } else {
                object3 = set.iterator();
                object2 = null;
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (object2 != null && ((String)object2).startsWith("ContactPerson")) {
                        object = this.getContactPerson(serviceConfig2, (String)object2, true);
                        fSHostedProviderDescriptor.addContactPerson((FSContactPerson)object, false);
                        continue;
                    }
                    if (object2 == null || !((String)object2).startsWith("Organization")) continue;
                    object = this.getOrganization(serviceConfig2, (String)object2, true);
                    fSHostedProviderDescriptor.setOrganization((FSOrganization)object);
                }
            }
            object3 = serviceConfig2.getSubConfig("LocalConfiguration");
            if (object3 == null) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::getProvider No LocalConfig for hostedProvider");
                }
                return fSHostedProviderDescriptor;
            }
            object2 = ((ServiceConfig)object3).getAttributes();
            object = new FSLocalConfigurationDescriptor((ServiceConfig)object3, (Map)object2);
            Set set2 = this.getAuthDomainURLList(((FSLocalConfigurationDescriptor)object).getAssociatedOrgDN());
            ((FSLocalConfigurationDescriptor)object).setAuthDomainURLList(set2);
            fSHostedProviderDescriptor.setLocalConfiguration((FSLocalConfigurationDescriptor)object);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::getProvider finished setting Local Config");
            }
            return fSHostedProviderDescriptor;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getProvider  couldn't get provider SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getProvider couldn't get provider SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    private ServiceConfig getEntityServiceConfig(String string) throws FSAllianceManagementException {
        try {
            if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
                FSUtils.debug.error("FSAllianceManager.getEntityServiceConfig entityID " + string + "is invalid");
                throw new FSInvalidNameException("alliance_management_entityid_invalid", null);
            }
            return this.entityConfig.getSubConfig(string);
        }
        catch (Exception exception) {
            throw new FSAllianceManagementException(exception.getMessage());
        }
    }

    public void deleteEntityContactPerson(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = null;
            serviceConfig = this.getEntityServiceConfig(string);
            if (serviceConfig != null && serviceConfig.getSubConfigNames().contains("ContactPerson1")) {
                serviceConfig.removeSubConfig("ContactPerson1");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("contactperson-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("contactperson-deletion-exception", null);
        }
    }

    public void deleteEntityOrganization(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = null;
            serviceConfig = this.getEntityServiceConfig(string);
            if (serviceConfig != null && serviceConfig.getSubConfigNames().contains("Organization")) {
                serviceConfig.removeSubConfig("Organization");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityOrganization could not delete org got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("org-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityOrganization could not delete org got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("org-deletion-exception", null);
        }
    }

    public void deleteEntity(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        if (set == null || set.isEmpty()) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity entityID is empty set.");
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteEntity((String)iterator.next());
        }
    }

    public void deleteEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager.deleteEntity entityID " + string + " is invalid");
            throw new FSInvalidNameException("alliance_management_entityid_invalid", null);
        }
        try {
            this.entityConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteEntity deleted" + string);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "DELETE_ENTITY", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity could not delete entity got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("entity-deletion-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity could not delete entity got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("entity-deletion-exception", null);
        }
    }

    public FSEntityDescriptor getEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::getEntity entityID: " + string + "is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
            Map map = serviceConfig.getAttributes();
            FSEntityDescriptor fSEntityDescriptor = new FSEntityDescriptor(string, map);
            Set set = serviceConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAllianceManager.getEntity(String): entity does not contain sub element");
                }
            } else {
                Iterator iterator = set.iterator();
                String string2 = null;
                int n = -1;
                while (iterator.hasNext()) {
                    Object object;
                    string2 = (String)iterator.next();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("id =" + string2);
                    }
                    if (string2 != null && string2.startsWith("ContactPerson")) {
                        object = this.getContactPerson(serviceConfig, string2, false);
                        fSEntityDescriptor.setContactPerson((FSContactPerson)object);
                        continue;
                    }
                    if (string2 != null && string2.startsWith("Organization")) {
                        object = this.getOrganization(serviceConfig, string2, false);
                        fSEntityDescriptor.setOrganization((FSOrganization)object);
                        continue;
                    }
                    if (fSEntityDescriptor.getType().equals("urn:liberty:iff:affiliate")) {
                        object = this.getAffiliationDescriptor(serviceConfig, string2);
                        fSEntityDescriptor.setAffiliationDescriptor((FSAffiliationDescriptor)object);
                        continue;
                    }
                    if (string2.endsWith("|SP") && (n = string2.indexOf("|SP")) != -1) {
                        object = this.getProvider(serviceConfig, string2.substring(0, n), "SP");
                        fSEntityDescriptor.addSPDescriptor((FSProviderDescriptor)object);
                        continue;
                    }
                    if (string2.endsWith("|IDP") && (n = string2.indexOf("|IDP")) != -1) {
                        object = this.getProvider(serviceConfig, string2.substring(0, n), "IDP");
                        String string3 = ((FSProviderDescriptor)object).getProviderRole();
                        fSEntityDescriptor.addIDPDescriptor((FSProviderDescriptor)object);
                        continue;
                    }
                    object = this.getProvider(serviceConfig, string2, null);
                }
            }
            return fSEntityDescriptor;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getEntity  couldn't get entity SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("amFederation", "alliance_management_entity_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getEntity couldn't get entity SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("amFederation", "alliance_management_entity_retrieval_exception", null);
        }
    }

    public void modifyProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        ServiceConfig serviceConfig = this.getEntityConfig(fSProviderDescriptor.getProviderID());
        this.modifyProvider(serviceConfig, fSProviderDescriptor);
    }

    public void modifyEntity(FSEntityDescriptor fSEntityDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSEntityDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager.ModifyEntity entityrDescriptor not valid");
            throw new FSInvalidNameException("alliance_management_entityid_invalid", null);
        }
        String string = fSEntityDescriptor.getEntityID();
        if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager.ModifyEntity entityID: " + string + " not valid");
            throw new FSInvalidNameException("alliance_management_entityid_invalid", null);
        }
        try {
            String[] stringArray;
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
            if (serviceConfig != null) {
                Object object;
                FSOrganization fSOrganization;
                stringArray = fSEntityDescriptor.getAttributes();
                Map map = serviceConfig.getAttributes();
                if (!map.equals(stringArray)) {
                    serviceConfig.setAttributes((Map)stringArray);
                }
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::ModifyEntity set general attributes");
                }
                Set set = serviceConfig.getSubConfigNames();
                HashSet<String> hashSet = new HashSet<String>();
                ServiceConfig serviceConfig2 = null;
                FSContactPerson fSContactPerson = fSEntityDescriptor.getContactPerson();
                if (fSContactPerson != null) {
                    stringArray = fSContactPerson.getAttributes(false);
                    serviceConfig2 = serviceConfig.getSubConfig(fSContactPerson.getCPID());
                    if (serviceConfig2 != null) {
                        map = serviceConfig2.getAttributes();
                        if (!map.equals(stringArray)) {
                            serviceConfig2.setAttributes((Map)stringArray);
                        }
                    } else {
                        this.deleteEntityContactPerson(string);
                        this.createContactPerson(serviceConfig, fSContactPerson, false);
                    }
                    hashSet.add(fSContactPerson.getCPID());
                }
                if ((fSOrganization = fSEntityDescriptor.getOrganization()) != null) {
                    stringArray = fSOrganization.getAttributes(false);
                    serviceConfig2 = serviceConfig.getSubConfig(fSOrganization.getOrgID());
                    if (serviceConfig2 != null) {
                        map = serviceConfig2.getAttributes();
                        if (!map.equals(stringArray)) {
                            serviceConfig2.setAttributes((Map)stringArray);
                        }
                    } else {
                        this.deleteEntityOrganization(string);
                        this.createOrganization(serviceConfig, fSOrganization, false);
                    }
                    hashSet.add(fSOrganization.getOrgID());
                }
                Iterator iterator = null;
                String string2 = null;
                Object var13_15 = null;
                if (fSEntityDescriptor.getType().equalsIgnoreCase("urn:liberty:iff:provider")) {
                    Object object2;
                    object = fSEntityDescriptor.getSPDescriptor();
                    if (object == null || object.isEmpty()) {
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager:modifyEntity sp list is empty");
                        }
                    } else {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            object2 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                            string2 = ((FSProviderDescriptor)object2).getProviderID();
                            if (set.contains(string2 + "|SP") || set.contains(string2)) {
                                this.modifyProvider(serviceConfig, (FSProviderDescriptor)object2);
                            } else {
                                this.createProvider(serviceConfig, (FSProviderDescriptor)object2);
                            }
                            if (string2.endsWith("|SP")) {
                                hashSet.add(string2);
                                continue;
                            }
                            hashSet.add(string2 + "|SP");
                        }
                    }
                    if ((object2 = fSEntityDescriptor.getIDPDescriptor()) == null || object2.isEmpty()) {
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::modifyEntity: idp list is null");
                        }
                    } else {
                        iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                            string2 = fSProviderDescriptor.getProviderID();
                            if (set.contains(string2 + "|IDP") || set.contains(string2)) {
                                this.modifyProvider(serviceConfig, fSProviderDescriptor);
                            } else {
                                this.createProvider(serviceConfig, fSProviderDescriptor);
                            }
                            if (string2.endsWith("|IDP")) {
                                hashSet.add(string2);
                                continue;
                            }
                            hashSet.add(string2 + "|IDP");
                        }
                    }
                } else {
                    object = fSEntityDescriptor.getAffiliationDescriptor();
                    if (object != null) {
                        this.modifyAffiliationDescriptor(serviceConfig, (FSAffiliationDescriptor)object);
                        hashSet.add(((FSAffiliationDescriptor)object).getAffiliationID());
                    }
                }
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (!set.contains(string2) || hashSet.contains(string2)) continue;
                    serviceConfig.removeSubConfig(string2);
                }
            } else {
                throw new FSAllianceManagementException("No such Entity: " + string);
            }
            stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "MODIFY_ENTITY", stringArray, this.token);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyEntity couldn't modify entity SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("entity-modify-exception", null);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyEntity couldn't modify entity SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("entity-modify-exception", null);
        }
    }

    public void modifyAffiliationDescriptor(ServiceConfig serviceConfig, FSAffiliationDescriptor fSAffiliationDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSAffiliationDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyAffiliatonDescriptor AffiliationDescriptor not valid");
            throw new FSInvalidNameException("affiliation-invalid", null);
        }
        String string = fSAffiliationDescriptor.getAffiliationID();
        if (string == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyAffiliatonDescriptor AffiliationDescriptor not valid");
            throw new FSInvalidNameException("affiliation-id-invalid", null);
        }
        try {
            String[] stringArray;
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null) {
                stringArray = fSAffiliationDescriptor.getAttributes();
                Map map = serviceConfig2.getAttributes();
                if (!map.equals(stringArray)) {
                    serviceConfig2.setAttributes((Map)stringArray);
                }
            } else {
                this.createAffiliationDescriptor(serviceConfig, fSAffiliationDescriptor);
            }
            stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "MODIFY_AFFILIATION", stringArray, this.token);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyAffiliationDescriptorcouldn't modify affiliation SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("affiliation-modify-exception", null);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.modifyAffiliationDescriptor couldn't modify affiliation SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("affiliation-modify-exception", null);
        }
    }

    public void modifyProvider(ServiceConfig serviceConfig, FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSProviderDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerDescriptor not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        String string = fSProviderDescriptor.getProviderID();
        String string2 = fSProviderDescriptor.getProviderRole();
        String string3 = string + "|" + string2;
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string) && !this.getAllProviderIds().contains(string3)) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerID :" + string + "not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            Object object;
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string3);
            if (serviceConfig2 == null) {
                serviceConfig2 = serviceConfig.getSubConfig(string);
            }
            if (serviceConfig2 != null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                ServiceConfig serviceConfig3;
                Set set;
                FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
                object = fSProviderDescriptor.getAttributes();
                Set set2 = fSProviderDescriptor.getListOfCOTs();
                if (!this.isValidCOTList(set2)) {
                    FSUtils.debug.error("FSAllianceManager.java:: modifyProvider ListOfCOTs invalid");
                    throw new FSAllianceManagementException("cotlist_invalid", null);
                }
                Map map = serviceConfig2.getAttributes();
                if (!map.equals(object)) {
                    serviceConfig2.setAttributes((Map)object);
                }
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::ModifyProvider set general attributes");
                }
                if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor") && (fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration()) != null) {
                    Object object6;
                    Object object7;
                    Object object8;
                    if (fSLocalConfigurationDescriptor.getIsPassive() && fSLocalConfigurationDescriptor.getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    set = fSLocalConfigurationDescriptor.getTrustedProviders();
                    if (!this.isValidProviderList(set2, set)) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    serviceConfig3 = serviceConfig2.getSubConfig("LocalConfiguration");
                    object = fSLocalConfigurationDescriptor.getAttributes(this.revisionNumber);
                    if (serviceConfig3 == null) {
                        serviceConfig2.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, (Map)object);
                        serviceConfig3 = serviceConfig2.getSubConfig("LocalConfiguration");
                        object5 = fSLocalConfigurationDescriptor.getSPAuthContextInfo();
                        if (object5 != null) {
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthInfo Not null");
                            }
                            serviceConfig3.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthContext Node created ");
                            }
                            object4 = serviceConfig3.getSubConfig("SPAuthenticationContextInfo");
                            object3 = object5.keySet();
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                object8 = (FSSPAuthenticationContextInfo)object5.get((String)object2.next());
                                if (object8 == null || (object7 = ((FSSPAuthenticationContextInfo)object8).getAuthenticationContext()) == null || ((String)object7).length() <= 0) continue;
                                ((ServiceConfig)object4).addSubConfig((String)object7, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object8).getAttributes());
                            }
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager.java::createProvider finished SP Auth information");
                        }
                        if ((object4 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            serviceConfig3.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider IDPAuthode created");
                            }
                            object3 = serviceConfig3.getSubConfig("IDPAuthenticationContextInfo");
                            object2 = object4.keySet();
                            object8 = object2.iterator();
                            while (object8.hasNext()) {
                                object7 = (FSIDPAuthenticationContextInfo)object4.get((String)object8.next());
                                if (object7 == null || (object6 = ((FSIDPAuthenticationContextInfo)object7).getAuthenticationContext()) == null || ((String)object6).length() <= 0) continue;
                                ((ServiceConfig)object3).addSubConfig((String)object6, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object7).getAttributes());
                            }
                        }
                    } else {
                        map = serviceConfig3.getAttributes();
                        if (!map.equals(object)) {
                            serviceConfig3.setAttributes((Map)object);
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAlliaceManager::ModifyProvider set LocalConfiguration");
                        }
                        if ((object4 = serviceConfig3.getSubConfig("SPAuthenticationContextInfo")) == null) {
                            serviceConfig3.addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider created Node for SPAuthConfig Info ");
                            }
                            object4 = serviceConfig3.getSubConfig("SPAuthenticationContextInfo");
                        }
                        if ((object5 = fSLocalConfigurationDescriptor.getSPAuthContextInfo()) != null) {
                            object3 = object5.keySet();
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                object8 = (FSSPAuthenticationContextInfo)object5.get((String)object2.next());
                                if (object8 == null || (object7 = ((FSSPAuthenticationContextInfo)object8).getAuthenticationContext()) == null || ((String)object7).length() <= 0) continue;
                                object6 = ((ServiceConfig)object4).getSubConfig((String)object7);
                                if (object6 != null) {
                                    ((ServiceConfig)object6).setAttributes(((FSSPAuthenticationContextInfo)object8).getAttributes());
                                    continue;
                                }
                                ((ServiceConfig)object4).addSubConfig((String)object7, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object8).getAttributes());
                            }
                        }
                        if ((object2 = serviceConfig3.getSubConfig("IDPAuthenticationContextInfo")) == null) {
                            serviceConfig3.addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider createdNode for IDPAuthConfig Info ");
                            }
                            object2 = serviceConfig3.getSubConfig("IDPAuthenticationContextInfo");
                        }
                        if ((object3 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            object8 = object3.keySet();
                            object7 = object8.iterator();
                            while (object7.hasNext()) {
                                String string4;
                                object6 = (FSIDPAuthenticationContextInfo)object3.get((String)object7.next());
                                if (object6 == null || (string4 = ((FSIDPAuthenticationContextInfo)object6).getAuthenticationContext()) == null || string4.length() <= 0) continue;
                                ServiceConfig serviceConfig4 = ((ServiceConfig)object2).getSubConfig(string4);
                                if (serviceConfig4 != null) {
                                    serviceConfig4.setAttributes(((FSIDPAuthenticationContextInfo)object6).getAttributes());
                                    continue;
                                }
                                ((ServiceConfig)object2).addSubConfig(string4, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object6).getAttributes());
                            }
                        }
                    }
                }
                set = this.setContactPersonSubConfigs(serviceConfig, fSProviderDescriptor, serviceConfig2);
                serviceConfig3 = null;
                object5 = fSProviderDescriptor.getOrganization();
                if (object5 != null) {
                    object = ((FSOrganization)object5).getAttributes(true);
                    serviceConfig3 = serviceConfig2.getSubConfig(((FSOrganization)object5).getOrgID());
                    if (serviceConfig3 != null) {
                        map = serviceConfig3.getAttributes();
                        if (!map.equals(object)) {
                            serviceConfig3.setAttributes((Map)object);
                        }
                    } else {
                        this.createOrganization(serviceConfig2, (FSOrganization)object5, true);
                    }
                    set.add(((FSOrganization)object5).getOrgID());
                }
                object4 = serviceConfig2.getSubConfigNames();
                object3 = null;
                if (object4 != null) {
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object3 = (String)object2.next();
                        if (((String)object3).equalsIgnoreCase("LocalConfiguration") || set != null && (!object4.contains(object3) || set.contains(object3))) continue;
                        serviceConfig.removeSubConfig((String)object3);
                    }
                }
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::modifyPovider Modified provider");
            }
            object = new String[]{string};
            LogUtil.access(Level.INFO, "MODIFY_PROVIDER", object, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.modifyProvider", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.modifyProvider", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
    }

    private Set setContactPersonSubConfigs(ServiceConfig serviceConfig, FSProviderDescriptor fSProviderDescriptor, ServiceConfig serviceConfig2) throws FSAllianceManagementException, SMSException, SSOException {
        Object object;
        Iterator iterator;
        HashSet<String> hashSet = new HashSet<String>();
        Set set = fSProviderDescriptor.getContactPerson();
        Set set2 = serviceConfig2.getSubConfigNames();
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (FSContactPerson)((Map.Entry)iterator.next()).getValue();
                String string = ((FSContactPerson)object).getCPID();
                if (set2 != null && !set2.isEmpty()) {
                    set2.remove(string);
                }
                Map map = ((FSContactPerson)object).getAttributes(true);
                ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string);
                if (serviceConfig3 != null) {
                    Map map2 = serviceConfig3.getAttributes();
                    if (!map2.equals(map)) {
                        serviceConfig3.setAttributes(map);
                    }
                } else {
                    this.createContactPerson(serviceConfig2, (FSContactPerson)object, true);
                }
                hashSet.add(string);
            }
        }
        if (set2 != null && !set2.isEmpty()) {
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith("ContactPerson")) continue;
                serviceConfig2.removeSubConfig((String)object);
            }
        }
        return hashSet;
    }

    public Set getAllEntityIds() throws FSAllianceManagementException {
        return this.getAllEntityIds("*");
    }

    public Set getAllProviderIds() throws FSAllianceManagementException {
        return this.getAllProviderIds("*");
    }

    public Set getAllEntityIds(String string) throws FSAllianceManagementException {
        try {
            Set set = null;
            set = string != null && string.equals("*") ? this.entityConfig.getSubConfigNames() : this.entityConfig.getSubConfigNames(string);
            return set;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAllEntityIds", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_entity_retrieval_exception", null);
        }
    }

    public Set getAllEntityIds(String string, String string2) throws FSAllianceManagementException {
        Set set = this.getAllEntityIds(string);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                FSEntityDescriptor fSEntityDescriptor = this.getEntity(string3);
                if (fSEntityDescriptor.getType().equalsIgnoreCase(string2)) continue;
                iterator.remove();
            }
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public Set getAllProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        ServiceConfig serviceConfig = null;
        try {
            Set set = this.getAllEntityIds();
            if (set != null) {
                Iterator iterator = set.iterator();
                String string3 = null;
                while (iterator.hasNext()) {
                    Map map;
                    FSEntityDescriptor fSEntityDescriptor;
                    string3 = (String)iterator.next();
                    serviceConfig = this.entityConfig.getSubConfig(string3);
                    if (serviceConfig == null || !(fSEntityDescriptor = new FSEntityDescriptor(string3, map = serviceConfig.getAttributes())).getType().equalsIgnoreCase("urn:liberty:iff:provider")) continue;
                    Set set2 = null;
                    set2 = string != null && string.equals("*") ? serviceConfig.getSubConfigNames() : serviceConfig.getSubConfigNames(string);
                    if (set2 == null || set2.isEmpty()) continue;
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        string2 = (String)iterator2.next();
                        if (string2 == null || string2.startsWith("ContactPerson") || string2.startsWith("Organization")) continue;
                        hashSet.add(string2);
                    }
                }
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAllProviderID SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_sso_exception", null);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAllProviderIds SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveProviderIds() throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public Set getAllHostedProviderIds() throws FSAllianceManagementException {
        return this.getAllHostedProviderIds("*");
    }

    public Set getAllHostedProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("hosted")) continue;
                    hashSet.add(string3);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager.getAllHostedProviders", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveHostedProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllHostedProviderIds();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                    if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                    hashSet.add(string2);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllActiveHostedProviderIds SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllRemoteProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("remote")) continue;
                    hashSet.add(string3);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllRemoteProviders SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_sms_exception", null, (Throwable)((Object)fSAllianceManagementException));
        }
        return hashSet;
    }

    public Set getAllRemoteProviderIds() throws FSAllianceManagementException {
        return this.getAllRemoteProviderIds("*");
    }

    public Set getAllActiveRemoteProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getAllRemoteProviderIds();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public void deleteProviders(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.deleteProvider((String)iterator.next());
            }
        }
    }

    public FSProviderDescriptor getProviderBySuccinctID(String string) throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSProviderDescriptor fSProviderDescriptor = this.getProvider((String)iterator.next());
            if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderSuccinctID()) == null || !string2.equalsIgnoreCase(string)) continue;
            return fSProviderDescriptor;
        }
        throw new FSAllianceManagementException("alliance_management_provider_succinctid_invalid", null);
    }

    public FSHostedProviderDescriptor getHostedProviderByMetaAlias(String string) throws FSAllianceManagementException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        if (cacheOn && (fSHostedProviderDescriptor = FSCache.getHostedProviderDescriptor(string)) != null) {
            return fSHostedProviderDescriptor;
        }
        Set set = this.getAllHostedProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
            fSHostedProviderDescriptor = this.getHostedProvider((String)iterator.next());
            if (fSHostedProviderDescriptor == null || (fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration()) == null || (string2 = fSLocalConfigurationDescriptor.getProviderAlias()) == null || !string2.equalsIgnoreCase(string)) continue;
            if (cacheOn) {
                FSCache.setHostedProviderDescriptor(fSHostedProviderDescriptor, string);
            }
            return fSHostedProviderDescriptor;
        }
        throw new FSAllianceManagementException("alliance_management_provider_metaalias_invalid", null);
    }

    public FSHostedProviderDescriptor getHostedProvider(String string) throws FSAllianceManagementException {
        FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
        if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
            return (FSHostedProviderDescriptor)fSProviderDescriptor;
        }
        FSUtils.debug.error("FSAllianceManager.getHostedProviderDescriptor given provider is not a hosted provider");
        throw new FSAllianceManagementException("alliance_management_providerid_invalid", null);
    }

    Set getAuthDomainURLList(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            return hashSet;
        }
        if (DN.isDN((String)string)) {
            DN dN = new DN(string);
            Vector vector = dN.getRDNs();
            if (vector != null && vector.size() > 0) {
                hashSet.add(((RDN)vector.firstElement()).getValues()[0]);
            }
        } else if (string.startsWith("/")) {
            if (string.trim().equals("/")) {
                hashSet.add("/");
            } else if (!string.trim().endsWith("/")) {
                int n = string.lastIndexOf("/");
                hashSet.add(string.substring(n + 1).trim());
            } else {
                FSUtils.debug.error("getAuthDomainURLList.invalid org URL " + string);
            }
        } else {
            FSUtils.debug.error("getAuthDomainURLList invalid org URL " + string);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("getAuthDomainURLList=" + hashSet);
        }
        return hashSet;
    }

    public Set getProspectiveTrustedProviders(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = this.getHostedProvider(string);
        Set set = fSHostedProviderDescriptor.getListOfCOTs();
        if (set == null || set.isEmpty()) {
            FSUtils.debug.message("FSAllianceManager.getProspectiveTrustedProviders: No results");
        } else {
            Set set2 = this.getAllProviderIds();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProviderWithUniqueID(string2);
                Set set3 = fSProviderDescriptor.getListOfCOTs();
                if (set3 == null) continue;
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    if (!set3.contains(iterator2.next())) continue;
                    hashSet.add(string2);
                }
            }
            hashSet.remove(fSHostedProviderDescriptor.getProviderUniqueID());
        }
        return hashSet;
    }

    boolean isValidCOTList(Set set) throws FSAllianceManagementException {
        Set set2 = this.getAllCirclesOfTrust();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (set2.contains(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    boolean isValidProviderList(Set set, Set set2) throws FSAllianceManagementException {
        Set set3 = this.getAllProviderIds();
        if (set2 != null) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!set3.contains(string)) continue;
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
                Set set4 = fSProviderDescriptor.getListOfCOTs();
                if (set4 == null || set == null) {
                    return false;
                }
                boolean bl = false;
                Iterator iterator2 = set4.iterator();
                while (iterator2.hasNext()) {
                    if (!set.contains(iterator2.next())) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public void createEntityProvider(FSEntityDescriptor fSEntityDescriptor) throws FSAllianceManagementException {
        Object var2_2 = null;
        String string = null;
        if (fSEntityDescriptor == null || (string = fSEntityDescriptor.getEntityID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager.createEntityProvider  ID in the given EntityDescriptor is null");
            throw new FSInvalidNameException("alliance_management_entityid_invalid", null);
        }
        if (this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createEntityDescriptor Entity already exists");
            throw new FSAllianceManagementException("alliance_management_entity_exists", null);
        }
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::createEntityDescriptor valid entity ID");
        }
        try {
            FSOrganization fSOrganization;
            FSContactPerson fSContactPerson;
            Object object;
            Object object2;
            Map map = fSEntityDescriptor.getAttributes();
            this.entityConfig.addSubConfig(string, "EntityDescriptor", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createEntityDescriptor Entity Node created");
            }
            Iterator iterator = null;
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
            Set set = fSEntityDescriptor.getSPDescriptor();
            if (set == null || set.isEmpty()) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager:createEntityDescriptor sp list is empty");
                }
            } else {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    object2 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    this.createProvider(serviceConfig, (FSProviderDescriptor)object2);
                }
            }
            if ((object2 = fSEntityDescriptor.getIDPDescriptor()) == null || object2.isEmpty()) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createEntityDescriptor idp list is null");
                }
            } else {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    this.createProvider(serviceConfig, (FSProviderDescriptor)object);
                }
            }
            if ((object = fSEntityDescriptor.getAffiliationDescriptor()) != null) {
                this.createAffiliationDescriptor(serviceConfig, (FSAffiliationDescriptor)object);
            }
            if ((fSContactPerson = fSEntityDescriptor.getContactPerson()) != null) {
                this.createContactPerson(serviceConfig, fSContactPerson, false);
            }
            if ((fSOrganization = fSEntityDescriptor.getOrganization()) != null) {
                this.createOrganization(serviceConfig, fSOrganization, false);
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "CREATE_ENTITY", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createProvider could not create provider", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.createProvider could not create provider", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
    }

    public void createAffiliationDescriptor(ServiceConfig serviceConfig, FSAffiliationDescriptor fSAffiliationDescriptor) throws FSAllianceManagementException {
        String string = null;
        String string2 = null;
        if (fSAffiliationDescriptor == null || (string = fSAffiliationDescriptor.getAffiliationID()) == null || string.length() <= 0 || (string2 = fSAffiliationDescriptor.getAffiliationOwnerID()) == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager.createaffiliationDescriptor: ID in the given affiliationDescriptor is null");
            throw new FSInvalidNameException("affiliation-id-invalid", null);
        }
        Map map = fSAffiliationDescriptor.getAttributes();
        try {
            serviceConfig.addSubConfig(string, "AffiliationDescriptor", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createaffiliationDescriptoraffiliationDescriptor  Node created");
            }
            String[] stringArray = new String[]{string};
            LogUtil.access(Level.INFO, "CREATE_AFFILIATION", stringArray, this.token);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createAffiliationDescriptor", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_affiliation_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.createAffiliationDescriptor", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_affiliation_creation_exception", null);
        }
    }

    public void createContactPerson(ServiceConfig serviceConfig, FSContactPerson fSContactPerson, boolean bl) throws FSAllianceManagementException {
        Object var4_4 = null;
        String string = null;
        if (fSContactPerson == null || (string = fSContactPerson.getCPID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager.createContactPerson: ID in the given Contact person is null");
            throw new FSInvalidNameException("contactperson-id-invalid", null);
        }
        Map map = fSContactPerson.getAttributes(bl);
        try {
            if (bl) {
                serviceConfig.addSubConfig(string, "ProviderContactPerson", 0, map);
            } else {
                serviceConfig.addSubConfig(string, "ContactPerson", 0, map);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createContactPersonContact person  Node created");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createContactPerson", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_contactperson_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.createContactPerson", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_contactperson_creation_exception", null);
        }
    }

    public void createOrganization(ServiceConfig serviceConfig, FSOrganization fSOrganization, boolean bl) throws FSAllianceManagementException {
        String string = null;
        if (fSOrganization == null || (string = fSOrganization.getOrgID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createOrganization  ID in the given organization is null");
            throw new FSInvalidNameException("organization-id-invalid", null);
        }
        Map map = fSOrganization.getAttributes(bl);
        try {
            if (bl) {
                serviceConfig.addSubConfig(string, "ProviderOrganization", 0, map);
            } else {
                serviceConfig.addSubConfig(string, "EntityOrganization", 0, map);
            }
            FSUtils.debug.message("FSAllianceManager.createOrganization: organization Node created");
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager.createOrganization", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_organization_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager.createOrganization", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_organization_creation_exception", null);
        }
    }

    public FSContactPerson getContactPerson(ServiceConfig serviceConfig, String string, boolean bl) throws FSAllianceManagementException, FSInvalidNameException {
        FSContactPerson fSContactPerson = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::getContactPerson contactPersonID: " + string + " is invalid");
            throw new FSInvalidNameException("contactperson-id-invalid", null);
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSContactPerson = new FSContactPerson(string, map, bl);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCP  couldn't get contact person SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("contactPerson-retrieval-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCP couldn't get contact person SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("contactPerson-retrieval-exception", null);
        }
        return fSContactPerson;
    }

    public FSOrganization getOrganization(ServiceConfig serviceConfig, String string, boolean bl) throws FSAllianceManagementException, FSInvalidNameException {
        FSOrganization fSOrganization = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("orgID: " + string + "is invalid");
            throw new FSInvalidNameException("organization-id-invalid", null);
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSOrganization = new FSOrganization(string, map, bl);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getOrg  couldn't get organization SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("organization-retrieval-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getOrg couldn't get organization SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("organization-retrieval-exception", null);
        }
        return fSOrganization;
    }

    public FSAffiliationDescriptor getAffiliationDescriptor(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        FSAffiliationDescriptor fSAffiliationDescriptor = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("affID: " + string + "is invalid");
            throw new FSInvalidNameException("affiliation-id-invalid", null);
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSAffiliationDescriptor = new FSAffiliationDescriptor(string, map);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliation  couldn't get Affiliation SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("affiliation-retrieval-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliation couldn't get affiliation SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("affiliation-retrieval-exception", null);
        }
        return fSAffiliationDescriptor;
    }

    public FSAffiliationDescriptor getAffiliationDescriptor(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            FSAffiliationDescriptor fSAffiliationDescriptor = null;
            if (cacheOn && (fSAffiliationDescriptor = FSCache.getAffiliationDescriptor(string)) != null) {
                return fSAffiliationDescriptor;
            }
            Set set = this.entityConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                throw new FSAllianceManagementException("getAffiliationDescNoEntity", null);
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            Map map = null;
            String string2 = null;
            while (iterator.hasNext()) {
                serviceConfig = this.entityConfig.getSubConfig((String)iterator.next());
                if (serviceConfig != null) {
                    map = serviceConfig.getAttributes();
                }
                if (map == null || map.isEmpty() || (string2 = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType")) == null || !string2.equalsIgnoreCase("urn:liberty:iff:affiliate")) continue;
                Set set2 = serviceConfig.getSubConfigNames();
                if (set2 == null || set2.isEmpty()) {
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("This entity does not contain any sub element.");
                    continue;
                }
                if (!set2.contains(string)) continue;
                fSAffiliationDescriptor = this.getAffiliationDescriptor(serviceConfig, string);
                if (cacheOn) {
                    FSAffiliationDescriptor fSAffiliationDescriptor2 = FSCache.setAffiliationDescriptor(fSAffiliationDescriptor);
                }
                return fSAffiliationDescriptor;
            }
            return null;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliationDescriptor  couldn't get AffiliationDescriptor SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("affiliation-retrieval-exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliationDescriptor couldn't get AffiliationDescriptor SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("affiliation-retrieval-exception", null);
        }
    }

    public Set getProvidersInAuthenticationDomain(String string) throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        HashSet<String> hashSet = new HashSet<String>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
            Set set2 = fSProviderDescriptor.getListOfCOTs();
            if (set2 == null || !set2.contains(string)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public void addProvidersToAuthenticationDomain(String string, Collection collection) throws FSAllianceManagementException {
        this.addRemoveProvidersFromAuthenticationDomain(string, collection, true);
    }

    public void removeProvidersFromAuthenticationDomain(String string, Collection collection) throws FSAllianceManagementException {
        this.addRemoveProvidersFromAuthenticationDomain(string, collection, false);
    }

    private void addRemoveProvidersFromAuthenticationDomain(String string, Collection collection, boolean bl) throws FSAllianceManagementException {
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                HashSet<String> hashSet = fSProviderDescriptor.getListOfCOTs();
                if (bl) {
                    if (hashSet == null || hashSet == Collections.EMPTY_SET) {
                        hashSet = new HashSet<String>();
                    }
                    hashSet.add(string);
                } else if (hashSet != null) {
                    hashSet.remove(string);
                }
                fSProviderDescriptor.setListOfCOTs(hashSet);
                this.modifyProvider(fSProviderDescriptor);
            }
        }
    }

    public FSHostedProviderDescriptor getHostedProvider(String string, String string2) throws FSAllianceManagementException {
        FSProviderDescriptor fSProviderDescriptor = this.getProvider(string, string2);
        if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
            return (FSHostedProviderDescriptor)fSProviderDescriptor;
        }
        FSUtils.debug.error("FSAllianceManager.getHostedProviderDescriptor given provider is not a hosted provider");
        throw new FSAllianceManagementException("alliance_management_providerid_invalid", null);
    }

    static {
        try {
            String string = SystemProperties.get((String)"com.sun.identity.federation.alliance.cache.enabled");
            cacheOn = string.equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            FSUtils.debug.error("Could not get cacheOn signal from config.  Take default value.");
            cacheOn = true;
        }
    }
}

