/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.IntegerValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.common.validation.XSDateTimeValidator;
import com.sun.identity.common.validation.XSDurationValidator;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSAffiliationDescriptor {
    private String affID = null;
    private String affOwnerID = null;
    private String extension = null;
    private String validUtil = null;
    private String cacheDuration = null;
    private Set affMember = null;
    protected String encryptionKeyAlias = null;
    private String keyInfo = null;
    private String keyUse = null;
    private String encryptMethod = null;
    private String keySize = null;

    public FSAffiliationDescriptor(String string) throws FSAllianceManagementException {
        this.setAffiliationID(string);
    }

    public FSAffiliationDescriptor(String string, String string2) throws FSAllianceManagementException {
        this(string);
        this.setAffiliationOwnerID(string2);
    }

    FSAffiliationDescriptor(String string, Map map) throws FSAllianceManagementException {
        this.setAffiliationID(string);
        this.setAffiliationOwnerID(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationOwnerID"));
        this.setExtension(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationExtension"));
        this.setAffiliationMember((Set)map.get("sunIdentityServerAffiliateMember"));
        this.setSigningKeyAlias(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeyInfo"));
        this.setEncryptionKeyAlias(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateEncryptionKeyalias"));
        this.setKeyUse(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeyUse"));
        this.setEncryptionKeySize(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeySize"));
        this.setEncryptionKeyMethod(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateEncryptionMethod"));
        this.setValidUntil(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationValidUntil"));
        this.setCacheDuration(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationCacheDuration"));
    }

    public String getAffiliationID() {
        return this.affID;
    }

    void setAffiliationID(String string) throws FSInvalidNameException {
        if (string == null || string.trim().length() == 0) {
            throw new FSInvalidNameException("affiliation-id-invalid", null);
        }
        this.affID = string;
    }

    public String getAffiliationOwnerID() {
        return this.affOwnerID;
    }

    public void setAffiliationOwnerID(String string) {
        this.affOwnerID = string;
    }

    public String getSigningKeyAlias() {
        return this.keyInfo;
    }

    public String getEncryptionKeyAlias() {
        return this.encryptionKeyAlias;
    }

    public String getEncryptionKeyMethod() {
        return this.encryptMethod;
    }

    public String getKeyUse() {
        return this.keyUse;
    }

    public int getEncryptionKeySize() {
        int n = -1;
        if (this.keySize != null) {
            try {
                n = Integer.parseInt(this.keySize);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public void setSigningKeyAlias(String string) {
        this.keyInfo = string;
    }

    public void setEncryptionKeyAlias(String string) {
        this.encryptionKeyAlias = string;
    }

    public void setEncryptionKeyMethod(String string) {
        this.encryptMethod = string;
    }

    public void setKeyUse(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("signing") && !string.equalsIgnoreCase("encryption")) {
            throw new FSAllianceManagementException("alliance_management_invalid_key_usage", null);
        }
        this.keyUse = string;
    }

    public void setEncryptionKeySize(int n) throws FSAllianceManagementException {
        this.keySize = Integer.toString(n);
    }

    public void setEncryptionKeySize(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            IntegerValidator integerValidator = IntegerValidator.getInstance();
            try {
                integerValidator.validate(string);
                this.keySize = string;
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_key_size", null);
            }
        } else {
            this.keySize = null;
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public Set getAffiliationMember() {
        return this.affMember;
    }

    public void setAffiliationMember(Set set) {
        this.affMember = set == null ? new HashSet() : set;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setValidUntil(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            XSDateTimeValidator xSDateTimeValidator = XSDateTimeValidator.getInstance();
            try {
                xSDateTimeValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_valid_until", null);
            }
        }
        this.validUtil = string;
    }

    public void setCacheDuration(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            XSDurationValidator xSDurationValidator = XSDurationValidator.getInstance();
            try {
                xSDurationValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_cache_duration", null);
            }
        }
        this.cacheDuration = string;
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationOwnerID", this.affOwnerID);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeyInfo", this.keyInfo);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeyUse", this.keyUse);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeySize", this.keySize);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateEncryptionMethod", this.encryptMethod);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateEncryptionKeyalias", this.encryptionKeyAlias);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerAffiliateMember", this.affMember);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationExtension", this.extension);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationCacheDuration", this.cacheDuration);
        return hashMap;
    }
}

