/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.accountmgmt.FSAccountUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class FSAccountManager {
    private static FSAccountManager instance = null;
    private static String defaultOrgDN = "";
    private static SSOToken ssoToken = null;
    private static Map idRepoMap = new HashMap();
    private static boolean msgEnabled = false;
    private static String SP_FILTER = null;
    private static String SP_PROVIDER_ID;

    private FSAccountManager() throws FSAccountMgmtException {
        defaultOrgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        if (FSUtils.debug.messageEnabled()) {
            msgEnabled = true;
        }
        try {
            ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            FSUtils.debug.error("FSAccountManager.getInstance() : UnsupportedOperationException: ", (Throwable)unsupportedOperationException);
            throw new FSAccountMgmtException(unsupportedOperationException.getMessage());
        }
        SP_PROVIDER_ID = SystemProperties.get((String)"com.sun.identity.federation.sp");
        if (SP_PROVIDER_ID != null && !SP_PROVIDER_ID.equals("")) {
            SP_FILTER = "|" + SP_PROVIDER_ID + "|";
        }
    }

    private AMIdentityRepository getAMIdentityRepository(String string) throws FSAccountMgmtException {
        AMIdentityRepository aMIdentityRepository;
        block7: {
            aMIdentityRepository = null;
            try {
                aMIdentityRepository = (AMIdentityRepository)idRepoMap.get(string);
                if (aMIdentityRepository != null) break block7;
                aMIdentityRepository = new AMIdentityRepository(ssoToken, string);
                Map map = idRepoMap;
                synchronized (map) {
                    idRepoMap.put(string, aMIdentityRepository);
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAccountManager.getAMIdRepo :  create IdRepo for realm " + string);
                }
            }
            catch (IdRepoException idRepoException) {
                FSUtils.debug.error("FSAccountManager.getAMIdentityRepository : IdRepoException: ", (Throwable)idRepoException);
                throw new FSAccountMgmtException(idRepoException.getMessage());
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAccountManager.getAMIdentityRepository : SSOException: ", (Throwable)sSOException);
                throw new FSAccountMgmtException(sSOException.getMessage());
            }
        }
        return aMIdentityRepository;
    }

    public static FSAccountManager getInstance() throws FSAccountMgmtException {
        return instance;
    }

    public void writeAccountFedInfo(AMIdentity aMIdentity, FSAccountFedInfoKey fSAccountFedInfoKey, FSAccountFedInfo fSAccountFedInfo) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo() : called");
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (fSAccountFedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        if (fSAccountFedInfo == null) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo():Invalid Argument : FedInfo is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-object-is-null", null);
        }
        try {
            Object object;
            Object object2;
            HashSet<Object> hashSet;
            Object object3;
            Object object4;
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.writeAccountFedInfo() : Unable to get AMIdentity with amId :" + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            HashSet<Object> hashSet2 = aMIdentity.getAttribute("iplanet-am-user-federation-info-key");
            if (hashSet2 == null) {
                hashSet2 = new HashSet<Object>();
            } else if (!hashSet2.isEmpty()) {
                object4 = hashSet2.iterator();
                object3 = "";
                hashSet = FSAccountUtils.createFilter(fSAccountFedInfoKey);
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    if (((String)object3).indexOf((String)((Object)hashSet)) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo():AccountFedInfo Key Already Exists, will overwrite.");
                    }
                    hashSet2.remove(object3);
                    break;
                }
            }
            object4 = FSAccountUtils.objectToKeyString(fSAccountFedInfoKey);
            hashSet2.add(object4);
            object3 = new HashMap();
            object3.put("iplanet-am-user-federation-info-key", hashSet2);
            hashSet = aMIdentity.getAttribute("iplanet-am-user-federation-info");
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
            } else if (!hashSet.isEmpty()) {
                object2 = hashSet.iterator();
                object = "";
                String string = FSAccountUtils.createFilter(fSAccountFedInfoKey);
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (object.indexOf(string) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.writeAccountFedInfo() : AccountFedInfo Already Exists, will overwrite");
                    }
                    hashSet.remove(object);
                    break;
                }
            }
            object2 = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
            hashSet.add(object2);
            object3.put("iplanet-am-user-federation-info", hashSet);
            aMIdentity.setAttributes((Map)object3);
            aMIdentity.store();
            if (msgEnabled) {
                FSUtils.debug.message("FSAccountManager.writeAccountFedInfo(): Key : " + (String)object4 + ", Value : " + (String)object2 + " : Added ");
            }
            object = new String[]{IdUtils.getUniversalId(aMIdentity), object2, object4};
            LogUtil.access(Level.INFO, "WRITE_ACCOUNT_FED_INFO", object);
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo(): IdRepoException : ", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.writeAccountFedInfo(): SSOException : ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public void removeAccountFedInfo(AMIdentity aMIdentity, FSAccountFedInfo fSAccountFedInfo) throws FSAccountMgmtException {
        if (fSAccountFedInfo == null) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : FedInfo is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-object-is-null", null);
        }
        try {
            HashSet hashSet = aMIdentity.getAttribute("iplanet-am-user-federation-info");
            if (hashSet == null) {
                hashSet = new HashSet();
            } else if (!hashSet.isEmpty()) {
                Iterator iterator = hashSet.iterator();
                String string = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Account Info to be removed:" + string);
                }
                if (string != null && hashSet.contains(string)) {
                    hashSet.remove(string);
                }
                HashMap hashMap = new HashMap();
                hashMap.put("iplanet-am-user-federation-info", hashSet);
                aMIdentity.setAttributes(hashMap);
                aMIdentity.store();
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAccountManager.removeAccountFedInfo(): SSOException : ", (Throwable)exception);
            throw new FSAccountMgmtException(exception.getMessage());
        }
    }

    public void writeAccountFedInfo(AMIdentity aMIdentity, FSAccountFedInfoKey fSAccountFedInfoKey, FSAccountFedInfo fSAccountFedInfo, FSAccountFedInfoKey fSAccountFedInfoKey2) throws FSAccountMgmtException {
        this.writeAccountFedInfo(aMIdentity, fSAccountFedInfoKey, fSAccountFedInfo);
    }

    public void removeAccountFedInfoKey(AMIdentity aMIdentity, FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        block8: {
            FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():called");
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Invalid Argument : user DN is NULL");
                throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
            }
            if (fSAccountFedInfoKey == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():Invalid Argument : FedInfo key is NULL");
                throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
            }
            try {
                if (aMIdentity == null) {
                    FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey: Unable to get AMIdentity with amId:" + aMIdentity);
                    throw new FSAccountMgmtException("actmgmt-user-not-found", null);
                }
                HashMap<String, Set> hashMap = new HashMap<String, Set>();
                Set set = aMIdentity.getAttribute("iplanet-am-user-federation-info-key");
                if (set == null || set.isEmpty()) break block8;
                Iterator iterator = set.iterator();
                String string = "";
                String string2 = FSAccountUtils.createFilter(fSAccountFedInfoKey);
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (string.indexOf(string2) < 0) continue;
                    if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.removeAccountFedInfoKey():Account Fed Info Key Exists, will remove it");
                    }
                    set.remove(string);
                    hashMap.put("iplanet-am-user-federation-info-key", set);
                    aMIdentity.setAttributes(hashMap);
                    aMIdentity.store();
                    break;
                }
            }
            catch (IdRepoException idRepoException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():IdRepoException:", (Throwable)idRepoException);
                throw new FSAccountMgmtException(idRepoException.getMessage());
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfoKey():SSOException:", (Throwable)sSOException);
                throw new FSAccountMgmtException(sSOException.getMessage());
            }
        }
    }

    public void removeAccountFedInfo(AMIdentity aMIdentity, FSAccountFedInfoKey fSAccountFedInfoKey, String string) throws FSAccountMgmtException {
        block14: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAccountManager.removeAccountFedInfo(): amId=" + aMIdentity + ", infoKey=" + FSAccountUtils.createFilter(fSAccountFedInfoKey) + ", providerID=" + string);
            }
            if (fSAccountFedInfoKey == null) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : FedInfo key is NULL");
                throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
            }
            if (string == null || string.length() <= 0) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Invalid Argument : providerID is NULL");
                throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
            }
            try {
                String[] stringArray;
                Object object;
                if (aMIdentity == null) {
                    FSUtils.debug.error("FSAccountManager.removeAccountFedInfo(): Unable to get AMIdentity with amId:" + aMIdentity);
                    throw new FSAccountMgmtException("actmgmt-user-not-found", null);
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                boolean bl = false;
                Set set = aMIdentity.getAttribute("iplanet-am-user-federation-info-key");
                String string2 = "";
                if (set != null && !set.isEmpty()) {
                    object = FSAccountUtils.createFilter(fSAccountFedInfoKey);
                    stringArray = set.iterator();
                    while (stringArray.hasNext()) {
                        string2 = (String)stringArray.next();
                        if (string2.indexOf((String)object) < 0) continue;
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Key Exists, will remove it");
                        }
                        set.remove(string2);
                        hashMap.put("iplanet-am-user-federation-info-key", set);
                        bl = true;
                        break;
                    }
                }
                if ((object = aMIdentity.getAttribute("iplanet-am-user-federation-info")) != null && !object.isEmpty()) {
                    stringArray = object.iterator();
                    String string3 = "";
                    String string4 = FSAccountUtils.createFilter(string);
                    while (stringArray.hasNext()) {
                        string3 = (String)stringArray.next();
                        if (string3.indexOf(string4) < 0) continue;
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.removeAccountFedInfo():Account Fed Info Exists, will remove it");
                        }
                        object.remove(string3);
                        hashMap.put("iplanet-am-user-federation-info", object);
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    aMIdentity.setAttributes(hashMap);
                    aMIdentity.store();
                    stringArray = new String[]{IdUtils.getUniversalId(aMIdentity), string, string2};
                    LogUtil.access(Level.INFO, "REMOVE_ACCOUNT_FED_INFO", stringArray);
                    break block14;
                }
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():Account Federation Info not Found");
                throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
            }
            catch (IdRepoException idRepoException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():IdRepoException:", (Throwable)idRepoException);
                throw new FSAccountMgmtException(idRepoException.getMessage());
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAccountManager.removeAccountFedInfo():SSOException:", (Throwable)sSOException);
                throw new FSAccountMgmtException(sSOException.getMessage());
            }
        }
    }

    public FSAccountFedInfo readAccountFedInfo(AMIdentity aMIdentity, String string) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAccountFedInfo() : user=" + aMIdentity + ", providerID=" + string);
        }
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():Invalid Argument : providerID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        Set set = null;
        try {
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.readAccountFedInfo(): Unable to get AMIdentity with user:" + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = aMIdentity.getAttribute("iplanet-am-user-federation-info");
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():IdRepoException:", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.readAccountFedInfo():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            String string2 = FSAccountUtils.createFilter(string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSAccountFedInfo fSAccountFedInfo;
                String string3 = (String)iterator.next();
                if (string3.indexOf(string2) < 0 || SP_FILTER != null && string3.indexOf(SP_FILTER) < 0) continue;
                if (msgEnabled) {
                    FSUtils.debug.message("FSAccountManager.readAccountFedInfo():  value found: " + string3);
                }
                if (!(fSAccountFedInfo = FSAccountUtils.stringToObject(string3)).isFedStatusActive()) {
                    return null;
                }
                return fSAccountFedInfo;
            }
        }
        if (msgEnabled) {
            FSUtils.debug.message("FSAccountManager.readAccountFedInfo():  value with user: " + aMIdentity + " and providerID : " + string + " not found");
        }
        return null;
    }

    public Set readAllFederatedProviderID(String string) throws FSAccountMgmtException {
        AMIdentity aMIdentity = null;
        try {
            aMIdentity = IdUtils.getIdentity(ssoToken, string);
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID(String1):IdRepoException:", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        return this.readAllFederatedProviderID(aMIdentity);
    }

    public Set readAllFederatedProviderID(AMIdentity aMIdentity) throws FSAccountMgmtException {
        if (SP_PROVIDER_ID != null && !SP_PROVIDER_ID.equals("")) {
            return this.readAllFederatedProviderID(SP_PROVIDER_ID, aMIdentity);
        }
        return this.readAllFederatedProviderID(null, aMIdentity);
    }

    public Set readAllFederatedProviderID(String string, String string2) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAllFedProviderID() : user=" + string2 + ", providerID=" + string);
        }
        if (string2 == null) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        AMIdentity aMIdentity = null;
        try {
            aMIdentity = IdUtils.getIdentity(ssoToken, string2);
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID(String):IdRepoException:", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        return this.readAllFederatedProviderID(string, aMIdentity);
    }

    public Set readAllFederatedProviderID(String string, AMIdentity aMIdentity) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.readAllFedProviderID() : amId=" + aMIdentity + ", providerID=" + string);
        }
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():Invalid Argument : user ID is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        Set set = null;
        try {
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID(): Unable to get AMIdentity with amId : " + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = aMIdentity.getAttribute("iplanet-am-user-federation-info");
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():IdRepoException:", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.readAllFederatedProviderID():SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            String string2 = "";
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string2);
                if (!fSAccountFedInfo.isFedStatusActive()) continue;
                if (string == null) {
                    hashSet.add(fSAccountFedInfo.getProviderID());
                    continue;
                }
                if (string2.indexOf("|" + string + "|") == -1) continue;
                hashSet.add(fSAccountFedInfo.getProviderID());
            }
        }
        return hashSet;
    }

    public void deActivateFederation(AMIdentity aMIdentity, String string, String string2, String string3) throws FSAccountMgmtException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.deActivateFederation(): called, amId=" + aMIdentity + ", providerID=" + string + ", nameIdentifier=" + string2);
        }
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation():Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        try {
            Object object;
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.deActivateFederation(): Unable to get AMIdentity with amId:" + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            Set set = aMIdentity.getAttribute("iplanet-am-user-federation-info");
            Set set2 = aMIdentity.getAttribute("iplanet-am-user-federation-info-key");
            if (set2 != null && !set2.isEmpty() && string2 != null && string3 != null && set2.contains(object = FSAccountUtils.createFilter(string3, string2))) {
                set2.remove(object);
                hashMap.put("iplanet-am-user-federation-info-key", set2);
            }
            if (set != null && !set.isEmpty()) {
                object = set.iterator();
                String string4 = "";
                String string5 = FSAccountUtils.createFilter(string);
                while (object.hasNext()) {
                    string4 = (String)object.next();
                    if (string4.indexOf(string5) < 0 || SP_FILTER != null && string4.indexOf(SP_FILTER) < 0) continue;
                    FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string4);
                    String string6 = "";
                    if (fSAccountFedInfo.isFedStatusActive()) {
                        set.remove(string4);
                        fSAccountFedInfo.deActivateFedStatus();
                        string6 = FSAccountUtils.objectToInfoString(fSAccountFedInfo);
                        set.add(string6);
                        hashMap.put("iplanet-am-user-federation-info", set);
                        aMIdentity.setAttributes(hashMap);
                        aMIdentity.store();
                        if (msgEnabled) {
                            FSUtils.debug.message("FSAccountManager.deActivateFederation():  Value : " + string6 + " deActivated ");
                        }
                        Object[] objectArray = new String[]{IdUtils.getUniversalId(aMIdentity), string};
                        LogUtil.access(Level.INFO, "FSAccountManager", "deActivateFederation", objectArray);
                    } else if (msgEnabled) {
                        FSUtils.debug.message("FSAccountManager.deActivateFederation():  Value : " + string6 + " Already InActive ");
                    }
                    return;
                }
            }
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : Account Federation Info not Found");
            throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : IdRepoException: ", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.deActivateFederation() : SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
    }

    public boolean isFederationActive(String string, String string2) throws FSAccountMgmtException {
        AMIdentity aMIdentity = null;
        try {
            aMIdentity = IdUtils.getIdentity(ssoToken, string);
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : IdRepoException: ", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        return this.isFederationActive(aMIdentity, string2);
    }

    public boolean isFederationActive(AMIdentity aMIdentity, String string) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.isFederationActive() : called");
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.isFederationActive():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : Invalid Argument : ProviderID is NULL");
            throw new FSAccountMgmtException("actmgmt-provider-id-is-null", null);
        }
        Set set = null;
        try {
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.isFederationActive(): Unable to get AMIdentity with amId:" + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = aMIdentity.getAttribute("iplanet-am-user-federation-info");
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : IdRepoException: ", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.isFederationActive() : SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            String string2 = FSAccountUtils.createFilter(string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FSAccountFedInfo fSAccountFedInfo;
                String string3 = (String)iterator.next();
                if (string3.indexOf(string2) < 0) continue;
                if (msgEnabled) {
                    FSUtils.debug.message("FSAccountManager.isFederationActive(): value found: " + string3);
                }
                return (fSAccountFedInfo = FSAccountUtils.stringToObject(string3)).isFedStatusActive();
            }
        }
        FSUtils.debug.error("FSAccountManager.isFederationActive() : Account Federation Info not Found");
        throw new FSAccountMgmtException("actmgmt-fed-info-not-found", null);
    }

    public boolean hasAnyActiveFederation(AMIdentity aMIdentity) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.hasAnyActiveFederation():called");
        if (aMIdentity == null) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Invalid Argument : user DN is NULL");
            throw new FSAccountMgmtException("actmgmt-user-dn-is-null", null);
        }
        Set set = null;
        try {
            if (aMIdentity == null) {
                FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():Unable to get AMIdentity with amId: " + aMIdentity);
                throw new FSAccountMgmtException("actmgmt-user-not-found", null);
            }
            set = aMIdentity.getAttribute("iplanet-am-user-federation-info");
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():IdRepoException: ", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.hasAnyActiveFederation():SSOException: ", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            String string = "";
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                FSAccountFedInfo fSAccountFedInfo = FSAccountUtils.stringToObject(string);
                if (!fSAccountFedInfo.isFedStatusActive() || !fSAccountFedInfo.isRoleIDP()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public AMIdentity getAMIdentity(FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        return this.getAMIdentity(fSAccountFedInfoKey, "/");
    }

    public AMIdentity getAMIdentity(FSAccountFedInfoKey fSAccountFedInfoKey, String string) throws FSAccountMgmtException {
        FSUtils.debug.message("FSAccountManager.AMIdentity(fedInfo) : called");
        if (fSAccountFedInfoKey == null) {
            FSUtils.debug.error("FSAccountManager.getAMIdentity():Invalid Argument : fedInfoKey is NULL");
            throw new FSAccountMgmtException("actmgmt-account-fed-info-key-object-is-null", null);
        }
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(FSAccountUtils.objectToKeyString(fSAccountFedInfoKey));
        hashMap.put("iplanet-am-user-federation-info-key", hashSet);
        return this.getAMIdentity(string, hashMap);
    }

    public AMIdentity getAMIdentity(NameIdentifier nameIdentifier, String string) throws FSAccountMgmtException {
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("*" + nameIdentifier.getName() + "*");
        hashMap.put("iplanet-am-user-federation-info-key", hashSet);
        return this.getAMIdentity(string, hashMap);
    }

    public AMIdentity getAMIdentity(String string, Map map) throws FSAccountMgmtException {
        Object object;
        if (map == null) {
            return null;
        }
        Set set = null;
        try {
            object = this.getAMIdentityRepository(string);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(true);
            idSearchControl.setTimeOut(0);
            idSearchControl.setMaxResults(0);
            idSearchControl.setAllReturnAttributes(false);
            idSearchControl.setSearchModifiers(IdSearchOpModifier.AND, map);
            IdSearchResults idSearchResults = ((AMIdentityRepository)object).searchIdentities(IdType.USER, "*", idSearchControl);
            set = idSearchResults.getSearchResults();
        }
        catch (IdRepoException idRepoException) {
            FSUtils.debug.error("FSAccountManager.getAMIdentity() : IdRepoException:", (Throwable)idRepoException);
            throw new FSAccountMgmtException(idRepoException.getMessage());
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAccountManager.getAMIdentity() : SSOException:", (Throwable)sSOException);
            throw new FSAccountMgmtException(sSOException.getMessage());
        }
        if (set == null || set.isEmpty()) {
            FSUtils.debug.message("FSAccountManager.getAMIdentity: Not Found");
            return null;
        }
        if (set.size() > 1) {
            FSUtils.debug.error("FSAccountManager.getAMIdentity() : Multiple match found");
            throw new FSAccountMgmtException("actmgmt-multiple-uid-matched", null);
        }
        object = (AMIdentity)set.iterator().next();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAccountManager.gotAMIdentity: " + object);
            FSUtils.debug.message("FSAccountManager.Name=: " + ((AMIdentity)object).getName());
            FSUtils.debug.message("FSAccountManager.DN=: " + ((AMIdentity)object).getDN());
            FSUtils.debug.message("FSAccountManager.univId= " + IdUtils.getUniversalId((AMIdentity)object));
            FSUtils.debug.message("FSAccountManager.realm=: " + ((AMIdentity)object).getRealm());
        }
        return object;
    }

    static {
        try {
            instance = new FSAccountManager();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAccountManager: unable to new instance", (Throwable)exception);
        }
    }
}

