/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceConfig;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelegationPrivilege
extends DelegationPermission {
    static final Debug debug = DelegationManager.debug;
    static final String RESOURCE = "resource";
    static final String ACTIONS = "actions";
    private String name;
    private Set subjects;

    public DelegationPrivilege(String string, Set set, String string2, String string3, String string4, String string5, String string6, Set set2, Map map) throws DelegationException {
        super(string2, string3, string4, string5, string6, set2, map);
        this.setName(string);
        this.setSubjects(set);
    }

    public DelegationPrivilege(String string, Set set, String string2) throws DelegationException {
        this.name = string;
        try {
            Map map;
            string2 = DNMapper.orgNameToDN(string2);
            ServiceConfig serviceConfig = null;
            try {
                if (debug.messageEnabled()) {
                    debug.message("DelegationPrivilege: Getting org privileges; org=" + string2);
                }
                serviceConfig = DelegationUtils.getServiceConfig(string2, string, false);
            }
            catch (DelegationException delegationException) {
                if (debug.messageEnabled()) {
                    debug.message("DelegationPrivilege: privilege " + string + " not defined in realm " + string2);
                }
                serviceConfig = null;
            }
            if (serviceConfig == null) {
                if (debug.messageEnabled()) {
                    debug.message("DelegationPrivilege: Getting global privileges");
                }
                try {
                    serviceConfig = DelegationUtils.getServiceConfig(null, string, true);
                }
                catch (DelegationException delegationException) {
                    debug.error("DelegationPrivilege: privilege " + string + " is not defined in any configuration.", (Throwable)((Object)delegationException));
                    Object[] objectArray = new String[]{string};
                    throw new DelegationException("amDelegation", "privilege_not_configured", objectArray, null);
                }
            }
            if ((map = serviceConfig.getAttributes()) == null || map.isEmpty()) {
                throw new DelegationException("amDelegation", "get_privilege_attrs_failed", null, null);
            }
            Set set2 = (Set)map.get(RESOURCE);
            Set set3 = (Set)map.get(ACTIONS);
            if (set2 == null || set3 == null || set2.isEmpty() || set3.isEmpty()) {
                throw new DelegationException("amDelegation", "get_privilege_res_or_actions_failed", null, null);
            }
            Iterator iterator = set2.iterator();
            String string3 = (String)iterator.next();
            string3 = DelegationUtils.swapRealmTag(string2, string3);
            this.setOrganizationName(string3);
            this.setActions(set3);
            this.subjects = set;
            if (debug.messageEnabled()) {
                debug.message("DelegationPrivilege: org=" + string2 + "; privilege name=" + string + "; resource=" + string3 + "; actions=" + set3 + "; subjects=" + set);
            }
        }
        catch (SSOException sSOException) {
            debug.error("DelegationPrivilege: ", (Throwable)sSOException);
            throw new DelegationException(sSOException);
        }
    }

    public void setOrganizationName(String string) throws DelegationException {
        this.orgName = string != null ? string : this.getOrgBaseDN(string);
    }

    private String getOrgBaseDN(String string) {
        return DNMapper.orgNameToDN(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws DelegationException {
        this.name = string;
    }

    public Set getSubjects() {
        return this.subjects;
    }

    public void setSubjects(Set set) throws DelegationException {
        this.subjects = set;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("DelegationPrivilege Object:");
        stringBuffer.append("\nname=");
        stringBuffer.append(this.name);
        stringBuffer.append("\nsubject=");
        stringBuffer.append(this.subjects);
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

