/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class DelegationManager {
    public static final String DELEGATION_SERVICE = "sunAMDelegationService";
    static final String DELEGATION_PLUGIN_INTERFACE = "DelegationInterface";
    static final String PERMISSIONS = "Permissions";
    static final String DELEGATION_DEBUG = "amDelegation";
    static final String SUBJECT_ID_TYPES = "SubjectIdTypes";
    public static final Debug debug = Debug.getInstance((String)"amDelegation");
    private static DelegationInterface pluginInstance = null;
    private static Set actions = null;
    private static Set subjectIdTypes = null;
    private String orgName;
    private SSOToken token;

    public DelegationManager(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.token = sSOToken;
        this.orgName = DNMapper.orgNameToDN(string);
        if (pluginInstance == null) {
            pluginInstance = DelegationManager.getDelegationPlugin();
        }
    }

    public Set getConfiguredPrivilegeNames() throws DelegationException {
        Set set = null;
        Set set2 = null;
        Set set3 = null;
        try {
            ServiceConfig serviceConfig;
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(DELEGATION_SERVICE, DelegationManager.getAdminToken());
            ServiceConfig serviceConfig2 = serviceConfigManager.getGlobalConfig(null);
            if (serviceConfig2 != null && (serviceConfig = serviceConfig2.getSubConfig(PERMISSIONS)) != null) {
                set2 = serviceConfig.getSubConfigNames();
            }
            if ((serviceConfig2 = serviceConfigManager.getOrganizationConfig(this.orgName, null)) != null && (serviceConfig = serviceConfig2.getSubConfig(PERMISSIONS)) != null) {
                set3 = serviceConfig.getSubConfigNames();
            }
            if (set2 != null && !set2.isEmpty()) {
                set = set2;
                if (set3 != null && !set3.isEmpty()) {
                    set.addAll(set3);
                }
            } else {
                set = set3;
            }
        }
        catch (Exception exception) {
            throw new DelegationException(exception);
        }
        return set;
    }

    public Set getPrivileges() throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getPrivileges(this.token, this.orgName);
            }
            catch (SSOException sSOException) {
                throw new DelegationException(sSOException);
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    public Set getPrivileges(String string) throws DelegationException {
        Set set = this.getPrivileges();
        if (string == null) {
            return set;
        }
        HashSet<DelegationPrivilege> hashSet = new HashSet<DelegationPrivilege>();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DelegationPrivilege delegationPrivilege = (DelegationPrivilege)iterator.next();
                Set set2 = delegationPrivilege.getSubjects();
                if (set2 == null || set2.isEmpty()) continue;
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    hashSet.add(delegationPrivilege);
                }
            }
        }
        return hashSet;
    }

    public void addPrivilege(DelegationPrivilege delegationPrivilege) throws DelegationException {
        if (pluginInstance != null) {
            try {
                pluginInstance.addPrivilege(this.token, this.orgName, delegationPrivilege);
            }
            catch (SSOException sSOException) {
                throw new DelegationException(sSOException);
            }
        } else {
            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
        }
    }

    public void removePrivilege(String string) throws DelegationException {
        if (pluginInstance != null) {
            try {
                pluginInstance.removePrivilege(this.token, this.orgName, string);
            }
            catch (SSOException sSOException) {
                throw new DelegationException(sSOException);
            }
        } else {
            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
        }
    }

    public Set getSubjects(String string) throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getSubjects(this.token, this.orgName, subjectIdTypes, string);
            }
            catch (SSOException sSOException) {
                throw new DelegationException(sSOException);
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    public synchronized Set getActions() throws DelegationException {
        if (actions == null) {
            try {
                ServiceTypeManager serviceTypeManager = new ServiceTypeManager(DelegationManager.getAdminToken());
                ServiceType serviceType = serviceTypeManager.getServiceType(DELEGATION_SERVICE);
                if (serviceType != null) {
                    actions = serviceType.getActionNames();
                }
            }
            catch (Exception exception) {
                throw new DelegationException(exception);
            }
        }
        return actions;
    }

    public Set getManageableOrganizationNames(Set set) throws DelegationException {
        if (pluginInstance != null) {
            try {
                return pluginInstance.getManageableOrganizationNames(this.token, set);
            }
            catch (SSOException sSOException) {
                throw new DelegationException(sSOException);
            }
        }
        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
    }

    static synchronized DelegationInterface getDelegationPlugin() throws DelegationException {
        block11: {
            if (pluginInstance == null) {
                try {
                    Iterator iterator;
                    Object object;
                    SSOToken sSOToken = DelegationManager.getAdminToken();
                    ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(DELEGATION_SERVICE, sSOToken);
                    ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
                    if (serviceSchema != null && (object = serviceSchema.getAttributeDefaults()) != null) {
                        subjectIdTypes = (Set)object.get(SUBJECT_ID_TYPES);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Configured Subject ID Types: " + subjectIdTypes);
                    }
                    if ((object = serviceSchemaManager.getPluginSchemaNames(DELEGATION_PLUGIN_INTERFACE, null)) == null) {
                        throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("pluginNames=" + object);
                    }
                    if ((iterator = object.iterator()).hasNext()) {
                        String string = (String)iterator.next();
                        PluginSchema pluginSchema = serviceSchemaManager.getPluginSchema(string, DELEGATION_PLUGIN_INTERFACE, null);
                        if (pluginSchema == null) {
                            throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                        }
                        String string2 = pluginSchema.getClassName();
                        if (debug.messageEnabled()) {
                            debug.message("Plugin class name:" + string2);
                        }
                        pluginInstance = (DelegationInterface)Class.forName(string2).newInstance();
                        pluginInstance.initialize(sSOToken, null);
                        if (debug.messageEnabled()) {
                            debug.message("Successfully created a delegation plugin instance");
                        }
                        break block11;
                    }
                    throw new DelegationException(DELEGATION_DEBUG, "no_plugin_specified", null, null);
                }
                catch (Exception exception) {
                    debug.error("Unable to get an instance of pluginfor delegation", (Throwable)exception);
                    pluginInstance = null;
                    throw new DelegationException(exception);
                }
            }
        }
        return pluginInstance;
    }

    static SSOToken getAdminToken() throws SSOException {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (sSOToken == null) {
            throw new SSOException((Throwable)((Object)new DelegationException(DELEGATION_DEBUG, "getting_admin_token_failed", null, null)));
        }
        return sSOToken;
    }
}

