/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.sm.DNMapper;
import java.util.Map;
import java.util.Set;

public class DelegationEvaluator {
    static final Debug debug = DelegationManager.debug;
    static String privilegedUserName;
    private DelegationInterface pluginInstance = DelegationManager.getDelegationPlugin();

    public DelegationEvaluator() throws DelegationException {
        if (debug.messageEnabled()) {
            debug.message("Instantiated a DelegationEvaluator.");
        }
    }

    public boolean isAllowed(SSOToken sSOToken, DelegationPermission delegationPermission, Map map) throws SSOException, DelegationException {
        boolean bl = false;
        if (delegationPermission != null && sSOToken != null) {
            String string = sSOToken.getPrincipal().getName();
            if (string.equalsIgnoreCase(privilegedUserName)) {
                bl = true;
            } else if (this.pluginInstance != null) {
                bl = this.pluginInstance.isAllowed(sSOToken, delegationPermission, map);
            } else {
                throw new DelegationException("amDelegation", "no_plugin_specified", null, null);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("isAllowed() returns " + bl + " for user: " + sSOToken.getPrincipal().getName() + " for permission " + delegationPermission);
        }
        return bl;
    }

    public Set getPermissions(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        if (this.pluginInstance != null) {
            String string2 = DNMapper.orgNameToDN(string);
            return this.pluginInstance.getPermissions(sSOToken, string2);
        }
        throw new DelegationException("amDelegation", "no_plugin_specified", null, null);
    }

    static {
        try {
            privilegedUserName = DelegationManager.getAdminToken().getPrincipal().getName();
        }
        catch (Exception exception) {
            debug.error("DelegationEvaluator:", (Throwable)exception);
        }
    }
}

