/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.util.AMResourceBundleCache;
import com.sun.identity.common.L10NMessage;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.login.LoginException;

public class AuthLoginException
extends LoginException
implements L10NMessage {
    private String _message;
    private Throwable _nestedException;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String _bundleName = null;
    private String _errorCode = null;
    private Object[] _args = null;
    private ResourceBundle _bundle = null;

    public AuthLoginException(String string, Throwable throwable) {
        this._message = string;
        this._nestedException = throwable;
    }

    public AuthLoginException(Throwable throwable) {
        this._nestedException = throwable;
        if (throwable instanceof L10NMessage) {
            this._errorCode = ((L10NMessage)throwable).getErrorCode();
        }
    }

    public AuthLoginException(String string) {
        this._message = string;
    }

    public AuthLoginException(String string, String string2, Object[] objectArray, Throwable throwable) {
        this._bundleName = string;
        this._errorCode = string2;
        this._args = objectArray;
        this._nestedException = throwable;
    }

    public AuthLoginException(String string, String string2, Object[] objectArray) {
        this(string, string2, objectArray, null);
    }

    public String getL10NMessage(Locale locale) {
        String string;
        String string2 = this._message;
        if (this._bundleName != null && locale != null && this._errorCode != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            string = this._bundle.getString(this._errorCode);
            string2 = this._args == null || this._args.length == 0 ? string : MessageFormat.format(string, this._args);
        }
        string = null;
        if (this._nestedException != null) {
            if (this._nestedException instanceof L10NMessage) {
                L10NMessage l10NMessage = (L10NMessage)this._nestedException;
                string = l10NMessage.getL10NMessage(locale);
            } else {
                string = this._nestedException.getMessage();
            }
        }
        if (string2 == null) {
            string2 = string;
        } else if (string != null) {
            string2 = string2 + "\n" + string;
        }
        return string2;
    }

    public String getResourceBundleName() {
        return this._bundleName;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public Object[] getMessageArgs() {
        return this._args;
    }

    public String getMessage() {
        return this.getL10NMessage(Locale.ENGLISH);
    }

    public void printStackTrace() {
        System.err.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.fetchStackTrace());
    }

    private String getLocalMessage(Locale locale) {
        String string = this._message;
        if (this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String string2 = this._bundle.getString(this._errorCode);
            string = this._args == null || this._args.length == 0 ? string2 : MessageFormat.format(string2, this._args);
        }
        return this._message;
    }

    private String getLocalMessage() {
        return this.getLocalMessage(Locale.ENGLISH);
    }

    private String fetchStackTrace() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Throwable throwable = this;
        stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + ((AuthLoginException)throwable).getLocalMessage() + "\n");
        while (throwable instanceof AuthLoginException && ((AuthLoginException)throwable)._nestedException != null) {
            throwable = ((AuthLoginException)throwable)._nestedException;
            ++n;
            if (throwable instanceof AuthLoginException) {
                stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + ((AuthLoginException)throwable).getLocalMessage() + "\n");
                continue;
            }
            stringBuffer.append(throwable.getClass().getName() + "(" + n + ")" + ":" + throwable.getMessage() + "\n");
        }
        if (throwable == this) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((AuthLoginException)throwable).printExceptionStackTrace(printWriter);
            string = stringWriter.getBuffer().toString();
        } else {
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.printExceptionStackTrace(new PrintWriter(stringWriter2));
            StringBuffer stringBuffer2 = stringWriter.getBuffer();
            StringBuffer stringBuffer3 = stringWriter2.getBuffer();
            stringBuffer2.insert(0, stringBuffer.toString());
            string = stringBuffer2.toString();
        }
        return string;
    }

    private void printExceptionStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }
}

