/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.spi.AMModuleProperties;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.HttpCallback;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.MessageLoginException;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.authentication.spi.UserIDGenerator;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import com.sun.identity.authentication.util.ISValidation;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AMLoginModule
implements LoginModule {
    List internal = null;
    List external = null;
    List origList = null;
    private String fileName = null;
    boolean noCallbacks = false;
    private static Callback[] EMPTY_CALLBACK = new Callback[0];
    private int stateLength = 0;
    private ResourceBundle bundle = null;
    private LoginState loginState = null;
    private CallbackHandler handler = null;
    private Subject subject = null;
    private Map sharedState = null;
    private Map options = null;
    private static Debug debug = Debug.getInstance((String)"amLoginModule");
    private int currentState = 1;
    private final String EMPTY_STRING = "";
    private String moduleName = null;
    private String moduleClass = null;
    private static final String bundleName = "amAuth";
    private Principal principal = null;
    private boolean succeeded = false;
    private boolean isSharedState = false;
    private boolean isStore = true;
    protected static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    private Callback[] cloneCallbacks(int n, Callback[] callbackArray) throws AuthLoginException {
        Object object;
        if (callbackArray == null || callbackArray.length == 0) {
            debug.error("cloneCallbacks, no callbacks in state " + (n + 1));
            throw new AuthLoginException(bundleName, "noCallbackState", new Object[]{new Integer(n + 1)});
        }
        int n2 = callbackArray.length;
        Callback[] callbackArray2 = new Callback[n2];
        ArrayList<Callback> arrayList = new ArrayList<Callback>();
        int n3 = 0;
        while (n3 < n2) {
            if (callbackArray[n3] instanceof NameCallback) {
                callbackArray2[n3] = new NameCallback(((NameCallback)callbackArray[n3]).getPrompt());
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is NameCallback");
                }
            } else if (callbackArray[n3] instanceof PasswordCallback) {
                callbackArray2[n3] = new PasswordCallback(((PasswordCallback)callbackArray[n3]).getPrompt(), ((PasswordCallback)callbackArray[n3]).isEchoOn());
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is PasswordCallback");
                }
            } else if (callbackArray[n3] instanceof TextOutputCallback) {
                callbackArray2[n3] = new TextOutputCallback(((TextOutputCallback)callbackArray[n3]).getMessageType(), ((TextOutputCallback)callbackArray[n3]).getMessage());
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is TextOutputCallback");
                }
            } else if (callbackArray[n3] instanceof PagePropertiesCallback) {
                callbackArray2[n3] = new PagePropertiesCallback(((PagePropertiesCallback)callbackArray[n3]).getModuleName(), ((PagePropertiesCallback)callbackArray[n3]).getHeader(), ((PagePropertiesCallback)callbackArray[n3]).getImage(), ((PagePropertiesCallback)callbackArray[n3]).getTimeOutValue(), ((PagePropertiesCallback)callbackArray[n3]).getTemplateName(), ((PagePropertiesCallback)callbackArray[n3]).getErrorState(), ((PagePropertiesCallback)callbackArray[n3]).getPageState());
                ((PagePropertiesCallback)callbackArray2[n3]).setRequire(((PagePropertiesCallback)callbackArray[n3]).getRequire());
                ((PagePropertiesCallback)callbackArray2[n3]).setAttribute(((PagePropertiesCallback)callbackArray[n3]).getAttribute());
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is PagePropertiesCallback");
                }
            } else if (callbackArray[n3] instanceof ChoiceCallback) {
                int n4 = ((ChoiceCallback)callbackArray[n3]).getDefaultChoice();
                callbackArray2[n3] = new ChoiceCallback(((ChoiceCallback)callbackArray[n3]).getPrompt(), ((ChoiceCallback)callbackArray[n3]).getChoices(), n4, ((ChoiceCallback)callbackArray[n3]).allowMultipleSelections());
                ((ChoiceCallback)callbackArray2[n3]).setSelectedIndex(n4);
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is ChoiceCallback");
                }
            } else if (callbackArray[n3] instanceof ConfirmationCallback) {
                ConfirmationCallback confirmationCallback = (ConfirmationCallback)callbackArray[n3];
                object = confirmationCallback.getPrompt();
                String[] stringArray = confirmationCallback.getOptions();
                callbackArray2[n3] = object == null ? (stringArray == null ? new ConfirmationCallback(confirmationCallback.getMessageType(), confirmationCallback.getOptionType(), confirmationCallback.getDefaultOption()) : new ConfirmationCallback(confirmationCallback.getMessageType(), stringArray, confirmationCallback.getDefaultOption())) : (stringArray == null ? new ConfirmationCallback((String)object, confirmationCallback.getMessageType(), confirmationCallback.getOptionType(), confirmationCallback.getDefaultOption()) : new ConfirmationCallback((String)object, confirmationCallback.getMessageType(), stringArray, confirmationCallback.getDefaultOption()));
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is ConfirmationCallback");
                }
            } else if (callbackArray[n3] instanceof TextInputCallback) {
                callbackArray2[n3] = new TextInputCallback(((TextInputCallback)callbackArray[n3]).getPrompt());
                arrayList.add(callbackArray2[n3]);
                if (debug.messageEnabled()) {
                    debug.message("clone #" + n3 + " is TextInputCallback");
                }
            } else if (callbackArray[n3] instanceof HttpCallback) {
                HttpCallback httpCallback = (HttpCallback)callbackArray[n3];
                callbackArray2[n3] = new HttpCallback(httpCallback.getAuthorizationHeader(), httpCallback.getNegotiationHeaderName(), httpCallback.getNegotiationHeaderValue(), httpCallback.getNegotiationCode());
                arrayList.add(callbackArray2[n3]);
            } else {
                debug.error("unknown callback " + callbackArray[n3]);
            }
            ++n3;
        }
        Callback[] callbackArray3 = new Callback[arrayList.size()];
        if (arrayList.size() != 0) {
            object = arrayList.iterator();
            int n5 = 0;
            while (object.hasNext()) {
                callbackArray3[n5++] = (Callback)object.next();
            }
        }
        this.internal.set(n, callbackArray2);
        this.external.set(n, callbackArray3);
        return callbackArray3;
    }

    public SSOToken getSSOSession() throws AuthLoginException {
        SSOToken sSOToken = AuthD.getAuth().getSSOAuthSession();
        if (sSOToken == null) {
            throw new AuthLoginException(bundleName, "nullSess", null);
        }
        return sSOToken;
    }

    public Callback[] getCallback(int n) throws AuthLoginException {
        if (this.noCallbacks || this.isSharedState) {
            return EMPTY_CALLBACK;
        }
        if (this.internal == null) {
            this.origList = AMModuleProperties.getModuleProperties(this.fileName);
            if (this.origList == null || this.origList.isEmpty()) {
                this.noCallbacks = true;
                return EMPTY_CALLBACK;
            }
            this.stateLength = this.origList.size();
            this.internal = new ArrayList();
            this.external = new ArrayList();
            if (debug.messageEnabled()) {
                debug.message("callback size for state " + n + "=" + this.stateLength);
            }
            int n2 = 0;
            while (n2 < this.stateLength) {
                this.internal.add(null);
                this.external.add(null);
                ++n2;
            }
        }
        if (n > this.stateLength) {
            debug.error("getCallback, state " + n + " > " + this.stateLength);
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(n)});
        }
        Object e = this.external.get(n - 1);
        if (e != null) {
            return (Callback[])e;
        }
        return this.cloneCallbacks(n - 1, (Callback[])this.origList.get(n - 1));
    }

    public void replaceCallback(int n, int n2, Callback callback) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("ReplaceCallback : state=" + n + ", index=" + n2 + ", callback=" + callback);
        }
        if (n > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(n)});
        }
        Callback[] callbackArray = this.getCallback(n);
        if (n2 < 0 || n2 >= callbackArray.length) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", new Object[]{new Integer(n2)});
        }
        if (callback == null) {
            throw new AuthLoginException(bundleName, "nullCallback", null);
        }
        callbackArray[n2] = callback;
        ((Callback[])this.internal.get((int)(n - 1)))[n2 + 1] = callback;
    }

    public void replaceHeader(int n, String string) throws AuthLoginException {
        PagePropertiesCallback pagePropertiesCallback;
        String string2;
        int n2;
        if (debug.messageEnabled()) {
            debug.message("ReplaceHeader : state=" + n + ", header=" + string);
        }
        if (n > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(n)});
        }
        Callback[] callbackArray = this.getCallback(n);
        if (callbackArray.length <= 0) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", null);
        }
        if (string != null && !string.equals("") && (n2 = (string2 = (pagePropertiesCallback = (PagePropertiesCallback)((Callback[])this.internal.get(n - 1))[0]).getHeader()).indexOf("#REPLACE#")) != -1) {
            String string3 = string2.substring(0, n2) + string;
            pagePropertiesCallback.setHeader(string3);
        }
    }

    public void resetCallback(int n, int n2) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("resetCallback: state=" + n + ",index=" + n2);
        }
        if (n > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(n)});
        }
        Callback[] callbackArray = this.getCallback(n);
        if (n2 < 0 || n2 >= callbackArray.length) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", new Object[]{new Integer(n2)});
        }
        Callback callback = ((Callback[])this.origList.get(n - 1))[n2 + 1];
        Callback callback2 = null;
        if (callback instanceof NameCallback) {
            callback2 = new NameCallback(((NameCallback)callback).getPrompt());
        } else if (callback instanceof PasswordCallback) {
            callback2 = new PasswordCallback(((PasswordCallback)callback).getPrompt(), ((PasswordCallback)callback).isEchoOn());
        } else if (callback instanceof ChoiceCallback) {
            int n3 = ((ChoiceCallback)callback).getDefaultChoice();
            callback2 = new ChoiceCallback(((ChoiceCallback)callback).getPrompt(), ((ChoiceCallback)callback).getChoices(), n3, ((ChoiceCallback)callback).allowMultipleSelections());
            ((ChoiceCallback)callback2).setSelectedIndex(n3);
        } else {
            debug.error("Unsupported call back instance " + callback);
            throw new AuthLoginException(bundleName, "unknownCallback", null);
        }
        if (debug.messageEnabled()) {
            debug.message("original=" + callback + ",new=" + callback2);
        }
        ((Callback[])this.internal.get((int)(n - 1)))[n2 + 1] = callback2;
        ((Callback[])this.external.get((int)(n - 1)))[n2] = callback2;
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        this.moduleClass = string.substring(n + 1);
        this.moduleName = (String)map2.get("moduleInstanceName");
        this.loginState = this.getLoginState();
        this.fileName = this.loginState.getFileName(this.moduleClass + ".xml");
        this.bundle = amCache.getResBundle(bundleName, this.getLoginLocale());
        if (debug.messageEnabled()) {
            debug.message("AMLoginModule resbundle locale=" + this.getLoginLocale());
            debug.message("Login, class = " + string + ", module=" + this.moduleName + ", file=" + this.fileName);
        }
        this.isSharedState = Boolean.valueOf(Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-shared-state-enabled", (String)"false"));
        this.isStore = Boolean.valueOf(Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-store-shared-state-enabled", (String)"true"));
        this.init(subject, map, map2);
    }

    public abstract void init(Subject var1, Map var2, Map var3);

    public abstract int process(Callback[] var1, int var2) throws LoginException;

    public abstract Principal getPrincipal();

    public void destroyModuleState() {
    }

    public void nullifyUsedVars() {
    }

    private int wrapProcess(Callback[] callbackArray, int n) throws AuthLoginException {
        try {
            return this.process(callbackArray, n);
        }
        catch (LoginException loginException) {
            this.currentState = 0;
            this.setFailureModuleName(this.moduleName);
            if (loginException instanceof InvalidPasswordException) {
                throw new InvalidPasswordException(loginException);
            }
            throw new AuthLoginException(loginException);
        }
    }

    private boolean moduleHasDone() {
        return this.currentState == -1 || this.currentState == 0;
    }

    public final boolean login() throws AuthLoginException {
        if (this.moduleHasDone()) {
            debug.message("This module has already done.");
            return this.currentState == -1;
        }
        if (debug.messageEnabled()) {
            debug.message("This module is not done yet. CurrentState: " + this.currentState);
        }
        if (this.internal == null) {
            this.getCallback(1);
        }
        if (this.noCallbacks) {
            this.currentState = this.wrapProcess(EMPTY_CALLBACK, 1);
            if (this.currentState == -1) {
                this.setSuccessModuleName(this.moduleName);
                this.succeeded = true;
                this.nullifyUsedVars();
                return true;
            }
            if (this.currentState == 0) {
                this.setFailureModuleName(this.moduleName);
                this.succeeded = false;
                this.destroyModuleState();
                this.principal = null;
                return false;
            }
            this.setFailureModuleName(this.moduleName);
            this.succeeded = false;
            this.cleanup();
            throw new AuthLoginException(bundleName, "invalidCode", new Object[]{new Integer(this.currentState)});
        }
        if (this.handler == null) {
            debug.error("Handler is null");
            throw new AuthLoginException(bundleName, "nullHandler", null);
        }
        try {
            while (this.currentState != -1 && this.currentState != 0) {
                Object object;
                Callback[] callbackArray;
                if (debug.messageEnabled()) {
                    debug.message("Login, state = " + this.currentState);
                }
                if (this.isSharedState) {
                    this.currentState = this.wrapProcess(EMPTY_CALLBACK, 1);
                    this.isSharedState = false;
                    continue;
                }
                this.getCallback(this.currentState);
                Callback[] callbackArray2 = (Callback[])this.internal.get(this.currentState - 1);
                PagePropertiesCallback pagePropertiesCallback = (PagePropertiesCallback)callbackArray2[0];
                if (pagePropertiesCallback.getErrorState()) {
                    this.setFailureModuleName(this.moduleName);
                    callbackArray = pagePropertiesCallback.getTemplateName();
                    object = pagePropertiesCallback.getHeader();
                    if (callbackArray == null || callbackArray.equals("")) {
                        throw new MessageLoginException((String)object);
                    }
                    this.setModuleErrorTemplate((String)callbackArray);
                    throw new AuthLoginException((String)object);
                }
                this.handler.handle(callbackArray2);
                callbackArray = (Callback[])this.internal.get(this.currentState - 1);
                object = (PagePropertiesCallback)callbackArray[0];
                String string = ((PagePropertiesCallback)object).getPageState();
                if (string != null && string.length() != 0 && !string.equals(Integer.toString(this.currentState))) {
                    int n = Integer.parseInt(string);
                    ((PagePropertiesCallback)object).setPageState(Integer.toString(this.currentState));
                    this.currentState = n;
                    if (debug.messageEnabled()) {
                        debug.message("currentState from UI " + this.currentState);
                    }
                }
                this.currentState = this.wrapProcess((Callback[])this.external.get(this.currentState - 1), this.currentState);
                if (!debug.messageEnabled()) continue;
                debug.message("Login NEXT State : " + this.currentState);
            }
            if (this.currentState == -1) {
                this.setSuccessModuleName(this.moduleName);
                this.succeeded = true;
                this.nullifyUsedVars();
                return true;
            }
            this.setFailureModuleName(this.moduleName);
            this.succeeded = false;
            this.destroyModuleState();
            this.principal = null;
            return false;
        }
        catch (IOException iOException) {
            this.setFailureModuleName(this.moduleName);
            if (iOException.getMessage().equals("110")) {
                debug.message("login timed out ", (Throwable)iOException);
            } else {
                debug.message("login ", (Throwable)iOException);
            }
            throw new AuthLoginException(iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            this.setFailureModuleName(this.moduleName);
            debug.message("Login", (Throwable)unsupportedCallbackException);
            throw new AuthLoginException(unsupportedCallbackException);
        }
    }

    public int getAuthLevel() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return 0;
            }
        }
        return this.loginState.getAuthLevel();
    }

    public boolean setAuthLevel(int n) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set auth level : " + n);
                return false;
            }
        }
        this.loginState.setModuleAuthLevel(n);
        return true;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public HttpServletRequest getHttpServletRequest() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getHttpServletRequest();
    }

    protected LoginState getLoginState(String string) throws AuthLoginException {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                throw new AuthLoginException(bundleName, "wrongCall", new Object[]{string});
            }
        }
        return this.loginState;
    }

    protected Locale getLoginLocale() {
        try {
            String string = this.getLocale();
            return com.iplanet.am.util.Locale.getLocale((String)string);
        }
        catch (AuthLoginException authLoginException) {
            debug.message("unable to determine loginlocale ", (Throwable)authLoginException);
            return Locale.ENGLISH;
        }
    }

    private LoginState getLoginState() {
        Callback[] callbackArray = new Callback[1];
        try {
            callbackArray[0] = new LoginStateCallback();
            if (this.handler == null) {
                return null;
            }
            this.handler.handle(callbackArray);
            return ((LoginStateCallback)callbackArray[0]).getLoginState();
        }
        catch (Exception exception) {
            debug.message("Error..", (Throwable)exception);
            return null;
        }
    }

    public HttpServletResponse getHttpServletResponse() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getHttpServletResponse();
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public String getLocale() throws AuthLoginException {
        return this.getLoginState("getLocale()").getLocale();
    }

    public int getNumberOfStates() {
        return this.stateLength;
    }

    public String getRequestOrg() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getOrgDN();
    }

    public String getSessionId() {
        InternalSession internalSession;
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        if ((internalSession = this.loginState.getSession()) != null) {
            return internalSession.getID().toString();
        }
        return null;
    }

    public Map getOrgProfile(String string) throws AuthLoginException {
        Map map = null;
        if (string == null || string.equals("")) {
            string = this.getLoginState("getOrgProfile(String)").getOrgDN();
        }
        try {
            OrganizationConfigManager organizationConfigManager = AuthD.getAuth().getOrgConfigManager(string);
            map = organizationConfigManager.getAttributes("sunIdentityRepositoryService");
            if (debug.messageEnabled()) {
                debug.message("orgMap is : " + map);
            }
        }
        catch (Exception exception) {
            debug.message("getOrgProfile", (Throwable)exception);
            throw new AuthLoginException(exception);
        }
        return map;
    }

    public Map getOrgServiceTemplate(String string, String string2) throws AuthLoginException {
        Map map = null;
        if (string == null || string.equals("")) {
            string = this.getLoginState("getOrgServiceTemplate(String, String)").getOrgDN();
        }
        try {
            OrganizationConfigManager organizationConfigManager = AuthD.getAuth().getOrgConfigManager(string);
            map = organizationConfigManager.getServiceConfig(string2).getAttributes();
        }
        catch (Exception exception) {
            debug.message("getOrgServiceTemplate", (Throwable)exception);
            throw new AuthLoginException(exception);
        }
        return map;
    }

    public boolean getPersistentCookieOn() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        return this.loginState.getPersistentCookieMode();
    }

    public boolean isDynamicProfileCreationEnabled() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        return this.loginState.isDynamicProfileCreationEnabled();
    }

    public boolean setPersistentCookieOn() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        if (!this.loginState.getPersistentCookieMode()) {
            return false;
        }
        this.loginState.setPersistentCookieOn();
        return true;
    }

    public Map getServiceConfig(String string) throws AuthLoginException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, AuthD.getAuth().getSSOAuthSession());
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            HashMap hashMap = new HashMap();
            if (serviceSchema != null) {
                hashMap.putAll(serviceSchema.getAttributeDefaults());
            }
            if ((serviceSchema = serviceSchemaManager.getOrganizationSchema()) != null) {
                hashMap.putAll(serviceSchema.getAttributeDefaults());
            }
            if ((serviceSchema = serviceSchemaManager.getUserSchema()) != null) {
                hashMap.putAll(serviceSchema.getAttributeDefaults());
            }
            if ((serviceSchema = serviceSchemaManager.getPolicySchema()) != null) {
                hashMap.putAll(serviceSchema.getAttributeDefaults());
            }
            return hashMap;
        }
        catch (Exception exception) {
            debug.message("getServiceConfig", (Throwable)exception);
            throw new AuthLoginException(exception);
        }
    }

    public AMUser getUserProfile(String string) throws AuthLoginException {
        AMUser aMUser = null;
        try {
            aMUser = AuthD.getAuth().getSDK().getUser(string);
        }
        catch (Exception exception) {
            debug.message("getUserProfile", (Throwable)exception);
            throw new AuthLoginException(exception);
        }
        return aMUser;
    }

    public String getUserSessionProperty(String string) throws AuthLoginException {
        InternalSession internalSession = this.getLoginState("getUserSessionProperty()").getSession();
        if (internalSession != null) {
            return internalSession.getProperty(string);
        }
        return null;
    }

    public void setUserSessionProperty(String string, String string2) throws AuthLoginException {
        InternalSession internalSession = this.getLoginState("setUserSessionProperty()").getSession();
        if (internalSession == null) {
            throw new AuthLoginException(bundleName, "wrongCall", new Object[]{" setUserSessionProperty()"});
        }
        internalSession.putProperty(string, string2);
    }

    public Set getNewUserIDs(Map map, int n) throws AuthLoginException {
        boolean bl = this.getLoginState((String)"getNewUserIDs(Map, int)").userIDGeneratorEnabled;
        if (!bl) {
            return null;
        }
        String string = this.getLoginState((String)"getNewUserIDs(Map, int)").userIDGeneratorClassName;
        String string2 = this.getLoginState("getNewUserIDs(Map, int)").getOrgDN();
        if (string == null || string.equals("")) {
            string = "com.sun.identity.authentication.spi.DefaultUserIDGenerator";
        }
        UserIDGenerator userIDGenerator = null;
        try {
            Class<?> clazz = Class.forName(string);
            userIDGenerator = (UserIDGenerator)clazz.newInstance();
        }
        catch (Exception exception) {
            debug.message("getNewUserIDs(): unable to instantiate " + string, (Throwable)exception);
            return null;
        }
        return userIDGenerator.generateUserIDs(string2, map, n);
    }

    public void setLoginFailureURL(String string) throws AuthLoginException {
        this.getLoginState("setLoginFailureURL()").setFailureLoginURL(string);
    }

    public void setModuleErrorTemplate(String string) throws AuthLoginException {
        this.getLoginState("setModuleTemplate()").setModuleErrorTemplate(string);
    }

    public void setLoginSuccessURL(String string) throws AuthLoginException {
        this.getLoginState("setLoginSuccessURL()").setSuccessLoginURL(string);
    }

    public void setOrg(String string) throws AuthLoginException {
    }

    public boolean isRequired(int n, int n2) {
        if (n > this.stateLength) {
            return false;
        }
        Callback[] callbackArray = (Callback[])this.internal.get(n - 1);
        if (callbackArray == null || callbackArray.length == 0) {
            return false;
        }
        Callback callback = callbackArray[0];
        if (callback instanceof PagePropertiesCallback) {
            List list = ((PagePropertiesCallback)callback).getRequire();
            if (list == null || list.isEmpty() || n2 >= list.size()) {
                return false;
            }
            String string = (String)list.get(n2);
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public String getAttribute(int n, int n2) {
        if (n > this.stateLength) {
            return "";
        }
        Callback[] callbackArray = (Callback[])this.internal.get(n - 1);
        if (callbackArray == null || callbackArray.length == 0) {
            return "";
        }
        Callback callback = callbackArray[0];
        if (callback instanceof PagePropertiesCallback) {
            List list = ((PagePropertiesCallback)callback).getAttribute();
            if (list == null || list.isEmpty() || n2 >= list.size()) {
                return "";
            }
            return (String)list.get(n2);
        }
        return "";
    }

    public final boolean abort() throws AuthLoginException {
        debug.message("ABORT return.... false");
        if (!this.succeeded) {
            return false;
        }
        this.logout();
        return true;
    }

    public final boolean commit() throws AuthLoginException {
        this.principal = this.getPrincipal();
        if (debug.messageEnabled()) {
            debug.message("AMLoginModule.commit():Succeed,principal=" + this.principal);
        }
        if (!this.succeeded || this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            debug.message("Done added user to principal");
        }
        this.cleanup();
        return true;
    }

    public final boolean logout() throws AuthLoginException {
        if (this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().remove(this.principal);
        }
        this.succeeded = false;
        this.cleanup();
        return true;
    }

    public void setFailureID(String string) {
        if (string == null) {
            return;
        }
        debug.message("setFailureID : " + string);
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set set userId : " + string);
                return;
            }
        }
        this.loginState.setFailedUserId(string);
    }

    public void setUserAttributes(Map map) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set user attributes");
                return;
            }
        }
        this.loginState.setUserCreationAttributes(map);
    }

    public void validateUserName(String string, String string2) throws UserNamePasswordValidationException {
        try {
            AMUserPasswordValidation aMUserPasswordValidation = this.getUPValidationInstance();
            if (aMUserPasswordValidation != null) {
                debug.message("Validating username...");
                aMUserPasswordValidation.validateUserID(string);
            } else if (string2 != null && !string2.equals("") && !ISValidation.validate(string, string2, debug)) {
                throw new UserNamePasswordValidationException(bundleName, "invalidChars", null);
            }
        }
        catch (AMException aMException) {
            if (debug.messageEnabled()) {
                debug.message("User Name validation Failed" + aMException.getMessage());
            }
            throw new UserNamePasswordValidationException(aMException);
        }
        catch (Exception exception) {
            debug.message("unKnown Exception occured during username validation");
            throw new UserNamePasswordValidationException(exception);
        }
    }

    private void setSuccessModuleName(String string) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set moduleName : " + string);
                return;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SETTING Module name.... :" + string);
        }
        this.loginState.setSuccessModuleName(string);
    }

    public boolean isValidUserEntry(String string) {
        boolean bl = false;
        try {
            bl = AuthD.getAuth().getSDK().isValidEntry(string);
        }
        catch (Exception exception) {
            debug.message("Entry not found", (Throwable)exception);
        }
        if (debug.messageEnabled()) {
            debug.message("User Valid :" + bl);
        }
        return bl;
    }

    public boolean isSuperAdmin(String string) {
        boolean bl = AuthD.getAuth().isSuperAdmin(string);
        if (debug.messageEnabled()) {
            debug.message("is SuperAdmin : " + bl);
        }
        return bl;
    }

    public void validatePassword(String string) throws UserNamePasswordValidationException {
        AMUserPasswordValidation aMUserPasswordValidation = this.getUPValidationInstance();
        try {
            if (aMUserPasswordValidation != null) {
                debug.message("Validating password...");
                aMUserPasswordValidation.validatePassword(string);
            } else {
                debug.message("No plugin found");
            }
        }
        catch (AMException aMException) {
            if (debug.messageEnabled()) {
                debug.message("Password validation Failed " + aMException.getMessage());
            }
            throw new UserNamePasswordValidationException(aMException);
        }
        catch (Exception exception) {
            debug.message("Unknown Exception occured during username validation");
            throw new UserNamePasswordValidationException(exception);
        }
    }

    private AMUserPasswordValidation getUPValidationInstance() {
        try {
            String string = this.getPluginClassName();
            if (debug.messageEnabled()) {
                debug.message("UserPasswordValidation Class Name is : " + string);
            }
            if (string == null || string.equals("")) {
                return null;
            }
            AMUserPasswordValidation aMUserPasswordValidation = (AMUserPasswordValidation)Class.forName(string).newInstance();
            return aMUserPasswordValidation;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug.messageEnabled()) {
                debug.message("Class not Found :", (Throwable)classNotFoundException);
            }
            return null;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Error: ", (Throwable)exception);
            }
            return null;
        }
    }

    private String getPluginClassName() throws AuthLoginException {
        Map map = this.getServiceConfig("iPlanetAMAdminConsoleService");
        String string = Misc.getServerMapAttr((Map)map, (String)"iplanet-am-admin-console-user-password-validation-class");
        if (debug.messageEnabled()) {
            debug.message("Plugin Class:  " + string);
        }
        return string;
    }

    private void setFailureModuleName(String string) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set moduleName : " + string);
                return;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SETTING Failure Module name.... :" + string);
        }
        this.loginState.setFailureModuleName(string);
    }

    public String getUserKey() {
        return "javax.security.auth.login.name";
    }

    public String getPwdKey() {
        return "javax.security.auth.login.password";
    }

    private void cleanup() {
        this.principal = null;
        if (this.sharedState != null) {
            this.sharedState.remove("javax.security.auth.login.name");
            this.sharedState.remove("javax.security.auth.login.password");
        }
        this.sharedState = null;
        this.destroyModuleState();
    }

    public void storeUsernamePasswd(String string, String string2) {
        if (this.isStore && this.sharedState != null) {
            this.sharedState.put("javax.security.auth.login.name", string);
            this.sharedState.put("javax.security.auth.login.password", string2);
        }
    }

    public boolean isSharedStateEnabled() {
        return this.isSharedState;
    }

    public AMIdentityRepository getAMIdentityRepository(String string) {
        return AuthD.getAuth().getAMIdentityRepository(string);
    }

    public void createIdentity(String string, Map map, Set set) throws IdRepoException, SSOException {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to create Identity: " + string);
                return;
            }
        }
        this.loginState.createUserIdentity(string, map, set);
    }
}

