/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.modules.saml.SAMLPrincipal;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.SSOTokenPrincipal;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.common.DateUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfig;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginState {
    private static final String rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    private static final boolean urlRewriteInPath = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.cookieRewritingInPath", (String)""));
    private static AuthD ad = AuthD.getAuth();
    private static String pCookieName = AuthUtils.getPersistentCookieName();
    private static Set userAttributes = new HashSet();
    Callback[] receivedCallbackInfo;
    Callback[] prevCallback;
    Callback[] submittedCallbackInfo;
    HashMap callbacksPerState = new HashMap();
    InternalSession sess = null;
    HttpSession hsess = null;
    HttpServletRequest servletRequest;
    HttpServletResponse servletResponse;
    String orgName;
    String userOrg;
    String orgDN = null;
    int loginStatus = 2;
    Hashtable requestHash;
    boolean requestType;
    Set aliasAttrNames = null;
    public boolean inetDomainStatus = true;
    String userContainerDN = null;
    boolean nullUserContainerDN = false;
    boolean dnByUserContainer = false;
    String userNamingAttr = null;
    public Set defaultRoles = null;
    boolean dynamicProfileCreation = false;
    boolean ignoreUserProfile = false;
    boolean createWithAlias = false;
    boolean persistentCookieMode = false;
    public String persistentCookieTime = null;
    public boolean persistentCookieOn = false;
    public String defaultAuthLevel = "0";
    Subject subject;
    String token = null;
    String userDN = null;
    int maxSession;
    int idleTime;
    int cacheTime;
    int authLevel = 0;
    int moduleAuthLevel = Integer.MIN_VALUE;
    String client = null;
    String authMethName = "";
    String pAuthMethName = null;
    String queryOrg = null;
    SessionID sid;
    SSOToken ssoToken;
    boolean cookieSupported = true;
    boolean cookieSet = false;
    String filePath;
    boolean userEnabled = true;
    boolean isAdmin;
    boolean isApp = false;
    AMIdentity amIdentityRole = null;
    Set tokenSet;
    AuthContext.IndexType indexType;
    String indexName = null;
    AuthContext.IndexType prevIndexType = null;
    Set userAliasList = null;
    boolean hasAdminToken = false;
    String gotoURL = null;
    String gotoOnFailURL = null;
    String failureLoginURL = null;
    String successLoginURL = null;
    String moduleSuccessLoginURL = null;
    String moduleFailureLoginURL = null;
    Set orgSuccessLoginURLSet = null;
    String clientOrgSuccessLoginURL = null;
    String defaultOrgSuccessLoginURL = null;
    String clientOrgFailureLoginURL = null;
    String defaultOrgFailureLoginURL = null;
    Set orgFailureLoginURLSet = null;
    Map requestMap = new HashMap();
    public boolean userIDGeneratorEnabled;
    public String userIDGeneratorClassName;
    Set domainAuthenticators = null;
    Set moduleInstances = null;
    AuthContextLocal oldAuthContext;
    boolean sessionUpgrade = false;
    int upgradeAuthLevel = 0;
    String loginURL = null;
    long pageTimeOut = 60L;
    long lastCallbackSent = 0L;
    AMIdentity amIdentityUser = null;
    public boolean loginFailureLockoutMode = false;
    public String accountLife = null;
    public long loginFailureLockoutDuration = 0L;
    public long loginFailureLockoutTime = 300000L;
    public int loginFailureLockoutCount = 5;
    public String loginLockoutNotification = null;
    public String loginLockoutAttrName = null;
    public String loginLockoutAttrValue = null;
    public int loginLockoutUserWarning = 3;
    public int userWarningCount = 0;
    String errorCode = null;
    String errorMessage = null;
    String errorTemplate = null;
    String moduleErrorTemplate = null;
    String lockoutMsg = null;
    boolean timedOut = false;
    public String failureTokenId = null;
    String principalList = null;
    String pCookieUserName = null;
    private ISLocaleContext localeContext = new ISLocaleContext();
    X509Certificate cert = null;
    String defaultUserSuccessURL;
    String clientUserSuccessURL;
    Set userSuccessURLSet = Collections.EMPTY_SET;
    String clientUserFailureURL;
    String defaultUserFailureURL;
    Set userFailureURLSet = Collections.EMPTY_SET;
    String clientSuccessRoleURL;
    String defaultSuccessRoleURL;
    Set successRoleURLSet = Collections.EMPTY_SET;
    String clientFailureRoleURL;
    String defaultFailureRoleURL;
    Set failureRoleURLSet = Collections.EMPTY_SET;
    String userAuthConfig = "";
    String orgAuthConfig = null;
    String orgAdminAuthConfig = null;
    Set orgPostLoginClassSet = Collections.EMPTY_SET;
    Map serviceAttributesMap = new HashMap();
    String moduleErrorMessage = null;
    String defaultSuccessURL = null;
    String defaultFailureURL = null;
    String tempDefaultURL = null;
    String sessionSuccessURL = null;
    Set postLoginInstanceSet = null;
    boolean isRemote = false;
    boolean cookieDetect = false;
    HashMap userCreationAttributes = null;
    Set externalAliasList = null;
    Set successModuleSet = new HashSet();
    Set failureModuleSet = new HashSet();
    String failureModuleList = "";
    String fqdnFailureLoginURL = null;
    Map moduleMap = null;
    Map roleAttributeMap = null;
    Boolean foundPCookie = null;
    long pCookieTimeCreated;
    static AuthUtils au = new AuthUtils();
    Set identityTypes = Collections.EMPTY_SET;
    Hashtable idRepoHash = new Hashtable();
    AMIdentityRepository amIdRepo = null;
    private static String serverURL = null;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.servletRequest = httpServletRequest;
    }

    public InternalSession getSession() {
        if (this.sess == null || this.sess.getState() == 2 || this.sess.getState() == 3) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Session is null OR INACTIVE OR DESTROYED :" + this.sess);
            }
            return null;
        }
        return this.sess;
    }

    public HttpSession getHttpSession() {
        return this.hsess;
    }

    public void setSession(InternalSession internalSession) {
        this.sess = internalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedCallback(Callback[] callbackArray, AMLoginContext aMLoginContext) {
        AMLoginContext aMLoginContext2 = aMLoginContext;
        synchronized (aMLoginContext2) {
            this.submittedCallbackInfo = null;
            this.receivedCallbackInfo = callbackArray;
            this.prevCallback = callbackArray;
            aMLoginContext.notify();
        }
    }

    public void setReceivedCallback_NoThread(Callback[] callbackArray) {
        this.submittedCallbackInfo = null;
        this.receivedCallbackInfo = callbackArray;
        this.prevCallback = callbackArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubmittedCallback(Callback[] callbackArray, AMLoginContext aMLoginContext) {
        AMLoginContext aMLoginContext2 = aMLoginContext;
        synchronized (aMLoginContext2) {
            this.receivedCallbackInfo = null;
            this.prevCallback = this.receivedCallbackInfo;
            this.submittedCallbackInfo = callbackArray;
            aMLoginContext.notify();
        }
    }

    public void setSubmittedCallback_NoThread(Callback[] callbackArray) {
        this.receivedCallbackInfo = null;
        this.prevCallback = this.receivedCallbackInfo;
        this.submittedCallbackInfo = callbackArray;
    }

    public Callback[] getReceivedInfo() {
        return this.receivedCallbackInfo;
    }

    public Callback[] getSubmittedInfo() {
        return this.submittedCallbackInfo;
    }

    public String getOrgDN() {
        if (this.orgDN == null) {
            try {
                this.orgDN = ad.getOrgDN(this.userOrg);
            }
            catch (Exception exception) {
                AuthD.debug.message("Error getting orgDN: ", (Throwable)exception);
            }
        }
        return this.orgDN;
    }

    public String getOrgName() {
        if (this.orgName == null) {
            this.orgName = AuthUtils.DNtoName(this.getOrgDN());
        }
        return this.orgName;
    }

    public int getLoginStatus() {
        return this.loginStatus;
    }

    public synchronized void setLoginStatus(int n) {
        this.loginStatus = n;
    }

    public void setParamHash(Hashtable hashtable) {
        this.requestHash = hashtable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                this.requestMap.put(k, v);
            }
        }
    }

    public void setRequestType(boolean bl) {
        this.requestType = bl;
    }

    public boolean isNewRequest() {
        return this.requestType;
    }

    public boolean isDynamicProfileCreationEnabled() {
        return this.dynamicProfileCreation;
    }

    public void populateOrgProfile() throws AuthException {
        try {
            Object object;
            this.inetDomainStatus = ad.getInetDomainStatus(this.getOrgDN());
            if (!this.inetDomainStatus) {
                this.logFailed(au.getErrorVal("109", "Error_Message"), "ORGINACTIVE");
                throw new AuthException("109", null);
            }
            OrganizationConfigManager organizationConfigManager = ad.getOrgConfigManager(this.getOrgDN());
            ServiceConfig serviceConfig = organizationConfigManager.getServiceConfig("iPlanetAMAuthService");
            Map map = serviceConfig.getAttributes();
            this.aliasAttrNames = (Set)map.get("iplanet-am-auth-alias-attr-name");
            if (AuthD.revisionNumber >= 30) {
                this.identityTypes = (Set)map.get("sunAMIdentityType");
            } else {
                this.identityTypes = new HashSet();
                object = (Set)map.get("iplanet-am-auth-user-container");
                this.getContainerDN((Set)object);
            }
            this.userNamingAttr = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-user-naming-attr", (String)"uid");
            this.defaultRoles = (Set)map.get("iplanet-am-auth-default-role");
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (((String)object).equalsIgnoreCase("true")) {
                this.dynamicProfileCreation = true;
            } else if (((String)object).equalsIgnoreCase("ignore")) {
                this.ignoreUserProfile = true;
            } else if (((String)object).equalsIgnoreCase("createAlias")) {
                this.createWithAlias = true;
                this.dynamicProfileCreation = true;
            }
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-persistent-cookie-mode");
            if (((String)object).equalsIgnoreCase("true")) {
                this.persistentCookieMode = true;
            }
            object = null;
            this.persistentCookieTime = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-persistent-cookie-time");
            AMAuthenticationManager aMAuthenticationManager = new AMAuthenticationManager(ad.getSSOAuthSession(), this.getOrgDN());
            this.domainAuthenticators = aMAuthenticationManager.getAllowedModuleNames();
            if (this.domainAuthenticators == null) {
                this.domainAuthenticators = Collections.EMPTY_SET;
            }
            this.defaultAuthLevel = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-default-auth-level", (String)LoginState.ad.defaultAuthLevel);
            this.localeContext.setOrgLocale(this.getOrgDN());
            this.orgSuccessLoginURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            if (this.orgSuccessLoginURLSet == null) {
                this.orgSuccessLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgSuccessLoginURL = this.getRedirectUrl(this.orgSuccessLoginURLSet);
            this.defaultOrgSuccessLoginURL = this.tempDefaultURL;
            this.orgFailureLoginURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
            if (this.orgFailureLoginURLSet == null) {
                this.orgFailureLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgFailureLoginURL = this.getRedirectUrl(this.orgFailureLoginURLSet);
            this.defaultOrgFailureLoginURL = this.tempDefaultURL;
            this.orgAuthConfig = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-org-config");
            this.orgAdminAuthConfig = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-admin-auth-module");
            this.orgPostLoginClassSet = (Set)map.get("iplanet-am-auth-post-login-process-class");
            if (this.orgPostLoginClassSet == null) {
                this.orgPostLoginClassSet = Collections.EMPTY_SET;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-lockout-mode")) != null && ((String)object).equalsIgnoreCase("true")) {
                this.loginFailureLockoutMode = true;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-duration")) != null) {
                try {
                    this.loginFailureLockoutDuration = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-duration bad format.");
                }
                this.loginFailureLockoutDuration *= 60000L;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-count")) != null) {
                try {
                    this.loginFailureLockoutCount = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-count bad format.");
                }
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-duration")) != null) {
                try {
                    this.loginFailureLockoutTime = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-login-failure-duration bad format.");
                }
                this.loginFailureLockoutTime *= 60000L;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-warn-user")) != null) {
                try {
                    this.loginLockoutUserWarning = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-warn-user bad format.");
                }
            }
            this.loginLockoutNotification = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-email-address");
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-username-generator-enabled");
            if (object != null) {
                this.userIDGeneratorEnabled = Boolean.valueOf((String)object);
            }
            this.userIDGeneratorClassName = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-username-generator-class");
            this.loginLockoutAttrName = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-attribute-name");
            this.loginLockoutAttrValue = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-attribute-value");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Getting Org Profile: " + this.orgDN + "\nlocale->" + this.localeContext.getLocale() + "\ncharset->" + this.localeContext.getMIMECharset() + "\ndynamicProfileCreation->" + this.dynamicProfileCreation + "\ndefaultAuthLevel->" + this.defaultAuthLevel + "\norgSucessLoginURLSet->" + this.orgSuccessLoginURLSet + "\norgFailureLoginURLSet->" + this.orgFailureLoginURLSet + "\nclientSuccessLoginURL ->" + this.clientOrgSuccessLoginURL + "\ndefaultSuccessLoginURL ->" + this.defaultOrgSuccessLoginURL + "\norgPostLoginClassSet ->" + this.orgPostLoginClassSet + "\norgAuthConfig ->" + this.orgAuthConfig + "\norgAdminAuthConfig ->" + this.orgAdminAuthConfig + "\nclientFailureLoginURL ->" + this.clientOrgFailureLoginURL + "\ndefaultFailureLoginURL ->" + this.defaultOrgFailureLoginURL + "\nloginFailureLockoutMode->" + this.loginFailureLockoutMode + "\nloginFailureLockoutCount->" + this.loginFailureLockoutCount + "\nloginFailureLockoutTime->" + this.loginFailureLockoutTime + "\nloginLockoutUserWarning->" + this.loginLockoutUserWarning + "\nloginLockoutNotification->" + this.loginLockoutNotification + "\npersistentCookieMode->" + this.persistentCookieMode + "\nidentityTypes->" + this.identityTypes + "\naliasAttrNames ->" + this.aliasAttrNames);
            }
        }
        catch (AuthException authException) {
            AuthD.debug.error("Error in populateOrgProfile", (Throwable)((Object)authException));
            throw new AuthException((Throwable)((Object)authException));
        }
        catch (Exception exception) {
            AuthD.debug.error("Error in populateOrgProfile", (Throwable)exception);
            throw new AuthException("102", null);
        }
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public String getUserDN() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getUserDN: " + this.userDN);
        }
        return this.userDN;
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public void setClient(String string) {
        this.client = string;
    }

    public String getClient() {
        String string;
        block9: {
            if (this.client != null) {
                return this.client;
            }
            string = "";
            try {
                String string2 = null;
                if (this.requestHash != null) {
                    string2 = (String)this.requestHash.get("client");
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("getClient : servletRequest is : " + this.client);
                    AuthD.debug.message("getClient : cli is : " + string2);
                }
                if (string2 == null || string2.equals("")) {
                    if (this.servletRequest != null) {
                        string = this.servletRequest.getRemoteAddr();
                    } else {
                        InetAddress inetAddress = InetAddress.getLocalHost();
                        string = inetAddress.getHostAddress();
                    }
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block9;
                AuthD.debug.message("Error getting clienty Type ", (Throwable)exception);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Client is : " + string);
        }
        this.client = string;
        return string;
    }

    public String tokenToDN(String string) {
        try {
            String string2 = string.toLowerCase();
            int n = string2.indexOf("|");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (Misc.isDescendantOf((String)string2, (String)this.getOrgDN())) {
                return string2;
            }
            if (ad.isSuperAdmin(string2)) {
                return string2;
            }
            String string3 = "amService-".toLowerCase();
            if (string2.startsWith(string3)) {
                return "cn=" + string2 + ",ou=DSAME Users," + rootSuffix;
            }
            String string4 = string2;
            string4 = AuthUtils.DNtoName(string2);
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(this.userNamingAttr).append("=").append(string4).append(",").append(this.userContainerDN);
            this.dnByUserContainer = true;
            String string5 = stringBuffer.toString();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("token=" + string + ", id=" + string4 + ", DN=" + string5);
            }
            return string5;
        }
        catch (Exception exception) {
            AuthD.debug.error("tokenToDN : " + exception.getMessage());
            return string;
        }
    }

    public String getClientType() {
        String string = null;
        string = this.servletRequest != null ? au.getClientType(this.servletRequest) : au.getDefaultClientType();
        return string;
    }

    public boolean activateSession(Subject subject, AuthContextLocal authContextLocal) {
        try {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("activateSession - Token is : " + this.token);
                AuthD.debug.message("activateSession - userDN is : " + this.userDN);
            }
            boolean bl = false;
            try {
                this.setSuccessLoginURL(this.indexType, this.indexName);
                if (ad.isHttpSessionUsed()) {
                    this.sess = ad.newSession(this.getOrgDN(), null);
                    this.sid = this.sess.getID();
                    this.sess.setObject("authContextObject", (Object)authContextLocal);
                    if (this.hsess != null) {
                        this.hsess.removeAttribute("authContextObject");
                        this.hsess.invalidate();
                        this.hsess = null;
                    }
                }
                this.subject = this.addSSOTokenPrincipal(subject);
                this.setSessionProperties(this.sess);
                bl = this.sess.activate(this.userDN);
            }
            catch (AuthException authException) {
                return false;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Activating session: " + this.sess);
            }
            return bl;
        }
        catch (Exception exception) {
            AuthD.debug.error("Error activating session: ", (Throwable)exception);
            return false;
        }
    }

    public void setSessionProperties(InternalSession internalSession) throws AuthException {
        String string;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState getSession = " + internalSession + " \nrequest token = " + this.token);
        }
        if (this.token == null) {
            throw new AuthException("102", null);
        }
        String string2 = string = this.cookieSupported ? "true" : "false";
        if (this.userDN == null) {
            this.userDN = this.getUserDN(this.amIdentityUser);
        }
        String string3 = null;
        if (this.oldAuthContext != null) {
            string3 = AuthUtils.getLoginState(this.oldAuthContext).getUserDN();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("userDN is : " + this.userDN);
            AuthD.debug.message("oldUserDN is : " + string3);
            AuthD.debug.message("sessonUpgrade is : " + this.sessionUpgrade);
        }
        if (this.sessionUpgrade && string3 != null && AuthUtils.getNormalizedDN(this.userDN).equals(AuthUtils.getNormalizedDN(string3))) {
            this.sessionUpgrade();
        } else {
            this.sessionUpgrade = false;
        }
        Date date = new Date();
        String string4 = DateUtils.toUTCDateFormat((Date)date);
        String string5 = null;
        if (this.loginURL != null) {
            int n = this.loginURL.indexOf("?");
            string5 = this.loginURL;
            if (n != -1) {
                string5 = this.loginURL.substring(0, n);
            }
            internalSession.putProperty("loginURL", string5);
        }
        this.sessionSuccessURL = ad.processURL(this.successLoginURL, this.servletRequest);
        this.sessionSuccessURL = this.encodeURL(this.sessionSuccessURL, this.servletResponse, true);
        if (this.sessionSuccessURL != null) {
            internalSession.putProperty("successURL", this.sessionSuccessURL);
        }
        String string6 = null;
        if (this.amIdentityUser != null) {
            string6 = IdUtils.getUniversalId(this.amIdentityUser);
        }
        this.getClient();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setSessionProperties Principal = " + this.userDN + "\n" + "UserId = " + this.token + "\n" + "client = " + this.client + "\n" + "Organization = " + this.orgDN + "\n" + "locale = " + this.localeContext.getLocale() + "\n" + "charset = " + this.localeContext.getMIMECharset() + "\n" + "idleTime = " + this.idleTime + "\n" + "cacheTime = " + this.cacheTime + "\n" + "maxSession = " + this.maxSession + "\n" + "AuthLevel = " + this.authLevel + "\n" + "AuthType = " + this.authMethName + "\n" + "Subject = " + this.subject.toString() + "\n" + "UniversalId = " + string6 + "\n" + "cookieSupport = " + string + "\n" + "principals = " + this.principalList + "\n" + "defaultLoginURL = " + string5 + "\n" + "successURL = " + this.sessionSuccessURL + "\n" + "IndexType = " + this.indexType + "\n" + "AuthInstant = " + string4);
        }
        try {
            Map map;
            if (this.isApplicationModule() && ad.isSpecialUser(this.userDN) || this.isAgent(this.amIdentityUser)) {
                AuthD.debug.message("setSessionProperties for non-expiring session");
                internalSession.setClientID(this.token);
                internalSession.setExpire(false);
                internalSession.setType(1);
            } else {
                AuthD.debug.message("request: in putProperty stuff");
                internalSession.setClientID(this.userDN);
                internalSession.setMaxSessionTime((long)this.maxSession);
                internalSession.setMaxIdleTime((long)this.idleTime);
                internalSession.setMaxCachingTime((long)this.cacheTime);
            }
            internalSession.setClientDomain(this.getOrgDN());
            internalSession.setType(0);
            if (this.client != null) {
                internalSession.putProperty("Host", this.client);
            }
            if (!this.sessionUpgrade) {
                internalSession.putProperty("AuthLevel", new Integer(this.authLevel).toString());
                internalSession.putProperty("AuthType", this.authMethName);
            }
            internalSession.putProperty("Principal", this.userDN);
            internalSession.putProperty("UserId", this.token);
            internalSession.putProperty("UserToken", AuthUtils.DNtoName(this.token));
            internalSession.putProperty("Organization", this.orgDN);
            internalSession.putProperty("Locale", this.localeContext.getLocale().toString());
            internalSession.putProperty("CharSet", this.localeContext.getMIMECharset());
            internalSession.putProperty("clientType", this.getClientType());
            internalSession.putProperty("cookieSupport", string);
            internalSession.putProperty("authInstant", string4);
            if (this.principalList != null) {
                internalSession.putProperty("Principals", this.principalList);
            }
            if (this.indexType != null) {
                internalSession.putProperty("IndexType", this.indexType.toString());
            }
            if (string6 != null) {
                internalSession.putProperty("sun.am.UniversalIdentifier", string6);
            }
            if (this.indexType == AuthContext.IndexType.ROLE && this.indexName != null && !this.sessionUpgrade) {
                internalSession.putProperty("Role", this.indexName);
            }
            if (this.indexType == AuthContext.IndexType.SERVICE && this.indexName != null && !this.sessionUpgrade) {
                internalSession.putProperty("Service", this.indexName);
            }
            if ((map = this.getAttrMapForSAML()) != null && !map.isEmpty()) {
                Set set = map.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string7 = (String)entry.getKey();
                    String string8 = (String)entry.getValue();
                    internalSession.putProperty(string7, string8);
                    if (!AuthD.debug.messageEnabled()) continue;
                    AuthD.debug.message("AttrMap for SAML : " + string7 + " , " + string8);
                }
            }
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception in setSession ", (Throwable)exception);
            throw new AuthException(exception);
        }
    }

    public boolean getInetDomainStatus() {
        return this.inetDomainStatus;
    }

    public void setQueryOrg(String string) {
        this.queryOrg = string;
    }

    public String getQueryOrg() {
        return this.queryOrg;
    }

    public String getLocale() {
        if (this.isRemote) {
            return AuthD.platLocale;
        }
        return this.localeContext.getLocale().toString();
    }

    void destroySession() {
        if (this.sess != null) {
            AuthUtils.removeAuthContext(this.sid);
            ad.destroySession(this.sid);
            this.sid = null;
            this.sess = null;
        }
        if (ad.isHttpSessionUsed() && this.hsess != null) {
            this.hsess.removeAttribute("authContextObject");
            this.hsess.invalidate();
            this.hsess = null;
        }
    }

    public void persistentCookieArgExists() {
        String string = (String)this.requestHash.get("iPSPCookie");
        if (string != null && !string.equals("")) {
            this.persistentCookieOn = string.equalsIgnoreCase("yes");
        }
    }

    public SessionID getSid() {
        return this.sid;
    }

    public String getUserDomain(HttpServletRequest httpServletRequest, SessionID sessionID, Hashtable hashtable) {
        String string = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!this.sessionUpgrade && !hashtable.isEmpty() && sSOTokenManager.isValidToken(sSOToken)) {
                string = sSOToken.getProperty("Organization");
                AuthD.debug.message("User org from existing valid session");
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("ERROR in getUserDomain - " + exception.toString());
        }
        if (string == null) {
            string = AuthUtils.newSessionArgExists(hashtable, sessionID) && sessionID.toString().length() > 0 ? sessionID.getSessionDomain() : au.getDomainNameByRequest(httpServletRequest, hashtable);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("returning from getUserDomain : " + string);
        }
        return string;
    }

    public AuthContextLocal createAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionID sessionID, Hashtable hashtable) throws AuthException {
        this.loginURL = au.constructLoginURL(httpServletRequest);
        this.setRequestLocale(httpServletRequest);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("locale : " + this.localeContext.getLocale());
        }
        this.userOrg = this.getUserDomain(httpServletRequest, sessionID, hashtable);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == null || this.userOrg.equals("")) {
            AuthD.debug.message("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"), "INVALIDDOMAIN");
            throw new AuthException("108", null);
        }
        AuthD.debug.message("AuthUtil:getAuthContext:Creating new AuthContextLocal & LoginState");
        AuthContextLocal authContextLocal = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.servletRequest = httpServletRequest;
        this.servletResponse = httpServletResponse;
        this.requestHash = hashtable;
        this.client = this.getClient();
        this.sid = sessionID;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("requestType : " + this.requestType);
            AuthD.debug.message("client : " + this.client);
            AuthD.debug.message("sid : " + sessionID);
        }
        try {
            this.createSession(httpServletRequest, authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception creating session .. :", (Throwable)exception);
            throw new AuthException(exception);
        }
        String string = au.getCookieSupport(this.getClientType());
        this.cookieDetect = au.getCookieDetect(string);
        if (string != null && string.equals("false")) {
            this.cookieSupported = false;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("cookieSupport is : " + string);
            AuthD.debug.message("cookieDetect is .. : " + this.cookieDetect);
            AuthD.debug.message("cookieSupported is .. : " + this.cookieSupported);
        }
        if (AuthUtils.isClientDetectionEnabled() && this.cookieDetect) {
            this.cookieSet = true;
        }
        this.setGoToURL();
        this.setGoToOnFailURL();
        this.amIdRepo = ad.getAMIdentityRepository(this.getOrgDN());
        this.persistentCookieArgExists();
        this.populateOrgProfile();
        return authContextLocal;
    }

    void createSession(HttpServletRequest httpServletRequest, AuthContextLocal authContextLocal) throws AuthException {
        AuthD.debug.message("LoginState: createSession: Creating new session: ");
        SessionID sessionID = null;
        if (ad.isHttpSessionUsed()) {
            AuthD.debug.message("Save authContext in HttpSession");
            if (httpServletRequest != null) {
                this.hsess = httpServletRequest.getSession();
                sessionID = new SessionID(this.hsess.getId());
                this.hsess.setAttribute("authContextObject", (Object)authContextLocal);
            }
        } else {
            AuthD.debug.message("Save authContext in InternalSession");
            this.sess = ad.newSession(this.getOrgDN(), null);
            sessionID = this.sess.getID();
            this.sess.setObject("authContextObject", (Object)authContextLocal);
        }
        this.sid = sessionID;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState:createSession: New session/sid=" + sessionID);
            AuthD.debug.message("LoginState:New session: ac=" + authContextLocal);
        }
    }

    public SSOToken getSSOToken() throws SSOException {
        if (this.ssoToken != null) {
            return this.ssoToken;
        }
        if (this.sess != null && this.sess.getState() == 2) {
            return null;
        }
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            this.ssoToken = sSOTokenManager.createSSOToken(this.sess.getID().toString());
            return this.ssoToken;
        }
        catch (SSOException sSOException) {
            AuthD.debug.error("Error retrieving SSOToken :", (Throwable)sSOException);
            throw new SSOException("amAuth", "102", null);
        }
    }

    public String encodeURL(String string, HttpServletResponse httpServletResponse) {
        return this.encodeURL(string, httpServletResponse, false);
    }

    public String encodeURL(String string, HttpServletResponse httpServletResponse, boolean bl) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("in encodeURL");
            AuthD.debug.message("cookieDetect : " + this.cookieDetect);
            AuthD.debug.message("cookieSupported : " + this.cookieSupported);
        }
        if (!this.cookieDetect && this.cookieSupported) {
            return string;
        }
        if (this.sess == null) {
            return string;
        }
        String string2 = AuthUtils.getCookieName();
        if (!bl && this.sess.getState() == 0) {
            string2 = AuthUtils.getAuthCookieName();
        }
        String string3 = string;
        string3 = urlRewriteInPath ? this.sess.encodeURL(string, (short)2, false, string2) : this.sess.encodeURL(string, (short)0, false, string2);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthRequest encodeURL : URL=" + string + ", Rewritten URL=" + string3);
        }
        return string3;
    }

    public String getFileName(String string) {
        String string2 = au.getFileName(string, this.getLocale(), this.getOrgDN(), this.servletRequest, ad.getServletContext(), this.indexType, this.indexName);
        return string2;
    }

    public boolean createUserProfile(String string, Set set) {
        try {
            Map map;
            if (!this.dynamicProfileCreation) {
                AuthD.debug.message("Error this user requires a profile to login");
                return false;
            }
            if (this.isApplicationModule()) {
                AuthD.debug.message("No profile created for Application module");
                return false;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Creating user entry: " + string);
                AuthD.debug.message("aliasList : " + set);
            }
            if (this.userCreationAttributes == null) {
                this.userCreationAttributes = new HashMap();
            }
            Map map2 = Collections.EMPTY_MAP;
            if (set != null && !set.isEmpty()) {
                AuthD.debug.message("Adding alias list to user profile");
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    set.addAll(this.externalAliasList);
                }
                map2.put("iplanet-am-user-alias-list", set);
            }
            if (!map2.isEmpty()) {
                this.userCreationAttributes.putAll(map2);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("userCreationAttributes is : " + this.userCreationAttributes);
            }
            this.amIdentityUser = this.createUserIdentity(string, this.userCreationAttributes, this.defaultRoles);
            this.userDN = this.getUserDN(this.amIdentityUser);
            Map map3 = this.amIdentityUser.getAttributes();
            if (this.amIdentityRole != null && (map = this.amIdentityRole.getServiceAttributes("iPlanetAMSessionService")) != null && !map.isEmpty()) {
                map3.putAll(map);
            }
            this.populateUserAttributes(map3, true, null);
            return true;
        }
        catch (Exception exception) {
            AuthD.debug.error("Cannot create user profile for: " + string);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Stack trace: ", (Throwable)exception);
            }
            return false;
        }
    }

    private String[] getDefaultSessionAttributes(String string) {
        String string2 = ad.getDefaultMaxSessionTime();
        String string3 = ad.getDefaultMaxIdleTime();
        String string4 = ad.getDefaultMaxCachingTime();
        Map map = ad.getOrgServiceAttributes(string, "iPlanetAMSessionService");
        if (!map.isEmpty()) {
            if (map.containsKey("iplanet-am-session-max-session-time")) {
                string2 = (String)((Set)map.get("iplanet-am-session-max-session-time")).iterator().next();
            }
            if (map.containsKey("iplanet-am-session-max-idle-time")) {
                string3 = (String)((Set)map.get("iplanet-am-session-max-idle-time")).iterator().next();
            }
            if (map.containsKey("iplanet-am-session-max-caching-time")) {
                string4 = (String)((Set)map.get("iplanet-am-session-max-caching-time")).iterator().next();
            }
        }
        String[] stringArray = new String[]{string2, string3, string4};
        return stringArray;
    }

    void populateUserAttributes(Map map, boolean bl, AMIdentity aMIdentity) throws AMException {
        String[] stringArray = this.getDefaultSessionAttributes(this.getOrgDN());
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("default max session time: " + stringArray[0] + "\ndefault max idle time: " + stringArray[1] + "\ndefault max caching time: " + stringArray[2]);
        }
        try {
            this.userAuthConfig = Misc.getMapAttr((Map)map, (String)"iplanet-am-user-auth-config", null);
            if (!bl) {
                this.userFailureURLSet = (Set)map.get("iplanet-am-user-failure-url");
                this.clientUserFailureURL = this.getRedirectUrl(this.userFailureURLSet);
                this.defaultUserFailureURL = this.tempDefaultURL;
                this.failureRoleURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
                this.clientFailureRoleURL = this.getRedirectUrl(this.failureRoleURLSet);
                this.defaultFailureRoleURL = this.tempDefaultURL;
                return;
            }
            this.maxSession = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-session-time", (String)stringArray[0], (Debug)AuthD.debug);
            this.idleTime = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-idle-time", (String)stringArray[1], (Debug)AuthD.debug);
            this.cacheTime = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-caching-time", (String)stringArray[2], (Debug)AuthD.debug);
            String string = Misc.getMapAttr((Map)map, (String)"inetuserstatus", (String)"active");
            if (aMIdentity != null) {
                string = aMIdentity.isActive() ? "active" : "inactive";
            }
            String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-user-login-status", (String)"active");
            String string3 = Misc.getMapAttr((Map)map, (String)"nsaccountlock", (String)"false");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("entity status is : " + string);
                AuthD.debug.message("user-login-status is : " + string2);
                AuthD.debug.message("nsaccountlock is : " + string3);
            }
            if (!(string2.equalsIgnoreCase("active") && string.equalsIgnoreCase("active") && string3.equalsIgnoreCase("false"))) {
                this.userEnabled = false;
            }
            String string4 = Misc.getMapAttr((Map)map, (String)"preferredlocale", null);
            this.localeContext.setUserLocale(string4);
            this.userAliasList = (Set)map.get("iplanet-am-user-alias-list");
            if (this.aliasAttrNames != null && !this.aliasAttrNames.isEmpty()) {
                Iterator iterator = this.aliasAttrNames.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    Set set = (Set)map.get(string5);
                    if (set == null) continue;
                    if (this.userAliasList == null) {
                        this.userAliasList = new HashSet();
                    }
                    this.userAliasList.addAll(set);
                }
            }
            this.accountLife = Misc.getMapAttr((Map)map, (String)"iplanet-am-user-account-life");
            this.userSuccessURLSet = (Set)map.get("iplanet-am-user-success-url");
            this.clientUserSuccessURL = this.getRedirectUrl(this.userSuccessURLSet);
            this.defaultUserSuccessURL = this.tempDefaultURL;
            this.successRoleURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            this.clientSuccessRoleURL = this.getRedirectUrl(this.successRoleURLSet);
            this.defaultSuccessRoleURL = this.tempDefaultURL;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Populate User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString() + "\n  userAlias->  :" + this.userAliasList + "\n  userSuccessURLSet-> :" + this.userSuccessURLSet + "\n  clientUserSuccessURL->  :" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL->  :" + this.defaultUserSuccessURL + "\n  userFailureURLSet-> :" + this.userFailureURLSet + "\n  clientUserFailureURL->  :" + this.clientUserFailureURL + "\n  defaultUserFailureURL->  :" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->  :" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->  :" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->  :" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->  :" + this.defaultFailureRoleURL + "\n  userAuthConfig -> : " + this.userAuthConfig + "\n  accountLife->" + this.accountLife);
            }
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Eception in populateUserAttributes : ", (Throwable)exception);
            }
            throw new AMException(exception.getMessage(), exception.toString());
        }
    }

    public boolean getUserProfile(String string, boolean bl) throws AuthException {
        try {
            return this.getUserProfile(string, bl, true);
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("getUserProfile(string,boolean)", (Throwable)exception);
            }
            throw new AuthException(exception);
        }
    }

    public boolean getUserProfile(String string, boolean bl, boolean bl2) throws AuthException {
        block33: {
            if (string == null || string.length() == 0) {
                throw new AuthException("102", null);
            }
            IdType idType = null;
            try {
                Object object;
                Object object2;
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("In getUserProfile : Search for user " + string);
                }
                Set<Object> set = Collections.EMPTY_SET;
                IdSearchResults idSearchResults = null;
                if (ad.isSuperAdmin(string)) {
                    object2 = ad.getIdentity(IdType.USER, string, this.orgDN);
                    set = new HashSet<Object>();
                    set.add(object2);
                } else {
                    block32: {
                        try {
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("LoginState: gettingIdentity using IdUtil.getIdentity: " + string + " Org: " + this.getOrgDN());
                            }
                            if ((object2 = IdUtils.getIdentity(ad.getSSOAuthSession(), string, this.getOrgDN())) != null && ((AMIdentity)object2).getAttributes() != null) {
                                set = new HashSet();
                                set.add(object2);
                                idType = ((AMIdentity)object2).getType();
                                if (AuthD.debug.messageEnabled()) {
                                    AuthD.debug.message("LoginState: getIdentity using IdUtil.getIdentity: " + object2);
                                }
                            }
                        }
                        catch (IdRepoException idRepoException) {
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("LoginState: getting identity Got IdRepException in IdUtils.getIdentity", (Throwable)idRepoException);
                            }
                        }
                        catch (SSOException sSOException) {
                            if (!AuthD.debug.messageEnabled()) break block32;
                            AuthD.debug.message("LoginState: getting identity Got SSOException in IdUtils.getIdentity", (Throwable)sSOException);
                        }
                    }
                    if (set == Collections.EMPTY_SET || !this.identityTypes.contains(idType.getName())) {
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("LoginState: getIdentity performing IdRepo search to obtain AMIdentity");
                        }
                        object2 = AuthUtils.DNtoName(string);
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("Search for Identity " + (String)object2);
                        }
                        object = this.identityTypes.iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            idSearchResults = this.searchIdentity(IdUtils.getType(string2), (String)object2);
                            if (idSearchResults != null) {
                                set = idSearchResults.getSearchResults();
                            }
                            if (set.isEmpty()) continue;
                        }
                    }
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("result is :" + set);
                }
                if (set.isEmpty()) {
                    return false;
                }
                if (set.size() > 1) {
                    AuthD.debug.error("getUserProfile : Multiple matches found for user '" + this.token + "' in org " + this.orgDN + "\nPlease make sure user is unique within the login " + "organization, and contact your admin to fix the problem");
                    throw new AuthException("102", null);
                }
                this.amIdentityUser = (AMIdentity)set.iterator().next();
                if (this.userDN == null) {
                    this.userDN = this.getUserDN(this.amIdentityUser);
                }
                idType = this.amIdentityUser.getType();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("userDN is : " + this.userDN);
                    AuthD.debug.message("userID(token) is : " + this.token);
                    AuthD.debug.message("idType is : " + idType);
                }
                if (bl) {
                    object2 = null;
                    object = null;
                    object2 = idSearchResults != null ? (Map)idSearchResults.getResultAttributes().get(this.amIdentityUser) : this.amIdentityUser.getAttributes();
                    if (this.amIdentityRole != null) {
                        AuthD.debug.message("retrieving session service from role");
                        object = this.amIdentityRole.getServiceAttributes("iPlanetAMSessionService");
                    } else if (idType.equals(IdType.USER)) {
                        AuthD.debug.message("retrieving session service from user");
                        object = this.amIdentityUser.getServiceAttributes("iPlanetAMSessionService");
                    }
                    if (object != null && !object.isEmpty()) {
                        object2.putAll(object);
                    }
                    this.populateUserAttributes((Map)object2, bl2, this.amIdentityUser);
                }
                return true;
            }
            catch (SSOException sSOException) {
                AuthD.debug.error("SSOException");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Stack trace: ", (Throwable)sSOException);
                }
            }
            catch (AMException aMException) {
                AuthD.debug.error("No aliases for: " + this.aliasAttrNames + "=" + this.token);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Stack trace: ", (Throwable)aMException);
                }
            }
            catch (IdRepoException idRepoException) {
                if (!AuthD.debug.messageEnabled()) break block33;
                AuthD.debug.error("IdReporException ", (Throwable)idRepoException);
            }
        }
        return false;
    }

    public void populateDefaultUserAttributes() throws AMException {
        String[] stringArray = this.getDefaultSessionAttributes(this.getOrgDN());
        try {
            this.maxSession = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            this.maxSession = 120;
        }
        try {
            this.idleTime = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            this.idleTime = 30;
        }
        try {
            this.cacheTime = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            this.cacheTime = 3;
        }
        this.userEnabled = true;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Populate Default User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  clientUserSuccessURL ->" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL ->" + this.defaultUserSuccessURL + "\n  clientUserFailureURL ->" + this.clientUserFailureURL + "\n  defaultUserFailureURL ->" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->" + this.defaultFailureRoleURL + "\n  userAuthConfig ->" + this.userAuthConfig + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchUserProfile(Subject subject, AuthContext.IndexType indexType, String string) throws AuthException {
        this.tokenSet = this.getTokenFromPrincipal(subject);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("in searchUserProfile");
            AuthD.debug.message("indexType is.. :" + indexType);
            AuthD.debug.message("indexName is.. :" + string);
            AuthD.debug.message("Subject is.. :" + subject);
            AuthD.debug.message("token is.. :" + this.token);
            AuthD.debug.message("tokenSet is.. :" + this.tokenSet);
            AuthD.debug.message("pCookieUserName is.. :" + this.pCookieUserName);
            AuthD.debug.message("userDN is.. :" + this.userDN);
        }
        try {
            boolean bl = true;
            if (this.ignoreUserProfile || this.isApplicationModule() && ad.isSpecialUser(this.userDN)) {
                if (ad.isSuperAdmin(this.userDN)) {
                    this.amIdentityUser = ad.getIdentity(IdType.USER, this.userDN, this.getOrgDN());
                }
                if (this.userDN == null) {
                    this.userDN = this.getUserDN(this.amIdentityUser);
                }
                this.populateDefaultUserAttributes();
                return true;
            }
            if (indexType == AuthContext.IndexType.USER || this.pCookieUserName != null) {
                if (this.token == null && this.pCookieUserName != null) {
                    this.token = this.pCookieUserName;
                }
                if (this.token == null) {
                    return false;
                }
                Map map = this.searchUserAliases(this.token, this.tokenSet);
                if (!this.checkAliasList(map)) {
                    if (!this.createWithAlias) throw new AuthException("107", null);
                    if (this.amIdentityUser == null) {
                        this.addAliasToUserProfile(this.amIdentityUser, map);
                    } else {
                        this.addAliasToUserProfile(this.token, map);
                    }
                }
            } else {
                boolean bl2 = true;
                if (this.tokenSet.isEmpty()) {
                    AuthD.debug.message("tokenset empty");
                    throw new AuthException("102", null);
                }
                if (this.tokenSet.size() == 1) {
                    AuthD.debug.message("tokenset size is 1");
                    bl = this.getCreateUserProfile(true);
                    if (!this.userEnabled) {
                        this.setFailedUserId(AuthUtils.DNtoName(this.token));
                        throw new AuthException("104", null);
                    }
                    if (ad.isSuperAdmin(this.userDN)) {
                        return true;
                    }
                    if (bl && indexType == AuthContext.IndexType.ROLE) {
                        boolean bl3 = this.getUserForRole(this.getIdentityRole(string, this.getOrgDN()));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("userRoleFound: " + bl3);
                        }
                        if (!bl3) {
                            this.logFailed(au.getErrorVal("113", "Error_Message"), "USERNOTFOUND");
                            throw new AuthException("113", null);
                        }
                    }
                } else {
                    AuthD.debug.message("came here !! multiple modules , users ");
                    String string2 = null;
                    bl = false;
                    boolean bl4 = false;
                    boolean bl5 = true;
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                    Map map = new HashMap();
                    HashMap<String, Boolean> hashMap3 = new HashMap<String, Boolean>();
                    Boolean bl6 = Boolean.FALSE;
                    String string3 = null;
                    Iterator iterator = this.tokenSet.iterator();
                    while (iterator.hasNext()) {
                        this.token = (String)iterator.next();
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("BEGIN WHILE: Token is.. : " + this.token);
                        }
                        bl = this.getUserProfile(this.token, true);
                        hashMap3.put(this.token, new Boolean(bl));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("gotUserProfile : " + bl);
                        }
                        if (!bl) continue;
                        if (string2 == null) {
                            string2 = this.token;
                        }
                        hashMap.put(this.token, new Boolean(this.userEnabled));
                        if (indexType == AuthContext.IndexType.ROLE) {
                            bl5 = this.getUserForRole(this.getIdentityRole(string, this.getOrgDN()));
                            hashMap2.put(this.token, new Boolean(bl5));
                        }
                        if (!(bl4 = this.getFoundUserAlias(map = this.searchUserAliases(this.token, this.tokenSet)))) continue;
                        string3 = this.token;
                        if (!AuthD.debug.messageEnabled()) break;
                        AuthD.debug.message("found aliases exiting while:" + map);
                        break;
                    }
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("Alias Token is : " + string3);
                        AuthD.debug.message("Profile Token :" + string2);
                        AuthD.debug.message("Token is : " + this.token);
                    }
                    if (string3 != null) {
                        this.token = string3;
                    }
                    if (!this.hasAdminToken) {
                        boolean bl7 = this.getUserEnabled(hashMap);
                        if (!bl7) {
                            this.setFailedUserId(AuthUtils.DNtoName(this.token));
                            throw new AuthException("104", null);
                        }
                        if (indexType == AuthContext.IndexType.ROLE) {
                            bl5 = this.getUserRoleFound(hashMap2);
                            if (!bl5) {
                                this.logFailed(au.getErrorVal("113", "Error_Message"), "USERNOTFOUND");
                                throw new AuthException("113", null);
                            }
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("userRoleFound:" + bl5);
                            }
                        }
                        bl = this.getGotUserProfile(hashMap3);
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("userEnabled : " + bl7);
                        }
                        if (bl && !bl4) {
                            if (!this.createWithAlias) throw new AuthException("107", null);
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("dynamicProfileCreation : " + this.dynamicProfileCreation);
                                AuthD.debug.message("foundUserAliasMap : " + map);
                                AuthD.debug.message("foundUserAliasMap : " + bl4);
                            }
                            this.addAliasToUserProfile(string2, map);
                        }
                        if (this.createWithAlias && !bl) {
                            bl = this.createUserProfileForTokens(this.tokenSet, hashMap3);
                        }
                    }
                }
            }
            if (!AuthD.debug.messageEnabled()) return bl;
            AuthD.debug.message("LoginState:searchUserProfile:returning: " + bl);
            return bl;
        }
        catch (AuthException authException) {
            throw new AuthException((Throwable)((Object)authException));
        }
        catch (Exception exception) {
            AuthD.debug.error("Error retrieving profile", (Throwable)exception);
            throw new AuthException(exception);
        }
    }

    boolean getCreateUserProfile(boolean bl) throws AuthException {
        boolean bl2 = false;
        bl2 = this.userDN != null ? this.getUserProfile(this.userDN, bl) : this.getUserProfile(this.token, bl);
        if (!bl2 && !ad.isSuperAdmin(this.userDN)) {
            bl2 = this.createUserProfile(this.token, null);
        }
        return bl2;
    }

    boolean createUserProfileForTokens(Set set, Map map) {
        HashSet hashSet = new HashSet();
        String string = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !ad.isSuperAdmin(string = (String)iterator.next())) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("alias list add token:" + (String)e);
                }
                hashSet.add(e);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Tokens List is.. :" + hashSet);
        }
        try {
            boolean bl = this.createUserProfile(string, hashSet);
            return bl;
        }
        catch (Exception exception) {
            AuthD.debug.error("Cannot create user profile for: " + string);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Stack trace: ", (Throwable)exception);
            }
            return false;
        }
    }

    Map searchUserAliases(String string, Set set) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("userAliastList is.. :" + this.userAliasList);
            AuthD.debug.message("userToken is.. :" + string);
            AuthD.debug.message("tokenSet is.. :" + set);
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this.userAliasList != null && !this.userAliasList.isEmpty()) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("AuthToken is : " + string2);
                        AuthD.debug.message("userToken is : " + string);
                    }
                    if (string2 != null && string2.equalsIgnoreCase(string) && !hashMap.containsKey(string2)) {
                        hashMap.put(string2, Boolean.TRUE);
                        continue;
                    }
                    if (this.userAliasList.contains(string2)) {
                        hashMap.put(string2, Boolean.TRUE);
                        continue;
                    }
                    hashMap.put(string2, Boolean.FALSE);
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase(string)) {
                    hashMap.put(string2, Boolean.TRUE);
                    continue;
                }
                hashMap.put(string2, Boolean.FALSE);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("searchUserAliases: foundUserAliasMap : " + hashMap);
            }
        }
        return hashMap;
    }

    Set getTokenFromPrincipal(Subject subject) {
        Set<Principal> set = subject.getPrincipals();
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Principal> iterator = set.iterator();
        while (iterator.hasNext()) {
            this.token = iterator.next().getName();
            if (this.token != null && !this.containsToken(stringBuffer, this.token)) {
                stringBuffer.append(this.token).append("|");
                String string = AuthUtils.getNormalizedDN(this.token);
                if (string != null && string.length() != 0) {
                    this.userDN = string;
                    this.token = AuthUtils.DNtoName(this.token);
                }
            }
            if (!hashSet.contains(this.token)) {
                hashSet.add(this.token);
            }
            if (!AuthD.debug.messageEnabled()) continue;
            AuthD.debug.message("principal name is... :" + this.token);
        }
        this.principalList = stringBuffer.toString();
        if (this.principalList != null && this.principalList.length() > 0) {
            this.principalList = this.principalList.substring(0, this.principalList.length() - 1);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Principal List is :" + this.principalList);
        }
        return hashSet;
    }

    public boolean isUserEnabled() {
        return this.userEnabled;
    }

    public void setAuthLevel(String string) {
        if (string == null) {
            this.authLevel = 0;
        } else {
            try {
                this.authLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.authLevel = 0;
            }
        }
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthLevel is set to : " + this.authLevel);
        }
    }

    public AMIdentity getIdentityRole(String string, String string2) {
        if (this.amIdentityRole == null) {
            this.amIdentityRole = this.searchIdentityRole(string, string2);
        }
        return this.amIdentityRole;
    }

    AMIdentity searchIdentityRole(String string, String string2) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("rolename : " + string);
        }
        if (string == null) {
            return null;
        }
        AMIdentity aMIdentity = null;
        try {
            aMIdentity = this.getRole(string);
        }
        catch (Exception exception) {
            AuthD.debug.error("getRole: Error : ", (Throwable)exception);
        }
        return aMIdentity;
    }

    public void setAuthModuleName(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("authethName" + string);
            AuthD.debug.message("pAuthMethName " + this.pAuthMethName);
        }
        StringBuffer stringBuffer = null;
        if (this.pAuthMethName != null && this.pAuthMethName.length() > 0) {
            stringBuffer = new StringBuffer().append(this.pAuthMethName);
        }
        if (string != null && string.length() > 0) {
            if (stringBuffer != null) {
                stringBuffer.append("|").append(string);
            } else {
                stringBuffer = new StringBuffer().append(string);
            }
        }
        if (stringBuffer != null) {
            this.authMethName = stringBuffer.toString();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setAuthModuleName: " + this.authMethName);
        }
    }

    public boolean getUserForRole(AMIdentity aMIdentity) {
        boolean bl;
        block3: {
            Object var2_2 = null;
            bl = false;
            try {
                if (this.amIdentityUser.isMember(aMIdentity)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error getRoleName : ", (Throwable)exception);
            }
        }
        return bl;
    }

    void setIndexType(AuthContext.IndexType indexType) {
        this.indexType = indexType;
    }

    void setPreviousIndexType(AuthContext.IndexType indexType) {
        this.prevIndexType = this.indexType;
    }

    public boolean isPersistentCookieOn() {
        return this.persistentCookieOn;
    }

    public boolean getPersistentCookieMode() {
        return this.persistentCookieMode;
    }

    void setToken(String string) {
        this.token = string;
    }

    public Hashtable getRequestParamHash() {
        return this.requestHash;
    }

    boolean getUserEnabled(Map map) {
        Boolean bl = Boolean.FALSE;
        this.userEnabled = !map.containsValue(bl);
        return this.userEnabled;
    }

    boolean getUserRoleFound(Map map) {
        boolean bl = true;
        Boolean bl2 = Boolean.FALSE;
        if (map.containsValue(bl2)) {
            bl = false;
        }
        return bl;
    }

    boolean getFoundUserAlias(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("foundAliasMap :" + map);
        }
        boolean bl = true;
        Boolean bl2 = Boolean.FALSE;
        if (map == null || map.isEmpty() || map.containsValue(bl2)) {
            bl = false;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("foundUserAlias : " + bl);
        }
        return bl;
    }

    boolean getGotUserProfile(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("GotUserProfileMAP is: " + map);
        }
        boolean bl = false;
        Boolean bl2 = Boolean.TRUE;
        if (map.containsValue(bl2)) {
            bl = true;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("gotUserProfile :" + bl);
        }
        return bl;
    }

    void addAliasToUserProfile(String string, Map map) throws AuthException {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Token : " + string);
        }
        AMIdentity aMIdentity = ad.getIdentity(IdType.USER, string, this.orgDN);
        this.addAliasToUserProfile(aMIdentity, map);
    }

    void addAliasToUserProfile(AMIdentity aMIdentity, Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("foundUserAliasMap : " + map);
        }
        try {
            if (map != null && !map.isEmpty()) {
                Object object;
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (this.token == null || this.token.equalsIgnoreCase((String)object) || this.userAliasList.contains(object)) continue;
                    this.userAliasList.add(object);
                }
                AuthD.debug.message("Adding alias list to user profile");
                object = new HashMap();
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    this.userAliasList.addAll(this.externalAliasList);
                }
                object.put("iplanet-am-user-alias-list", this.userAliasList);
                aMIdentity.setAttributes((Map)object);
                aMIdentity.store();
            }
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception : " + exception.getMessage(), (Throwable)exception);
        }
    }

    boolean checkAliasList(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("UserAliasList is.. : " + map);
        }
        boolean bl = true;
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Boolean bl2;
            String string;
            Object k = iterator.next();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Token is.. : " + (String)k);
            }
            if (ad.isSuperAdmin(string = this.tokenToDN((String)k)) || !(bl2 = (Boolean)map.get(k)).toString().equals("false")) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String searchPersistentCookie() {
        try {
            String string = null;
            String string2 = CookieUtils.getCookieValueFromReq((HttpServletRequest)this.servletRequest, (String)pCookieName);
            if (string2 != null) {
                string = this.parsePersistentCookie(string2);
            }
            return string;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ERROR searchPersistentCookie ", (Throwable)exception);
            }
            return null;
        }
    }

    private String parsePersistentCookie(String string) {
        try {
            Object object;
            this.foundPCookie = Boolean.FALSE;
            String string2 = (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
            if (string == null || string.equals("") || string.equals(string2)) {
                return null;
            }
            String string3 = (String)AccessController.doPrivileged(new DecodeAction(string));
            int n = string3.indexOf("%");
            if (n == -1) {
                return null;
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            int n2 = string5.indexOf("%");
            if (n2 == -1) {
                return null;
            }
            String string6 = string5.substring(0, n2);
            String string7 = string5.substring(n2 + 1);
            int n3 = string7.indexOf("%");
            if (n3 == -1) {
                return null;
            }
            String string8 = string7.substring(0, n3);
            string5 = string7.substring(n3 + 1);
            if ((n3 = string5.indexOf("%")) == -1) {
                return null;
            }
            int n4 = Integer.parseInt(string5.substring(0, n3));
            string7 = string5.substring(n3 + 1);
            if ((n3 = string7.indexOf("%")) == -1) {
                return null;
            }
            int n5 = Integer.parseInt(string7.substring(0, n3));
            if ((n3 = (string7 = string7.substring(n3 + 1)).indexOf("%")) == -1) {
                return null;
            }
            int n6 = Integer.parseInt(string7.substring(0, n3));
            if ((n3 = (string7 = string7.substring(n3 + 1)).indexOf("%")) == -1) {
                return null;
            }
            String string9 = string7.substring(0, n3);
            this.pCookieTimeCreated = Long.parseLong(string7.substring(n3 + 1));
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("pCookieTimeCreated : " + this.pCookieTimeCreated);
            }
            if (!this.sessionUpgrade && (object = new SessionID(string9)) != null) {
                AuthUtils.removeAuthContext(object);
            }
            if (!this.getOrgName().equals(string6)) {
                this.userOrg = this.orgName = string6;
            }
            object = null;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("authMethStr: " + string8);
            }
            int n7 = 0;
            String string10 = string8;
            while (n7 != -1) {
                String string11;
                n7 = string8.indexOf("|");
                if (n7 == -1) {
                    object = ad.getAuthenticatorForName(string8);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("authMethStr is : " + string8);
                        AuthD.debug.message("authModuleName is : " + (String)object);
                    }
                    if (object != null && this.domainAuthenticators.contains(string8)) break;
                    return null;
                }
                String string12 = string8.substring(0, n7);
                object = ad.getAuthenticatorForName(string12);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("authModulename is : " + string12);
                    AuthD.debug.message("authModuleName instance is : " + (String)object);
                }
                if (object == null || !this.domainAuthenticators.contains(string12)) {
                    return null;
                }
                string8 = string11 = string8.substring(n7 + 1);
            }
            this.pAuthMethName = string10;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Found valid PC : username=" + string4 + "\ndomainname=" + string6 + "\nauthMethod=" + string10 + "\nmaxSession=" + n4 + "\nidleTime=" + n5 + "\ncacheTime=" + n6 + "\norgDN=" + this.orgDN);
            }
            this.foundPCookie = Boolean.TRUE;
            return string4;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ERROR:parsePersistentCookie : ", (Throwable)exception);
            }
            return null;
        }
    }

    public static String encodePCookie() {
        return (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
    }

    public Cookie setPersistentCookie(String string) throws SSOException, AMException {
        String string2 = this.persistentCookieTime;
        Cookie cookie = null;
        if (string2 != null) {
            int n;
            try {
                n = Integer.parseInt(string2);
                if (this.foundPCookie != null && this.foundPCookie.booleanValue()) {
                    long l = System.currentTimeMillis() - this.pCookieTimeCreated;
                    n -= new Long(l / 1000L).intValue();
                }
            }
            catch (Exception exception) {
                n = 0;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Add Cookie: maxage=" + n);
                AuthD.debug.message("Add Cookie: maxage_str=" + string2);
            }
            if (n > 0) {
                String string3 = this.getUserDN(this.amIdentityUser) + "%" + this.getOrgName() + "%" + this.authMethName + "%" + Integer.toString(this.maxSession) + "%" + Integer.toString(this.idleTime) + "%" + Integer.toString(this.cacheTime) + "%" + this.sid.toString() + "%" + System.currentTimeMillis();
                String string4 = (String)AccessController.doPrivileged(new EncodeAction(string3));
                cookie = AuthUtils.createPersistentCookie(AuthUtils.getPersistentCookieName(), string4, n, string);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Add PCookie = " + string3);
                }
            } else if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Persistent Cookie Mode configured for domain " + this.orgName + ", but no persistentCookieTime = " + string2);
            }
        }
        return cookie;
    }

    public Cookie setlbCookie(String string, boolean bl) throws SSOException, AMException {
        String string2 = AuthUtils.getlbCookieName();
        String string3 = AuthUtils.getlbCookieValue();
        String string4 = this.persistentCookieTime;
        Cookie cookie = null;
        if (string4 != null && bl) {
            int n;
            try {
                n = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n = 0;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Add Load Balance Cookie: maxage=" + n);
            }
            if (n > 0) {
                cookie = AuthUtils.createPersistentCookie(string2, string3, n, string);
                AuthD.debug.message("Add Load Balance Cookie!");
            } else {
                AuthD.debug.message("No Load Balance Cookie set!");
            }
        } else {
            cookie = AuthUtils.createPersistentCookie(string2, string3, -1, string);
        }
        return cookie;
    }

    public AuthContext.IndexType getIndexType() {
        return this.indexType;
    }

    public AuthContext.IndexType getPreviousIndexType() {
        return this.prevIndexType;
    }

    void setGoToURL() {
        String string = (String)this.requestHash.get("goto");
        if (string != null && !string.equals("")) {
            this.gotoURL = string;
        }
    }

    void setGoToOnFailURL() {
        String string = (String)this.requestHash.get("gotoOnFail");
        if (string != null && !string.equals("")) {
            this.gotoOnFailURL = string;
        }
    }

    public String getSuccessLoginURL() {
        String string = this.servletRequest == null ? null : this.servletRequest.getParameter("goto");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("currentGoto : " + string);
        }
        String string2 = null;
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase("null")) {
            string2 = ad.processURL(string, this.servletRequest);
        } else if (string2 == null || string2.length() == 0) {
            string2 = ad.processURL(this.successLoginURL, this.servletRequest);
        }
        String string3 = this.encodeURL(string2, this.servletResponse, true);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("get fqdnURL : " + string2);
            AuthD.debug.message("get successLoginURL : " + this.successLoginURL);
            AuthD.debug.message("get encodedSuccessURL : " + string3);
        }
        return string3;
    }

    public String getConfiguredSuccessLoginURL() {
        String string = this.encodeURL(ad.processURL(this.successLoginURL, this.servletRequest), this.servletResponse, true);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getSuccessLoginURL : " + this.successLoginURL);
            AuthD.debug.message("getSuccessLoginURL (encoded) : " + string);
        }
        return string;
    }

    String getSuccessURLForRole() {
        String string;
        block2: {
            string = null;
            try {
                Map map = this.getRoleServiceAttributes();
                string = this.getRoleURLFromAttribute(map, "iplanet-am-auth-login-success-url");
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Execption:getSuccessURLForRole : ", (Throwable)exception);
            }
        }
        return string;
    }

    String getFailureURLForRole() {
        String string;
        block2: {
            string = null;
            try {
                Map map = this.getRoleServiceAttributes();
                string = this.getRoleURLFromAttribute(map, "iplanet-am-auth-login-failure-url");
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string;
    }

    Map getRoleServiceAttributes() throws Exception {
        try {
            if (this.roleAttributeMap == null) {
                if (AuthD.revisionNumber < 30) {
                    this.roleAttributeMap = this.amIdentityRole.getServiceAttributes("iPlanetAMAuthConfiguration");
                } else {
                    Map map = this.amIdentityRole.getServiceAttributes("iPlanetAMAuthConfiguration");
                    String string = (String)((Set)map.get("iplanet-am-auth-configuration")).iterator().next();
                    if (!string.equals("[Empty]")) {
                        this.roleAttributeMap = this.getServiceAttributes(string);
                    }
                }
            }
            if (this.roleAttributeMap == null) {
                this.roleAttributeMap = Collections.EMPTY_MAP;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Returning Service Attributes: " + this.roleAttributeMap);
                AuthD.debug.message("for Role : " + this.amIdentityRole.getName());
            }
            return this.roleAttributeMap;
        }
        catch (Exception exception) {
            AuthD.debug.error("Error getting Role Attributes : ", (Throwable)exception);
            throw new Exception("102");
        }
    }

    String getSuccessURLForService(String string) {
        String string2;
        block5: {
            string2 = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AttributeMAP is.. :" + this.serviceAttributesMap);
                }
                string2 = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-success-url");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("service successURL : " + string2);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string2;
    }

    String getFailureURLForService(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                if (this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                string2 = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-failure-url");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Service failureURL: " + string2);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block4;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string2;
    }

    Map getServiceAttributes(String string) throws Exception {
        try {
            Map map = AMAuthConfigUtils.getNamedConfig(string, this.getOrgDN(), ad.getSSOAuthSession());
            return map;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error getting service attribute: ");
                AuthD.debug.message(" Exception : " + exception.getMessage());
            }
            throw new Exception(exception.getMessage());
        }
    }

    AMPostAuthProcessInterface getPostLoginProcessInstance(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("postLoginProcess Class Name is : " + string);
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            AMPostAuthProcessInterface aMPostAuthProcessInterface = (AMPostAuthProcessInterface)Class.forName(string).newInstance();
            return aMPostAuthProcessInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Class not Found :", (Throwable)classNotFoundException);
            }
            return null;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error: ", (Throwable)exception);
            }
            return null;
        }
    }

    public void setSuccessLoginURL(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("URL : from modle  : " + string);
        }
        this.moduleSuccessLoginURL = string;
    }

    public void setFailureLoginURL(String string) {
        this.moduleFailureLoginURL = string;
    }

    public void setSuccessLoginURL(AuthContext.IndexType indexType, String string) {
        String string2;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("moduleSucessLoginURL : " + this.moduleSuccessLoginURL);
        }
        if (this.moduleSuccessLoginURL != null && !this.moduleSuccessLoginURL.equals("")) {
            this.successLoginURL = this.moduleSuccessLoginURL;
            return;
        }
        String string3 = null;
        if (this.clientUserSuccessURL != null && !this.clientUserSuccessURL.equals("")) {
            this.successLoginURL = this.clientUserSuccessURL;
            if (this.successLoginURL != null) {
                return;
            }
        }
        string3 = this.defaultUserSuccessURL;
        if (indexType == AuthContext.IndexType.ROLE) {
            string2 = this.getSuccessURLForRole();
            if (string2 != null && !string2.equals("")) {
                this.successLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            string2 = this.getSuccessURLForService(string);
            if (string2 != null && !string2.equals("")) {
                this.successLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (this.clientSuccessRoleURL != null && !this.clientSuccessRoleURL.equals("")) {
            this.successLoginURL = this.clientSuccessRoleURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultSuccessRoleURL;
        }
        if (this.clientOrgSuccessLoginURL != null && !this.clientOrgSuccessLoginURL.equals("")) {
            this.successLoginURL = this.clientOrgSuccessLoginURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultOrgSuccessLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultServiceSuccessURLSet);
        } else {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultSuccessURLSet);
            LoginState.ad.defaultSuccessURL = this.tempDefaultURL;
        }
        if (this.defaultSuccessURL != null && !this.defaultSuccessURL.equals("")) {
            this.successLoginURL = this.defaultSuccessURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.tempDefaultURL;
        }
        this.successLoginURL = string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("SUCCESS Login url : " + this.successLoginURL);
        }
    }

    public void setFailureLoginURL(AuthContext.IndexType indexType, String string) {
        String string2;
        String string3;
        block22: {
            if (this.moduleFailureLoginURL != null && !this.moduleFailureLoginURL.equals("")) {
                this.failureLoginURL = this.moduleFailureLoginURL;
                return;
            }
            if (this.gotoOnFailURL != null && !this.gotoOnFailURL.equals("")) {
                this.failureLoginURL = this.gotoOnFailURL;
                return;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("failureTokenId in setFailureLoginURL = " + this.failureTokenId);
            }
            string3 = null;
            if (this.failureTokenId != null) {
                try {
                    this.getUserProfile(this.failureTokenId, true, false);
                    if (this.clientUserFailureURL != null && !this.clientUserFailureURL.equals("")) {
                        this.failureLoginURL = this.clientUserFailureURL;
                        return;
                    }
                    string3 = this.defaultUserFailureURL;
                }
                catch (Exception exception) {
                    if (!AuthD.debug.messageEnabled()) break block22;
                    AuthD.debug.message("Error retreiving profile for : " + this.failureTokenId, (Throwable)exception);
                }
            }
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            string2 = this.getFailureURLForRole();
            if (string2 != null && !string2.equals("")) {
                this.failureLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            string2 = this.getFailureURLForService(string);
            if (string2 != null && !string2.equals("")) {
                this.failureLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (this.clientFailureRoleURL != null && !this.clientFailureRoleURL.equals("")) {
            this.failureLoginURL = this.clientFailureRoleURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultFailureRoleURL;
        }
        if (this.clientOrgFailureLoginURL != null && !this.clientOrgFailureLoginURL.equals("")) {
            this.failureLoginURL = this.clientOrgFailureLoginURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultOrgFailureLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultFailureURL = this.getRedirectUrl(LoginState.ad.defaultServiceFailureURLSet);
        } else {
            this.defaultFailureURL = this.getRedirectUrl(LoginState.ad.defaultFailureURLSet);
            LoginState.ad.defaultFailureURL = this.tempDefaultURL;
        }
        if (this.defaultFailureURL != null && !this.defaultFailureURL.equals("")) {
            this.failureLoginURL = this.defaultFailureURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.tempDefaultURL;
        }
        this.failureLoginURL = string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("defaultFailureURL : " + this.failureLoginURL);
        }
    }

    public String getFailureLoginURL() {
        if (this.fqdnFailureLoginURL == null || this.fqdnFailureLoginURL.length() == 0) {
            this.fqdnFailureLoginURL = ad.processURL(this.failureLoginURL, this.servletRequest);
        }
        return this.fqdnFailureLoginURL;
    }

    String getRoleURLFromAttribute(Map map, String string) {
        try {
            Set set = (Set)map.get(string);
            String string2 = this.getRedirectUrl(set);
            return string2;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error getting role attribute ", (Throwable)exception);
            }
            return null;
        }
    }

    String getServiceURLFromAttribute(Map map, String string) {
        Set set = (Set)map.get(string);
        String string2 = this.getRedirectUrl(set);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("attr map: " + map + "\nserviceURL : " + string2);
        }
        return string2;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    protected void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.servletResponse = httpServletResponse;
    }

    public synchronized void setPersistentCookieOn() {
        this.persistentCookieOn = true;
    }

    public Callback[] getRecdCallback() {
        return this.prevCallback;
    }

    public synchronized void setPrevCallback(Callback[] callbackArray) {
        this.prevCallback = callbackArray;
    }

    protected String getAccountLife() {
        return this.accountLife;
    }

    protected String getUserToken() {
        return this.token;
    }

    protected boolean getLoginFailureLockoutMode() {
        return this.loginFailureLockoutMode;
    }

    protected long getLoginFailureLockoutTime() {
        return this.loginFailureLockoutTime;
    }

    protected int getLoginFailureLockoutCount() {
        return this.loginFailureLockoutCount;
    }

    protected String getLoginLockoutNotification() {
        return this.loginLockoutNotification;
    }

    protected int getLoginLockoutUserWarning() {
        return this.loginLockoutUserWarning;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorTemplate(String string) {
        this.errorTemplate = string;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setModuleErrorTemplate(String string) {
        this.moduleErrorTemplate = string;
    }

    public String getModuleErrorTemplate() {
        return this.moduleErrorTemplate;
    }

    public void setTimedOut(boolean bl) {
        this.timedOut = bl;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setLockoutMsg(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setLockoutMsg :" + string);
        }
        this.lockoutMsg = string;
    }

    public String getLockoutMsg() {
        return this.lockoutMsg;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public AuthContextLocal createAuthContext(SessionID sessionID, String string, HttpServletRequest httpServletRequest) throws AuthException {
        this.userOrg = this.getDomainNameByOrg(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == "" || this.userOrg == null) {
            AuthD.debug.error("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"), "INVALIDDOMAIN");
            throw new AuthException("108", null);
        }
        AuthD.debug.message("AuthUtil:getAuthContext:Creating new AuthContextLocal & LoginState");
        AuthContextLocal authContextLocal = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.sid = sessionID;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("requestType : " + this.requestType);
            AuthD.debug.message("sid : " + sessionID);
            AuthD.debug.message("orgName passed: " + string);
        }
        try {
            this.createSession(httpServletRequest, authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception creating session .. :", (Throwable)exception);
            throw new AuthException("102", null);
        }
        this.amIdRepo = ad.getAMIdentityRepository(this.getOrgDN());
        this.populateOrgProfile();
        this.isRemote = true;
        return authContextLocal;
    }

    public boolean setModuleAuthLevel(int n) {
        boolean bl = false;
        this.moduleAuthLevel = n;
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
            bl = true;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("spi authLevel :" + n);
            AuthD.debug.message("module configuration authLevel :" + this.authLevel);
            AuthD.debug.message("levelSet :" + bl);
        }
        return bl;
    }

    public String getDomainNameByOrg(String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                string2 = au.getOrganizationDN(string, false, null);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Incorrect orgName passed:" + string, (Throwable)exception);
            }
        }
        return string2;
    }

    public Set getModuleInstances() {
        block5: {
            try {
                if (this.moduleInstances != null && !this.moduleInstances.isEmpty()) {
                    return this.moduleInstances;
                }
                this.moduleInstances = this.domainAuthenticators;
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("moduleInstances are : " + this.moduleInstances);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error getting moduleInstances ", (Throwable)exception);
            }
        }
        if (this.moduleInstances == null) {
            this.moduleInstances = Collections.EMPTY_SET;
        }
        return this.moduleInstances;
    }

    public Set getDomainAuthenticators() {
        return this.domainAuthenticators;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }

    public void logSuccess() {
        try {
            String string = LoginState.ad.bundle.getString("loginSuccess");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LOGIN_SUCCESS");
            if (this.indexType != null) {
                stringBuffer.append("_").append(this.indexType.toString().toUpperCase());
                arrayList.add(this.indexType.toString());
                if (this.indexName != null) {
                    arrayList.add(this.indexName);
                }
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            String string2 = null;
            SSOToken sSOToken = this.getSSOToken();
            if (sSOToken != null) {
                string2 = sSOToken.getProperty("AMCtxId");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                hashtable.put("ModuleName", this.authMethName);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            if (string2 != null) {
                hashtable.put("ContextID", string2);
            }
            ad.logIt(stringArray, 0, stringBuffer.toString(), hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error creating logSuccess message", (Throwable)exception);
        }
    }

    public void logFailed(String string) {
        this.logFailed(string, null);
    }

    public void logFailed(String string, String string2) {
        try {
            String string3 = string;
            if (string == null) {
                string3 = LoginState.ad.bundle.getString("loginFailed");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string3);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LOGIN_FAILED");
            if (this.indexType != null && this.indexType != AuthContext.IndexType.COMPOSITE_ADVICE) {
                stringBuffer.append("_").append(this.indexType.toString().toUpperCase());
                arrayList.add(this.indexType.toString());
                if (this.indexName != null) {
                    arrayList.add(this.indexName);
                }
            }
            if (string2 != null) {
                stringBuffer.append("_").append(string2);
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            } else if (this.failureTokenId != null) {
                hashtable.put("LoginID", this.failureTokenId);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.failureModuleList != null && this.failureModuleList.length() > 0) {
                hashtable.put("ModuleName", this.failureModuleList);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            ad.logIt(stringArray, 1, stringBuffer.toString(), hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error creating logFailed message", (Throwable)exception);
        }
    }

    public void logLogout() {
        try {
            String string = LoginState.ad.bundle.getString("logout");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LOGOUT");
            if (this.indexType != null) {
                stringBuffer.append("_").append(this.indexType.toString().toUpperCase());
                arrayList.add(this.indexType.toString());
                if (this.indexName != null) {
                    arrayList.add(this.indexName);
                }
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            String string2 = null;
            SSOToken sSOToken = this.getSSOToken();
            if (sSOToken != null) {
                string2 = sSOToken.getProperty("AMCtxId");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                hashtable.put("ModuleName", this.authMethName);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            if (string2 != null) {
                hashtable.put("ContextID", string2);
            }
            ad.logIt(stringArray, 0, stringBuffer.toString(), hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error creating logout message", (Throwable)exception);
        }
    }

    public String getLoginLockoutAttrName() {
        return this.loginLockoutAttrName;
    }

    public String getLoginLockoutAttrValue() {
        return this.loginLockoutAttrValue;
    }

    public long getLoginFailureLockoutDuration() {
        return this.loginFailureLockoutDuration;
    }

    public void setPrevAuthContext(AuthContextLocal authContextLocal) {
        this.oldAuthContext = authContextLocal;
    }

    public AuthContextLocal getPrevAuthContext() {
        return this.oldAuthContext;
    }

    public void setSessionUpgrade(boolean bl) {
        this.sessionUpgrade = bl;
    }

    public boolean isSessionUpgrade() {
        return this.sessionUpgrade;
    }

    void sessionUpgrade() {
        String string;
        String string2;
        LoginState loginState = AuthUtils.getLoginState(this.oldAuthContext);
        InternalSession internalSession = null;
        if (loginState != null) {
            internalSession = loginState.getSession();
        }
        if (internalSession == null) {
            return;
        }
        this.upgradeAllProperties(internalSession);
        int n = 0;
        try {
            n = Integer.parseInt(internalSession.getProperty("AuthLevel"));
        }
        catch (NumberFormatException numberFormatException) {
            AuthD.debug.error("AuthLevel from session property bad format");
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("prevAuthLevel : " + n);
        }
        this.upgradeAuthLevel = n > this.authLevel ? n : this.authLevel;
        String string3 = string2 = internalSession.getProperty("Service");
        String string4 = null;
        if (this.indexType == AuthContext.IndexType.SERVICE) {
            string4 = this.indexName;
            if (string2 != null) {
                string3 = string2;
                if (this.indexName != null && string2.indexOf(this.indexName) == -1) {
                    string3 = this.indexName + "|" + string2;
                }
            } else {
                string3 = this.indexName;
            }
        }
        String string5 = string = internalSession.getProperty("Role");
        if (this.indexType == AuthContext.IndexType.ROLE) {
            if (string != null) {
                string5 = string;
                if (this.indexName != null && string.indexOf(this.indexName) == -1) {
                    string5 = this.indexName + "|" + string;
                }
            } else {
                string5 = this.indexName;
            }
        }
        String string6 = internalSession.getProperty("AuthType");
        String string7 = this.authMethName;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("authMethName (newModuleList) : " + this.authMethName);
            AuthD.debug.message("prevModuleList : " + string6);
        }
        String string8 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string7);
        string8 = string6 != string7 ? this.parsePropertyList(string6, string7) : stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("oldAuthLevel : " + n);
            AuthD.debug.message("newAuthLevel : " + this.authLevel);
            AuthD.debug.message("upgradeAuthLevel : " + this.upgradeAuthLevel);
            AuthD.debug.message("prevServiceName : " + string2);
            AuthD.debug.message("newServiceName : " + string4);
            AuthD.debug.message("upgradeServiceName : " + string3);
            AuthD.debug.message("preRoleName : " + string);
            AuthD.debug.message("newRoleName : " + string5);
            AuthD.debug.message("upgradeRoleName : " + string5);
            AuthD.debug.message("prevModuleList: " + string6);
            AuthD.debug.message("newModuleList: " + string7);
            AuthD.debug.message("upgradeModuleList: " + string8);
        }
        this.updateSessionProperty("AuthLevel", new Integer(this.upgradeAuthLevel).toString());
        this.updateSessionProperty("AuthType", string8);
        this.updateSessionProperty("Service", string3);
        this.updateSessionProperty("Role", string5);
        this.sess.setIsSessionUpgrade(true);
    }

    void updateSessionProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.sess.putProperty(string, string2);
    }

    String parsePropertyList(String string, String string2) {
        String string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("oldProperty : " + string);
            AuthD.debug.message("newProperty : " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) != -1) continue;
            stringBuffer.append("|").append(string3);
        }
        string3 = stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("propertyList is : " + string3);
        }
        return string3;
    }

    void upgradeAllProperties(InternalSession internalSession) {
        Enumeration enumeration = internalSession.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = internalSession.getProperty(string);
            this.updateSessionProperty(string, string2);
        }
    }

    void setCookieSet(boolean bl) {
        this.cookieSet = bl;
    }

    boolean isCookieSet() {
        return this.cookieSet;
    }

    void setCookieSupported(boolean bl) {
        this.cookieSupported = bl;
    }

    boolean isCookieSupported() {
        return this.cookieSupported;
    }

    void postLogin(AuthContext.IndexType indexType, String string, boolean bl) {
        this.setPostLoginInstances(indexType, string);
        AMPostAuthProcessInterface aMPostAuthProcessInterface = null;
        if (this.postLoginInstanceSet != null && !this.postLoginInstanceSet.isEmpty()) {
            Iterator iterator = this.postLoginInstanceSet.iterator();
            while (iterator.hasNext()) {
                aMPostAuthProcessInterface = (AMPostAuthProcessInterface)iterator.next();
                this.executePostLoginSPI(aMPostAuthProcessInterface, bl);
            }
        }
    }

    void executePostLoginSPI(AMPostAuthProcessInterface aMPostAuthProcessInterface, boolean bl) {
        block6: {
            try {
                if (bl) {
                    aMPostAuthProcessInterface.onLoginSuccess(this.requestMap, this.servletRequest, this.servletResponse, this.getSSOToken());
                } else {
                    aMPostAuthProcessInterface.onLoginFailure(this.requestMap, this.servletRequest, this.servletResponse);
                }
            }
            catch (AuthenticationException authenticationException) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Error ", (Throwable)((Object)authenticationException));
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block6;
                AuthD.debug.message("Error ", (Throwable)exception);
            }
        }
    }

    void setPostLoginInstances(AuthContext.IndexType indexType, String string) {
        AMPostAuthProcessInterface aMPostAuthProcessInterface = null;
        String string2 = null;
        Set set = Collections.EMPTY_SET;
        if (indexType == AuthContext.IndexType.ROLE) {
            set = this.getRolePostLoginClassSet();
        } else if (indexType == AuthContext.IndexType.SERVICE) {
            if (string.equals("adminconsoleservice")) {
                if (AuthD.revisionNumber >= 30 && this.orgAdminAuthConfig != null && !this.orgAdminAuthConfig.equals("[Empty]")) {
                    set = this.getServicePostLoginClassSet(this.orgAdminAuthConfig);
                }
            } else {
                set = this.getServicePostLoginClassSet(string);
            }
        } else if (indexType == AuthContext.IndexType.USER && AuthD.revisionNumber >= 30 && this.userAuthConfig != null && !this.userAuthConfig.equals("[Empty]")) {
            set = this.getServicePostLoginClassSet(this.userAuthConfig);
        }
        if ((set == null || set.isEmpty()) && this.orgPostLoginClassSet != null && !this.orgPostLoginClassSet.isEmpty()) {
            set = this.orgPostLoginClassSet;
        } else if (AuthD.revisionNumber >= 30 && indexType == null && this.orgAuthConfig != null && !this.orgAuthConfig.equals("[Empty]")) {
            set = this.getServicePostLoginClassSet(this.orgAuthConfig);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("postLoginClassSet = " + set);
            AuthD.debug.message("is empty postLoginClassSet = " + set.isEmpty());
        }
        if (set != null && !set.isEmpty()) {
            this.postLoginInstanceSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("setPostLoginInstances : " + string2);
                    AuthD.debug.message("setPostLoginInstances : " + set.size());
                }
                if ((aMPostAuthProcessInterface = this.getPostLoginProcessInstance(string2)) == null) continue;
                this.postLoginInstanceSet.add(aMPostAuthProcessInterface);
            }
        }
    }

    Set getRolePostLoginClassSet() {
        Set set;
        block4: {
            set = null;
            try {
                Map map = this.getRoleServiceAttributes();
                set = (Set)map.get("iplanet-am-auth-post-login-process-class");
                if (set == null) {
                    set = Collections.EMPTY_SET;
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Role Post Login Class Set : " + set);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block4;
                AuthD.debug.message("Error get role class set ", (Throwable)exception);
            }
        }
        return set;
    }

    Set getServicePostLoginClassSet(String string) {
        Set set;
        block6: {
            set = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Service Attributes are . :" + this.serviceAttributesMap);
                }
                if ((set = (Set)this.serviceAttributesMap.get("iplanet-am-auth-post-login-process-class")) == null) {
                    set = Collections.EMPTY_SET;
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("postLoginClassName: " + set);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block6;
                AuthD.debug.message("Error get service post login class name " + exception.getMessage());
            }
        }
        return set;
    }

    void setModuleErrorMessage(String string) {
        this.moduleErrorMessage = string;
    }

    public String getModuleErrorMessage() {
        return this.moduleErrorMessage;
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public synchronized void setPageTimeOut(long l) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Setting page timeout :" + l);
        }
        this.pageTimeOut = l;
    }

    public long getPageTimeOut() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning page timeout :" + this.pageTimeOut);
        }
        return this.pageTimeOut;
    }

    public void setLastCallbackSent(long l) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setting Last Callback Sent :" + l);
        }
        this.lastCallbackSent = l;
    }

    public long getLastCallbackSent() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning Last Callback Sent :" + this.lastCallbackSent);
        }
        return this.lastCallbackSent;
    }

    private String getRedirectUrl(Set set) {
        String string = null;
        this.tempDefaultURL = null;
        if (set != null && !set.isEmpty()) {
            String string2 = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("URL is : " + string3);
                }
                if (string3 == null || string3.length() <= 0) continue;
                int n = string3.indexOf("|");
                if (n != -1) {
                    if (string != null) continue;
                    string = au.getClientURLFromString(string3, n, this.servletRequest);
                    continue;
                }
                if (string2 != null && string2.length() != 0) continue;
                string2 = string3;
            }
            this.tempDefaultURL = string2;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("defaultURL : " + string2);
                AuthD.debug.message("tempDefaultURL : " + this.tempDefaultURL);
            }
        }
        return string;
    }

    public boolean ignoreProfile() {
        return this.ignoreUserProfile;
    }

    boolean containsToken(StringBuffer stringBuffer, String string) {
        block5: {
            String string2 = stringBuffer.toString();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("principalString : " + string2);
            }
            if (string2 == null) {
                return false;
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals(string)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.warningEnabled()) break block5;
                AuthD.debug.warning("getToken: ", (Throwable)exception);
            }
        }
        return false;
    }

    private Set mergeSet(Set set, Set set2) {
        if (set == null || set.isEmpty()) {
            if (set2 == null || set2.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set;
        }
        HashSet hashSet = new HashSet(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private Map toAvPairMap(Set set, String string) {
        if (string == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        if (set == null || set.isEmpty()) {
            return hashMap;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap.put((String)iterator.next(), hashSet);
        }
        return hashMap;
    }

    public void setFailedUserId(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setting userID : " + string);
        }
        this.failureTokenId = string;
    }

    void updateSessionForFailover() {
        InternalSession internalSession = this.getSession();
        internalSession.setIsISStored(true);
    }

    public Callback[] getCallbacksPerState(String string) {
        Callback[] callbackArray = null;
        callbackArray = (Callback[])this.callbacksPerState.get(string);
        return callbackArray;
    }

    public void setCallbacksPerState(String string, Callback[] callbackArray) {
        this.callbacksPerState.put(string, callbackArray);
    }

    public void setPCookieUserName(String string) {
        this.pCookieUserName = string;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Setting Pcookie user name : " + this.pCookieUserName);
        }
    }

    public void setCookieDetect(boolean bl) {
        this.cookieDetect = bl;
    }

    public boolean isCookieDetect() {
        return this.cookieDetect;
    }

    private Subject addSSOTokenPrincipal(Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        String string = this.sid.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("sid string is.. " + string);
        }
        SSOTokenPrincipal sSOTokenPrincipal = new SSOTokenPrincipal(string);
        subject.getPrincipals().add(sSOTokenPrincipal);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Subject is.. :" + subject);
        }
        return subject;
    }

    public void setUserCreationAttributes(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("attributeValuePairs : " + map);
        }
        if (map != null && !map.isEmpty()) {
            if (this.userCreationAttributes == null) {
                this.userCreationAttributes = new HashMap();
            }
            if (map.containsKey("iplanet-am-user-alias-list")) {
                this.externalAliasList = (HashSet)map.get("iplanet-am-user-alias-list");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("externalAliasList:" + this.externalAliasList);
                }
                map.remove("iplanet-am-user-alias-list");
            }
            this.userCreationAttributes.putAll(map);
        }
    }

    public void setSuccessModuleName(String string) {
        this.successModuleSet.add(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Module name is .. " + string);
            AuthD.debug.message("successModuleSet is : " + this.successModuleSet);
        }
    }

    protected Set getSuccessModuleSet() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getSuccessModuleSet : " + this.successModuleSet);
        }
        return this.successModuleSet;
    }

    private boolean isApplicationModule() {
        boolean bl = this.authMethName != null && this.authMethName.equalsIgnoreCase("Application");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("is Application Module : " + bl);
        }
        return bl;
    }

    public void setFailureModuleName(String string) {
        this.failureModuleSet.add(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Module name is .. " + string);
            AuthD.debug.message("failureModuleSet is : " + this.failureModuleSet);
        }
    }

    public Set getFailureModuleSet() {
        return this.failureModuleSet;
    }

    public void setFailureModuleList(String string) {
        this.failureModuleList = string;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("failureModulelist :" + string);
        }
    }

    public boolean isAgent(AMIdentity aMIdentity) {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (aMIdentity.getType().equals(IdType.AGENT)) {
                    bl = true;
                    AuthD.debug.message("user is of type 'Agent'");
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error isAgent : " + exception.toString());
            }
        }
        return bl;
    }

    protected void setModuleMap(Map map) {
        this.moduleMap = map;
    }

    protected String getModuleName(String string) {
        return (String)this.moduleMap.get(string);
    }

    public void nullifyUsedVars() {
        this.receivedCallbackInfo = null;
        this.prevCallback = null;
        this.submittedCallbackInfo = null;
        this.callbacksPerState = null;
        this.requestHash = null;
        this.aliasAttrNames = null;
        this.defaultRoles = null;
        this.token = null;
        this.tokenSet = null;
        this.prevIndexType = null;
        this.userAliasList = null;
        Object var1_1 = null;
        this.accountLife = null;
        this.loginLockoutNotification = null;
        this.loginLockoutAttrName = null;
        this.loginLockoutAttrValue = null;
        this.lockoutMsg = null;
        this.principalList = null;
        this.cert = null;
        this.userCreationAttributes = null;
        this.externalAliasList = null;
        this.failureModuleSet = null;
        this.failureModuleList = "";
        this.moduleMap = null;
        if (!this.persistentCookieOn || !this.persistentCookieMode || this.foundPCookie != null && !this.foundPCookie.booleanValue()) {
            this.userContainerDN = null;
            this.userNamingAttr = null;
        }
    }

    public void setRequestLocale(HttpServletRequest httpServletRequest) {
        this.localeContext.setLocale(httpServletRequest);
    }

    public Map getAttrMapForSAML() {
        Map map = null;
        if (this.authMethName != null && this.authMethName.equalsIgnoreCase("SAML") && this.subject != null) {
            AuthD.debug.message("Your authenticated principals are : ");
            Iterator<Principal> iterator = this.subject.getPrincipals().iterator();
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Principal name : " + principal.getClass().getName() + " Principal : " + principal.getName());
                }
                if (!(principal instanceof SAMLPrincipal)) continue;
                SAMLPrincipal sAMLPrincipal = (SAMLPrincipal)principal;
                map = sAMLPrincipal.getAttrMap();
                if (!AuthD.debug.messageEnabled()) break;
                AuthD.debug.message("GET attrMap : " + map);
                break;
            }
        }
        return map;
    }

    public boolean isSessionInvalid() {
        return this.sess == null || this.sess.getState() == 0 || this.sess.getState() == 3;
    }

    public AMIdentity getRole(String string) throws AuthException {
        try {
            this.amIdentityRole = ad.getIdentity(IdType.ROLE, string, this.getOrgDN());
        }
        catch (AuthException authException) {
            AuthD.debug.message("role not found or is not a static role");
        }
        if (this.amIdentityRole == null) {
            this.amIdentityRole = ad.getIdentity(IdType.FILTEREDROLE, string, this.getOrgDN());
        }
        return this.amIdentityRole;
    }

    public String getRoleUniversalId(String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                AMIdentity aMIdentity = this.getRole(string);
                string2 = IdUtils.getUniversalId(aMIdentity);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Error getting role : " + exception.getMessage());
            }
        }
        return string2;
    }

    public String getUserDN(AMIdentity aMIdentity) {
        String string = null;
        string = aMIdentity != null ? IdUtils.getDN(aMIdentity) : this.tokenToDN(this.token);
        return string;
    }

    void getContainerDN(Set set) throws AuthException {
        String string = null;
        String string2 = null;
        if (set == null || set.isEmpty()) {
            AuthD.debug.message("Container DNs is null");
            this.nullUserContainerDN = true;
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                try {
                    if (Misc.isDescendantOf((String)string3, (String)this.getOrgDN())) {
                        int n = ad.getSDK().getAMObjectType(string3);
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("Container Type = " + n);
                            AuthD.debug.message("Container Name = " + string3);
                        }
                        if (n == 3 && string2 == null) {
                            string2 = string3;
                            this.identityTypes.add("agent");
                        } else if (n == 2 && string == null) {
                            string = string3;
                            this.identityTypes.add("agent");
                            this.identityTypes.add("user");
                        } else if (n == 5 && this.userContainerDN == null) {
                            this.userContainerDN = string3;
                            this.identityTypes.add("user");
                        }
                    }
                    if (this.userContainerDN == null || string2 == null || string == null) continue;
                    break;
                }
                catch (Exception exception) {
                    AuthD.debug.error("Container - " + string3 + " is INVALID :- ", (Throwable)exception);
                }
            }
        }
        if (this.userContainerDN == null) {
            try {
                this.userContainerDN = AMStoreConnection.getNamingAttribute(5) + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.getOrgDN();
                this.identityTypes.add("user");
            }
            catch (AMException aMException) {
                AuthD.debug.message("Cannot get userContainer DN");
            }
        }
        if (this.userContainerDN == null && string2 == null) {
            AuthD.debug.message("No Valid Container in the list");
            throw new AuthException("102", null);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("agentContainerDN = " + string2);
            AuthD.debug.message("userContainerDN = " + this.userContainerDN);
            AuthD.debug.message("userOrgDN set in PC atrr = " + string);
        }
    }

    IdSearchResults searchIdentity(IdType idType, String string) throws IdRepoException, SSOException {
        IdSearchResults idSearchResults;
        block16: {
            Set set;
            IdSearchControl idSearchControl;
            boolean bl;
            Map map;
            String string2;
            int n;
            int n2;
            Set set2;
            block15: {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("In searchAutehnticatedUser: idType " + idType);
                    AuthD.debug.message("In getUserProfile : Search for user " + string);
                }
                idSearchResults = null;
                set2 = this.mergeSet(this.aliasAttrNames, userAttributes);
                n2 = 2;
                n = 0;
                string2 = null;
                map = null;
                bl = true;
                idSearchControl = new IdSearchControl();
                idSearchControl.setRecursive(bl);
                idSearchControl.setTimeOut(n);
                idSearchControl.setAllReturnAttributes(true);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("alias attr=" + this.aliasAttrNames + ", attr=" + userAttributes + ",merge=" + set2);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Search for Identity " + string);
                }
                set = Collections.EMPTY_SET;
                try {
                    idSearchControl.setMaxResults(0);
                    idSearchResults = this.amIdRepo.searchIdentities(idType, string, idSearchControl);
                    if (idSearchResults != null) {
                        set = idSearchResults.getSearchResults();
                    }
                }
                catch (SSOException sSOException) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("SSOException Error searching Identity  with username " + sSOException.getMessage());
                    }
                }
                catch (IdRepoException idRepoException) {
                    if (!AuthD.debug.messageEnabled()) break block15;
                    AuthD.debug.message("IdRepoException : Error searching  Identities with username : " + idRepoException.getMessage());
                }
            }
            if (set.isEmpty() && this.aliasAttrNames != null && !this.aliasAttrNames.isEmpty()) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("No identity found, try alias attrname.");
                }
                string2 = "*";
                map = this.toAvPairMap(this.aliasAttrNames, string);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Search for Filter :" + map);
                    AuthD.debug.message("idType :" + idType);
                    AuthD.debug.message("pattern :" + string2);
                    AuthD.debug.message("avPairs :" + map);
                    AuthD.debug.message("isRecursive :" + bl);
                    AuthD.debug.message("maxResults :" + n2);
                    AuthD.debug.message("maxTime :" + n);
                    AuthD.debug.message("returnSet :" + set2);
                }
                try {
                    idSearchControl.setMaxResults(n2);
                    idSearchControl.setSearchModifiers(IdSearchOpModifier.OR, map);
                    idSearchResults = this.amIdRepo.searchIdentities(idType, string2, idSearchControl);
                }
                catch (SSOException sSOException) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("SSOException : Error searching Identities with aliasattrname : " + sSOException.getMessage());
                    }
                }
                catch (IdRepoException idRepoException) {
                    if (!AuthD.debug.messageEnabled()) break block16;
                    AuthD.debug.message("IdRepoException : Error searching Identities : " + idRepoException.getMessage());
                }
            }
        }
        return idSearchResults;
    }

    public AMIdentity createUserIdentity(String string, Map map, Set set) throws IdRepoException, SSOException {
        AMIdentity aMIdentity = this.amIdRepo.createIdentity(IdType.USER, string, map);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    if (string2.length() == 0) continue;
                    this.amIdentityRole = this.getRole(string2);
                    this.amIdentityRole.addMember(aMIdentity);
                }
                catch (Exception exception) {
                    AuthD.debug.message("createUserProfile():invalid role: ", (Throwable)exception);
                }
            }
        }
        return aMIdentity;
    }

    public String getUserUniversalId(String string) {
        AMIdentity aMIdentity = this.amIdentityUser;
        String string2 = null;
        try {
            if (aMIdentity == null) {
                aMIdentity = ad.getIdentity(IdType.USER, string, this.getOrgDN());
            }
            string2 = IdUtils.getUniversalId(this.amIdentityUser);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error getting Identity for user :" + exception.getMessage());
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getUserUniversalId:universalId : " + string2);
        }
        return string2;
    }

    static {
        userAttributes.add("iplanet-am-auth-login-success-url");
        userAttributes.add("iplanet-am-auth-login-failure-url");
        userAttributes.add("iplanet-am-user-alias-list");
        userAttributes.add("iplanet-am-session-max-session-time");
        userAttributes.add("iplanet-am-session-max-idle-time");
        userAttributes.add("iplanet-am-session-max-caching-time");
        userAttributes.add("inetuserstatus");
        userAttributes.add("nsaccountlock");
        userAttributes.add("preferredlocale");
        userAttributes.add("iplanet-am-user-login-status");
        userAttributes.add("iplanet-am-user-account-life");
        userAttributes.add("iplanet-am-user-success-url");
        userAttributes.add("iplanet-am-user-failure-url");
        userAttributes.add("iplanet-am-auth-post-login-process-class");
        String string = SystemProperties.get((String)"com.iplanet.distAuth.server.protocol");
        String string2 = null;
        String string3 = null;
        if (string != null && string.length() != 0) {
            string2 = SystemProperties.get((String)"com.iplanet.distAuth.server.host");
            string3 = SystemProperties.get((String)"com.iplanet.distAuth.server.port");
        } else {
            string = SystemProperties.get((String)"com.iplanet.am.server.protocol");
            string2 = SystemProperties.get((String)"com.iplanet.am.server.host");
            string3 = SystemProperties.get((String)"com.iplanet.am.server.port");
        }
        serverURL = string + "://" + string2 + ":" + string3;
    }
}

