/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuthXMLRequestParser {
    static Debug debug = Debug.getInstance((String)"amXMLHandler");
    Document xmlDocument = null;
    AuthXMLRequest authXMLRequest = null;
    HttpServletRequest servletReq;

    public AuthXMLRequestParser(String string, HttpServletRequest httpServletRequest) {
        this.servletReq = httpServletRequest;
        try {
            this.xmlDocument = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string.toString().getBytes("UTF-8")));
            if (debug.messageEnabled()) {
                debug.message("AuthXMLRequestParser : xmlDoc : " + this.xmlDocument);
            }
        }
        catch (Exception exception) {
            debug.message("AuthXMLRequest Parser error : ", (Throwable)exception);
        }
    }

    public AuthXMLRequest parseXML() throws AuthException {
        try {
            debug.message("entering parseXML");
            if (this.xmlDocument == null) {
                return null;
            }
            this.authXMLRequest = new AuthXMLRequest();
            Element element = this.xmlDocument.getDocumentElement();
            if (element != null) {
                Callback[] callbackArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Node node;
                String string = element.getAttribute("version");
                if (debug.messageEnabled()) {
                    debug.message("Request Version is.. : " + string);
                }
                if (string != null) {
                    this.authXMLRequest.setRequestVersion(string);
                }
                Node node2 = XMLUtils.getChildNode((Node)element, (String)"Request");
                String string2 = null;
                if (node2 != null) {
                    string2 = this.parseNodeAttributes(node2, "authIdentifier");
                    if (debug.messageEnabled()) {
                        debug.message("AuthIdentifier is : " + string2);
                    }
                    this.authXMLRequest.setAuthIdentifier(string2);
                }
                if ((node = XMLUtils.getChildNode((Node)node2, (String)"NewAuthContext")) != null) {
                    object5 = this.parseNodeAttributes(node, "orgName");
                    this.authXMLRequest.setOrgName((String)object5);
                    this.authXMLRequest.setRequestType(0);
                    object4 = AuthUtils.getAuthContext((String)object5, this.servletReq);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object4);
                }
                if ((object5 = XMLUtils.getChildNode((Node)node2, (String)"QueryInformation")) != null) {
                    object4 = this.parseNodeAttributes((Node)object5, "requestedInformation");
                    this.authXMLRequest.setRequestInformation((String)object4);
                    this.authXMLRequest.setRequestType(3);
                    object3 = this.parseNodeAttributes((Node)object5, "orgName");
                    object2 = null;
                    object2 = object3 != null ? AuthUtils.getAuthContext((String)object3, this.servletReq) : AuthUtils.getAuthContext(null, string2, false);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object2);
                }
                if ((object4 = XMLUtils.getChildNode((Node)node2, (String)"Login")) != null) {
                    debug.message("found login node !!");
                    object3 = this.parseNodeAttributes((Node)object4, "orgName");
                    object2 = null;
                    if (object3 != null) {
                        this.authXMLRequest.setOrgName((String)object3);
                        object2 = AuthUtils.getAuthContext((String)object3, this.servletReq);
                    } else {
                        object2 = AuthUtils.getAuthContext(this.servletReq, string2);
                    }
                    this.authXMLRequest.setRequestType(1);
                    this.parseLoginNodeElements((Node)object4, this.authXMLRequest);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object2);
                }
                if ((object3 = XMLUtils.getChildNode((Node)node2, (String)"SubmitRequirements")) != null) {
                    this.authXMLRequest.setRequestType(2);
                    object2 = AuthUtils.getAuthContext(this.servletReq, string2);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object2);
                    object = new AuthUtils();
                    callbackArray = ((AuthUtils)object).getRecdCallback((AuthContextLocal)object2);
                    this.parseSubmitReqElements((Node)object3, this.authXMLRequest, callbackArray);
                }
                if ((object2 = XMLUtils.getChildNode((Node)node2, (String)"Logout")) != null) {
                    this.authXMLRequest.setRequestType(4);
                    object = AuthUtils.getAuthContext(null, string2, true);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object);
                }
                if ((object = XMLUtils.getChildNode((Node)node2, (String)"Abort")) != null) {
                    this.authXMLRequest.setRequestType(5);
                    callbackArray = AuthUtils.getAuthContext(null, string2, true);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)callbackArray);
                }
            }
        }
        catch (AuthException authException) {
            throw authException;
        }
        catch (Exception exception) {
            debug.message("Error in parseXML: : ", (Throwable)exception);
        }
        return this.authXMLRequest;
    }

    private String parseNodeAttributes(Node node, String string) {
        try {
            if (node == null) {
                return null;
            }
            String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)string);
            if (debug.messageEnabled()) {
                debug.message("Attr Value is : " + string2);
            }
            return string2;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Error getting " + string);
                debug.message("Exception ", (Throwable)exception);
            }
            return null;
        }
    }

    private void parseLoginNodeElements(Node node, AuthXMLRequest authXMLRequest) {
        Object object;
        authXMLRequest.setRequestType(1);
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"IndexTypeNamePair");
        if (node2 != null) {
            object = this.parseNodeAttributes(node2, "indexType");
            if (debug.messageEnabled()) {
                debug.message("indexType is .. : " + (String)object);
            }
            authXMLRequest.setIndexType((String)object);
            Node node3 = XMLUtils.getChildNode((Node)node2, (String)"IndexName");
            if (node3 != null) {
                String string = XMLUtils.getValueOfValueNode((Node)node3);
                if (debug.messageEnabled()) {
                    debug.message("indexName is .. : " + string);
                }
                authXMLRequest.setIndexName(string);
            }
            authXMLRequest.setRequestType(6);
        }
        if ((object = XMLUtils.getChildNode((Node)node, (String)"Params")) != null) {
            authXMLRequest.setParams(XMLUtils.getValueOfValueNode((Node)object));
        }
    }

    void parseSubmitReqElements(Node node, AuthXMLRequest authXMLRequest, Callback[] callbackArray) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Callbacks");
        Callback[] callbackArray2 = AuthXMLUtils.getCallbacks(node2, true, callbackArray);
        authXMLRequest.setSubmittedCallbacks(callbackArray2);
    }
}

