/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.saml;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.services.util.Base64;
import com.sun.identity.authentication.modules.saml.SAMLPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.SAMLCallback;
import com.sun.identity.saml.SAMLClient;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Response;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;

public class SAML
extends AMLoginModule {
    private String userTokenId;
    private Principal userPrincipal = null;
    private static final String amAuthSAML = "amAuthSAML";
    private static Debug debug = Debug.getInstance((String)"amAuthSAML");
    private ResourceBundle bundle = null;
    private Map options;
    private static String AUTH_LEVEL = "sunAMAuthSAMLAuthLevel";
    private String authLevel;
    private Map sharedState;
    private CallbackHandler callbackHandler;
    private String[] arti = null;
    private Response samlResponse = null;
    private String target = null;
    private SAMLServiceManager.SOAPEntry partnerdest = null;
    private com.sun.identity.saml.assertion.Subject assertionSubject = null;
    private Map attrMap = null;
    private List assertions = null;
    private boolean checkSignature = false;

    public SAML() {
        debug.message("SAML()");
    }

    public void init(Subject subject, Map map, Map map2) {
        debug.message("in initialize...");
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthSAML, locale);
        if (debug.messageEnabled()) {
            debug.message("amAuthSAML Authentication resource bundle locale=" + locale);
        }
        this.callbackHandler = this.getCallbackHandler();
        this.options = map2;
        this.sharedState = map;
        if (map2 != null) {
            try {
                String string = Misc.getMapAttr((Map)map2, (String)AUTH_LEVEL);
                if (string != null) {
                    try {
                        this.setAuthLevel(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        debug.error("Unable to set auth level " + string, (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                debug.error("SAML Init Exception", (Throwable)exception);
            }
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        String string = null;
        try {
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            if (httpServletRequest != null) {
                this.processRequest(httpServletRequest);
            } else {
                this.sendCallbacks();
            }
            if (debug.messageEnabled()) {
                debug.message("Artifact : " + this.arti);
                debug.message("Response : " + this.samlResponse);
            }
            if (this.arti != null) {
                this.assertions = this.processArtifact();
            } else if (this.samlResponse != null) {
                this.assertions = this.processResponse();
            } else {
                debug.error("Invalid input given to the Module");
                throw new AuthLoginException(amAuthSAML, "invalidInput", null);
            }
            if (debug.messageEnabled()) {
                debug.message("Assertions : " + this.assertions);
            }
            try {
                this.attrMap = SAMLUtils.getAttributeMap(this.partnerdest, this.assertions, this.assertionSubject, this.target);
                if (debug.messageEnabled()) {
                    debug.message("Attribute Map : " + this.attrMap);
                }
                if (this.attrMap != null && !this.attrMap.isEmpty()) {
                    string = (String)this.attrMap.get("USER_NAME");
                    this.attrMap.remove("USER_NAME");
                }
            }
            catch (Exception exception) {
                debug.error("getAttributeMap : ", (Throwable)exception);
                throw new AuthLoginException(amAuthSAML, "failedGettingAttrMap", null);
            }
            debug.message("Module is successful");
            this.storeUsernamePasswd(string, null);
            this.userTokenId = string;
            return -1;
        }
        catch (AuthLoginException authLoginException) {
            this.setFailureID(this.userTokenId);
            debug.error("Error in 'process' : ", (Throwable)authLoginException);
            throw new AuthLoginException(amAuthSAML, "failedProcess", null);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            SAMLPrincipal sAMLPrincipal = new SAMLPrincipal(this.userTokenId);
            this.assertions = SAMLUtils.getStrAssertions(this.assertions);
            sAMLPrincipal.setAssertions(this.assertions);
            sAMLPrincipal.setAttrMap(this.attrMap);
            this.userPrincipal = sAMLPrincipal;
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        debug.message("clean up module state");
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        debug.message("nullify Used Variables");
        this.arti = null;
        this.samlResponse = null;
    }

    private void sendCallbacks() throws AuthLoginException {
        block9: {
            if (this.callbackHandler == null) {
                throw new AuthLoginException(amAuthSAML, "NoCallbackHandler", null);
            }
            try {
                Callback[] callbackArray = new Callback[]{new SAMLCallback(this.bundle.getString("arti_or_response")), new NameCallback(this.bundle.getString("target_url"))};
                if (debug.messageEnabled()) {
                    debug.message("Callback 0 is.. :" + callbackArray[0]);
                    debug.message("Callback 1 is.. :" + callbackArray[1]);
                }
                this.callbackHandler.handle(callbackArray);
                this.target = ((NameCallback)callbackArray[1]).getName();
                if (this.target == null) {
                    debug.message("no Target specified");
                    throw new AuthLoginException(amAuthSAML, "IllegalArgs", null);
                }
                SAMLCallback sAMLCallback = (SAMLCallback)callbackArray[0];
                int n = sAMLCallback.getType();
                if (n == 1) {
                    this.arti = sAMLCallback.getArtifact();
                    break block9;
                }
                if (n == 2) {
                    this.samlResponse = sAMLCallback.getSamlResponse();
                    this.checkSignature = sAMLCallback.getCheckSignature();
                    break block9;
                }
                debug.message("no type specified");
                throw new AuthLoginException(amAuthSAML, "IllegalArgs", null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                debug.message("message type missing");
                throw new AuthLoginException(amAuthSAML, "IllegalArgs", null);
            }
            catch (IOException iOException) {
                throw new AuthLoginException(iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new AuthLoginException(amAuthSAML, "UnsupportedCallback", null);
            }
        }
    }

    private void processRequest(HttpServletRequest httpServletRequest) throws AuthLoginException {
        this.target = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
        String string = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
        this.arti = httpServletRequest.getParameterValues(string);
        if (this.target == null) {
            this.target = httpServletRequest.getParameter("TARGET");
        }
        if (this.target == null) {
            debug.message("no Target specified");
            throw new AuthLoginException(amAuthSAML, "missingTargetSite", null);
        }
        String string2 = httpServletRequest.getParameter("SAMLResponse");
        if (string2 != null) {
            boolean bl;
            byte[] byArray = null;
            try {
                byArray = Base64.decode((String)string2);
            }
            catch (Exception exception) {
                debug.error("processRequest : Exception when decoding SAMLResponse:", (Throwable)exception);
                throw new AuthLoginException(amAuthSAML, "errorDecodeResponse", null);
            }
            this.samlResponse = SAMLUtils.getResponse(byArray);
            if (this.samlResponse == null) {
                throw new AuthLoginException(amAuthSAML, "errorObtainResponse", null);
            }
            boolean bl2 = SAMLUtils.verifySignature(this.samlResponse);
            if (!bl2) {
                throw new AuthLoginException(amAuthSAML, "invalidResponse", null);
            }
            if (debug.messageEnabled()) {
                debug.message("Received response : " + this.samlResponse.toString());
            }
            StringBuffer stringBuffer = httpServletRequest.getRequestURL();
            if (debug.messageEnabled()) {
                debug.message("processRequest: requestUrl = " + stringBuffer);
            }
            if (!(bl = SAMLUtils.verifyResponse(this.samlResponse, stringBuffer.toString(), httpServletRequest))) {
                throw new AuthLoginException(amAuthSAML, "invalidResponse", null);
            }
        }
    }

    private List processArtifact() throws AuthLoginException {
        List list = null;
        AssertionArtifact assertionArtifact = null;
        try {
            list = SAMLClient.artifactQueryHandler(this.arti, null);
            this.assertionSubject = SAMLUtils.examAssertions(list);
            if (this.assertionSubject == null) {
                throw new AuthLoginException(amAuthSAML, "nullSubject", null);
            }
            assertionArtifact = new AssertionArtifact(this.arti[0]);
        }
        catch (SAMLException sAMLException) {
            debug.error("Error in artifactQueryHandler :", (Throwable)sAMLException);
            throw new AuthLoginException(amAuthSAML, "errorArtiQuery", null);
        }
        catch (IOException iOException) {
            debug.error("Error in artifactQueryHandler :", (Throwable)iOException);
            throw new AuthLoginException(amAuthSAML, "errorArtiQuery", null);
        }
        String string = assertionArtifact.getSourceID();
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null) {
            throw new AuthLoginException(amAuthSAML, "nullPartnerUrl", null);
        }
        this.partnerdest = (SAMLServiceManager.SOAPEntry)map.get(string);
        if (this.partnerdest == null) {
            throw new AuthLoginException(amAuthSAML, "failedAccountMapping", null);
        }
        return list;
    }

    private List processResponse() throws AuthLoginException {
        boolean bl;
        List list = null;
        if (this.checkSignature && !(bl = SAMLUtils.verifySignature(this.samlResponse))) {
            throw new AuthLoginException(amAuthSAML, "invalidResponse", null);
        }
        Map map = SAMLUtils.verifyAssertionAndGetSSMap(this.samlResponse);
        if (debug.messageEnabled()) {
            debug.message("processResponse: ssMap = " + map);
        }
        if (map == null) {
            throw new AuthLoginException(amAuthSAML, "invalidAssertion", null);
        }
        this.assertionSubject = (com.sun.identity.saml.assertion.Subject)map.get("subject");
        if (this.assertionSubject == null) {
            throw new AuthLoginException(amAuthSAML, "nullSubject", null);
        }
        this.partnerdest = (SAMLServiceManager.SOAPEntry)map.get("sourceSite");
        if (this.partnerdest == null) {
            throw new AuthLoginException(amAuthSAML, "failedAccountMapping", null);
        }
        list = (List)map.get("assertion");
        return list;
    }
}

