/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.msisdn;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.msisdn.MSISDNPrincipal;
import com.sun.identity.authentication.modules.msisdn.MSISDNValidation;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class MSISDN
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private Locale locale;
    private static Debug debug = null;
    private static final int DEFAULT_MSISDN_AUTH_LEVEL = 0;
    private String userTokenId;
    private String errorMsgKey = null;
    private MSISDNPrincipal userPrincipal;
    private Map options;
    private Set gatewayList;
    private Set parameterNameList;
    private Set searchHeaderList;
    private String userSearchAttr;
    private String serverHost;
    private int serverPort;
    private String startSearchLoc;
    private String principleUser;
    private String principlePasswd;
    private String useSSL;
    private boolean validGateway = false;
    private boolean searchAllHeaders = false;
    private static final String amAuthMSISDN = "amAuthMSISDN";
    private static final String TRUSTED_GATEWAY_LIST = "sunAMAuthMSISDNTrustedGatewayList";
    private static final String MSISDN_PARAMETER_NAME = "sunAMAuthMSISDNParameterNameList";
    private static final String MSISDN_AUTH_LEVEL = "sunAMAuthMSISDNAuthLevel";
    private static final String MSISDN_HEADER_SEARCH = "sunAMAuthMSISDNHeaderSearch";
    private static final String SEARCH_COOKIE = "searchCookie";
    private static final String SEARCH_HEADER = "searchRequest";
    private static final String SEARCH_PARAM = "searchParam";
    private static final int SUBMITTED_CREDENTIALS = 0;

    public void init(Subject subject, Map map, Map map2) {
        this.locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthMSISDN, this.locale);
        if (debug.messageEnabled()) {
            debug.message("MSISDN resbundle locale=" + this.locale);
        }
        this.options = map2;
        this.initAuthConfig();
    }

    private void initAuthConfig() {
        if (this.options != null) {
            debug.message("MSISDN: getting attributes.");
            this.gatewayList = (Set)this.options.get(TRUSTED_GATEWAY_LIST);
            if (this.gatewayList != null && !this.gatewayList.isEmpty() && this.gatewayList.contains("none")) {
                if (debug.messageEnabled()) {
                    debug.message("No gateways trusted ");
                }
                this.errorMsgKey = "MSISDNInvalidGateway";
            } else {
                this.parameterNameList = (Set)this.options.get(MSISDN_PARAMETER_NAME);
                this.searchHeaderList = (Set)this.options.get(MSISDN_HEADER_SEARCH);
                if (this.searchHeaderList == null || this.searchHeaderList.isEmpty()) {
                    this.searchAllHeaders = true;
                    if (debug.messageEnabled()) {
                        debug.message("searchAllHeaders :" + this.searchAllHeaders);
                    }
                }
                this.setMSISDNAuthLevel();
            }
        } else {
            debug.error("options is null");
            this.errorMsgKey = "MSISDNValidateEx";
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        Object object;
        debug.message("MSISDN : in process ..");
        if (this.errorMsgKey != null) {
            debug.message("Error initalizing config");
            throw new AuthLoginException(amAuthMSISDN, this.errorMsgKey, null);
        }
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        String string = null;
        String string2 = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getRemoteAddr();
            string2 = this.getMSISDNNumberFromRequest(httpServletRequest);
        } else {
            debug.message("Null request calling sendCallback");
            object = this.sendCallback();
            if (object != null) {
                string2 = (String)object.get("msisdnNumber");
                string = (String)object.get("gateway");
            }
        }
        if (!this.isValidGateway(string) || string2 == null) {
            debug.error("Gateway is invalid OR msisdn number is null");
            throw new AuthLoginException(amAuthMSISDN, "MSISDNValidateEx", null);
        }
        object = new MSISDNValidation(this.options, debug, this.bundle, this.locale);
        this.userTokenId = ((MSISDNValidation)object).getUserId(string2);
        this.storeUsernamePasswd(this.userTokenId, null);
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal == null && this.userTokenId != null) {
            this.userPrincipal = new MSISDNPrincipal(this.userTokenId);
        }
        return this.userPrincipal;
    }

    private Map sendCallback() {
        HashMap<String, Object> hashMap;
        block8: {
            hashMap = null;
            try {
                CallbackHandler callbackHandler = this.getCallbackHandler();
                if (callbackHandler == null) {
                    throw new AuthLoginException(amAuthMSISDN, "NoCallbackHandler", null);
                }
                Callback[] callbackArray = new Callback[]{new NameCallback(this.bundle.getString("gateway")), new PasswordCallback(this.bundle.getString("msisdn"), true)};
                callbackHandler.handle(callbackArray);
                hashMap = new HashMap<String, Object>();
                int n = callbackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    Callback callback = callbackArray[n2];
                    if (callback instanceof PasswordCallback) {
                        object = ((PasswordCallback)callback).getPassword();
                        if (object != null) {
                            hashMap.put("msisdnNumber", new String((char[])object));
                        }
                    } else if (callback instanceof NameCallback && (object = (Object)((NameCallback)callback).getName()) != null) {
                        hashMap.put("gateway", object);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block8;
                debug.message("sendCallback", (Throwable)exception);
            }
        }
        return hashMap;
    }

    private void setMSISDNAuthLevel() {
        String string = Misc.getMapAttr((Map)this.options, (String)MSISDN_AUTH_LEVEL);
        int n = 0;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                debug.error("Invalid auth level " + string);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Set auth level to " + n);
        }
        this.setAuthLevel(n);
    }

    private boolean isValidGateway(String string) {
        return this.gatewayList != null && (this.gatewayList.isEmpty() || this.gatewayList.contains(string));
    }

    private String getMSISDNNumberFromRequest(HttpServletRequest httpServletRequest) {
        String string = null;
        if (this.parameterNameList != null && !this.parameterNameList.isEmpty()) {
            Iterator iterator = this.parameterNameList.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                if (debug.messageEnabled()) {
                    debug.message("parameterName : " + string2);
                }
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_COOKIE)) {
                    Cookie[] cookieArray = httpServletRequest.getCookies();
                    if (cookieArray != null) {
                        int n = 0;
                        while (n < cookieArray.length) {
                            String string3 = cookieArray[n].getName();
                            if (string3 != null && string3.equalsIgnoreCase(string2)) {
                                string = cookieArray[n].getValue();
                                break;
                            }
                            ++n;
                        }
                    }
                    if (string != null) break;
                }
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_HEADER)) {
                    string = httpServletRequest.getHeader(string2);
                }
                if (string != null) break;
                if (this.searchAllHeaders || this.searchHeaderList.contains(SEARCH_PARAM)) {
                    string = httpServletRequest.getParameter(string2);
                }
                if (string != null) break;
            }
        }
        return string;
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
        this.userTokenId = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.locale = null;
        this.errorMsgKey = null;
        this.options = null;
        this.gatewayList = null;
        this.parameterNameList = null;
        this.searchHeaderList = null;
        this.userSearchAttr = null;
        this.serverHost = null;
        this.startSearchLoc = null;
        this.principleUser = null;
        this.principlePasswd = null;
        this.useSSL = null;
    }

    static {
        debug = Debug.getInstance((String)amAuthMSISDN);
    }
}

