/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.AMResourceBundleCache;
import com.sun.identity.common.L10NMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class LDAPUtilException
extends LDAPException
implements L10NMessage {
    private String msgID;
    private String bundleName;
    private String message;
    private Object[] args;
    private static String defaultBundleName = "amAuthLDAP";
    AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    public LDAPUtilException() {
    }

    public LDAPUtilException(String string) {
        super(string);
    }

    protected LDAPUtilException(String string, int n) {
        super(string, n);
    }

    public LDAPUtilException(String string, Object[] objectArray) {
        this.msgID = string;
        this.args = objectArray;
        this.bundleName = defaultBundleName;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(String string, int n, Object[] objectArray) {
        super(string, n);
        this.msgID = string;
        this.args = objectArray;
        this.bundleName = defaultBundleName;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(String string, String string2, int n, Object[] objectArray) {
        super(string2, n);
        this.msgID = string2;
        this.args = objectArray;
        this.bundleName = string;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(Throwable throwable) {
        this.message = throwable.getMessage();
        if (throwable instanceof L10NMessage) {
            L10NMessage l10NMessage = (L10NMessage)throwable;
            this.bundleName = l10NMessage.getResourceBundleName();
            this.msgID = l10NMessage.getErrorCode();
            this.args = l10NMessage.getMessageArgs();
        }
    }

    public String getL10NMessage(Locale locale) {
        if (this.msgID == null) {
            return this.getMessage();
        }
        String string = this.msgID;
        if (this.bundleName != null && locale != null) {
            ResourceBundle resourceBundle = this.amCache.getResBundle(this.bundleName, locale);
            string = resourceBundle.getString(this.msgID);
            if (this.args != null && this.args.length != 0) {
                string = MessageFormat.format(string, this.args);
            }
        }
        return string;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getErrorCode() {
        return this.msgID;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }
}

